/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.xml;

import com.idoox.wasp.Constants;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.idoox.xml.Attribute;
import org.idoox.xml.DeclaredPrefixesStack;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;

public class TokenizerResolver {
    protected static final boolean trace = false;

    public static byte[] toCanonicalForm(Tokenizer source) throws TokenizerException, IOException {
        return TokenizerResolver.toCanonicalForm(source, false);
    }

    public static byte[] toCanonicalForm(Tokenizer source, boolean addAncestorPrefix) throws TokenizerException, IOException {
        String xmlString = "";
        Token token = new Token();
        byte state = source.currentState();
        if (state != 2 && state != 4) {
            throw new TokenizerException("Source must be in START_TOKEN or CONTENT state");
        }
        PrefixesStack registeredPrefixes = new PrefixesStack();
        Stack tokenNames = new Stack();
        if (addAncestorPrefix && state == 2) {
            source.readToken(token);
            xmlString = xmlString + TokenizerResolver.engineCanonicalizeStartToken(source, token, registeredPrefixes, tokenNames, true);
            state = source.next();
        }
        while (state != 1) {
            switch (state) {
                case 2: {
                    source.readToken(token);
                    xmlString = xmlString + TokenizerResolver.engineCanonicalizeStartToken(source, token, registeredPrefixes, tokenNames, false);
                    break;
                }
                case 3: {
                    String tokenName = (String)tokenNames.pop();
                    xmlString = xmlString + "</" + tokenName + ">";
                    registeredPrefixes.unregisterPrefixes();
                    break;
                }
                case 4: {
                    xmlString = xmlString + TokenizerResolver.normalizeText(source.readContent());
                    break;
                }
            }
            state = source.next();
        }
        return xmlString.getBytes(Constants.UTF_8);
    }

    protected static String engineCanonicalizeStartToken(Tokenizer source, Token token, PrefixesStack registeredPrefixes, Stack tokenNames, boolean root) {
        String xmlString = "";
        DeclaredPrefixesStack prefixesStack = new DeclaredPrefixesStack();
        source.pushNewlyDeclaredPrefixes(prefixesStack);
        if (root) {
            TokenizerResolver.addRootPrefixes(source, prefixesStack);
        }
        TokenizerResolver.engineCanonicalizeNamespace(registeredPrefixes, prefixesStack);
        int realAttsCount = token.getAttributeCount();
        Attribute[] atts = new Attribute[realAttsCount + prefixesStack.used];
        System.arraycopy(token.attArr, 0, atts, 0, realAttsCount);
        int i = 0;
        while (i < prefixesStack.used) {
            Attribute att = new Attribute();
            att.prefix = "xmlns";
            att.localName = prefixesStack.prefixes[i];
            att.value = prefixesStack.prefixValues[i];
            att.uri = prefixesStack.prefixValues[i];
            atts[realAttsCount + i] = att;
            ++i;
        }
        Arrays.sort(atts, new AttrCompare());
        String prefix = null;
        String tokenName = token.localName;
        prefix = token.prefix;
        if (prefix != null && prefix.length() > 0) {
            tokenName = prefix + ":" + tokenName;
        }
        xmlString = xmlString + "<" + tokenName;
        tokenNames.push(tokenName);
        int i2 = 0;
        while (i2 < atts.length) {
            Attribute attr = atts[i2];
            attr.value = TokenizerResolver.normalizeAttr(attr.value);
            xmlString = "xmlns".equals(attr.prefix) ? (attr.localName != null && attr.localName.length() > 0 ? xmlString + " xmlns:" + attr.localName + "=\"" + attr.value + "\"" : xmlString + " xmlns=\"" + attr.value + "\"") : ("xmlns".equals(attr.qName) ? xmlString + " xmlns=\"" + attr.value + "\"" : xmlString + " " + attr.qName + "=\"" + attr.value + "\"");
            ++i2;
        }
        xmlString = xmlString + ">";
        return xmlString;
    }

    private static void addRootPrefixes(Tokenizer source, DeclaredPrefixesStack prefixesStack) {
        Map rootCurrentPrefix = source.getCurrentPrefixMap();
        if (rootCurrentPrefix.size() > 0) {
            Iterator it = rootCurrentPrefix.keySet().iterator();
            while (it.hasNext()) {
                String prefix = (String)it.next();
                String value = (String)rootCurrentPrefix.get(prefix);
                if (prefix == null) {
                    prefix = "";
                }
                if (value == null || value.equals("")) continue;
                boolean defined = false;
                int i = 0;
                while (i < prefixesStack.used) {
                    String currentPrefix;
                    String string = currentPrefix = prefixesStack.prefixes[i] == null ? "" : prefixesStack.prefixes[i];
                    if (prefix.equals(currentPrefix)) {
                        defined = true;
                        break;
                    }
                    ++i;
                }
                if (defined) continue;
                prefixesStack.enlarge(1);
                prefixesStack.prefixes[prefixesStack.used] = prefix;
                prefixesStack.prefixValues[prefixesStack.used] = value;
                ++prefixesStack.used;
            }
        }
    }

    private static void engineCanonicalizeNamespace(PrefixesStack registeredPrefixes, DeclaredPrefixesStack prefixesStack) {
        int used = 0;
        int i = 0;
        while (i < prefixesStack.used) {
            if (TokenizerResolver.canRetainPrefix(registeredPrefixes, prefixesStack.prefixes[i], prefixesStack.prefixValues[i])) {
                prefixesStack.prefixes[used] = prefixesStack.prefixes[i];
                prefixesStack.prefixValues[used] = prefixesStack.prefixValues[i];
                ++used;
            }
            ++i;
        }
        prefixesStack.used = used;
        registeredPrefixes.registerPrefixes(prefixesStack);
    }

    private static boolean canRetainPrefix(PrefixesStack registeredPrefixes, String prefix, String value) {
        if (prefix == null) {
            prefix = "";
        }
        if (prefix.equals("")) {
            if (value != null && value.length() > 0) {
                return true;
            }
            return registeredPrefixes.isPrefixRegistered(prefix) && registeredPrefixes.getURI(value).length() > 0;
        }
        return !registeredPrefixes.isPrefixRegistered(prefix) || !registeredPrefixes.getURI(prefix).equals(value);
    }

    public static final String normalizeAttr(String s) {
        StringBuffer stringbuffer = new StringBuffer();
        int i = s == null ? 0 : s.length();
        int j = 0;
        while (j < i) {
            char c = s.charAt(j);
            switch (c) {
                case '&': {
                    stringbuffer.append("&amp;");
                    break;
                }
                case '<': {
                    stringbuffer.append("&lt;");
                    break;
                }
                case '\"': {
                    stringbuffer.append("&quot;");
                    break;
                }
                case '\t': {
                    stringbuffer.append("&#x9;");
                    break;
                }
                case '\n': {
                    stringbuffer.append("&#xA;");
                    break;
                }
                case '\r': {
                    stringbuffer.append("&#xD;");
                    break;
                }
                default: {
                    stringbuffer.append(c);
                }
            }
            ++j;
        }
        return stringbuffer.toString();
    }

    public static final String normalizeText(String text) {
        StringBuffer stringbuffer = new StringBuffer();
        int i = text == null ? 0 : text.length();
        int j = 0;
        while (j < i) {
            char c = text.charAt(j);
            switch (c) {
                case '&': {
                    stringbuffer.append("&amp;");
                    break;
                }
                case '<': {
                    stringbuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringbuffer.append("&gt;");
                    break;
                }
                case '\r': {
                    stringbuffer.append("&#xD;");
                    break;
                }
                default: {
                    stringbuffer.append(c);
                }
            }
            ++j;
        }
        return stringbuffer.toString();
    }

    public static byte[] toC14nExcCanonicalForm(Tokenizer source, String prefixList) throws TokenizerException, IOException {
        String xmlString = "";
        Token token = new Token();
        byte state = source.currentState();
        if (state != 2 && state != 4) {
            throw new TokenizerException("Source must be in START_TOKEN or CONTENT state");
        }
        PrefixesStack registeredPrefixes = new PrefixesStack();
        Stack tokenNames = new Stack();
        List listPrefixes = TokenizerResolver.parsePrefixList(prefixList);
        while (state != 1) {
            switch (state) {
                case 2: {
                    source.readToken(token);
                    xmlString = xmlString + TokenizerResolver.engineC14nExcStartToken(source, token, registeredPrefixes, tokenNames, listPrefixes);
                    break;
                }
                case 3: {
                    String tokenName = (String)tokenNames.pop();
                    xmlString = xmlString + "</" + tokenName + ">";
                    registeredPrefixes.unregisterPrefixes();
                    break;
                }
                case 4: {
                    xmlString = xmlString + TokenizerResolver.normalizeText(source.readContent());
                    break;
                }
            }
            state = source.next();
        }
        return xmlString.getBytes(Constants.UTF_8);
    }

    private static List parsePrefixList(String prefixList) {
        ArrayList<String> ret = new ArrayList<String>();
        if (prefixList == null || prefixList.length() == 0) {
            return ret;
        }
        StringTokenizer st = new StringTokenizer(prefixList);
        while (st.hasMoreTokens()) {
            ret.add(st.nextToken());
        }
        return ret;
    }

    private static String engineC14nExcStartToken(Tokenizer source, Token token, PrefixesStack registeredPrefixes, Stack tokenNames, List listPrefixes) {
        String xmlString = "";
        DeclaredPrefixesStack ndPrefixesStack = new DeclaredPrefixesStack();
        source.pushNewlyDeclaredPrefixes(ndPrefixesStack);
        DeclaredPrefixesStack prefixesStack = new DeclaredPrefixesStack();
        TokenizerResolver.engineC14nExcNamespace(source, token, registeredPrefixes, ndPrefixesStack, prefixesStack, listPrefixes);
        int realAttsCount = token.getAttributeCount();
        Attribute[] atts = new Attribute[realAttsCount + prefixesStack.used];
        System.arraycopy(token.attArr, 0, atts, 0, realAttsCount);
        int i = 0;
        while (i < prefixesStack.used) {
            Attribute att = new Attribute();
            att.prefix = "xmlns";
            att.localName = prefixesStack.prefixes[i];
            att.value = prefixesStack.prefixValues[i];
            att.uri = prefixesStack.prefixValues[i];
            atts[realAttsCount + i] = att;
            ++i;
        }
        Vector<String> notDefinedPrefixes = null;
        int i2 = 0;
        while (i2 < realAttsCount) {
            if (atts[i2].prefix != null && !registeredPrefixes.isPrefixRegistered(atts[i2].prefix)) {
                if (notDefinedPrefixes == null) {
                    notDefinedPrefixes = new Vector<String>();
                }
                notDefinedPrefixes.add(atts[i2].prefix);
            }
            ++i2;
        }
        if (notDefinedPrefixes != null && notDefinedPrefixes.size() > 0) {
            Attribute[] newAtts = new Attribute[atts.length + notDefinedPrefixes.size()];
            System.arraycopy(atts, 0, newAtts, 0, atts.length);
            int i3 = 0;
            while (i3 < notDefinedPrefixes.size()) {
                Attribute att = new Attribute();
                att.prefix = "xmlns";
                att.localName = (String)notDefinedPrefixes.get(i3);
                att.uri = att.value = registeredPrefixes.getURI(att.localName);
                newAtts[atts.length + i3] = att;
                ++i3;
            }
            atts = newAtts;
        }
        Arrays.sort(atts, new AttrCompare());
        String prefix = null;
        String tokenName = token.localName;
        prefix = token.prefix;
        if (prefix != null && prefix.length() > 0) {
            tokenName = prefix + ":" + tokenName;
        }
        xmlString = xmlString + "<" + tokenName;
        tokenNames.push(tokenName);
        int i4 = 0;
        while (i4 < atts.length) {
            Attribute attr = atts[i4];
            attr.value = TokenizerResolver.normalizeAttr(attr.value);
            xmlString = "xmlns".equals(attr.prefix) ? (attr.localName != null && attr.localName.length() > 0 ? xmlString + " xmlns:" + attr.localName + "=\"" + attr.value + "\"" : xmlString + " xmlns=\"" + attr.value + "\"") : ("xmlns".equals(attr.qName) ? xmlString + " xmlns=\"" + attr.value + "\"" : xmlString + " " + attr.qName + "=\"" + attr.value + "\"");
            ++i4;
        }
        xmlString = xmlString + ">";
        return xmlString;
    }

    private static void engineC14nExcNamespace(Tokenizer source, Token token, PrefixesStack registeredPrefixes, DeclaredPrefixesStack ndPrefixesStack, DeclaredPrefixesStack prefixesStack, List listPrefixes) {
        String prefix = token.prefix;
        if (prefix != null && prefix.length() != 0 && TokenizerResolver.canRetainPrefix(registeredPrefixes, prefix, source.getNamespaceForPrefix(prefix))) {
            prefixesStack.enlarge(1);
            prefixesStack.prefixes[prefixesStack.used] = prefix;
            prefixesStack.prefixValues[prefixesStack.used] = source.getNamespaceForPrefix(prefix);
            ++prefixesStack.used;
            registeredPrefixes.registerPrefix(prefix, source.getNamespaceForPrefix(prefix));
        }
        int i = 0;
        while (i < token.getAttributeCount()) {
            prefix = token.attArr[i].prefix;
            if (prefix != null && prefix.length() != 0 && !prefix.equals("xml") && TokenizerResolver.canRetainPrefix(registeredPrefixes, prefix, source.getNamespaceForPrefix(prefix))) {
                prefixesStack.enlarge(1);
                prefixesStack.prefixes[prefixesStack.used] = prefix;
                prefixesStack.prefixValues[prefixesStack.used] = source.getNamespaceForPrefix(prefix);
                ++prefixesStack.used;
                registeredPrefixes.registerPrefix(prefix, source.getNamespaceForPrefix(prefix));
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < ndPrefixesStack.used) {
            prefix = ndPrefixesStack.prefixes[i2];
            if (prefix != null && prefix.length() != 0 && listPrefixes.contains(prefix) && TokenizerResolver.canRetainPrefix(registeredPrefixes, prefix, source.getNamespaceForPrefix(prefix))) {
                prefixesStack.enlarge(1);
                prefixesStack.prefixes[prefixesStack.used] = prefix;
                prefixesStack.prefixValues[prefixesStack.used] = source.getNamespaceForPrefix(prefix);
                ++prefixesStack.used;
                registeredPrefixes.registerPrefix(prefix, source.getNamespaceForPrefix(prefix));
            }
            ++i2;
        }
        registeredPrefixes.registerPrefixes(prefixesStack, false);
    }

    protected static class PrefixesStack {
        private HashMap prefixMap = new HashMap();
        private Stack prefixesStacks = new Stack();

        private void registerPrefix(String prefix, String uri) {
            Stack values = null;
            if (this.prefixMap.containsKey(prefix)) {
                values = (Stack)this.prefixMap.get(prefix);
            } else {
                values = new Stack();
                this.prefixMap.put(prefix, values);
            }
            values.push(uri);
        }

        private void unregisterPrefix(String prefix) {
            if (!this.prefixMap.containsKey(prefix)) {
                return;
            }
            Stack values = (Stack)this.prefixMap.get(prefix);
            values.pop();
            if (values.size() == 0) {
                this.prefixMap.remove(prefix);
            }
        }

        public void registerPrefixes(DeclaredPrefixesStack prefixesStack) {
            this.registerPrefixes(prefixesStack, true);
        }

        public void registerPrefixes(DeclaredPrefixesStack prefixesStack, boolean putPrefixes) {
            if (putPrefixes) {
                int i = 0;
                while (i < prefixesStack.used) {
                    String prefix = prefixesStack.prefixes[i] != null ? prefixesStack.prefixes[i] : "";
                    String value = prefixesStack.prefixValues[i] != null ? prefixesStack.prefixValues[i] : "";
                    this.registerPrefix(prefix, value);
                    ++i;
                }
            }
            this.prefixesStacks.push(prefixesStack);
        }

        private void unregisterPrefixes(DeclaredPrefixesStack prefixesStack) {
            int i = 0;
            while (i < prefixesStack.used) {
                String prefix = prefixesStack.prefixes[i] != null ? prefixesStack.prefixes[i] : "";
                this.unregisterPrefix(prefix);
                ++i;
            }
        }

        public void unregisterPrefixes() {
            DeclaredPrefixesStack prefixesStack = (DeclaredPrefixesStack)this.prefixesStacks.pop();
            this.unregisterPrefixes(prefixesStack);
        }

        public String getURI(String prefix) {
            if (!this.isPrefixRegistered(prefix)) {
                return null;
            }
            return (String)((Stack)this.prefixMap.get(prefix)).peek();
        }

        public boolean isPrefixRegistered(String prefix) {
            return this.prefixMap.containsKey(prefix);
        }
    }

    private static class AttrCompare
    implements Comparator {
        private AttrCompare() {
        }

        public int compare(Object obj0, Object obj1) {
            String name1;
            String name0;
            Attribute attr0 = (Attribute)obj0;
            Attribute attr1 = (Attribute)obj1;
            String prefix0 = attr0.prefix;
            String prefix1 = attr1.prefix;
            String localName0 = attr0.localName;
            String localName1 = attr1.localName;
            if (prefix0 != null && prefix0.length() > 0) {
                name0 = prefix0;
                if (localName0 != null && localName0.length() > 0) {
                    name0 = name0 + ":" + localName0;
                }
            } else {
                name0 = localName0;
            }
            if (prefix1 != null && prefix1.length() > 0) {
                name1 = prefix1;
                if (localName1 != null && localName1.length() > 0) {
                    name1 = name1 + ":" + localName1;
                }
            } else {
                name1 = localName1;
            }
            String namespaceURI0 = attr0.uri;
            String namespaceURI1 = attr1.uri;
            boolean definesNS0 = false;
            boolean definesNS1 = false;
            if (name0.equals("xmlns")) {
                localName0 = "";
                prefix0 = "xmlns";
                definesNS0 = true;
                if (namespaceURI0 == null) {
                    namespaceURI0 = "http://www.w3.org/2000/xmlns/";
                }
            }
            if (name1.equals("xmlns")) {
                localName1 = "";
                prefix1 = "xmlns";
                definesNS1 = true;
                if (namespaceURI1 == null) {
                    namespaceURI1 = "http://www.w3.org/2000/xmlns/";
                }
            }
            if (name0.startsWith("xmlns:")) {
                prefix0 = "xmlns";
                localName0 = name0.substring(name0.indexOf("xmlns:") + "xmlns:".length());
                definesNS0 = true;
                if (namespaceURI0 == null) {
                    namespaceURI0 = "http://www.w3.org/2000/xmlns/";
                }
            }
            if (name1.startsWith("xmlns:")) {
                prefix1 = "xmlns";
                localName1 = name1.substring(name1.indexOf("xmlns:") + "xmlns:".length());
                definesNS1 = true;
                if (namespaceURI1 == null) {
                    namespaceURI1 = "http://www.w3.org/2000/xmlns/";
                }
            }
            if (namespaceURI0 == null) {
                namespaceURI0 = "";
                localName0 = name0;
            }
            if (namespaceURI1 == null) {
                namespaceURI1 = "";
                localName1 = name1;
            }
            if (attr0 == null) {
                return 0;
            }
            if (attr1 == null) {
                return 0;
            }
            if (localName0 == null && name0 == null) {
                return 0;
            }
            if (localName1 == null && name1 == null) {
                return 0;
            }
            if (definesNS0 && definesNS1) {
                int result = AttrCompare.signum(localName0.compareTo(localName1));
                return result;
            }
            if (!definesNS0 && !definesNS1) {
                int NScomparisonResult = AttrCompare.signum(namespaceURI0.compareTo(namespaceURI1));
                if (NScomparisonResult != 0) {
                    return NScomparisonResult;
                }
                int result = AttrCompare.signum(localName0.compareTo(localName1));
                return result;
            }
            if (definesNS0 && !definesNS1) {
                return -1;
            }
            if (!definesNS0 && definesNS1) {
                return 1;
            }
            return 0;
        }

        private static int signum(int input) {
            if (input == 0) {
                return 0;
            }
            if (input < 0) {
                return -1;
            }
            return 1;
        }
    }
}

