/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.xml;

class IntArray {
    private static final int INITIAL_ROW_SIZE = 200;
    private static final int INITIAL_ROW_COUNT = 5;
    private int[][] content;
    private int currentRow;
    private int currentPos;
    private int elementCount;

    public IntArray() {
        this(5, 200);
    }

    public IntArray(int initialRowCount, int initialRowSize) {
        this.content = new int[initialRowCount][];
        this.content[0] = new int[initialRowSize];
    }

    public int get(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (index < this.content[0].length) {
            return this.content[0][index];
        }
        int row = 0;
        while (row <= this.currentRow) {
            if (index < this.content[row].length) break;
            index -= this.content[row].length;
            ++row;
        }
        return this.content[row][index];
    }

    public void add(int element) {
        if (this.currentPos == this.content[this.currentRow].length) {
            if (this.currentRow == this.content.length - 1) {
                int[][] newArr = new int[this.content.length * 2][];
                System.arraycopy(this.content, 0, newArr, 0, this.content.length);
                this.content = newArr;
            }
            ++this.currentRow;
            this.content[this.currentRow] = new int[this.content[0].length << this.currentRow];
            this.currentPos = 0;
        }
        this.content[this.currentRow][this.currentPos++] = element;
        ++this.elementCount;
    }

    public int getLength() {
        return this.elementCount;
    }
}

