/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.wasp.wsdl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import org.idoox.wasp.Context;
import org.xml.sax.SAXException;

public interface WSDLRepository {
    public Definition getDefinition(String var1, boolean var2) throws MalformedURLException, IOException, SAXException, WSDLException;

    public Definition getDefinition(String var1) throws MalformedURLException, IOException, SAXException, WSDLException;

    public Definition getDefinition(String var1, Map var2) throws MalformedURLException, IOException, SAXException, WSDLException;

    public Definition getDefinition(String var1, boolean var2, Map var3) throws MalformedURLException, IOException, SAXException, WSDLException;

    public PortInfo[] findPortByPortType(QName var1);

    public String findWSDLUrlByPort(String var1, QName var2);

    public ServiceInfo findService(QName var1);

    public static interface Config {
        public String[] getWSDLUrls();

        public void setWSDLUrls(String[] var1);
    }

    public static class PortInfo {
        private String portName;
        private QName serviceQName;
        private String wsdlUrl;
        private static final QName EMPTY_QNAME = new QName("", "");
        private int hCode = -1;

        public PortInfo(String portName, QName serviceQName, String wsdlUrl) {
            this.portName = portName;
            this.serviceQName = serviceQName;
            this.wsdlUrl = wsdlUrl;
        }

        public String getPortName() {
            return this.portName == null ? "" : this.portName;
        }

        public void setPortName(String portName) {
            this.portName = portName;
        }

        public QName getServiceQName() {
            return this.serviceQName == null ? EMPTY_QNAME : this.serviceQName;
        }

        public void setServiceQName(QName serviceQName) {
            this.serviceQName = serviceQName;
        }

        public String getWSDLUrl() {
            return this.wsdlUrl == null ? "" : this.wsdlUrl;
        }

        public void setWSDLUrl(String wsdlUrl) {
            this.wsdlUrl = wsdlUrl;
        }

        public int hashCode() {
            if (this.hCode == -1) {
                this.hCode = this.getPortName().hashCode() ^ this.getServiceQName().hashCode();
            }
            return this.hCode;
        }

        public boolean equals(Object toCmp) {
            if (!(toCmp instanceof PortInfo)) {
                return false;
            }
            PortInfo portInfo = (PortInfo)toCmp;
            return this.getPortName().equals(portInfo.getPortName()) && this.getServiceQName().equals(portInfo.getServiceQName());
        }

        public String toString() {
            return "portName='" + this.portName + "' serviceQName='" + this.serviceQName + "' wsdlUrl='" + this.wsdlUrl + "'";
        }
    }

    public static class ServiceInfo {
        private Definition definition;
        private Service service;
        private String definitionURL;
        private QName serviceName;
        static /* synthetic */ Class class$org$idoox$wasp$wsdl$WSDLRepository;

        public ServiceInfo(Definition definition, Service service) {
            this.definition = definition;
            this.service = service;
        }

        public ServiceInfo(String definitionURL, QName serviceName) {
            this.definitionURL = definitionURL;
            this.serviceName = serviceName;
        }

        public Definition getDefinition() {
            if (this.definition == null && this.definitionURL != null && this.serviceName != null) {
                WSDLRepository wsdlRepo = (WSDLRepository)Context.getInstance(class$org$idoox$wasp$wsdl$WSDLRepository == null ? (class$org$idoox$wasp$wsdl$WSDLRepository = ServiceInfo.class$("org.idoox.wasp.wsdl.WSDLRepository")) : class$org$idoox$wasp$wsdl$WSDLRepository);
                try {
                    this.definition = wsdlRepo.getDefinition(this.definitionURL);
                    this.service = this.definition.getService(this.serviceName);
                    if (this.service == null) {
                        throw new RuntimeException("Cannot find service " + this.serviceName + " in WSDL!");
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Wrong WSDL: " + e.getClass().getName() + ": " + e.getMessage());
                }
            }
            return this.definition;
        }

        public void setDefinition(Definition definition) {
            this.definition = definition;
        }

        public Service getService() {
            return this.service;
        }

        public void setService(Service service) {
            this.service = service;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

