/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.wasp.wsdl;

import com.idoox.debug.IndentCategory;
import com.idoox.soap.EnvelopeOutCache;
import com.idoox.xml.schema.util.XMLSchemaUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import org.idoox.xml.schema.Member;
import org.idoox.xml.schema.Schema;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xml.schema.Type;
import org.idoox.xmlrpc.MessageProcessingException;
import org.systinet.wsdl.extensions.java.JavaFault;
import org.systinet.wsdl.extensions.java.JavaOperation;

public class SOAPMethodInfo
implements Serializable {
    public static final int DIR_IN = 1;
    public static final int DIR_OUT = 2;
    public static final int DIR_INOUT = 3;
    public PartInfo[] parts;
    public Boolean schemaSettedUp = Boolean.FALSE;
    public PartInfo[] headerParts;
    public boolean containsRequestAttachment;
    public boolean containsResponseAttachment;
    public boolean useDime;
    public String soapAction;
    public boolean rpcOperation;
    public String documentation;
    public String requestMessageEncodingURI;
    public QName requestName;
    public String responseMessageEncodingURI;
    public QName responseName;
    public String operationName;
    public String inputName;
    public String outputName;
    public PartInfo returnValuePart;
    public static final int OPERATION_REQUEST_RESPONSE = 0;
    public static final int OPERATION_ONEWAY = 1;
    public static final int OPERATION_SOLICIT_RESPONSE = 2;
    public static final int OPERATION_NOTIFICATION = 3;
    public int operationType;
    public EnvelopeOutCache envelopeOutCache;
    public EnvelopeOutCache envelopeOutCache1;
    public String signature;
    public String javaMethodName;
    public String[] javaExceptions;
    public String[] nonJavaFaults;
    public String httpLocationURI;
    public QName httpUriEncoding;
    public QName inWrapperQName;
    public QName outWrapperQName;
    public FaultPartInfos faultsInfo = new FaultPartInfos();
    RequiredElements requiredInElements;
    RequiredElements requiredOutElements;

    public String toString() {
        return "SOAPMethodInfo [" + this.requestName + ", " + this.responseName + ", parts : " + this.parts.length + "[" + this.formatParts() + " ] " + " ret " + (this.returnValuePart != null ? this.returnValuePart.toString() : "<null>") + " ]";
    }

    private String formatParts() {
        if (this.parts == null) {
            return "";
        }
        StringBuffer ret = new StringBuffer();
        int i = 0;
        while (i < this.parts.length) {
            if (i != 0) {
                ret.append(", ");
            }
            if (this.parts[i] != null) {
                ret.append(this.parts[i].toString());
            } else {
                ret.append("<null>");
            }
            ++i;
        }
        return ret.toString();
    }

    public boolean isSchemaCorrect() {
        return this.schemaSettedUp;
    }

    public void setCorrectSchema(Schema schema) throws SchemaException {
        if (this.schemaSettedUp.equals(Boolean.FALSE)) {
            Type auxType;
            QName type;
            Member aux;
            int i = 0;
            while (i < this.parts.length) {
                if (this.parts[i].inSchemaElement != null && (aux = schema.getSchemaElement(this.parts[i].inSchemaElement.getName())) != null) {
                    this.parts[i].inSchemaElement = aux;
                }
                if (this.parts[i].outSchemaElement != null && (aux = schema.getSchemaElement(this.parts[i].outSchemaElement.getName())) != null) {
                    this.parts[i].outSchemaElement = aux;
                }
                if (this.parts[i].inSchemaType != null) {
                    type = this.parts[i].inSchemaType.getName();
                    if (type == null) {
                        if (this.parts[i].inSchemaElement != null) {
                            this.parts[i].inSchemaType = this.parts[i].inSchemaElement.getType();
                        }
                    } else {
                        auxType = schema.getSchemaType(this.parts[i].inSchemaType.getName());
                        if (auxType != null) {
                            this.parts[i].inSchemaType = auxType;
                        }
                    }
                }
                if (this.parts[i].outSchemaType != null) {
                    type = this.parts[i].outSchemaType.getName();
                    if (type == null) {
                        if (this.parts[i].outSchemaElement != null) {
                            this.parts[i].outSchemaType = this.parts[i].outSchemaElement.getType();
                        }
                    } else {
                        auxType = schema.getSchemaType(this.parts[i].outSchemaType.getName());
                        if (auxType != null) {
                            this.parts[i].outSchemaType = auxType;
                        }
                    }
                }
                ++i;
            }
            if (this.returnValuePart != null) {
                if (this.returnValuePart.inSchemaElement != null && (aux = schema.getSchemaElement(this.returnValuePart.inSchemaElement.getName())) != null) {
                    this.returnValuePart.inSchemaElement = aux;
                }
                if (this.returnValuePart.outSchemaElement != null && (aux = schema.getSchemaElement(this.returnValuePart.outSchemaElement.getName())) != null) {
                    this.returnValuePart.outSchemaElement = aux;
                }
                if (this.returnValuePart.inSchemaType != null) {
                    type = this.returnValuePart.inSchemaType.getName();
                    if (type == null) {
                        if (this.returnValuePart.inSchemaElement != null) {
                            this.returnValuePart.inSchemaType = this.returnValuePart.inSchemaElement.getType();
                        }
                    } else {
                        auxType = schema.getSchemaType(this.returnValuePart.inSchemaType.getName());
                        if (auxType != null) {
                            this.returnValuePart.inSchemaType = auxType;
                        }
                    }
                }
                if (this.returnValuePart.outSchemaType != null) {
                    type = this.returnValuePart.outSchemaType.getName();
                    if (type == null) {
                        if (this.returnValuePart.outSchemaElement != null) {
                            this.returnValuePart.outSchemaType = this.returnValuePart.outSchemaElement.getType();
                        }
                    } else {
                        auxType = schema.getSchemaType(this.returnValuePart.outSchemaType.getName());
                        if (auxType != null) {
                            this.returnValuePart.outSchemaType = auxType;
                        }
                    }
                }
            }
            this.faultsInfo.setCorrectSchema(schema);
            this.schemaSettedUp = Boolean.TRUE;
        }
    }

    public void addFault(String faultName, String javaType) {
        FaultPartInfo faultPartInfo = this.faultsInfo.getFaultPartByName(faultName);
        if (faultPartInfo != null) {
            faultPartInfo.setJavaType(javaType);
        }
    }

    public void dump(IndentCategory cat) {
        cat.enter(this.operationName);
        cat.debug("request  : " + this.requestName);
        cat.debug("response : " + this.responseName);
        if (this.returnValuePart != null) {
            cat.enter("return");
            this.returnValuePart.dump(cat);
            cat.leave();
        }
        if (this.parts != null) {
            int i = 0;
            while (i < this.parts.length) {
                this.parts[i].dump(cat);
                ++i;
            }
        }
        cat.leave();
    }

    public boolean isVoid() {
        if (this.returnValuePart != null) {
            return false;
        }
        if (this.parts != null) {
            int i = 0;
            while (i < this.parts.length) {
                PartInfo part = this.parts[i];
                if (part.partType != 1) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public void fillFaultPartInfos(BindingOperation operation, Schema schema) throws WSDLException, SchemaException {
        this.faultsInfo = new FaultPartInfos(operation, schema);
    }

    public RequiredElements getRequiredInElements() {
        if (this.requiredInElements == null) {
            this.requiredInElements = new RequiredElements();
            int i = 0;
            while (i < this.parts.length) {
                if (this.parts[i].inSchemaElement != null && this.parts[i].inSchemaElement.getName() != null) {
                    this.requiredInElements.addRecord(this.parts[i].inSchemaElement.getName(), this.parts[i].inSchemaElement.isNillable(), this.parts[i].inSchemaElement.getMinOccurs(), this.parts[i].inSchemaElement.getMaxOccurs(), false);
                }
                ++i;
            }
        }
        return this.requiredInElements;
    }

    public RequiredElements getRequiredOutElements() {
        if (this.requiredOutElements == null) {
            this.requiredOutElements = new RequiredElements();
            int i = 0;
            while (i < this.parts.length) {
                if (this.parts[i].outSchemaElement != null && this.parts[i].outSchemaElement.getName() != null) {
                    this.requiredOutElements.addRecord(this.parts[i].outSchemaElement.getName(), this.parts[i].outSchemaElement.isNillable(), this.parts[i].outSchemaElement.getMinOccurs(), this.parts[i].outSchemaElement.getMaxOccurs(), this.parts[i].isAttachment);
                }
                ++i;
            }
            if (this.returnValuePart != null && this.returnValuePart.outSchemaElement != null && this.returnValuePart.outSchemaElement.getName() != null) {
                this.requiredOutElements.addRecord(this.returnValuePart.outSchemaElement.getName(), this.returnValuePart.outSchemaElement.isNillable(), this.returnValuePart.outSchemaElement.getMinOccurs(), this.returnValuePart.outSchemaElement.getMaxOccurs(), this.returnValuePart.isAttachment);
            }
        }
        return this.requiredOutElements;
    }

    public static class RequiredElements {
        ArrayList records = new ArrayList();

        public Invocation newInvocation() {
            return new Invocation();
        }

        private void addRecord(QName elementQName, boolean nillable, int minOccurs, int maxOccurs, boolean attachment) {
            int i = this.indexOf(elementQName);
            if (i == -1) {
                this.records.add(new Record(elementQName, nillable, minOccurs, maxOccurs, attachment));
            } else {
                Record r = (Record)this.records.get(i);
                r.minOccurs += minOccurs;
                r.maxOccurs += maxOccurs;
            }
        }

        private int indexOf(QName name) {
            int i = 0;
            while (i < this.records.size()) {
                if (((Record)this.records.get((int)i)).elementQName.equals(name)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public class Invocation {
            int[] counts;

            private boolean shouldValidateNillableIn() {
                return true;
            }

            private boolean shouldValidateMinOccurs() {
                return true;
            }

            public Invocation() {
                this.counts = new int[RequiredElements.this.records.size()];
            }

            public void nillElement(QName name) throws MessageProcessingException {
                if (!this.shouldValidateMinOccurs()) {
                    return;
                }
                int i = RequiredElements.this.indexOf(name);
                if (i == -1) {
                    throw new MessageProcessingException("Unknown element " + name);
                }
                if (!((Record)RequiredElements.this.records.get((int)i)).nillable && this.shouldValidateNillableIn()) {
                    throw new MessageProcessingException("Element " + name + " can't be nill");
                }
                int n = i;
                this.counts[n] = this.counts[n] + 1;
            }

            public void notNillElement(QName name) throws MessageProcessingException {
                if (!this.shouldValidateMinOccurs()) {
                    return;
                }
                int i = RequiredElements.this.indexOf(name);
                if (i == -1) {
                    throw new MessageProcessingException("Unknown element " + name);
                }
                int n = i;
                this.counts[n] = this.counts[n] + 1;
            }

            public void endInvocation() throws MessageProcessingException {
                if (!this.shouldValidateMinOccurs()) {
                    return;
                }
                int i = 0;
                while (i < RequiredElements.this.records.size()) {
                    Record r = (Record)RequiredElements.this.records.get(i);
                    if (this.counts[i] < r.minOccurs && !r.attachment) {
                        throw new MessageProcessingException("Element " + r.elementQName + " was presented " + this.counts[i] + ", but minOccurs is " + r.minOccurs);
                    }
                    if (this.counts[i] > r.maxOccurs && r.maxOccurs != -1) {
                        throw new MessageProcessingException("Element " + r.elementQName + " was presented " + this.counts[i] + ", but maxOccurs is " + r.maxOccurs);
                    }
                    ++i;
                }
            }
        }

        public static class Record {
            public QName elementQName;
            public boolean nillable;
            public int minOccurs;
            public int maxOccurs;
            public boolean attachment;

            public Record(QName elementQName, boolean nillable, int minOccurs, int maxOccurs, boolean attachment) {
                this.elementQName = elementQName;
                this.nillable = nillable;
                this.minOccurs = minOccurs;
                this.maxOccurs = maxOccurs;
                this.attachment = attachment;
            }
        }
    }

    public static class FaultPartInfo {
        private String faultName;
        private Type type;
        private Member element;
        private String name;
        private String encodingURI;
        private String namespaceURI;
        private String javaType;
        private int use = 1;
        private QName messageQName;

        public FaultPartInfo(BindingFault bindingFault, Fault portTypeFault, Schema schema, String javaType) throws WSDLException, SchemaException {
            QName elementName;
            if (portTypeFault == null) {
                throw new WSDLException("INVALID_WSDL", "SOAP binding fault '" + bindingFault.getName() + "' NOT FOUND in portType!");
            }
            this.faultName = bindingFault.getName();
            Iterator extElms = bindingFault.getExtensibilityElements().iterator();
            while (extElms.hasNext()) {
                Object o = extElms.next();
                if (!(o instanceof SOAPFault)) continue;
                SOAPFault soapFault = (SOAPFault)o;
                String wsdlUse = soapFault.getUse();
                if ("literal".equals(wsdlUse)) {
                    this.use = 1;
                } else if ("encoded".equals(wsdlUse)) {
                    this.use = 0;
                } else {
                    throw new WSDLException("INVALID_WSDL", "Unknown use: " + wsdlUse + " on fault part " + this.faultName);
                }
                this.namespaceURI = soapFault.getNamespaceURI();
                List encodingStyles = soapFault.getEncodingStyles();
                if (encodingStyles == null || encodingStyles.size() <= 0) continue;
                this.encodingURI = (String)encodingStyles.get(0);
            }
            Message faultMessage = portTypeFault.getMessage();
            this.messageQName = faultMessage.getQName();
            Map parts = faultMessage.getParts();
            if (parts.size() != 1) {
                throw new WSDLException("INVALID_WSDL", "Fault message '" + faultMessage.getQName() + "' MUST contain exactly one part. Found " + parts.size() + " parts.");
            }
            Part faultPart = (Part)faultMessage.getParts().values().iterator().next();
            this.name = faultPart.getName();
            QName typeName = faultPart.getTypeName();
            if (typeName != null) {
                this.type = XMLSchemaUtil.getSchemaType(schema, typeName);
            }
            if ((elementName = faultPart.getElementName()) != null) {
                this.element = XMLSchemaUtil.getSchemaElement(schema, elementName);
                if (this.element == null) {
                    throw new SchemaException("Can not get schema element for " + elementName);
                }
                this.type = this.element.getType();
            }
            if (this.faultName == null) {
                throw new WSDLException("INVALID_WSDL", "Found fault part with null name");
            }
            this.javaType = javaType;
        }

        public FaultPartInfo(String name, Type type, Member element, String encodingURI, int use) {
            this.type = type;
            this.element = element;
            this.name = name;
            this.encodingURI = encodingURI;
            this.use = use;
            if (name == null) {
                throw new IllegalArgumentException("Name MUST NOT be null");
            }
            if (type == null && element == null) {
                throw new IllegalArgumentException("Either element or type MUST NOT be null");
            }
        }

        public FaultPartInfo(String name, Type type, Member element, String encodingURI, String namespaceURI) {
            this.type = type;
            this.element = element;
            this.name = name;
            this.encodingURI = encodingURI;
            this.namespaceURI = namespaceURI;
            if (name == null) {
                throw new IllegalArgumentException("Name MUST NOT be null");
            }
            if (type == null && element == null) {
                throw new IllegalArgumentException("Either element or type MUST NOT be null");
            }
        }

        public String getFaultName() {
            return this.faultName;
        }

        public Type getType() {
            return this.type;
        }

        public Member getElement() {
            return this.element;
        }

        public String getName() {
            return this.name;
        }

        public String getEncodingURI() {
            return this.encodingURI;
        }

        public String getNamespaceURI() {
            return this.namespaceURI;
        }

        public int getUse() {
            return this.use;
        }

        public Type getSchemaType() {
            if (this.element != null) {
                return this.element.getType();
            }
            if (this.type != null) {
                return this.type;
            }
            return null;
        }

        public QName getSchemaTypeName() {
            Type schemaType = this.getSchemaType();
            if (schemaType != null) {
                return schemaType.getName();
            }
            return null;
        }

        public QName getElementName() {
            Member element = this.getElement();
            if (element != null) {
                return element.getName();
            }
            return null;
        }

        public String getJavaType() {
            return this.javaType;
        }

        public void setJavaType(String javaType) {
            this.javaType = javaType;
        }

        public QName getMessageQName() {
            return this.messageQName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FaultPartInfo)) {
                return false;
            }
            FaultPartInfo faultPartInfo = (FaultPartInfo)o;
            if (this.use != faultPartInfo.use) {
                return false;
            }
            boolean bl = this.element != null ? !this.element.equals(faultPartInfo.element) : faultPartInfo.element != null;
            if (bl) {
                return false;
            }
            boolean bl2 = this.encodingURI != null ? !this.encodingURI.equals(faultPartInfo.encodingURI) : faultPartInfo.encodingURI != null;
            if (bl2) {
                return false;
            }
            if (!this.name.equals(faultPartInfo.name)) {
                return false;
            }
            boolean bl3 = this.namespaceURI != null ? !this.namespaceURI.equals(faultPartInfo.namespaceURI) : faultPartInfo.namespaceURI != null;
            if (bl3) {
                return false;
            }
            return !(this.type != null ? !this.type.equals(faultPartInfo.type) : faultPartInfo.type != null);
        }

        public int hashCode() {
            int result = this.type != null ? this.type.hashCode() : 0;
            result = 29 * result + (this.element != null ? this.element.hashCode() : 0);
            result = 29 * result + this.name.hashCode();
            return result;
        }

        public void setCorrectSchema(Schema schema) throws SchemaException {
            QName name;
            Member auxElement;
            if (this.element != null && (auxElement = schema.getSchemaElement(name = this.element.getName())) != null) {
                this.element = auxElement;
            }
            if (this.type != null) {
                name = this.type.getName();
                if (name == null) {
                    if (this.element != null) {
                        this.type = this.element.getType();
                    }
                } else {
                    Type auxType = schema.getSchemaType(name);
                    if (auxType != null) {
                        this.type = auxType;
                    }
                }
            }
        }
    }

    public static class FaultPartInfos {
        private FaultPartInfo[] faults;
        private Set encodings;
        private static final Set EMPTY_SET = new HashSet(0);
        private static final FaultPartInfo[] NO_FAULT_PARTS = new FaultPartInfo[0];

        public FaultPartInfos() {
            this.encodings = EMPTY_SET;
            this.faults = NO_FAULT_PARTS;
        }

        public FaultPartInfos(BindingOperation operation, Schema schema) throws WSDLException, SchemaException {
            Map mappedJavaFaults = this.getFaultsMapping(operation);
            Set set = operation.getBindingFaults().entrySet();
            this.encodings = new HashSet(set.size());
            this.faults = new FaultPartInfo[set.size()];
            Iterator bindingFaults = set.iterator();
            int i = 0;
            while (bindingFaults.hasNext()) {
                Map.Entry entry = bindingFaults.next();
                BindingFault bindingFault = (BindingFault)entry.getValue();
                String name = (String)entry.getKey();
                Fault portTypeFault = operation.getOperation().getFault(name);
                FaultPartInfo faultInfo = new FaultPartInfo(bindingFault, portTypeFault, schema, (String)mappedJavaFaults.get(name));
                this.faults[i++] = faultInfo;
                String encodingURI = faultInfo.getEncodingURI();
                if (encodingURI == null) continue;
                this.encodings.add(encodingURI);
            }
        }

        public FaultPartInfo getFaultPart(String javaType) {
            if (javaType == null) {
                return null;
            }
            int i = 0;
            while (i < this.faults.length) {
                FaultPartInfo fault = this.faults[i];
                if (javaType.equals(fault.getJavaType())) {
                    return fault;
                }
                ++i;
            }
            return null;
        }

        public FaultPartInfo getFaultPartForException(String exceptionName) {
            if (exceptionName == null) {
                return null;
            }
            int i = 0;
            while (i < this.faults.length) {
                FaultPartInfo fault = this.faults[i];
                QName qName = fault.getElementName();
                if (qName != null && exceptionName.equals(qName.getLocalPart())) {
                    return fault;
                }
                qName = fault.getSchemaTypeName();
                if (qName != null && exceptionName.equals(qName.getLocalPart())) {
                    return fault;
                }
                qName = fault.getMessageQName();
                if (qName != null && exceptionName.equals(qName.getLocalPart())) {
                    return fault;
                }
                ++i;
            }
            return null;
        }

        public FaultPartInfo getFaultPart(Type schemaType) {
            if (schemaType == null) {
                return null;
            }
            int i = 0;
            while (i < this.faults.length) {
                FaultPartInfo fault = this.faults[i];
                if (schemaType.equals(fault.getType())) {
                    return fault;
                }
                ++i;
            }
            return null;
        }

        private FaultPartInfo getFaultPartByName(String faultName) {
            if (faultName == null) {
                return null;
            }
            int i = 0;
            while (i < this.faults.length) {
                FaultPartInfo fault = this.faults[i];
                if (faultName.equals(fault.getFaultName())) {
                    return fault;
                }
                ++i;
            }
            return null;
        }

        public FaultPartInfo getFaultPart(SOAPElement partElement) {
            if (partElement == null) {
                return null;
            }
            Name elementName = partElement.getElementName();
            int i = 0;
            while (i < this.faults.length) {
                FaultPartInfo fault = this.faults[i];
                Member faultPartElement = fault.getElement();
                if (faultPartElement == null) {
                    if (elementName.getLocalName().equals(fault.getName())) {
                        return fault;
                    }
                } else {
                    String uri = elementName.getURI();
                    QName fElement = faultPartElement.getName();
                    String fEURI = fElement.getNamespaceURI();
                    if (uri == null) {
                        uri = "";
                    }
                    if (fEURI == null) {
                        fEURI = "";
                    }
                    if (elementName.getLocalName().equals(fElement.getLocalPart()) && uri.equals(fEURI)) {
                        return fault;
                    }
                }
                ++i;
            }
            return null;
        }

        public Set getEncodings() {
            return this.encodings;
        }

        public FaultPartInfo[] getFaultParts() {
            return this.faults;
        }

        public void setCorrectSchema(Schema schema) throws SchemaException {
            int i = 0;
            while (i < this.faults.length) {
                FaultPartInfo fault = this.faults[i];
                fault.setCorrectSchema(schema);
                ++i;
            }
        }

        private Map getFaultsMapping(BindingOperation operation) {
            HashMap<String, String> ret = new HashMap<String, String>(6);
            if (operation.getExtensibilityElements() != null) {
                Iterator extElementsIt = operation.getExtensibilityElements().iterator();
                while (extElementsIt.hasNext()) {
                    ExtensibilityElement extEl = (ExtensibilityElement)extElementsIt.next();
                    if (!(extEl instanceof JavaOperation)) continue;
                    JavaOperation javaOperation = (JavaOperation)extEl;
                    List javaFaultsList = javaOperation.getJavaFaults();
                    int i = 0;
                    while (i < javaFaultsList.size()) {
                        JavaFault javaFault = (JavaFault)javaFaultsList.get(i);
                        ret.put(javaFault.getFaultName(), javaFault.getJavaType());
                        ++i;
                    }
                    break block0;
                }
            }
            return ret;
        }
    }

    public static class PartInfo
    implements Serializable {
        public String partName;
        public int partType;
        public Type inSchemaType;
        public Member inSchemaElement;
        public Type outSchemaType;
        public boolean isAttachment;
        public String mimeType;
        public Member outSchemaElement;
        public boolean isSoapHeader;

        public String toString() {
            StringBuffer ret = new StringBuffer();
            ret.append("Part[");
            ret.append(this.partName);
            ret.append(":");
            ret.append(this.inSchemaType != null ? this.inSchemaType.toIndentedString(0, new HashSet()) : "<null>");
            ret.append(":");
            ret.append(this.inSchemaElement);
            ret.append(":");
            ret.append(this.outSchemaType != null ? this.outSchemaType.toIndentedString(0, new HashSet()) : "<null>");
            ret.append(":");
            ret.append(this.outSchemaElement);
            ret.append("]");
            return ret.toString();
        }

        public void dump(IndentCategory cat) {
            cat.enter(this.partName);
            cat.debug("type : " + (this.partType == 1 ? "IN" : (this.partType == 2 ? "OUT" : "INOUT")));
            cat.leave();
        }
    }
}

