/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.wasp.tools.common;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.idoox.wasp.tools.CompilerIO;

public class FileCompilerIO
implements CompilerIO {
    protected File targetDirectory;

    public FileCompilerIO() {
        this(new File("."));
    }

    public FileCompilerIO(String targetDirectory) {
        this(new File(targetDirectory));
    }

    public FileCompilerIO(File targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public PrintWriter getWriter(String relativePath) throws IOException {
        File path = new File(this.targetDirectory, relativePath);
        File parent = path.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        System.out.println("writing file " + path.getCanonicalPath());
        return new NewLinePrintWriter(new FileWriter(path));
    }

    static class NewLinePrintWriter
    extends PrintWriter {
        NewLinePrintWriter(Writer w) {
            super(w);
        }

        public void print(String s) {
            this.printWithNewlines(s);
        }

        public void println(String s) {
            this.printWithNewlines(s);
            super.println();
        }

        public void println(Object s) {
            this.println(s.toString());
        }

        public void print(Object s) {
            this.print(s.toString());
        }

        private void printWithNewlines(String s) {
            s = s.replace('\r', ' ');
            int pos = -1;
            int oldpos = 0;
            while ((pos = s.indexOf(10, pos + 1)) >= 0) {
                super.println(s.substring(oldpos, pos));
                oldpos = pos + 1;
            }
            if (oldpos < s.length()) {
                super.print(s.substring(oldpos));
            }
        }
    }
}

