/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.wasp.tools.common;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.idoox.wasp.tools.CompilerIO;
import org.idoox.wasp.tools.common.FileCompilerIO;
import org.idoox.wasp.tools.common.FileExistsException;

public class CarefulFileCompilerIO
extends FileCompilerIO
implements CompilerIO {
    protected boolean force = false;

    public CarefulFileCompilerIO(boolean force) {
        this(new File("."), force);
    }

    public CarefulFileCompilerIO(String targetDirectory, boolean force) {
        super(targetDirectory);
        this.force = force;
    }

    public CarefulFileCompilerIO(File targetDirectory, boolean force) {
        super(targetDirectory);
        this.force = force;
    }

    public PrintWriter getWriter(String relativePath) throws IOException {
        File path = new File(this.targetDirectory, relativePath);
        if (!this.force && path.exists()) {
            throw new FileExistsException(path);
        }
        File parent = path.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        System.out.println("writing file " + path.getCanonicalPath());
        return new FileCompilerIO.NewLinePrintWriter(new FileWriter(path));
    }
}

