/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.wasp.serialization.xsdbuiltin;

import java.io.Serializable;
import org.idoox.wasp.serialization.xsdbuiltin.InvalidFormatException;
import org.idoox.wasp.serialization.xsdbuiltin.NormalizedString;

public class Token
extends NormalizedString
implements Serializable {
    static final long serialVersionUID = 9119873283942683681L;
    protected char tokenProhibitedChar = (char)32;

    public Token(String value) throws InvalidFormatException {
        this.set(value);
    }

    protected void check() throws InvalidFormatException {
        super.check();
        int valueLength = this.value.length();
        if (valueLength > 0) {
            if (this.value.charAt(0) == this.tokenProhibitedChar) {
                throw new InvalidFormatException("Invalid token: leading space(s).");
            }
            if (this.value.charAt(valueLength - 1) == this.tokenProhibitedChar) {
                throw new InvalidFormatException("Invalid token: trailing space(s).");
            }
            boolean previousWasSpace = false;
            int i = 1;
            int limit = valueLength - 1;
            while (i < limit) {
                if (this.value.charAt(i) == this.tokenProhibitedChar) {
                    if (previousWasSpace) {
                        throw new InvalidFormatException("Invalid token: sequence of spaces.");
                    }
                    previousWasSpace = true;
                } else {
                    previousWasSpace = false;
                }
                ++i;
            }
        }
    }
}

