/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.wasp.serialization.xsdbuiltin;

import java.io.Serializable;
import org.idoox.wasp.serialization.xsdbuiltin.InvalidFormatException;

public class HexBinary
implements Serializable {
    static final long serialVersionUID = -8153104230051663294L;
    private byte[] bin = null;

    public HexBinary(String value) throws InvalidFormatException {
        this.set(value);
    }

    public HexBinary(byte[] value) throws InvalidFormatException {
        this.set(value);
    }

    public void set(String value) throws InvalidFormatException {
        if (value.length() % 2 == 1) {
            value = "0" + value;
        }
        this.bin = new byte[value.length() / 2];
        int i = 0;
        while (i < this.bin.length) {
            char j = value.charAt(2 * i);
            if (j >= '0' && j <= '9') {
                j = (char)(j - 48);
            } else if (j >= 'A' && j <= 'F') {
                j = (char)(j - 55);
            } else if (j >= 'a' && j <= 'f') {
                j = (char)(j - 87);
            } else {
                throw new InvalidFormatException("hexbinary value not valid. Character " + j + " not allowed.");
            }
            byte b = (byte)(j << 4);
            j = value.charAt(2 * i + 1);
            if (j >= '0' && j <= '9') {
                j = (char)(j - 48);
            } else if (j >= 'A' && j <= 'F') {
                j = (char)(j - 55);
            } else if (j >= 'a' && j <= 'f') {
                j = (char)(j - 87);
            } else {
                throw new InvalidFormatException("hexbinary value not valid. Character " + j + " not allowed.");
            }
            this.bin[i] = b = (byte)(b | (byte)j);
            i = (short)(i + 1);
        }
    }

    public void set(byte[] value) throws InvalidFormatException {
        this.bin = value;
    }

    public String toString() {
        if (this.bin == null) {
            return null;
        }
        if (this.bin.length == 0) {
            return "";
        }
        char[] hex = new char[2 * this.bin.length];
        int i = 0;
        while (i < this.bin.length) {
            char j = (char)(this.bin[i] >> 4 & 0xF);
            hex[i * 2] = j <= '\t' ? (char)(j + 48) : (char)(j + 65 - 10);
            j = (char)(this.bin[i] & 0xF);
            hex[i * 2 + 1] = j <= '\t' ? (char)(j + 48) : (char)(j + 65 - 10);
            i = (short)(i + 1);
        }
        return new String(hex);
    }

    public byte[] toByteArray() {
        return this.bin;
    }
}

