/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.wasp.serialization.xsdbuiltin;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.idoox.wasp.serialization.xsdbuiltin.DateTimeBase;
import org.idoox.wasp.serialization.xsdbuiltin.DateTimeException;
import org.idoox.wasp.serialization.xsdbuiltin.DateTimeParser;
import org.idoox.wasp.serialization.xsdbuiltin.DateTimeUtil;
import org.idoox.wasp.serialization.xsdbuiltin.TimeZone;

public class DateTime
extends DateTimeBase
implements Serializable {
    static final long serialVersionUID = 5257946622307480648L;
    private int day;
    private int month;
    private int year;
    private int hour;
    private int min;
    private BigDecimal sec;

    public DateTime(int year, int month, int day, int hour, int min, BigDecimal sec, TimeZone timeZone, boolean isNegative) throws DateTimeException {
        this.setParams(year, month, day, hour, min, sec, timeZone, isNegative);
    }

    public DateTime(String dateTime) throws DateTimeException {
        DateTimeParser.parseDateTime(dateTime, this);
    }

    public DateTime(Date date) {
        this.setParams(date);
    }

    public void setParams(int year, int month, int day, int hour, int min, BigDecimal sec, TimeZone timeZone, boolean isNegative) throws DateTimeException {
        super.setParams(timeZone);
        this.year = year;
        this.month = this.inputMonth(month);
        this.day = day;
        this.hour = hour;
        this.min = min;
        this.sec = sec;
        this.isNegative = isNegative;
        if (!DateTimeUtil.isDateValid(year, this.month, day)) {
            throw new DateTimeException();
        }
        if (!DateTimeUtil.isTimeValid(hour, min, sec.intValue())) {
            throw new DateTimeException();
        }
    }

    public void setParams(Date date) {
        super.setDefaultTimeZone();
        Calendar calendar = Calendar.getInstance(super.getTimeZone().toJavaUtilTimeZone());
        calendar.setTime(date);
        this.year = calendar.get(1);
        this.month = this.inputMonth(calendar.get(2));
        this.day = calendar.get(5);
        this.hour = calendar.get(11);
        this.min = calendar.get(12);
        int ls1000 = calendar.get(13) * 1000 + calendar.get(14);
        this.sec = new BigDecimal((double)ls1000).movePointLeft(3);
    }

    public Date toJavaUtilDate() {
        java.util.TimeZone juTimeZone = this.timeZone != null ? this.timeZone.toJavaUtilTimeZone() : java.util.TimeZone.getTimeZone("GMT+00:00");
        GregorianCalendar calendar = new GregorianCalendar(juTimeZone);
        calendar.set(this.year, this.outputMonth(this.month), this.day, this.hour, this.min, this.sec.intValue());
        int mSec = this.sec.movePointRight(3).intValue() % 1000;
        calendar.set(14, mSec);
        if (this.isNegative) {
            calendar.set(0, 0);
        } else {
            calendar.set(0, 1);
        }
        return calendar.getTime();
    }

    public String toString() {
        String yearStr = DateTimeUtil.toFourDigitStr(this.year);
        String monthStr = DateTimeUtil.toTwoDigitStr(this.month);
        String dayStr = DateTimeUtil.toTwoDigitStr(this.day);
        String hourStr = DateTimeUtil.toTwoDigitStr(this.hour);
        String minStr = DateTimeUtil.toTwoDigitStr(this.min);
        String secStr = DateTimeUtil.toTwoDigitStr(this.sec);
        String ret = yearStr + "-" + monthStr + "-" + dayStr + "T" + hourStr + ":" + minStr + ":" + secStr;
        if (this.timeZone != null) {
            ret = ret + this.timeZone.toString();
        }
        if (this.isNegative) {
            ret = "-" + ret;
        }
        return ret;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public void setMonth(int month) {
        if (month > 12) {
            throw new RuntimeException("Cannot set month to value > 12. Supplied value: " + month);
        }
        this.month = month;
    }

    public void setDay(int day) {
        if (this.month > 31) {
            throw new RuntimeException("Cannot set day to value > 31. Supplied value: " + day);
        }
        this.day = day;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public void setMinute(int min) {
        this.min = min;
    }

    public void setSecond(BigDecimal sec) {
        this.sec = sec;
    }

    public int getMonth() {
        return this.outputMonth(this.month);
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMin() {
        return this.getMinute();
    }

    public int getMinute() {
        return this.min;
    }

    public BigDecimal getSec() {
        return this.getSecond();
    }

    public BigDecimal getSecond() {
        return this.sec;
    }
}

