/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.wasp.serialization.xsdbuiltin;

import java.io.Serializable;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.idoox.wasp.serialization.xsdbuiltin.DateTimeBase;
import org.idoox.wasp.serialization.xsdbuiltin.DateTimeException;
import org.idoox.wasp.serialization.xsdbuiltin.DateTimeParser;
import org.idoox.wasp.serialization.xsdbuiltin.DateTimeUtil;
import org.idoox.wasp.serialization.xsdbuiltin.TimeZone;

public class Date
extends DateTimeBase
implements Serializable {
    static final long serialVersionUID = 8617049208158174855L;
    private int day;
    private int month;
    private int year;

    public Date(int year, int month, int day, TimeZone timeZone, boolean minusSign) throws DateTimeException {
        this.setParams(year, month, day, timeZone, minusSign);
    }

    public Date(String date) throws Exception {
        DateTimeParser.parseDate(date, this);
    }

    public Date(java.util.Date date) {
        this.setParams(date);
    }

    public void setParams(int year, int month, int day, TimeZone timeZone, boolean isNegative) throws DateTimeException {
        super.setParams(timeZone);
        this.year = year;
        this.month = this.inputMonth(month);
        this.day = day;
        this.isNegative = isNegative;
        if (!DateTimeUtil.isDateValid(this.year, this.month, this.day)) {
            throw new DateTimeException();
        }
    }

    public void setParams(java.util.Date date) {
        this.timeZone = null;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.year = calendar.get(1);
        this.month = this.inputMonth(calendar.get(2));
        this.day = calendar.get(5);
    }

    public java.util.Date toJavaUtilDate() {
        java.util.TimeZone juTimeZone = this.timeZone != null ? this.timeZone.toJavaUtilTimeZone() : java.util.TimeZone.getDefault();
        GregorianCalendar calendar = new GregorianCalendar(juTimeZone);
        calendar.set(this.year, this.outputMonth(this.month), this.day, 0, 0, 0);
        calendar.set(14, 0);
        if (this.isNegative) {
            calendar.set(0, 0);
        } else {
            calendar.set(0, 1);
        }
        return calendar.getTime();
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.outputMonth(this.month);
    }

    public int getDay() {
        return this.day;
    }

    public String toString() {
        String yearStr = DateTimeUtil.toFourDigitStr(this.year);
        String monthStr = DateTimeUtil.toTwoDigitStr(this.month);
        String dayStr = DateTimeUtil.toTwoDigitStr(this.day);
        String ret = yearStr + "-" + monthStr + "-" + dayStr;
        if (this.timeZone != null) {
            ret = ret + this.timeZone.toString();
        }
        if (this.isNegative) {
            ret = "-" + ret;
        }
        return ret;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public void setDay(int day) {
        this.day = day;
    }
}

