/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.wasp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.idoox.xml.Tokenizer;
import org.idoox.xmlrpc.Fault;

public class SoapFaultException
extends RuntimeException {
    protected QName faultCode = null;
    protected List subcodes = null;
    protected String faultString = null;
    protected String faultNode = null;
    protected String faultActor = null;
    protected Tokenizer faultTokenizer = null;
    protected Fault fault = null;
    private static final List EMPTY_LIST = Collections.unmodifiableList(new ArrayList());

    public SoapFaultException(Fault fault) {
        super(fault.getFaultString());
        this.fault = fault;
    }

    public SoapFaultException() {
    }

    public SoapFaultException(QName faultCode, String faultString, String faultActor, Tokenizer detailTokenizer) {
        this(faultCode, null, faultString, faultActor, null, detailTokenizer);
    }

    public SoapFaultException(QName faultCode, List subcodes, String faultString, String faultActor, String faultNode, Tokenizer detailTokenizer) {
        this.faultCode = faultCode;
        this.subcodes = subcodes;
        this.faultString = faultString;
        this.faultActor = faultActor;
        this.faultNode = faultNode;
        this.faultTokenizer = detailTokenizer;
    }

    public QName getFaultCode() {
        if (this.fault != null) {
            return this.fault.getFaultCode();
        }
        return this.faultCode;
    }

    public void setFaultCode(QName faultCode) {
        if (this.fault != null) {
            throw new IllegalStateException("The exception is read-only");
        }
        this.faultCode = faultCode;
    }

    public List getFaultSubcodes() {
        if (this.fault != null) {
            return this.fault.getFaultSubcodes();
        }
        if (this.subcodes == null) {
            return EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.subcodes);
    }

    public void setFaultSubcodes(List subcodes) {
        if (this.fault != null) {
            throw new IllegalStateException("The exception is read-only");
        }
        this.subcodes = subcodes;
    }

    public void clearFaultSubcodes() {
        this.subcodes = null;
    }

    public String getFaultString() {
        if (this.fault != null) {
            return this.fault.getFaultString();
        }
        return this.faultString;
    }

    public void setFaultString(String faultString) {
        if (this.fault != null) {
            throw new IllegalStateException("The exception is read-only");
        }
        this.faultString = faultString;
    }

    public String getFaultReason() {
        return this.getFaultString();
    }

    public void setFaultReason(String faultReason) {
        this.setFaultString(faultReason);
    }

    public String getFaultActor() {
        if (this.fault != null) {
            return this.fault.getFaultActor();
        }
        return this.faultActor;
    }

    public void setFaultActor(String actor) {
        if (this.fault != null) {
            throw new IllegalStateException("The exception is read-only");
        }
        this.faultActor = actor;
    }

    public String getFaultRole() {
        return this.getFaultActor();
    }

    public void setFaultRole(String role) {
        this.setFaultActor(role);
    }

    public String getFaultNode() {
        if (this.fault != null) {
            return this.fault.getFaultNode();
        }
        return this.faultNode;
    }

    public void setFaultNode(String node) {
        if (this.fault != null) {
            throw new IllegalStateException("The exception is read-only");
        }
        this.faultNode = node;
    }

    public Tokenizer getDetailTokenizer() throws IOException {
        if (this.fault != null) {
            return this.fault.getDetailTokenizer();
        }
        return this.faultTokenizer;
    }

    public void setDetailTokenizer(Tokenizer tokenizer) {
        if (this.fault != null) {
            throw new IllegalStateException("The exception is read-only");
        }
        this.faultTokenizer = tokenizer;
    }

    public String toString() {
        String faultNode;
        String faultActor;
        StringBuffer sb = new StringBuffer("SOAP fault: code: ");
        if (this.fault == null) {
            sb.append(this.faultCode);
        } else {
            sb.append(this.fault.getFaultCode());
        }
        List subcodes = this.fault == null ? this.subcodes : this.fault.getFaultSubcodes();
        if (subcodes != null && subcodes.size() != 0) {
            sb.append(", subcodes: ");
            Iterator it = subcodes.iterator();
            while (it.hasNext()) {
                sb.append(it.next());
                if (!it.hasNext()) continue;
                sb.append(",");
            }
        }
        if ((faultActor = this.fault == null ? this.faultActor : this.fault.getFaultActor()) != null) {
            sb.append(", role(actor): ");
            sb.append(faultActor);
        }
        if ((faultNode = this.fault == null ? this.faultNode : this.fault.getFaultNode()) != null) {
            sb.append(", node: ");
            sb.append(faultNode);
        }
        sb.append(", reason(faultstring): ");
        if (this.fault == null) {
            sb.append(this.faultString);
        } else {
            sb.append(this.fault.getFaultString());
        }
        return sb.toString();
    }

    public String getMessage() {
        return this.toString();
    }
}

