/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import org.idoox.util.RuntimeWrappedException;

public class WrappedException
extends Exception {
    private Throwable reason;
    private boolean useOldStackTrace = false;

    public WrappedException() {
        this.reason = null;
    }

    public WrappedException(String message) {
        super(message);
        this.reason = null;
    }

    public WrappedException(String message, Throwable reason) {
        super(message);
        this.reason = reason;
    }

    public WrappedException(Throwable reason) {
        super(reason != null ? reason.toString() : null);
        this.reason = reason;
    }

    public String getLocalizedMessage() {
        if (this.reason == null || this.getMessage() != null && !this.getMessage().equals(this.reason.getMessage())) {
            return this.getMessage();
        }
        return null;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream p) {
        StackTraceHelper.printStackTrace((Throwable)this, p);
    }

    public void printStackTrace(PrintWriter p) {
        StackTraceHelper.printStackTrace((Throwable)this, p);
    }

    public Throwable getException() {
        return this.reason;
    }

    public Throwable getRootException() {
        Throwable ret = this.reason;
        if (this.reason instanceof RuntimeWrappedException) {
            ret = ((RuntimeWrappedException)this.reason).getRootException();
        }
        if (this.reason instanceof WrappedException) {
            ret = ((WrappedException)this.reason).getRootException();
        }
        if (ret == null) {
            ret = this;
        }
        return ret;
    }

    public Throwable getCause() {
        return this.reason;
    }

    void printOneStackTrace(PrintWriter printer) {
        super.printStackTrace(printer);
    }

    void printOneStackTrace(PrintStream printer) {
        super.printStackTrace(printer);
    }

    static class StackTraceHelper {
        static boolean hasGetCause = false;
        static /* synthetic */ Class class$java$lang$Throwable;

        StackTraceHelper() {
        }

        static void printStackTrace(Throwable e, PrintWriter printer) {
            StackTraceHelper.printOneStackTrace(e, printer);
            if (hasGetCause) {
                return;
            }
            Throwable cause = StackTraceHelper.getCause(e);
            if (cause == null) {
                return;
            }
            printer.print("Caused by: ");
            StackTraceHelper.printStackTrace(cause, printer);
        }

        static void printStackTrace(Throwable e, PrintStream printer) {
            StackTraceHelper.printOneStackTrace(e, printer);
            if (hasGetCause) {
                return;
            }
            Throwable cause = StackTraceHelper.getCause(e);
            if (cause == null) {
                return;
            }
            printer.print("Caused by: ");
            StackTraceHelper.printStackTrace(cause, printer);
        }

        private static void printOneStackTrace(Throwable e, PrintStream printer) {
            if (e instanceof RuntimeWrappedException) {
                RuntimeWrappedException ex = (RuntimeWrappedException)e;
                ex.printOneStackTrace(printer);
            } else if (e instanceof WrappedException) {
                WrappedException ex = (WrappedException)e;
                ex.printOneStackTrace(printer);
            } else {
                e.printStackTrace(printer);
            }
        }

        private static void printOneStackTrace(Throwable e, PrintWriter printer) {
            if (e instanceof RuntimeWrappedException) {
                RuntimeWrappedException ex = (RuntimeWrappedException)e;
                ex.printOneStackTrace(printer);
            } else if (e instanceof WrappedException) {
                WrappedException ex = (WrappedException)e;
                ex.printOneStackTrace(printer);
            } else {
                e.printStackTrace(printer);
            }
        }

        private static Throwable getCause(Throwable e) {
            if (e instanceof RuntimeWrappedException) {
                RuntimeWrappedException ex = (RuntimeWrappedException)e;
                return ex.getCause();
            }
            if (e instanceof WrappedException) {
                WrappedException ex = (WrappedException)e;
                return ex.getCause();
            }
            if (e instanceof UndeclaredThrowableException) {
                UndeclaredThrowableException ex = (UndeclaredThrowableException)e;
                return ex.getUndeclaredThrowable();
            }
            if (e instanceof InvocationTargetException) {
                InvocationTargetException ex = (InvocationTargetException)e;
                return ex.getTargetException();
            }
            if (e instanceof RemoteException) {
                RemoteException ex = (RemoteException)e;
                return ex.detail;
            }
            return null;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        static {
            Method getCause = null;
            try {
                getCause = (class$java$lang$Throwable == null ? (class$java$lang$Throwable = StackTraceHelper.class$("java.lang.Throwable")) : class$java$lang$Throwable).getMethod("getCause", new Class[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            hasGetCause = getCause != null;
        }
    }
}

