/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.util;

import com.idoox.debug.Category;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.systinet.wasp.transaction.Resource;

public class LongSet
implements Externalizable,
Resource {
    private static final long serialVersionUID = 477748573112499033L;
    protected static final Category log = Category.getCategory((class$org$idoox$util$LongSet == null ? (class$org$idoox$util$LongSet = LongSet.class$("org.idoox.util.LongSet")) : class$org$idoox$util$LongSet).getName());
    private List points;
    private boolean inTransaction = false;
    private List clone = null;
    static /* synthetic */ Class class$org$idoox$util$LongSet;

    public LongSet() {
        this.points = new ArrayList();
    }

    public LongSet(LongSet src) {
        this.points = new ArrayList(src.points);
    }

    LongSet(LongPoint[] points) {
        this.points = new ArrayList(points.length);
        int i = 0;
        while (i < points.length) {
            this.points.add(points[i]);
            ++i;
        }
    }

    LongSet(long lower, long upper) {
        this.points = new ArrayList();
        this.add(lower, upper);
    }

    public boolean contains(long value) {
        return this.contains(value, value);
    }

    public boolean contains(long lower, long upper) {
        int i = 0;
        while (i < this.points.size()) {
            LongPoint lp = (LongPoint)this.points.get(i);
            if (lower <= lp.upper) {
                return lower >= lp.lower && upper <= lp.upper;
            }
            ++i;
        }
        return false;
    }

    public void add(long value) {
        this.add(value, value);
    }

    public void add(long from, long to) {
        if (from > to) {
            throw new IllegalArgumentException("Invalid range supplied: [" + from + ", " + to + "]");
        }
        this.checkTransaction();
        int i = this.points.size() - 1;
        while (i >= 0) {
            LongPoint upperPoint = (LongPoint)this.points.get(i);
            if (to + 1L >= upperPoint.lower) {
                if (from > upperPoint.upper + 1L) {
                    this.points.add(i + 1, new LongPoint(from, to));
                    return;
                }
                if (to < upperPoint.upper) {
                    to = upperPoint.upper;
                }
                LongPoint lowerPoint = upperPoint;
                int j = i - 1;
                while (j >= 0) {
                    lowerPoint = (LongPoint)this.points.get(j);
                    if (from > lowerPoint.upper + 1L) {
                        lowerPoint = upperPoint;
                        ++j;
                        break;
                    }
                    lowerPoint = (LongPoint)this.points.remove(j);
                    if (from > lowerPoint.lower) break;
                    --j;
                }
                if (from > lowerPoint.lower) {
                    from = lowerPoint.lower;
                }
                if (j < 0) {
                    j = 0;
                }
                this.points.set(j, new LongPoint(from, to));
                return;
            }
            --i;
        }
        this.points.add(0, new LongPoint(from, to));
    }

    public Iterator getPoints() {
        return this.points.iterator();
    }

    public void remove(long value) {
        this.remove(value, value);
    }

    public void remove(long from, long to) {
        if (from > to) {
            throw new IllegalArgumentException("Invalid range supplied: [" + from + ", " + to + "]");
        }
        this.checkTransaction();
        int i = this.points.size() - 1;
        while (i >= 0) {
            LongPoint point = (LongPoint)this.points.get(i);
            if (to >= point.lower) {
                int j = i;
                if (to < point.upper) {
                    this.points.set(j, new LongPoint(to + 1L, point.upper));
                    if (from > point.lower) {
                        this.points.add(j, new LongPoint(point.lower, from - 1L));
                        return;
                    }
                    --j;
                }
                while (j >= 0) {
                    point = (LongPoint)this.points.get(j);
                    if (point.upper < from) {
                        return;
                    }
                    if (point.lower < from) {
                        this.points.set(j, new LongPoint(point.lower, from - 1L));
                        return;
                    }
                    this.points.remove(j--);
                }
                return;
            }
            --i;
        }
    }

    private void checkTransaction() {
        if (this.inTransaction && null == this.clone) {
            this.clone = new ArrayList(this.points);
        }
    }

    int getDifference(LongSet that) {
        int diff = this.points.size() - that.points.size();
        if (diff != 0) {
            return diff;
        }
        Object[] thisPoints = this.points.toArray();
        Object[] thatPoints = that.points.toArray();
        int i = 0;
        while (i < thisPoints.length) {
            if (!((LongPoint)thisPoints[i]).equals(thatPoints[i])) {
                return 1;
            }
            ++i;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LongSet)) {
            return false;
        }
        LongSet longSet = (LongSet)o;
        return this.points.equals(longSet.points);
    }

    public int hashCode() {
        return this.points.hashCode();
    }

    public void union(LongSet set) {
        int i = 0;
        while (i < set.points.size()) {
            LongPoint point = (LongPoint)set.points.get(i);
            this.add(point.lower, point.upper);
            ++i;
        }
    }

    public void difference(LongSet set) {
        int i = 0;
        while (i < set.points.size()) {
            LongPoint point = (LongPoint)set.points.get(i);
            this.remove(point.lower, point.upper);
            ++i;
        }
    }

    public static LongSet intersection(LongSet a, LongSet b) {
        LongSet result = new LongSet();
        int aPos = 0;
        int bPos = 0;
        int aLimit = a.points.size();
        int bLimit = b.points.size();
        while (aPos < aLimit && bPos < bLimit) {
            boolean swapped;
            LongPoint min = (LongPoint)a.points.get(aPos);
            LongPoint max = (LongPoint)b.points.get(bPos);
            boolean bl = swapped = min.lower > max.lower;
            if (swapped) {
                LongPoint swap = min;
                min = max;
                max = swap;
            }
            if (max.upper <= min.upper) {
                result.add(max.lower, max.upper);
                if (swapped) {
                    ++aPos;
                    continue;
                }
                ++bPos;
                continue;
            }
            if (min.upper >= max.lower) {
                result.add(max.lower, min.upper);
            }
            if (swapped) {
                ++bPos;
                continue;
            }
            ++aPos;
        }
        return result;
    }

    public boolean isEmpty() {
        return this.points.isEmpty();
    }

    public long getMax() {
        int last = this.points.size() - 1;
        if (last < 0) {
            throw new IllegalStateException("Unable to get the maximal point, no point available!");
        }
        return ((LongPoint)this.points.get(last)).upper;
    }

    public long getMin() {
        if (0 == this.points.size()) {
            throw new IllegalStateException("Unable to get the minimal point, no point available!");
        }
        return ((LongPoint)this.points.get(0)).lower;
    }

    public String toString() {
        if (this.points.isEmpty()) {
            return "<empty>";
        }
        StringBuffer sb = new StringBuffer(this.points.size() * 5);
        boolean first = true;
        int i = 0;
        while (i < this.points.size()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            LongPoint point = (LongPoint)this.points.get(i);
            sb.append(point);
            ++i;
        }
        return sb.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.points.size());
        Iterator i = this.points.iterator();
        while (i.hasNext()) {
            LongPoint point = (LongPoint)i.next();
            out.writeLong(point.lower);
            out.writeLong(point.upper);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            long lower = in.readLong();
            long upper = in.readLong();
            this.points.add(new LongPoint(lower, upper));
            ++i;
        }
    }

    public void begin() {
        this.inTransaction = true;
    }

    public void commit() {
        this.clone = null;
        this.inTransaction = false;
    }

    public void rollback() {
        if (null != this.clone) {
            this.points = this.clone;
            this.clone = null;
        }
        this.inTransaction = false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class LongPoint {
        private long lower;
        private long upper;
        private int hashCode = 0;

        LongPoint(long lower, long upper) {
            if (lower > upper) {
                throw new IllegalArgumentException("Invalid range supplied: [" + lower + ", " + upper + "]");
            }
            this.lower = lower;
            this.upper = upper;
        }

        public long getLower() {
            return this.lower;
        }

        public long getUpper() {
            return this.upper;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LongPoint)) {
                return false;
            }
            LongPoint lp = (LongPoint)o;
            if (this.lower != lp.lower) {
                return false;
            }
            return this.upper == lp.upper;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = (int)(this.lower ^ this.lower >>> 32);
                this.hashCode = 29 * this.hashCode + (int)(this.upper ^ this.upper >>> 32);
            }
            return this.hashCode;
        }

        public String toString() {
            return this.lower == this.upper ? Long.toString(this.lower) : "[" + this.lower + "-" + this.upper + "]";
        }
    }
}

