/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.namespace;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class QName
implements Serializable {
    private String namespaceURI;
    private String localPart;

    public QName(String localPart) {
        if (localPart == null) {
            throw new IllegalArgumentException("Local part not allowed to be null");
        }
        this.namespaceURI = "";
        this.localPart = localPart;
    }

    public QName(String namespaceURI, String localPart) {
        if (localPart == null) {
            throw new IllegalArgumentException("Local part not allowed to be null");
        }
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        this.namespaceURI = namespaceURI;
        this.localPart = localPart;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getLocalPart() {
        return this.localPart;
    }

    public String toString() {
        if (this.namespaceURI.equals("")) {
            return this.localPart;
        }
        return "{" + this.namespaceURI + "}" + this.localPart;
    }

    public static QName valueOf(String s) {
        if (s == null || s.equals("")) {
            throw new IllegalArgumentException("invalid QName literal");
        }
        if (s.charAt(0) == '{') {
            int i = s.indexOf(125);
            if (i == -1) {
                throw new IllegalArgumentException("invalid QName literal");
            }
            if (i == s.length() - 1) {
                throw new IllegalArgumentException("invalid QName literal");
            }
            return new QName(s.substring(1, i), s.substring(i + 1));
        }
        return new QName(s);
    }

    public final int hashCode() {
        return this.namespaceURI.hashCode() ^ this.localPart.hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QName)) {
            return false;
        }
        QName qname = (QName)obj;
        return this.namespaceURI.equals(qname.namespaceURI) && this.localPart.equals(qname.localPart);
    }

    private void readObject(ObjectInputStream objectinputstream) throws IOException, ClassNotFoundException {
        objectinputstream.defaultReadObject();
        this.namespaceURI = this.namespaceURI.intern();
        this.localPart = this.localPart.intern();
    }
}

