/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wsaddressing;

import com.idoox.debug.Category;
import com.systinet.wsaddressing.NamesCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.systinet.wasp.addressing.AddressingHeaders;
import org.systinet.wasp.addressing.Constants;
import org.systinet.wasp.addressing.EndpointReference;
import org.systinet.wasp.addressing.ReferenceProperties;
import org.systinet.wasp.handler.WaspGenericHandler;
import org.systinet.wasp.policy.EffectivePolicy;
import org.systinet.wasp.policy.PolicyException;
import org.systinet.wasp.policy.PolicyUsage;
import org.systinet.wasp.policy.assertion.SpecVersionAssertion;
import org.systinet.wasp.sequence.Sequence;
import org.systinet.wasp.soap.RenameableSOAPElement;
import org.systinet.wasp.soap.WaspSOAPMessage;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceClientContext;
import org.systinet.wasp.webservice.ServiceEndpointContext;

public class WSAddressingHandler
extends WaspGenericHandler {
    private static final Category log = Category.getCategory((class$com$systinet$wsaddressing$WSAddressingHandler == null ? (class$com$systinet$wsaddressing$WSAddressingHandler = WSAddressingHandler.class$("com.systinet.wsaddressing.WSAddressingHandler")) : class$com$systinet$wsaddressing$WSAddressingHandler).getName());
    private static final String KEY_WSA_TOUSE = "WS-Addressing version to use";
    public static QName[] WSA_UNDERSTAND_HEADERS = new QName[]{new QName("http://schemas.xmlsoap.org/ws/2004/03/addressing", "Action"), new QName("http://schemas.xmlsoap.org/ws/2004/03/addressing", "Address"), new QName("http://schemas.xmlsoap.org/ws/2004/03/addressing", "FaultTo"), new QName("http://schemas.xmlsoap.org/ws/2004/03/addressing", "From"), new QName("http://schemas.xmlsoap.org/ws/2004/03/addressing", "MessageID"), new QName("http://schemas.xmlsoap.org/ws/2004/03/addressing", "PortType"), new QName("http://schemas.xmlsoap.org/ws/2004/03/addressing", "Recipient"), new QName("http://schemas.xmlsoap.org/ws/2004/03/addressing", "RelatesTo"), new QName("http://schemas.xmlsoap.org/ws/2004/03/addressing", "ReplyTo"), new QName("http://schemas.xmlsoap.org/ws/2004/03/addressing", "ServiceName"), new QName("http://schemas.xmlsoap.org/ws/2004/03/addressing", "To"), new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "Action"), new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "Address"), new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "FaultTo"), new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "From"), new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "MessageID"), new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "PortType"), new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "Recipient"), new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "RelatesTo"), new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "ReplyTo"), new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "ServiceName"), new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "To"), new QName("http://schemas.xmlsoap.org/ws/2003/03/addressing", "Action"), new QName("http://schemas.xmlsoap.org/ws/2003/03/addressing", "Address"), new QName("http://schemas.xmlsoap.org/ws/2003/03/addressing", "FaultTo"), new QName("http://schemas.xmlsoap.org/ws/2003/03/addressing", "From"), new QName("http://schemas.xmlsoap.org/ws/2003/03/addressing", "MessageID"), new QName("http://schemas.xmlsoap.org/ws/2003/03/addressing", "PortType"), new QName("http://schemas.xmlsoap.org/ws/2003/03/addressing", "Recipient"), new QName("http://schemas.xmlsoap.org/ws/2003/03/addressing", "RelatesTo"), new QName("http://schemas.xmlsoap.org/ws/2003/03/addressing", "ReplyTo"), new QName("http://schemas.xmlsoap.org/ws/2003/03/addressing", "ServiceName"), new QName("http://schemas.xmlsoap.org/ws/2003/03/addressing", "To")};
    private static SOAPFactory soapFactory;
    private static SOAPException exceptionInInit;
    private static final Map allNames;
    private static final AddressingHeaders NO_HEADERS;
    static /* synthetic */ Class class$com$systinet$wsaddressing$WSAddressingHandler;

    public void init(HandlerInfo config) {
        super.init(config);
    }

    public boolean handleFault(MessageContext context) {
        int processingType = Current.getProcessingType();
        boolean result = processingType == 1 ? this.handleInput(context) : this.handleOutput(context);
        return result;
    }

    public boolean handleInput(MessageContext context) {
        block15: {
            if (!context.containsProperty("MessageSourceImpl.headerPresent")) {
                return true;
            }
            try {
                if (exceptionInInit != null) {
                    throw exceptionInInit;
                }
                SOAPMessage message = ((SOAPMessageContext)context).getMessage();
                SOAPHeader header = message.getSOAPPart().getEnvelope().getHeader();
                if (header == null) break block15;
                String messageAddressingURI = null;
                NamesCache names = null;
                SOAPElement element = null;
                int i = 0;
                while (i < Constants.SUPPORTED_WSA.length) {
                    NamesCache testNamespaces = (NamesCache)allNames.get(Constants.SUPPORTED_WSA[i]);
                    element = this.getWSAElement(header, testNamespaces.getElementTo());
                    if (element != null) {
                        messageAddressingURI = Constants.SUPPORTED_WSA[i];
                        names = testNamespaces;
                        break;
                    }
                    ++i;
                }
                if (element == null) {
                    return true;
                }
                try {
                    this.checkMessageAddressingURIForInput(messageAddressingURI);
                }
                catch (PolicyException e) {
                    log.error(e.getMessage());
                    ((SOAPMessageContext)context).setMessage(null);
                    return false;
                }
                AddressingHeaders headers = new AddressingHeaders(null);
                headers.to = new EndpointReference(this.normalizeAnonymousAddress(messageAddressingURI, element.getValue()));
                EndpointReference to = this.getWSAEndpointReference(header, names.getElementRecipient(), names);
                if (to != null) {
                    if (!headers.to.getAddress().equals(to.getAddress())) {
                        log.error("Recipient/Address URI (" + headers.to + ") differs from To URI (" + to + ")!");
                    } else {
                        headers.to = to;
                    }
                }
                headers.messageID = this.getWSAElementTextValue(header, names.getElementMessageId());
                headers.from = this.getWSAEndpointReference(header, names.getElementFrom(), names);
                headers.replyTo = this.getWSAEndpointReference(header, names.getElementReplyTo(), names);
                headers.faultTo = this.getWSAEndpointReference(header, names.getElementFaultTo(), names);
                Iterator elements = header.getChildElements(names.getElementRelatesTo());
                if (elements.hasNext()) {
                    ArrayList<AddressingHeaders.Relationship> relationships = new ArrayList<AddressingHeaders.Relationship>(2);
                    while (elements.hasNext()) {
                        element = (SOAPElement)elements.next();
                        String messageID = element.getValue();
                        QName type = this.stringToQName(element.getAttributeValue(names.getAttributeRelationship()), element);
                        relationships.add(new AddressingHeaders.Relationship(messageID, type));
                    }
                    headers.relatesTo = relationships.toArray(new AddressingHeaders.Relationship[0]);
                }
                if (!NO_HEADERS.equals(headers)) {
                    Current.getCallContext().getContextData().put("addressing.input", headers);
                }
            }
            catch (SOAPException e) {
                throw new JAXRPCException(e);
            }
        }
        return true;
    }

    public boolean handleOutput(MessageContext context) {
        log.debug("Handling output");
        AddressingHeaders headers = (AddressingHeaders)Current.getCallContext().getContextData().get("addressing.output");
        if (headers != null) {
            String useAddressingURI;
            try {
                useAddressingURI = this.computeAddressingURIForOutput();
            }
            catch (PolicyException e) {
                log.error(e.getMessage());
                return false;
            }
            NamesCache names = (NamesCache)allNames.get(useAddressingURI);
            try {
                SOAPHeaderElement he;
                boolean outSeq;
                boolean bl = outSeq = Sequence.getActiveOutputSequence() != null;
                if (exceptionInInit != null) {
                    throw exceptionInInit;
                }
                SOAPMessage message = ((SOAPMessageContext)context).getMessage();
                SOAPEnvelope envelope = message.getSOAPPart().getEnvelope();
                envelope.addNamespaceDeclaration("wsa", useAddressingURI);
                SOAPHeader header = envelope.getHeader();
                if (header == null) {
                    header = envelope.addHeader();
                }
                if (headers.messageID != null) {
                    he = (SOAPHeaderElement)this.addWSATextElement(header, names.getElementMessageId(), headers.messageID);
                    if (outSeq) {
                        he.setMustUnderstand(true);
                    }
                }
                if (headers.to != null) {
                    SOAPHeaderElement he2;
                    EndpointReference nakedTo = new EndpointReference(this.deNormalizeAnonymousAddress(useAddressingURI, headers.to.getAddress()));
                    if (useAddressingURI.equals("http://schemas.xmlsoap.org/ws/2003/03/addressing") && !headers.to.equals(nakedTo)) {
                        he2 = (SOAPHeaderElement)this.addWSAEndpointReference(header, names.getElementRecipient(), headers.to, names);
                        if (outSeq) {
                            he2.setMustUnderstand(true);
                        }
                    }
                    he2 = (SOAPHeaderElement)this.addWSATextElement(header, names.getElementTo(), this.deNormalizeAnonymousAddress(useAddressingURI, headers.to.getAddress()));
                    if (outSeq) {
                        he2.setMustUnderstand(true);
                    }
                    Iterator itProperties = headers.to.getReferenceProperties().getChildElements();
                    while (itProperties.hasNext()) {
                        Object property = itProperties.next();
                        if (!(property instanceof SOAPElement)) continue;
                        header.addChildElement((SOAPElement)property);
                    }
                } else {
                    log.error("No 'TO' present in addressing output headers");
                }
                if (headers.from != null) {
                    he = (SOAPHeaderElement)this.addWSAEndpointReference(header, names.getElementFrom(), headers.from, names);
                    if (outSeq) {
                        he.setMustUnderstand(true);
                    }
                }
                if (!(headers.replyTo == null || headers.from != null && headers.replyTo.getAddress().equals(headers.from.getAddress()))) {
                    this.addWSAEndpointReference(header, names.getElementReplyTo(), headers.replyTo, names);
                }
                if (!(headers.faultTo == null || headers.replyTo != null && headers.faultTo.getAddress().equals(headers.replyTo.getAddress()))) {
                    this.addWSAEndpointReference(header, names.getElementFaultTo(), headers.faultTo, names);
                }
                int i = 0;
                while (i < headers.relatesTo.length) {
                    SOAPElement element = this.addWSATextElement(header, names.getElementRelatesTo(), headers.relatesTo[i].messageID);
                    QName type = headers.relatesTo[i].type;
                    if (type != null) {
                        element.addAttribute(names.getAttributeRelationship(), "nsr:" + type.getLocalPart());
                        element.addNamespaceDeclaration("nsr", type.getNamespaceURI());
                    }
                    ++i;
                }
                if (message instanceof WaspSOAPMessage) {
                    String action = ((WaspSOAPMessage)message).getSOAPAction();
                    if ((action == null || "".equals(action)) && headers.relatesTo.length > 0) {
                        action = "Response";
                    }
                    if (action != null && !"".equals(action)) {
                        SOAPHeaderElement he3 = (SOAPHeaderElement)this.addWSATextElement(header, names.getElementAction(), action);
                        if (outSeq) {
                            he3.setMustUnderstand(true);
                        }
                    }
                }
            }
            catch (SOAPException e) {
                throw new JAXRPCException(e);
            }
        }
        return true;
    }

    private final SOAPElement addWSAEndpointReference(SOAPHeader header, Name name, EndpointReference epr, NamesCache namesCache) throws SOAPException {
        ReferenceProperties rp;
        Iterator rpChilds;
        SOAPHeaderElement eprElement = header.addHeaderElement(name);
        if (epr.getAddress() != null) {
            this.addWSATextElement(eprElement, namesCache.getElementAddress(), this.deNormalizeAnonymousAddress(namesCache.getNamespaceURI(), epr.getAddress()));
        }
        if (epr.getPortType() != null) {
            this.addWSAQNameElement(eprElement, namesCache.getElementPortType(), epr.getPortType());
        }
        if (epr.getServiceName() != null) {
            SOAPElement element = this.addWSAQNameElement(eprElement, namesCache.getElementServiceName(), epr.getServiceName());
            if (epr.getPortName() != null) {
                element.addAttribute(namesCache.getAttributePortName(), epr.getPortName());
            }
        }
        if ((rpChilds = (rp = epr.getReferenceProperties()).getChildElements()).hasNext()) {
            SOAPElement internalElement = rp.getInternalSOAPElement();
            ((RenameableSOAPElement)((Object)internalElement)).setName(namesCache.getElementReferenceProperties());
            eprElement.addChildElement(internalElement);
        }
        return eprElement;
    }

    private final SOAPElement addWSATextElement(SOAPElement header, Name name, String value) throws SOAPException {
        SOAPElement element = header.addChildElement(name);
        element.addTextNode(value);
        return element;
    }

    private final SOAPElement addWSAQNameElement(SOAPElement header, Name name, QName value) throws SOAPException {
        SOAPElement element = header.addChildElement(name);
        element.addNamespaceDeclaration("nse", value.getNamespaceURI());
        element.addTextNode("nse:" + value.getLocalPart());
        return element;
    }

    private final String getWSAElementTextValue(SOAPElement element, Name name) {
        SOAPElement child = this.getWSAElement(element, name);
        if (child != null) {
            return child.getValue();
        }
        return null;
    }

    private final QName getWSAElementQNameValue(SOAPElement element, Name name) {
        SOAPElement child = this.getWSAElement(element, name);
        if (child != null) {
            QName value = this.stringToQName(child.getValue(), child);
            return value;
        }
        return null;
    }

    private final SOAPElement getWSAElement(SOAPElement element, Name name) {
        Iterator children = element.getChildElements(name);
        if (children.hasNext()) {
            return (SOAPElement)children.next();
        }
        return null;
    }

    private final EndpointReference getWSAEndpointReference(SOAPElement element, Name name, NamesCache namesCache) throws SOAPException {
        EndpointReference epr = null;
        Iterator children = element.getChildElements(name);
        if (children.hasNext()) {
            SOAPElement eprElement = (SOAPElement)children.next();
            String address = this.normalizeAnonymousAddress(namesCache.getNamespaceURI(), this.getWSAElementTextValue(eprElement, namesCache.getElementAddress()));
            QName portType = this.getWSAElementQNameValue(eprElement, namesCache.getElementPortType());
            SOAPElement serviceElement = this.getWSAElement(eprElement, namesCache.getElementServiceName());
            QName serviceName = null;
            String portName = null;
            if (serviceElement != null) {
                serviceName = this.stringToQName(serviceElement.getValue(), serviceElement);
                portName = serviceElement.getAttributeValue(soapFactory.createName("PortName"));
            }
            epr = new EndpointReference(this.normalizeAnonymousAddress(namesCache.getNamespaceURI(), address), portType, serviceName, portName);
            SOAPElement refPropElement = this.getWSAElement(eprElement, namesCache.getElementReferenceProperties());
            if (refPropElement != null) {
                ReferenceProperties rp = epr.getReferenceProperties();
                ((RenameableSOAPElement)((Object)refPropElement)).setName(namesCache.getElementReferencePropertiesInternal());
                rp.setInternalSOAPElement(refPropElement);
            }
        }
        return epr;
    }

    private final QName stringToQName(String src, SOAPElement element) {
        QName result = null;
        if (src != null) {
            int prefixIdx = src.indexOf(58);
            if (prefixIdx != -1) {
                if (prefixIdx >= src.length()) {
                    return null;
                }
                String prefix = src.substring(0, prefixIdx);
                String localPart = src.substring(prefixIdx + 1);
                result = new QName(element.getNamespaceURI(prefix), localPart);
            } else {
                result = new QName(src);
            }
        }
        return result;
    }

    private String normalizeAnonymousAddress(String usedNamespaceUri, String address) {
        if (Constants.WSA_TO_ADDRESS_ANONYMOUS_MAPPING.get(usedNamespaceUri).equals(address)) {
            return "http://schemas.xmlsoap.org/ws/2003/03/addressing/role/anonymous";
        }
        return address;
    }

    private String deNormalizeAnonymousAddress(String toNamespaceUri, String address) {
        if ("http://schemas.xmlsoap.org/ws/2003/03/addressing/role/anonymous".equals(address)) {
            return (String)Constants.WSA_TO_ADDRESS_ANONYMOUS_MAPPING.get(toNamespaceUri);
        }
        return address;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String computeAddressingURIForOutput() throws PolicyException {
        String useAddressingURI = null;
        int processingType = Current.getProcessingType();
        ServiceEndpointContext serviceEndpointContext = null;
        ServiceClientContext serviceClientContext = null;
        if (processingType == 2) {
            serviceEndpointContext = Current.getServiceEndpointContext();
            useAddressingURI = (String)serviceEndpointContext.getContextData().get(KEY_WSA_TOUSE);
        } else if (processingType == 1) {
            serviceClientContext = Current.getServiceClientContext();
            useAddressingURI = (String)serviceClientContext.getContextData().get(KEY_WSA_TOUSE);
        }
        boolean addressingFoundInCache = true;
        EffectivePolicy ep = (EffectivePolicy)Current.getCallContext().getContextData().get("policy.output");
        if (useAddressingURI == null) {
            addressingFoundInCache = false;
            if (ep == null) throw new PolicyException("No effective policy specified.");
            int maxPreference = -1;
            SpecVersionAssertion wsa = null;
            int i = 0;
            while (i < Constants.SUPPORTED_WSA.length) {
                SpecVersionAssertion wsaTemp = (SpecVersionAssertion)ep.getAssertion(new SpecVersionAssertion(Constants.SUPPORTED_WSA[i], null));
                if (wsaTemp != null && !wsaTemp.getUsage().equals(PolicyUsage.REJECTED) && wsaTemp.getPreference() > maxPreference) {
                    maxPreference = wsaTemp.getPreference();
                    wsa = wsaTemp;
                }
                ++i;
            }
            if (wsa == null) throw new PolicyException("No supported WS-Addressing SpecVersion found in effective policy");
            ep.setSatisfied(wsa);
            useAddressingURI = wsa.getURI();
        } else if (ep != null) {
            ep.setSatisfied(new SpecVersionAssertion(useAddressingURI, null));
        }
        if (useAddressingURI == null) throw new PolicyException("Cannot handle output, no supported WS-Addressing specified in the policy.");
        if (addressingFoundInCache) return useAddressingURI;
        if (processingType == 2) {
            serviceEndpointContext.getContextData().put(KEY_WSA_TOUSE, useAddressingURI);
            return useAddressingURI;
        } else {
            if (processingType != 1) return useAddressingURI;
            serviceClientContext.getContextData().put(KEY_WSA_TOUSE, useAddressingURI);
        }
        return useAddressingURI;
    }

    private void checkMessageAddressingURIForInput(String messageAddressingURI) throws PolicyException {
        EffectivePolicy ep = (EffectivePolicy)Current.getCallContext().getContextData().get("policy.input");
        if (ep != null) {
            SpecVersionAssertion specVersion = (SpecVersionAssertion)ep.setSatisfied(new SpecVersionAssertion(messageAddressingURI, null));
            if (specVersion != null) {
                if (specVersion.getUsage().equals(PolicyUsage.REJECTED)) {
                    throw new PolicyException("WS-Addressing version '" + messageAddressingURI + "' specified in the message not supported. According to the policy," + " messages with this WS-Addressing version are rejected");
                }
            } else {
                boolean supported = false;
                int i = 0;
                while (i < Constants.SUPPORTED_WSA.length) {
                    if (Constants.SUPPORTED_WSA[i].equals(messageAddressingURI)) {
                        supported = true;
                        break;
                    }
                    ++i;
                }
                if (!supported) {
                    throw new PolicyException("WS-Addressing version '" + messageAddressingURI + "' not supported.");
                }
            }
        } else {
            throw new PolicyException("Cannot handle input, no effective policy found.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        exceptionInInit = null;
        allNames = Collections.synchronizedMap(new HashMap());
        try {
            soapFactory = SOAPFactory.newInstance();
            int i = 0;
            while (i < Constants.SUPPORTED_WSA.length) {
                allNames.put(Constants.SUPPORTED_WSA[i], new NamesCache(Constants.SUPPORTED_WSA[i], soapFactory));
                ++i;
            }
        }
        catch (SOAPException e) {
            exceptionInInit = e;
        }
        NO_HEADERS = new AddressingHeaders(null);
    }
}

