/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.webservice;

import com.idoox.wasp.InitialReferencesRegistrar;
import com.idoox.wasp.ProtocolRepositoryImpl;
import com.idoox.wasp.interceptor.InterceptorRepository;
import com.idoox.wasp.serialization.SerializationRepositoryImpl;
import com.idoox.xmlrpc.header.HeaderProcessorRepositoryImpl;
import com.systinet.wasp.webservice.InstanceNameGenerator;
import org.idoox.config.Configurable;
import org.idoox.wasp.Context;
import org.idoox.wasp.Module;
import org.idoox.wasp.interceptor.Interceptor;
import org.idoox.xmlrpc.header.HeaderProcessor;

public class WASPConfigurationImpl
implements Module {
    public static final String CORE_CONFIGURATION = "com.systinet.wasp.WASPConfigurationImpl";
    protected HeaderProcessorRepositoryImpl hpRepo;
    protected InterceptorRepository iRepo;
    protected ProtocolRepositoryImpl pRepo;
    protected SerializationRepositoryImpl sRepo;

    public String registerInterceptor(Interceptor instance) {
        String name = InstanceNameGenerator.generateName(instance);
        this.iRepo.addInterceptor(name, instance);
        return name;
    }

    public void unregisterInterceptor(String name) {
        this.iRepo.removeInterceptor(name);
    }

    public String registerHeaderProcessor(HeaderProcessor instance) {
        return this.hpRepo.addHPInstance(instance);
    }

    public void unregisterHeaderProcessor(String name) {
        this.hpRepo.removeHPInstance(name);
    }

    public String registerProtocol(String protocol, Class protocolHandlerClass) {
        return this.pRepo.registerProtocol(protocol, protocolHandlerClass);
    }

    public void unregisterProtocol(String name) {
        this.pRepo.unregisterProtocol(name);
    }

    public void setDefaultProtocol(String name) {
        this.pRepo.setDefaultProtocol(name);
    }

    public void load(Configurable config) {
        InitialReferencesRegistrar.addInitialReference(CORE_CONFIGURATION, this);
    }

    public void init() {
        try {
            this.hpRepo = (HeaderProcessorRepositoryImpl)Context.getInstance("com.idoox.xmlrpc.header.HeaderProcessorRepository");
            this.pRepo = (ProtocolRepositoryImpl)Context.getInstance("org.idoox.wasp.ProtocolRepository");
            this.sRepo = (SerializationRepositoryImpl)Context.getInstance("org.idoox.wasp.serialization.SerializationRepository");
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Unsupported implementation of a repository! (" + e.getMessage() + ")");
        }
        this.iRepo = (InterceptorRepository)Context.getInstance("com.idoox.wasp.interceptor.InterceptorRepository");
    }

    public void destroy() {
    }
}

