/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.webservice;

import com.idoox.debug.Category;
import com.idoox.soap.EnvelopeCaching;
import com.idoox.util.HierarchicalMap;
import com.idoox.wasp.SOAPServiceInfoCache;
import com.idoox.wasp.WSDLPortInfo;
import com.idoox.wasp.client.config.ServiceConfig;
import com.idoox.wasp.interceptor.InterceptorRepositoryImpl;
import com.idoox.wasp.serialization.SerializationRepositoryImpl;
import com.systinet.wasp.admin.PackageRepositoryImpl;
import com.systinet.wasp.async.AsyncCallbackService;
import com.systinet.wasp.async.AsyncRuntimeManager;
import com.systinet.wasp.client.BCAwareClientProxy;
import com.systinet.wasp.webservice.AttributesHelper;
import com.systinet.wasp.webservice.AttributesImpl;
import com.systinet.wasp.webservice.CallContextImpl;
import com.systinet.wasp.webservice.CurrentImpl;
import com.systinet.wasp.webservice.FinalizationSupport;
import com.systinet.wasp.webservice.HandlersImpl;
import com.systinet.wasp.webservice.HeaderProcessorsImpl;
import com.systinet.wasp.webservice.InterceptorsImpl;
import com.systinet.wasp.webservice.RegistryImpl;
import com.systinet.wasp.webservice.ServiceClientContextImpl;
import com.systinet.wasp.webservice.ServiceClientHeaderProcessorsImpl;
import com.systinet.wasp.webservice.ServiceClientInterceptorsImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.idoox.transport.TransportStartException;
import org.idoox.transport.client.Endpoint;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.Context;
import org.idoox.wasp.WaspInternalException;
import org.idoox.wasp.wsdl.SOAPPortInfo;
import org.idoox.wasp.wsdl.SOAPServiceInfo;
import org.idoox.xml.schema.SchemaException;
import org.systinet.wasp.IWasp;
import org.systinet.wasp.addressing.EndpointReference;
import org.systinet.wasp.handler.HandlerRepository;
import org.systinet.wasp.policy.IPolicyManager;
import org.systinet.wasp.rpc.WaspCall;
import org.systinet.wasp.rpc.WaspCallFactory;
import org.systinet.wasp.webservice.Attributes;
import org.systinet.wasp.webservice.CallContext;
import org.systinet.wasp.webservice.Handlers;
import org.systinet.wasp.webservice.HeaderProcessors;
import org.systinet.wasp.webservice.IListenerRepository;
import org.systinet.wasp.webservice.Interceptors;
import org.systinet.wasp.webservice.LookupException;
import org.systinet.wasp.webservice.PublishException;
import org.systinet.wasp.webservice.ServiceClient;
import org.systinet.wasp.webservice.ServiceClientContext;
import org.systinet.wasp.webservice.ServiceClientListener;
import org.systinet.wasp.webservice.ServiceEndpoint;

public class ServiceClientImpl
extends ServiceClient {
    private static final Category cat = Category.getCategory("com.systinet.wasp.webservice.ServiceClientImpl");
    private static WaspCallFactory callFactory = WaspCallFactory.newInstance();
    private Category debugLog;
    private Class bcIface;
    private Configurable configurable;
    private Attributes attributes;
    private Definition definition;
    private String definitionURL;
    private String definitionPortName;
    private QName definitionServiceName;
    private String serviceURL;
    private SOAPPortInfo definitionPort;
    private boolean lookedup = false;
    private boolean lookingup = false;
    private static final String LOOKEDUP_MESSAGE = "It's not possible to change ServiceClient after lookup";
    private static final String ASYNC_ENDPOINT_MESSAGE = "AsyncTransport must be set before setting of asyncEndpointPath.";
    private ServiceClientContext context;
    private InheritableThreadLocal callContext;
    private int asyncTimeout = -1;
    private String asyncTransport;
    private boolean asyncTransportWasSet = false;
    private AsyncCallbackService.Frontend asyncService;
    private AsyncCallbackService asyncCallbackService;
    private int connectionTimeout = -1;
    private Interceptors interceptors;
    private String interceptorsID;
    private HeaderProcessors headers;
    private Handlers handlers;
    private String handlersID;
    private String serializationID;
    private String faultSerializationID;
    private boolean doMultirefs = true;
    private List listeners = new ArrayList();
    private int listenerReaders = 0;
    private Map encodingToXmapSchema = new HashMap();
    private String encoding;
    private String encodingID;
    private EnvelopeCaching envelopeCache = new EnvelopeCaching();
    private String envelopePrefix;
    private Boolean namespaceOptimization = Boolean.TRUE;
    private String asyncEndpointPath;
    private boolean asyncEndpointPathWasSet = false;
    private ServiceEndpoint asyncServiceEndpoint;
    private IPolicyManager policyManager = null;
    private Object asyncEndpointMutex = new Object();
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$com$idoox$wasp$client$config$ServiceConfig;

    public ServiceClientImpl(String wsdlUrl, Map contextData) {
        this(wsdlUrl, contextData, null);
    }

    public ServiceClientImpl(ServiceClient client) {
        this(null, null, client);
    }

    private ServiceClientImpl(String wsdlUrl, Map contextData, ServiceClient client) {
        this.definitionURL = wsdlUrl;
        this.context = new ServiceClientContextImpl(this);
        if (contextData != null) {
            this.context.getContextData().putAll(contextData);
        }
        this.callContext = new InheritableThreadLocalCallontext();
        if (client != null) {
            this.headers = (HeaderProcessors)((HeaderProcessorsImpl)client.getHeaderProcessors()).clone();
            this.handlers = (Handlers)((HandlersImpl)client.getHandlers()).clone();
            this.interceptors = (Interceptors)((ServiceClientInterceptorsImpl)client.getInterceptors()).clone();
            this.configurable = client.getConfigurable();
            this.attributes = (Attributes)((AttributesImpl)client.getAttributes()).clone();
        }
    }

    public Configurable getConfigurable() {
        if (this.configurable == null) {
            this.configurable = Configurator.newRuntimeConfigurable();
        }
        return this.configurable;
    }

    public void setConfigurable(Configurable serviceClientConfig) {
        this.configurable = serviceClientConfig;
    }

    public Attributes getAttributes() {
        if (this.attributes == null) {
            this.attributes = new AttributesImpl();
        }
        return this.attributes;
    }

    public Class getInterface() {
        return this.bcIface;
    }

    public void setInterface(Class iface) {
        if (this.lookedup) {
            throw new IllegalStateException(LOOKEDUP_MESSAGE);
        }
        this.bcIface = iface;
    }

    public ServiceClientContext getContext() {
        return this.context;
    }

    public String getAsyncTransport() {
        return this.asyncTransport;
    }

    public void setAsyncTransport(String asyncTransport) {
        this.asyncTransport = asyncTransport;
        this.asyncTransportWasSet = true;
    }

    public String getAsyncEndpointPath() {
        return this.asyncEndpointPath;
    }

    public void setAsyncEndpointPath(String path) {
        this.asyncEndpointPath = path.indexOf("/") != 0 ? "/" + path : path;
        this.asyncEndpointPathWasSet = true;
        try {
            if (!this.asyncTransportWasSet) {
                throw new IllegalStateException(ASYNC_ENDPOINT_MESSAGE);
            }
            AsyncRuntimeManager.getInstance().startTransport(this.getAsyncTransport());
            this.getAsyncService().setAsyncService(this.publishAsyncEndpoint(false));
        }
        catch (PublishException e) {
            throw new RuntimeWrappedException(e);
        }
        catch (LookupException e) {
            throw new RuntimeWrappedException(e);
        }
        catch (TransportStartException e) {
            throw new RuntimeWrappedException(e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeWrappedException(e);
        }
        catch (WaspInternalException e) {
            throw new RuntimeWrappedException(e);
        }
    }

    public int getAsyncTimeout() {
        return this.asyncTimeout;
    }

    public void setAsyncTimeout(int timeout) {
        this.asyncTimeout = timeout;
    }

    public synchronized AsyncCallbackService.Frontend getAsyncService() {
        if (this.asyncService == null) {
            this.asyncService = new AsyncCallbackService.Frontend(this);
        }
        return this.asyncService;
    }

    public Interceptors getInterceptors() {
        if (this.interceptors == null) {
            this.interceptors = new ServiceClientInterceptorsImpl();
        }
        return this.interceptors;
    }

    public String getInterceptorsID() {
        if (!this.lookedup) {
            throw new IllegalStateException("Lookup was not done");
        }
        return this.interceptorsID;
    }

    public HeaderProcessors getHeaderProcessors() {
        if (this.headers == null) {
            this.headers = new ServiceClientHeaderProcessorsImpl();
        }
        return this.headers;
    }

    public Handlers getHandlers() {
        if (this.handlers == null) {
            this.handlers = new HandlersImpl();
        }
        return this.handlers;
    }

    public String getHandlersID() {
        if (!this.lookedup) {
            throw new IllegalStateException("Lookup was not done");
        }
        return this.handlersID;
    }

    public String getResource(String path) {
        ClassLoader cl = this.getClass().getClassLoader();
        if (path.equals("/")) {
            if (this.configurable != null) {
                return this.configurable.getReferenceLocation() + "/";
            }
            return null;
        }
        return cl.getResource(path).toExternalForm();
    }

    public InputStream getResourceAsStream(String path) throws IOException {
        String resource = this.getResource(path);
        if (resource == null) {
            return null;
        }
        return new FileInputStream(new File(resource));
    }

    public Category getDebugCategory() {
        if (this.debugLog == null) {
            try {
                this.debugLog = this.serviceURL != null ? Category.getCategory("client." + new Endpoint(this.serviceURL).getPath()) : (this.definitionURL != null ? Category.getCategory("client." + new Endpoint(this.definitionURL).getPath()) : Category.getCategory("client"));
            }
            catch (MalformedURLException e) {
                this.debugLog = Category.getCategory("client");
            }
            this.debugLog.setInstanceDebugLevel(3);
            this.debugLog.setFireUserEvent(true);
        }
        return this.debugLog;
    }

    public void log(String message) {
        this.getDebugCategory().info(message);
    }

    public void log(String message, Throwable throwable) {
        this.getDebugCategory().error(message, throwable);
    }

    public void setConnectionTimeout(int timeout) {
        this.connectionTimeout = timeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public CallContext getCallContext() {
        CallContext currentCC = (CallContext)this.callContext.get();
        if (currentCC == null) {
            currentCC = new CallContextImpl(this.context.getContextData());
            this.callContext.set(currentCC);
        }
        return currentCC;
    }

    public String getWSDLLocation() {
        return this.definitionURL;
    }

    public void setWSDLLocation(String wsdlLocation) {
        if (this.lookedup) {
            throw new IllegalStateException(LOOKEDUP_MESSAGE);
        }
        this.definitionURL = wsdlLocation;
    }

    public Definition getWSDL() throws LookupException {
        this.lookup(true);
        return this.definition;
    }

    public synchronized void setWSDL(Definition wsdl) {
        if (this.lookedup) {
            throw new IllegalStateException(LOOKEDUP_MESSAGE);
        }
        this.definition = wsdl;
    }

    public String getServiceURL() throws LookupException {
        this.lookup(false);
        return this.serviceURL;
    }

    public synchronized void setServiceURL(String url) {
        this.serviceURL = url;
    }

    public SOAPPortInfo getPortInfo() {
        return this.definitionPort;
    }

    public String getWSDLPortName() throws LookupException {
        this.lookup(true);
        return this.definitionPortName;
    }

    public synchronized void setWSDLPortName(String portName) {
        if (this.lookedup) {
            throw new IllegalStateException(LOOKEDUP_MESSAGE);
        }
        this.definitionPortName = portName;
    }

    public QName getWSDLServiceName() throws LookupException {
        this.lookup(true);
        return this.definitionServiceName;
    }

    public synchronized void setWSDLServiceName(QName serviceName) {
        if (this.lookedup) {
            throw new IllegalStateException(LOOKEDUP_MESSAGE);
        }
        this.definitionServiceName = serviceName;
    }

    public Object getProxy() {
        try {
            return this.createProxy(this.bcIface);
        }
        catch (LookupException e) {
            throw new RuntimeWrappedException(e);
        }
    }

    public Object createProxy(Class iface) throws LookupException {
        this.lookup(true);
        ClassLoader classLoader = iface.getClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        return Proxy.newProxyInstance(classLoader, new Class[]{iface, class$java$rmi$Remote == null ? (class$java$rmi$Remote = ServiceClientImpl.class$("java.rmi.Remote")) : class$java$rmi$Remote}, (InvocationHandler)new BCAwareClientProxy(this, iface));
    }

    public WaspCall createCall(String operation) throws LookupException {
        this.lookup(true);
        return callFactory.createWaspCall((ServiceClient)this, new QName(this.definitionServiceName.getNamespaceURI(), operation));
    }

    public WaspCall createCall() throws LookupException {
        this.lookup(true);
        return callFactory.createWaspCall(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addListener(ServiceClientListener listener) {
        List list = this.listeners;
        synchronized (list) {
            while (this.listenerReaders > 0) {
                try {
                    this.listeners.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.listeners.add(listener);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeListener(ServiceClientListener listener) {
        List list = this.listeners;
        synchronized (list) {
            while (this.listenerReaders > 0) {
                try {
                    this.listeners.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.listeners.remove(listener);
            return;
        }
    }

    public void invokeListenersOnLookup() throws LookupException {
        List list;
        try {
            List list2 = this.listeners;
            synchronized (list2) {
                ++this.listenerReaders;
            }
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                ServiceClientListener listener = (ServiceClientListener)i.next();
                try {
                    listener.onLookup(this);
                }
                catch (LookupException e) {
                    throw e;
                }
                catch (Exception e) {
                    cat.error("Exception during invoking of listener", e);
                }
            }
            Object var7_7 = null;
            list = this.listeners;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            List list3 = this.listeners;
            synchronized (list3) {
                --this.listenerReaders;
                this.listeners.notifyAll();
            }
            throw throwable;
        }
        synchronized (list) {
            --this.listenerReaders;
            this.listeners.notifyAll();
        }
    }

    public String getSerializationID() {
        return this.serializationID;
    }

    public String getFaultSerializationID() {
        return this.faultSerializationID;
    }

    public synchronized void lookup(boolean needWSDL) throws LookupException {
        if (this.lookedup) {
            return;
        }
        if (this.lookingup) {
            return;
        }
        this.lookingup = true;
        try {
            if (this.definitionURL != null || this.definition != null) {
                SOAPServiceInfo[] services;
                if (this.definition == null) {
                    try {
                        services = SOAPServiceInfoCache.getServiceInfos(this.definitionURL, this.getCallContext().getContextData());
                    }
                    catch (Exception e) {
                        throw new LookupException("Error obtaining WSDL definition from " + this.definitionURL, e);
                    }
                }
                try {
                    services = SOAPServiceInfoCache.getServices(this.definition);
                }
                catch (SchemaException e) {
                    throw new LookupException("Error processing of specified WSDL definition", e);
                }
                if (services == null || services.length == 0) {
                    if (this.definitionURL != null) {
                        throw new LookupException("No service found in WSDL definition " + this.definitionURL);
                    }
                    throw new LookupException("No service found in WSDL definition");
                }
                this.definition = services[0].getDefinition();
                ArrayList<SOAPPortInfo> ports = new ArrayList<SOAPPortInfo>();
                int j = 0;
                while (j < services.length) {
                    if (this.definitionServiceName == null || this.definitionServiceName.equals(services[j].getServiceQName())) {
                        SOAPPortInfo[] portInfos = services[j].getPortInfos();
                        int i = 0;
                        while (i < portInfos.length) {
                            if (this.definitionPortName == null || this.definitionPortName.equals(portInfos[i].getPortName())) {
                                ports.add(portInfos[i]);
                            }
                            ++i;
                        }
                    }
                    ++j;
                }
                String ccProtocol = (String)this.getCallContext().getContextData().get("wasp.xml.protocol");
                if (ports.size() == 0) {
                    throw new LookupException("No suitable port found in WSDL definition " + this.definition.getDocumentBaseURI());
                }
                if (ports.size() == 1) {
                    String portProtocol = ((SOAPPortInfo)ports.get(0)).getProtocol();
                    if (portProtocol == null) {
                        throw new LookupException("WSDL definition " + this.definition.getDocumentBaseURI() + " contains only one port for unknown protocol");
                    }
                    if (ccProtocol != null && !ccProtocol.equals(portProtocol)) {
                        throw new LookupException("There is set " + ccProtocol + " protocol in CallContext but " + "WSDL definition " + this.definition.getDocumentBaseURI() + " contains only one port for " + portProtocol + " protocol");
                    }
                    this.definitionPort = (SOAPPortInfo)ports.get(0);
                } else {
                    HashMap<String, SOAPPortInfo> protocol2port = new HashMap<String, SOAPPortInfo>(ports.size());
                    Iterator i = ((AbstractList)ports).iterator();
                    while (i.hasNext()) {
                        SOAPPortInfo portInfo = (SOAPPortInfo)i.next();
                        String protocol = portInfo.getProtocol();
                        if (protocol == null) continue;
                        if ((SOAPPortInfo)protocol2port.get(protocol) != null) {
                            throw new LookupException("There are more suitable ports found in WSDL definition " + this.definition.getDocumentBaseURI() + " - please, specify one port on the ServiceClient");
                        }
                        protocol2port.put(protocol, portInfo);
                    }
                    if (ccProtocol != null) {
                        this.definitionPort = (SOAPPortInfo)protocol2port.get(ccProtocol);
                        if (this.definitionPort == null) {
                            throw new LookupException("There is set " + ccProtocol + " protocol in CallContext but " + "WSDL definition " + this.definition.getDocumentBaseURI() + " doesn't contain any port for this protocol");
                        }
                    } else {
                        IWasp wasp = (IWasp)Context.getInstance("org.systinet.wasp.Wasp");
                        String[] protocols = wasp.getDefaultXMLProtocols();
                        int i2 = 0;
                        while (i2 < protocols.length) {
                            this.definitionPort = (SOAPPortInfo)protocol2port.get(protocols[i2]);
                            if (this.definitionPort != null) break;
                            ++i2;
                        }
                        if (this.definitionPort == null) {
                            throw new LookupException("There is no port found in WSDL definition " + this.definition.getDocumentBaseURI() + " for default protocols " + Arrays.asList(protocols));
                        }
                    }
                }
                this.definitionServiceName = this.definitionPort.getServiceInfo().getServiceQName();
                this.definitionPortName = this.definitionPort.getPortName();
                if (this.serviceURL == null) {
                    this.setServiceURL(this.definitionPort.getEndpointURI());
                }
                if (this.serviceURL == null) {
                    throw new LookupException("Service location wasn't found for port " + this.definitionPortName + " in WSDL definition " + this.definition.getDocumentBaseURI());
                }
            } else {
                if (needWSDL) {
                    throw new LookupException("Either WSDL location or WSDL definition must be specified");
                }
                if (this.serviceURL == null) {
                    throw new LookupException("Service location wasn't specified");
                }
            }
            this.loadPersistentConfiguration();
            this.context.getContextData().put("core.processing.interceptors_id", this.interceptorsID);
            this.context.getContextData().put("core.handler.processing.id", this.handlersID);
            ((HeaderProcessorsImpl)this.getHeaderProcessors()).postRegistrate(this.handlersID);
            InterceptorsImpl interceptors = (InterceptorsImpl)this.getInterceptors();
            interceptors.setEnvelopeCache(this.envelopeCache);
            interceptors.postRegistrate(this.interceptorsID);
            ((HandlersImpl)this.getHandlers()).setProcessingID(this.handlersID);
            RegistryImpl registry = (RegistryImpl)Context.getInstance("org.systinet.wasp.webservice.IRegistry");
            registry.invokeServiceClientListenersOnLookup(this);
            this.invokeListenersOnLookup();
            this.lookedup = true;
            FinalizationSupport.Finalizable[] finalizables = new FinalizationSupport.Finalizable[]{(HandlersImpl)this.handlers, (InterceptorsImpl)this.interceptors, new WSDLPortInfoCleaner((WSDLPortInfo)this.getPortInfo(), this.getSerializationID())};
            FinalizationSupport.addReference(this, finalizables);
            FinalizationSupport.doFinalization();
            Object var12_16 = null;
            this.lookingup = false;
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            this.lookingup = false;
            throw throwable;
        }
    }

    private void loadPersistentConfiguration() throws LookupException {
        Configurable config = null;
        if (this.definitionPortName != null) {
            config = Configurator.getConfigurable("ServiceTypeConfig", this.definitionServiceName.getNamespaceURI() + ":" + this.definitionPortName);
        }
        if (config == null && this.serviceURL != null) {
            config = Configurator.getConfigurable("ServiceConfig", this.serviceURL);
        }
        PackageRepositoryImpl pckgRepo = (PackageRepositoryImpl)Context.getInstance("org.systinet.wasp.admin.PackageRepository");
        InterceptorRepositoryImpl iRepo = (InterceptorRepositoryImpl)Context.getInstance("com.idoox.wasp.interceptor.InterceptorRepository");
        HandlerRepository hRepo = (HandlerRepository)Context.getInstance("wasp.core.jaxrpc_handler_repository");
        SerializationRepositoryImpl sRepo = (SerializationRepositoryImpl)Context.getInstance("org.idoox.wasp.serialization.SerializationRepository");
        IListenerRepository lRepo = (IListenerRepository)Context.getInstance("org.systinet.wasp.webservice.ListenerRepository");
        if (config == null) {
            String defaultInterceptorsID = pckgRepo.getDefaultTransportInterceptorsID();
            this.interceptorsID = iRepo.cloneInterceptorsID(defaultInterceptorsID, "clientTransportInterceptors");
            String defaultHandlersID = pckgRepo.getDefaultHandlersID();
            this.handlersID = hRepo.cloneHandlerChain(defaultHandlersID);
            String defaultSerialiazationID = pckgRepo.getDefaultSerializationID();
            this.serializationID = sRepo.cloneSerializationID(defaultSerialiazationID);
            String defaultFaultSerialiazationID = pckgRepo.getDefaultFaultSerializationID();
            this.faultSerializationID = sRepo.cloneFaultSerializationID(defaultFaultSerialiazationID);
            this.doMultirefs = true;
        } else {
            Boolean configValue;
            ServiceConfig.EnvelopePrefix envelopePrefix;
            ServiceConfig cfg = (ServiceConfig)config.narrow(class$com$idoox$wasp$client$config$ServiceConfig == null ? (class$com$idoox$wasp$client$config$ServiceConfig = ServiceClientImpl.class$("com.idoox.wasp.client.config.ServiceConfig")) : class$com$idoox$wasp$client$config$ServiceConfig);
            this.encoding = cfg.getEncoding();
            this.encodingID = cfg.getEncodingId();
            Boolean aux = cfg.isMultirefs();
            this.doMultirefs = aux == null || aux != false;
            this.interceptorsID = iRepo.cloneInterceptorsID(cfg.getTransportInterceptors(), "clientTransportInterceptors");
            this.handlersID = hRepo.cloneHandlerChain(cfg.getHandlers());
            this.serializationID = sRepo.cloneSerializationID(cfg.getSerialization());
            this.faultSerializationID = sRepo.cloneFaultSerializationID(cfg.getFaultSerialization());
            if (!this.asyncTransportWasSet) {
                this.asyncTransport = cfg.getAsyncProtocol();
            }
            if (this.asyncTimeout == -1 && cfg.getAsyncTimeout() != null) {
                this.asyncTimeout = cfg.getAsyncTimeout();
            }
            try {
                AttributesHelper.parseAttributes(config, this.getClass().getClassLoader(), this.attributes);
            }
            catch (Exception e) {
                throw new LookupException("Exception during parsing attributes of service client " + config.getName(), e);
            }
            ServiceConfig.Listener[] listeners = cfg.getListeners();
            if (listeners != null) {
                int i = 0;
                while (i < listeners.length) {
                    ServiceConfig.Listener listener = listeners[i];
                    String refName = listener.getRef();
                    ServiceClientListener clientListener = lRepo.getServiceClientListener(refName);
                    if (clientListener == null) {
                        throw new LookupException("Cannot add listener: " + refName + " for service client. Listener doesn't exist.");
                    }
                    this.addListener(clientListener);
                    ++i;
                }
            }
            if ((envelopePrefix = cfg.getEnvelopePrefix()) != null) {
                this.envelopePrefix = envelopePrefix.getValue();
            }
            if ((configValue = cfg.getNamespaceOptimization()) != null) {
                this.namespaceOptimization = configValue;
            }
            this.configurable = Configurator.setDefaultsOnConfigurable(this.getConfigurable(), config);
        }
    }

    public CurrentSaver cloneCurrentSaver() {
        CallContextImpl newCallContext = new CallContextImpl(this.context.getContextData());
        newCallContext.setContextData((Map)((HierarchicalMap)this.getCallContext().getContextData()).clone());
        return new CurrentSaver(newCallContext, this.getContext(), 1);
    }

    public CurrentSaver startProcessing() {
        CurrentImpl current = (CurrentImpl)Context.getInstance("org.systinet.wasp.webservice.ICurrent");
        CurrentImpl.ThreadLocals threadLocals = current.getThreadLocals();
        CurrentSaver oldOne = new CurrentSaver(threadLocals.callContext, threadLocals.serviceClientContext, threadLocals.processingType);
        CallContextImpl cc = (CallContextImpl)this.getCallContext();
        cc.beginCall();
        QName portType = this.definitionPort != null ? this.definitionPort.getPortTypeQName() : null;
        EndpointReference er = new EndpointReference(this.serviceURL, portType, this.definitionServiceName, this.definitionPortName);
        if (this.policyManager == null) {
            this.policyManager = (IPolicyManager)Context.getInstance("org.systinet.wasp.policy.PolicyManager");
        }
        cc.getContextData().put("policy.output", this.policyManager.getEffectivePolicy(er));
        if (!this.asyncTransportWasSet) {
            cc.getContextData().put("policy.input", this.policyManager.getEffectivePolicy(er));
        }
        if (this.definitionPort != null) {
            cc.getContextData().put("wasp.xml.protocol", this.definitionPort.getProtocol());
        }
        threadLocals.callContext = cc;
        threadLocals.serviceClientContext = this.getContext();
        threadLocals.processingType = 1;
        return oldOne;
    }

    public void endProcessing(CurrentSaver oldCurrent) {
        CurrentImpl current = (CurrentImpl)Context.getInstance("org.systinet.wasp.webservice.ICurrent");
        CurrentImpl.ThreadLocals threadLocals = current.getThreadLocals();
        ((CallContextImpl)this.getCallContext()).endCall();
        threadLocals.callContext = oldCurrent.callContext;
        threadLocals.serviceClientContext = oldCurrent.scContext;
        threadLocals.processingType = oldCurrent.processingType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getEncodingID() {
        return this.encodingID;
    }

    public EnvelopeCaching getEnvelopeCache() {
        return this.envelopeCache;
    }

    public String getEnvelopePrefix() {
        return this.envelopePrefix;
    }

    public void setEnvelopePrefix(String envelopePrefix) {
        this.envelopePrefix = envelopePrefix;
    }

    public Boolean getNamespaceOptimization() {
        return this.namespaceOptimization;
    }

    public void setNamespaceOptimization(Boolean namespaceOptimization) {
        this.namespaceOptimization = namespaceOptimization;
    }

    public boolean isMultirefs() {
        return this.doMultirefs;
    }

    public final AsyncCallbackService publishAsyncEndpoint(boolean registerTransport) throws PublishException, LookupException, TransportStartException, MalformedURLException, WaspInternalException {
        Object object = this.asyncEndpointMutex;
        synchronized (object) {
            if (this.asyncServiceEndpoint == null) {
                this.asyncCallbackService = new AsyncCallbackService(this.getAsyncService());
                AsyncRuntimeManager asyncRuntime = AsyncRuntimeManager.getInstance();
                this.asyncServiceEndpoint = asyncRuntime.publishAsyncService(this.asyncCallbackService, this, this.asyncEndpointPath, registerTransport);
                if (!this.asyncEndpointPathWasSet) {
                    this.asyncEndpointPath = this.asyncServiceEndpoint.getPath();
                }
            }
            AsyncCallbackService asyncCallbackService = this.asyncCallbackService;
            return asyncCallbackService;
        }
    }

    public final boolean unpublishAsyncEndpointDefaultPath() throws PublishException {
        if (!this.asyncEndpointPathWasSet) {
            this.unpublishAsyncEndpoint();
            return true;
        }
        return false;
    }

    public final void unpublishAsyncEndpoint() throws PublishException {
        Object object = this.asyncEndpointMutex;
        synchronized (object) {
            if (this.asyncServiceEndpoint != null) {
                AsyncRuntimeManager asyncRuntime = AsyncRuntimeManager.getInstance();
                asyncRuntime.unpublishService(this.asyncCallbackService, this);
                this.asyncServiceEndpoint = null;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class WSDLPortInfoCleaner
    implements FinalizationSupport.Finalizable {
        WSDLPortInfo portInfo;
        String serializationID;

        public WSDLPortInfoCleaner(WSDLPortInfo portInfo, String serializationID) {
            this.portInfo = portInfo;
            this.serializationID = serializationID;
        }

        public void onFinalize() {
            if (this.portInfo != null) {
                this.portInfo.removeInfos(this.serializationID);
            }
        }
    }

    private class InheritableThreadLocalCallontext
    extends InheritableThreadLocal {
        private InheritableThreadLocalCallontext() {
        }

        protected Object childValue(Object parentValue) {
            CallContextImpl cc = new CallContextImpl(ServiceClientImpl.this.getContext().getContextData());
            cc.setContextData((Map)((HierarchicalMap)((CallContext)parentValue).getContextData()).clone());
            return cc;
        }
    }

    public static class CurrentSaver {
        public CallContext callContext;
        public ServiceClientContext scContext;
        public int processingType;

        public CurrentSaver(CallContext callContext, ServiceClientContext scContext, int processingType) {
            this.callContext = callContext;
            this.scContext = scContext;
            this.processingType = processingType;
        }
    }
}

