/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.webservice;

import com.systinet.wasp.ServiceManagerImpl;
import com.systinet.wasp.rpc.handler.SOAPMessageContextFactory;
import com.systinet.wasp.webservice.CallContextImpl;
import com.systinet.wasp.webservice.CurrentImpl;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import java.util.Map;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import org.idoox.wasp.Context;
import org.systinet.logging.Category;
import org.systinet.wasp.handler.HandlerRepository;
import org.systinet.wasp.rpc.handler.Bookmark;
import org.systinet.wasp.rpc.handler.ContextHolder;
import org.systinet.wasp.rpc.handler.WaspContextHolder;
import org.systinet.wasp.rpc.handler.soap.WaspSOAPMessageContext;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.Processing;
import org.systinet.wasp.webservice.ServiceEndpoint;
import org.systinet.wasp.webservice.ServiceEndpointContext;
import org.systinet.wasp.webservice.ServiceInstanceContext;

public class ServerBookmarkImpl
extends Bookmark {
    static final long serialVersionUID = -49171988212128887L;
    private static final Category dbg = Category.getCategory("com.systinet.wasp.webservice.ServerBookmarkImpl");
    public static final String CONNECTOR_PATH = "serverbookmark.connector.path";
    public static final String REQUEST_SCHEMA = "serverbookmark.request.schema";
    public static final String ASYNC_CALLBACK_SERVICE = "serverbookmark.async.callback.service";
    private String path;
    private ServiceInstanceContext serviceInstanceContext;
    private ServiceEndpointContext serviceEndpointContext;

    public ServerBookmarkImpl() {
    }

    public ServerBookmarkImpl(HandlerRepository.DirectionPositionEntry position) {
        this.position = position;
        this.path = Current.getServiceEndpointContext().getServiceEndpoint().getPath();
    }

    public synchronized void init(Processing processing) {
        dbg.debug("Initialization of server bookmark " + this + ", " + processing);
        ServiceEndpoint serviceEndpoint = (ServiceEndpoint)processing;
        this.serviceEndpointContext = serviceEndpoint.getContext();
        this.serviceInstanceContext = serviceEndpoint.getServiceInstance().getContext();
    }

    public ServiceEndpointContext getServiceEndpointContext() {
        return this.serviceEndpointContext;
    }

    public ServiceInstanceContext getServiceInstanceContext() {
        return this.serviceInstanceContext;
    }

    public WaspContextHolder handleInput(WaspContextHolder contextHolder) {
        WaspContextHolder waspContextHolder;
        Map messageProperties = contextHolder.getMessageProperties();
        this.applyToCurrentThread(contextHolder);
        try {
            SOAPMessageContext soapMessageContext = SOAPMessageContextFactory.newInstance();
            soapMessageContext.setMessage(contextHolder.getSoapMessage());
            ((WaspSOAPMessageContext)soapMessageContext).initProperties(messageProperties);
            WaspSOAPMessageContext responseContext = (WaspSOAPMessageContext)ServerBookmarkImpl.getRegistry().dispatch(soapMessageContext, this.path, this.position, true, false, false);
            if (responseContext != null) {
                WaspContextHolder waspContextHolder2 = WaspContextHolder.create(Current.getCallContext(), responseContext.getProperties(), responseContext.getMessage());
                Object var7_7 = null;
                return waspContextHolder2;
            }
            waspContextHolder = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            throw throwable;
        }
        Object var7_8 = null;
        return waspContextHolder;
    }

    public WaspContextHolder handleOutput(WaspContextHolder contextHolder) throws RemoteException {
        return this.handleOutputInternal(contextHolder, false);
    }

    public WaspContextHolder handleShortOutput(WaspContextHolder contextHolder) {
        return this.handleOutputInternal(contextHolder, true);
    }

    private final WaspContextHolder handleOutputInternal(WaspContextHolder contextHolder, boolean isShort) {
        WaspContextHolder waspContextHolder;
        Map messageProperties = contextHolder.getMessageProperties();
        this.applyToCurrentThread(contextHolder);
        try {
            SOAPMessageContext soapMessageContext = SOAPMessageContextFactory.newInstance();
            soapMessageContext.setMessage(contextHolder.getSoapMessage());
            ((WaspSOAPMessageContext)soapMessageContext).initProperties(messageProperties);
            WaspSOAPMessageContext responseContext = (WaspSOAPMessageContext)ServerBookmarkImpl.getRegistry().dispatch(soapMessageContext, this.path, this.position, false, isShort, false);
            if (isShort && responseContext != null) {
                WaspContextHolder waspContextHolder2 = WaspContextHolder.create(Current.getCallContext(), responseContext.getProperties(), responseContext.getMessage());
                Object var8_8 = null;
                return waspContextHolder2;
            }
            waspContextHolder = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            throw throwable;
        }
        Object var8_9 = null;
        return waspContextHolder;
    }

    public WaspContextHolder handleShortInput(WaspContextHolder invocationState) {
        dbg.error("This method should be never called: handleShortInput()");
        return null;
    }

    public void oneWayAck(String correlationId) {
        dbg.error("This method should be never called: oneWayAck()");
    }

    public synchronized void applyToCurrentThread(ContextHolder contextHolder) {
        CallContextImpl callContext = new CallContextImpl(contextHolder.getCallContextData(), this.serviceEndpointContext.getContextData());
        super.applyToCurrentThread(callContext, contextHolder.getMessageProperties());
        CurrentImpl.ThreadLocals threadLocals = Bookmark.getCurrent().getThreadLocals();
        threadLocals.processingType = 2;
        threadLocals.serviceEndpointContext = this.serviceEndpointContext;
        threadLocals.serviceInstanceContext = this.serviceInstanceContext;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.path);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.path = (String)in.readObject();
    }

    private static final ServiceManagerImpl getRegistry() {
        return (ServiceManagerImpl)Context.getInstance("org.systinet.wasp.webservice.IRegistry");
    }
}

