/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.webservice;

import com.idoox.debug.Category;
import com.idoox.wasp.server.ServiceConnector;
import com.idoox.wasp.server.config.GetServiceBindingConfig;
import com.idoox.wasp.server.config.ServiceBindingConfig;
import com.systinet.wasp.ServiceManagerImpl;
import com.systinet.wasp.client.ClientProxy;
import com.systinet.wasp.webservice.InstanceNameGenerator;
import com.systinet.wasp.webservice.ServiceEndpointImpl;
import com.systinet.wasp.webservice.ServiceInstanceImpl;
import com.systinet.wasp.webservice.Version;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.systinet.wasp.webservice.IRegistry;
import org.systinet.wasp.webservice.IServiceEndpointListener;
import org.systinet.wasp.webservice.LookupException;
import org.systinet.wasp.webservice.PublishException;
import org.systinet.wasp.webservice.ServiceClient;
import org.systinet.wasp.webservice.ServiceClientListener;
import org.systinet.wasp.webservice.ServiceEndpoint;
import org.systinet.wasp.webservice.ServiceEndpointListener;
import org.systinet.wasp.webservice.ServiceInstance;

public class RegistryImpl
extends ServiceManagerImpl
implements IRegistry {
    private static final Category cat = Category.getCategory("com.systinet.wasp.webservice.RegistryImpl");
    protected List serviceEndpointListeners = new LinkedList();
    protected List serviceEndpointListenersEnd = new LinkedList();
    protected List serviceClientListeners = new LinkedList();
    private int serviceEndpointListenerReaders;
    private int serviceClientListenerReaders;
    static /* synthetic */ Class class$org$systinet$wasp$webservice$RawService;
    static /* synthetic */ Class class$org$systinet$wasp$webservice$ServiceEndpoint;
    static /* synthetic */ Class class$com$idoox$wasp$server$config$ServiceBindingConfig;
    static /* synthetic */ Class class$com$idoox$wasp$server$config$GetServiceBindingConfig;
    static /* synthetic */ Class class$org$idoox$wasp$Context;

    public void publish(ServiceEndpoint serviceEndpoint) throws PublishException {
        Version version;
        String path = serviceEndpoint.getPath();
        if (this.getServiceEndpoint(path, version = ((ServiceEndpointImpl)serviceEndpoint).getParsedVersion()) != null) {
            throw new PublishException("Service endpoint of the same version " + version + " already registered at path '" + path + "'");
        }
        if (((ServiceEndpointImpl)serviceEndpoint).isRegistered()) {
            throw new PublishException("Service endpoint can be published only once in its life! (Trying to publish an endpoint to the path " + path + ".)");
        }
        ServiceInstance serviceInstance = serviceEndpoint.getServiceInstance();
        boolean rawService = (class$org$systinet$wasp$webservice$RawService == null ? (class$org$systinet$wasp$webservice$RawService = RegistryImpl.class$("org.systinet.wasp.webservice.RawService")) : class$org$systinet$wasp$webservice$RawService).isAssignableFrom(serviceEndpoint.getInterface());
        String instanceName = this.registerServiceInstance(serviceInstance);
        ServiceBindingConfig config = ((ServiceEndpointImpl)serviceEndpoint).createServiceBindingConfig(instanceName);
        ((ServiceEndpointImpl)serviceEndpoint).postRegistrate();
        ServiceConnector connector = this.addInitializedConnector(serviceEndpoint, config);
        this.mapServiceInstances(serviceEndpoint);
        this.putToConnectorMaps(connector, rawService);
        ((ServiceEndpointImpl)serviceEndpoint).setRegistered(true);
        this.invokeServiceEndpointListenersOnPublishDone(serviceEndpoint);
        ((ServiceEndpointImpl)serviceEndpoint).invokeListenersOnPublishDone();
    }

    public ServiceEndpoint publish(String path, Object implementationObject) throws PublishException {
        if (implementationObject != null) {
            if (implementationObject instanceof ServiceEndpoint) {
                throw new PublishException("Trying to expose ServiceEndpoint object as a service - it is probably a mistake! Use something like Registry.publish(ServiceEndpoint.create(\"/foo\", myService)) instead.");
            }
            if (implementationObject instanceof ServiceInstance) {
                throw new PublishException("Trying to expose ServiceInstance object as a service - it is probably a mistake! Use something like Registry.publish(ServiceEndpoint.create(\"/foo\", myServiceInstance)) instead.");
            }
        }
        ServiceEndpoint serviceEndpoint = ServiceEndpoint.create(path, implementationObject);
        this.publish(serviceEndpoint);
        return serviceEndpoint;
    }

    public ServiceEndpoint publish(String path, Class implementationClass) throws PublishException {
        if (implementationClass != null && (class$org$systinet$wasp$webservice$ServiceEndpoint == null ? (class$org$systinet$wasp$webservice$ServiceEndpoint = RegistryImpl.class$("org.systinet.wasp.webservice.ServiceEndpoint")) : class$org$systinet$wasp$webservice$ServiceEndpoint).isAssignableFrom(implementationClass)) {
            throw new PublishException("Trying to expose ServiceEndpoint class as a service - it is probably a mistake! Use something like Registry.publish(ServiceEndpoint.create(\"/foo\", MyService.class)) instead.");
        }
        ServiceEndpoint serviceEndpoint = ServiceEndpoint.create(path, implementationClass);
        this.publish(serviceEndpoint);
        return serviceEndpoint;
    }

    public void unpublish(ServiceEndpoint serviceEndpoint) throws PublishException {
        Set bindings;
        Map map;
        String instanceName;
        ServiceBindingConfig config;
        String path = serviceEndpoint.getPath();
        ServiceEndpoint testEndpoint = this.getServiceEndpoint(serviceEndpoint.getPath(), ((ServiceEndpointImpl)serviceEndpoint).getParsedVersion());
        if (testEndpoint == null) {
            throw new PublishException("Trying to unpublish service endpoint never published (or unpublished already)!");
        }
        this.invokeServiceEndpointListenersOnUnpublish(serviceEndpoint);
        ((ServiceEndpointImpl)serviceEndpoint).invokeListenersOnUnpublish();
        Map map2 = this.serviceInstanceToServiceEndpoints;
        synchronized (map2) {
            Set serviceEndpoints;
            ServiceInstance serviceInstance = serviceEndpoint.getServiceInstance();
            Set set = serviceEndpoints = (Set)this.serviceInstanceToServiceEndpoints.get(serviceInstance);
            synchronized (set) {
                serviceEndpoints.remove(serviceEndpoint);
                if (serviceEndpoints.size() == 0) {
                    String serviceName = (String)this.instanceToName.get(serviceInstance);
                    ServiceInstance serviceInstance2 = serviceInstance;
                    synchronized (serviceInstance2) {
                        this.serviceInstances.remove(serviceName);
                        this.instanceToName.remove(serviceInstance);
                    }
                    this.serviceInstanceToServiceEndpoints.remove(serviceInstance);
                }
            }
        }
        ((ServiceEndpointImpl)serviceEndpoint).unregisterChains();
        this.removeConnectors(serviceEndpoint);
        Configurable c = Configurator.getConfigurable("ServiceBinding", path);
        if (c != null) {
            config = (ServiceBindingConfig)c.narrow(class$com$idoox$wasp$server$config$ServiceBindingConfig == null ? (class$com$idoox$wasp$server$config$ServiceBindingConfig = RegistryImpl.class$("com.idoox.wasp.server.config.ServiceBindingConfig")) : class$com$idoox$wasp$server$config$ServiceBindingConfig);
            instanceName = config.getServiceClassRef();
            map = this.bindingsOfInstance;
            synchronized (map) {
                bindings = (Set)this.bindingsOfInstance.get(instanceName);
                if (bindings != null) {
                    bindings.remove(path);
                    if (bindings.size() == 0) {
                        this.bindingsOfInstance.remove(instanceName);
                    }
                }
            }
        }
        if ((c = Configurator.getConfigurable("GetServiceBinding", path)) != null) {
            config = (GetServiceBindingConfig)c.narrow(class$com$idoox$wasp$server$config$GetServiceBindingConfig == null ? (class$com$idoox$wasp$server$config$GetServiceBindingConfig = RegistryImpl.class$("com.idoox.wasp.server.config.GetServiceBindingConfig")) : class$com$idoox$wasp$server$config$GetServiceBindingConfig);
            instanceName = config.getServiceClassRef();
            map = this.getBindingsOfInstance;
            synchronized (map) {
                bindings = (Set)this.getBindingsOfInstance.get(instanceName);
                if (bindings != null) {
                    bindings.remove(path);
                    if (bindings.size() == 0) {
                        this.getBindingsOfInstance.remove(instanceName);
                    }
                }
            }
        }
        this.definitions.remove(serviceEndpoint);
    }

    public ServiceEndpoint unpublish(String path) throws PublishException {
        ServiceEndpoint serviceEndpoint = this.getServiceEndpoint(path);
        if (serviceEndpoint == null) {
            throw new PublishException("Trying to unpublish service endpoint never published (or unpublished already, path = \"" + path + "\")!)");
        }
        this.unpublish(serviceEndpoint);
        return serviceEndpoint;
    }

    public ServiceEndpoint unpublish(String path, String version) throws PublishException {
        ServiceEndpoint serviceEndpoint = this.getServiceEndpoint(path, version);
        if (serviceEndpoint == null) {
            throw new PublishException("Trying to unpublish service endpoint never published (or unpublished already, path = \"" + path + "\")!)");
        }
        this.unpublish(serviceEndpoint);
        return serviceEndpoint;
    }

    public ServiceEndpoint getServiceEndpoint(String path) {
        return this.getServiceEndpoint(path, (Version)null);
    }

    public ServiceEndpoint getServiceEndpoint(String path, String version) {
        return this.getServiceEndpoint(path, new Version(version));
    }

    public ServiceEndpoint getServiceEndpoint(String path, Version version) {
        ServiceConnector connector = this.getNewestServiceConnector(path);
        if (connector == null) {
            return null;
        }
        ServiceEndpointImpl endpoint = (ServiceEndpointImpl)connector.getServiceEndpoint();
        if (version == null || endpoint.getParsedVersion().equals(version)) {
            return endpoint;
        }
        if ((connector = (ServiceConnector)connector.getOlderVersions().getSpecified(version)) != null) {
            return connector.getServiceEndpoint();
        }
        return null;
    }

    private ServiceConnector getNewestServiceConnector(String path) {
        if (path == null) {
            return null;
        }
        int pathLength = path.length();
        if (pathLength > 1 && path.charAt(0) == '*') {
            String purePath = path.substring(1);
            Map map = this.wildConnectorsB;
            synchronized (map) {
                ServiceConnector serviceConnector = (ServiceConnector)this.wildConnectorsB.get(purePath);
                return serviceConnector;
            }
        }
        if (pathLength > 0 && path.charAt(pathLength - 1) == '*') {
            String purePath = path.substring(0, pathLength - 1);
            Map map = this.wildConnectorsE;
            synchronized (map) {
                ServiceConnector serviceConnector = (ServiceConnector)this.wildConnectorsE.get(purePath);
                return serviceConnector;
            }
        }
        Map map = this.connectors;
        synchronized (map) {
            ServiceConnector serviceConnector = (ServiceConnector)this.connectors.get(path);
            return serviceConnector;
        }
    }

    public ServiceEndpoint[] getServiceEndpoints() {
        return this.getServiceEndpointList().toArray(new ServiceEndpoint[0]);
    }

    protected Collection getServiceEndpointList() {
        Map map = this.connectors;
        synchronized (map) {
            HashSet<ServiceEndpoint> allEndpoints = new HashSet<ServiceEndpoint>((this.connectors.size() + this.wildConnectorsB.size() + this.wildConnectorsE.size()) * 2);
            Iterator cons = this.connectors.values().iterator();
            while (cons.hasNext()) {
                ServiceConnector connector = (ServiceConnector)cons.next();
                allEndpoints.add(connector.getServiceEndpoint());
            }
            Iterator cons2 = this.wildConnectorsB.values().iterator();
            while (cons2.hasNext()) {
                ServiceConnector connector = (ServiceConnector)cons2.next();
                allEndpoints.add(connector.getServiceEndpoint());
            }
            Iterator cons3 = this.wildConnectorsE.values().iterator();
            while (cons3.hasNext()) {
                ServiceConnector connector = (ServiceConnector)cons3.next();
                allEndpoints.add(connector.getServiceEndpoint());
            }
            Iterator cons4 = this.getConnectors.values().iterator();
            while (cons4.hasNext()) {
                ServiceConnector connector = (ServiceConnector)cons4.next();
                allEndpoints.add(connector.getServiceEndpoint());
            }
            Iterator cons5 = this.wildGetConnectorsB.values().iterator();
            while (cons5.hasNext()) {
                ServiceConnector connector = (ServiceConnector)cons5.next();
                allEndpoints.add(connector.getServiceEndpoint());
            }
            Iterator cons6 = this.wildGetConnectorsE.values().iterator();
            while (cons6.hasNext()) {
                ServiceConnector connector = (ServiceConnector)cons6.next();
                allEndpoints.add(connector.getServiceEndpoint());
            }
            HashSet<ServiceEndpoint> hashSet = allEndpoints;
            return hashSet;
        }
    }

    public void addListener(ServiceEndpointListener listener) {
        this.addListener(listener, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addListener(ServiceEndpointListener listener, boolean end) {
        List list = this.serviceEndpointListeners;
        synchronized (list) {
            while (this.serviceEndpointListenerReaders > 0) {
                try {
                    this.serviceEndpointListeners.wait();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (end) {
                this.serviceEndpointListenersEnd.add(listener);
            } else {
                this.serviceEndpointListeners.add(listener);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeListener(ServiceEndpointListener listener) {
        List list = this.serviceEndpointListeners;
        synchronized (list) {
            while (this.serviceEndpointListenerReaders > 0) {
                try {
                    this.serviceEndpointListeners.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.serviceEndpointListeners.contains(listener)) {
                this.serviceEndpointListeners.remove(listener);
            } else {
                if (!this.serviceEndpointListenersEnd.contains(listener)) return;
                this.serviceEndpointListenersEnd.remove(listener);
            }
            return;
        }
    }

    private String registerServiceInstance(ServiceInstance serviceInstance) {
        String name;
        ServiceInstance serviceInstance2 = serviceInstance;
        synchronized (serviceInstance2) {
            name = (String)this.instanceToName.get(serviceInstance);
            if (name != null) {
                String string = name;
                return string;
            }
            name = InstanceNameGenerator.generateName(serviceInstance.getImplementationClassName());
            ((ServiceInstanceImpl)serviceInstance).setName(name);
            this.instanceToName.put(serviceInstance, name);
            this.serviceInstances.put(name, serviceInstance);
            ((ServiceInstanceImpl)serviceInstance).setRegistered();
        }
        return name;
    }

    public ServiceEndpoint[] getServiceEndpoints(ServiceInstance serviceInstance) {
        return ((Set)this.serviceInstanceToServiceEndpoints.get(serviceInstance)).toArray(new ServiceEndpoint[0]);
    }

    public ServiceClient getServiceClient(Object stub) {
        ClientProxy handler = (ClientProxy)Proxy.getInvocationHandler(stub);
        return handler.getServiceClient();
    }

    /*
     * Unable to fully structure code
     */
    public void invokeServiceEndpointListenersOnPublish(ServiceEndpoint endpoint) throws PublishException {
        var2_2 = this.serviceEndpointListeners;
        synchronized (var2_2) {
            ++this.serviceEndpointListenerReaders;
        }
        toUnpublish = new ArrayList<ServiceEndpointListener>(this.serviceEndpointListeners.size());
        i = this.serviceEndpointListeners.iterator();
        while (i.hasNext()) {
            listener = (ServiceEndpointListener)i.next();
            try {
                listener.onPublish(endpoint);
                toUnpublish.add(listener);
                continue;
            }
            catch (PublishException e) {
                j = toUnpublish.iterator();
                ** while (j.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                listener = (ServiceEndpointListener)j.next();
                listener.onUnpublish(endpoint);
                continue;
            }
lbl23:
            // 1 sources

            throw e;
            catch (Exception e) {
                RegistryImpl.cat.error("Exception during invoking of listener", e);
            }
        }
        var5_6 = this.serviceEndpointListeners;
        synchronized (var5_6) {
            --this.serviceEndpointListenerReaders;
            this.serviceEndpointListeners.notifyAll();
        }
    }

    public void invokeServiceEndpointListenersOnPublishDone(ServiceEndpoint endpoint) {
        List list = this.serviceEndpointListeners;
        synchronized (list) {
            ++this.serviceEndpointListenerReaders;
        }
        Iterator i = this.serviceEndpointListeners.iterator();
        while (i.hasNext()) {
            Object listener = i.next();
            if (!(listener instanceof IServiceEndpointListener)) continue;
            try {
                ((IServiceEndpointListener)listener).onPublishDone(endpoint);
            }
            catch (Exception e) {
                cat.error("Exception during invoking of listener", e);
            }
        }
        List list2 = this.serviceEndpointListeners;
        synchronized (list2) {
            --this.serviceEndpointListenerReaders;
            this.serviceEndpointListeners.notifyAll();
        }
    }

    public void invokeServiceEndpointListenersOnUnpublish(ServiceEndpoint endpoint) throws PublishException {
        List list = this.serviceEndpointListeners;
        synchronized (list) {
            ++this.serviceEndpointListenerReaders;
        }
        Iterator i = this.serviceEndpointListeners.iterator();
        while (i.hasNext()) {
            ServiceEndpointListener listener = (ServiceEndpointListener)i.next();
            try {
                listener.onUnpublish(endpoint);
            }
            catch (PublishException e) {
                throw e;
            }
            catch (Exception e) {
                cat.error("Exception during invoking of listener", e);
            }
        }
        List list2 = this.serviceEndpointListeners;
        synchronized (list2) {
            --this.serviceEndpointListenerReaders;
            this.serviceEndpointListeners.notifyAll();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addListener(ServiceClientListener listener) {
        List list = this.serviceClientListeners;
        synchronized (list) {
            while (this.serviceClientListenerReaders > 0) {
                try {
                    this.serviceClientListeners.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.serviceClientListeners.add(listener);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeListener(ServiceClientListener listener) {
        List list = this.serviceClientListeners;
        synchronized (list) {
            while (this.serviceClientListenerReaders > 0) {
                try {
                    this.serviceClientListeners.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.serviceClientListeners.remove(listener);
            return;
        }
    }

    public void invokeServiceClientListenersOnLookup(ServiceClient serviceClient) throws LookupException {
        List list = this.serviceClientListeners;
        synchronized (list) {
            ++this.serviceClientListenerReaders;
        }
        Iterator i = this.serviceClientListeners.iterator();
        while (i.hasNext()) {
            ServiceClientListener listener = (ServiceClientListener)i.next();
            try {
                listener.onLookup(serviceClient);
            }
            catch (LookupException e) {
                throw e;
            }
            catch (Exception e) {
                cat.error("Exception during invoking of listener", e);
            }
        }
        List list2 = this.serviceClientListeners;
        synchronized (list2) {
            --this.serviceClientListenerReaders;
            this.serviceClientListeners.notifyAll();
        }
    }

    public synchronized void destroy() {
        Class clazz = class$org$idoox$wasp$Context == null ? (class$org$idoox$wasp$Context = RegistryImpl.class$("org.idoox.wasp.Context")) : class$org$idoox$wasp$Context;
        synchronized (clazz) {
            this.stopped = true;
        }
        Map map = this.connectors;
        synchronized (map) {
            Iterator allEndpoints = this.getServiceEndpointList().iterator();
            while (allEndpoints.hasNext()) {
                try {
                    this.unpublish((ServiceEndpoint)allEndpoints.next());
                }
                catch (PublishException ignore) {
                    // empty catch block
                }
            }
        }
        super.destroy();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

