/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.webservice;

import com.idoox.debug.Category;
import com.idoox.soap.EnvelopeCaching;
import com.idoox.wasp.interceptor.InterceptorRepositoryImpl;
import com.systinet.wasp.webservice.FinalizationSupport;
import com.systinet.wasp.webservice.PostRegistrable;
import com.systinet.wasp.webservice.WASPConfigurationImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.idoox.wasp.Context;
import org.idoox.wasp.interceptor.Interceptor;
import org.idoox.wasp.interceptor.InterceptorChain;
import org.systinet.wasp.webservice.Interceptors;

public abstract class InterceptorsImpl
implements Interceptors,
PostRegistrable,
Cloneable,
FinalizationSupport.Finalizable {
    private static final Category log = Category.getCategory("com.systinet.wasp.webservice.InterceptorsImpl");
    protected static final short INITIAL_SIZE = 5;
    protected List dirtyInterceptors;
    protected WASPConfigurationImpl waspConfiguration;
    protected InterceptorRepositoryImpl iRepo;
    protected String interceptorsID = null;
    protected boolean registrated = false;
    private EnvelopeCaching envelopeCache = null;
    private static Set certifiedInterceptors = new HashSet(13, 0.75f){
        {
            this.add("com.idoox.wasp.interceptor.DIMEInterceptor");
            this.add("com.idoox.wasp.interceptor.MultipartInterceptor");
            this.add("com.idoox.wasp.interceptor.DebugInterceptor");
        }
    };
    protected static final InterceptorEntry[] EMPTY_IE_ARRAY = new InterceptorEntry[0];

    public void setEnvelopeCache(EnvelopeCaching envelopeCache) {
        this.envelopeCache = envelopeCache;
    }

    public InterceptorsImpl() {
        try {
            this.waspConfiguration = (WASPConfigurationImpl)Context.getInstance("com.systinet.wasp.WASPConfigurationImpl");
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Unsupported repository implementation! (" + e.getMessage() + ")");
        }
        try {
            this.iRepo = (InterceptorRepositoryImpl)Context.getInstance("com.idoox.wasp.interceptor.InterceptorRepository");
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Unsupported repository implementation! (" + e.getMessage() + ")");
        }
        this.dirtyInterceptors = new ArrayList(5);
    }

    public Interceptor get(int position) throws IndexOutOfBoundsException {
        Interceptor interceptor;
        this.checkSize(position);
        if (this.isRegistered()) {
            String confName = this.getInterceptors()[position].name;
            interceptor = this.iRepo.getInterceptor(confName);
        } else {
            interceptor = ((InterceptorEntry)this.dirtyInterceptors.get((int)position)).interceptor;
        }
        return interceptor;
    }

    public int getDirection(int position) throws IndexOutOfBoundsException {
        this.checkSize(position);
        if (this.isRegistered()) {
            return this.getInterceptors()[position].direction;
        }
        return ((InterceptorEntry)this.dirtyInterceptors.get((int)position)).direction;
    }

    public void setDirection(int position, int direction) throws IndexOutOfBoundsException {
        this.checkSize(position);
        if (this.isRegistered()) {
            this.getInterceptors()[position].direction = direction;
        } else {
            ((InterceptorEntry)this.dirtyInterceptors.get((int)position)).direction = direction;
        }
    }

    public synchronized void insert(int position, Interceptor instance, int direction) throws IndexOutOfBoundsException {
        if (this.isRegistered()) {
            String confName = this.waspConfiguration.registerInterceptor(instance);
            switch (position) {
                case 0: {
                    this.addInterceptor(confName, direction, 0);
                    break;
                }
                case 0x7FFFFFFF: {
                    this.addInterceptor(confName, direction);
                    break;
                }
                default: {
                    this.checkSizeForInserting(position);
                    this.addInterceptor(confName, direction, position);
                    break;
                }
            }
        } else {
            InterceptorEntry entry = new InterceptorEntry(null, instance, direction, position);
            switch (position) {
                case 0: {
                    this.dirtyInterceptors.add(0, entry);
                    break;
                }
                case 0x7FFFFFFF: {
                    this.dirtyInterceptors.add(entry);
                    break;
                }
                default: {
                    this.checkSizeForInserting(position);
                    this.dirtyInterceptors.add(position, entry);
                }
            }
        }
    }

    public void insert(Interceptor instance, int direction) {
        try {
            this.insert(Integer.MAX_VALUE, instance, direction);
        }
        catch (IndexOutOfBoundsException e) {
            log.error(e);
        }
    }

    public synchronized void remove(int position) throws IndexOutOfBoundsException {
        this.checkSize(position);
        if (this.isRegistered()) {
            String confName = this.getInterceptors()[position].name;
            this.removeInterceptor(confName);
            if (confName.startsWith("WASP.transientInstanceName")) {
                this.waspConfiguration.unregisterInterceptor(confName);
            }
        } else {
            this.dirtyInterceptors.remove(position);
        }
    }

    public synchronized boolean remove(Interceptor instance) {
        boolean wasModified = false;
        if (this.isRegistered()) {
            InterceptorEntry[] entries = this.getInterceptors();
            int i = 0;
            while (i < entries.length) {
                if (instance == entries[i].interceptor) {
                    String confName = entries[i].name;
                    this.removeInterceptor(confName);
                    if (confName.startsWith("WASP.transientInstanceName")) {
                        this.waspConfiguration.unregisterInterceptor(confName);
                    }
                    wasModified = true;
                }
                ++i;
            }
        } else {
            Iterator it = this.dirtyInterceptors.iterator();
            while (it.hasNext()) {
                InterceptorEntry entry = (InterceptorEntry)it.next();
                if (instance != entry.interceptor) continue;
                it.remove();
                wasModified = true;
            }
        }
        return wasModified;
    }

    public int size() {
        if (this.isRegistered()) {
            return this.getInterceptors().length;
        }
        return this.dirtyInterceptors.size();
    }

    public void postRegistrate(String interceptorsID) {
        if (this.registrated) {
            throw new IllegalStateException("postRegistrate can be run only once..");
        }
        this.registrated = true;
        this.interceptorsID = interceptorsID;
        this.registerDirtyInterceptors();
        this.checkEnvelopeCaching();
    }

    private void checkEnvelopeCaching() {
        InterceptorEntry[] entries = this.getInterceptors();
        if (entries == null) {
            this.disableEnvelopeCache();
        }
        int i = 0;
        while (i < entries.length) {
            InterceptorEntry entry = entries[i];
            if (!this.certifiedInterceptor(entry)) {
                this.disableEnvelopeCache();
                return;
            }
            ++i;
        }
    }

    private void disableEnvelopeCache() {
        if (this.envelopeCache != null) {
            this.envelopeCache.disable();
        }
    }

    private boolean certifiedInterceptor(InterceptorEntry entry) {
        if (entry == null) {
            return false;
        }
        Interceptor interceptor = entry.interceptor;
        if (interceptor == null) {
            return false;
        }
        return certifiedInterceptors.contains(interceptor.getClass().getName());
    }

    protected void checkSize(int position) throws IndexOutOfBoundsException {
        if (this.isRegistered()) {
            if (position < 0 || position >= this.getInterceptors().length) {
                throw new IndexOutOfBoundsException("index: " + position + ", size: " + this.getInterceptors().length);
            }
        } else if (position < 0 || position >= this.dirtyInterceptors.size()) {
            throw new IndexOutOfBoundsException("index: " + position + ", size: " + this.dirtyInterceptors.size());
        }
    }

    protected void checkSizeForInserting(int position) throws IndexOutOfBoundsException {
        if (this.isRegistered()) {
            if (position < 0 || position > this.getInterceptors().length) {
                throw new IndexOutOfBoundsException("index: " + position + ", size: " + this.getInterceptors().length);
            }
        } else if (position < 0 || position > this.dirtyInterceptors.size()) {
            throw new IndexOutOfBoundsException("index: " + position + ", size: " + this.dirtyInterceptors.size());
        }
    }

    protected void registerDirtyInterceptors() {
        int i = 0;
        while (i < this.dirtyInterceptors.size()) {
            InterceptorEntry entry = (InterceptorEntry)this.dirtyInterceptors.get(i);
            String confName = this.waspConfiguration.registerInterceptor(entry.interceptor);
            if (entry.position == Integer.MAX_VALUE) {
                this.addInterceptor(confName, entry.direction);
            } else {
                this.addInterceptor(confName, entry.direction, entry.position);
            }
            ++i;
        }
        this.dirtyInterceptors.clear();
        this.dirtyInterceptors = null;
    }

    protected boolean isRegistered() {
        return this.interceptorsID != null;
    }

    public void addInterceptor(String name, int direction) {
        if (this.iRepo.getInterceptor(name) == null) {
            throw new IllegalArgumentException("interceptor unknown: '" + name + "'");
        }
        String iChainName = this.getInterceptorsID(true);
        InterceptorChain iChain = this.iRepo.getChain(iChainName);
        this.disableEnvelopeCache();
        iChain.add(name, direction);
    }

    public void addInterceptor(String name, int direction, int position) {
        if (this.iRepo.getInterceptor(name) == null) {
            throw new IllegalArgumentException("interceptor unknown: '" + name + "'");
        }
        String iChainName = this.getInterceptorsID(true);
        InterceptorChain iChain = this.iRepo.getChain(iChainName);
        this.disableEnvelopeCache();
        iChain.add(name, position, direction);
    }

    public void removeInterceptor(String name) {
        if (name == null) {
            return;
        }
        String iChainName = this.getInterceptorsID(false);
        InterceptorChain iChain = this.iRepo.getChain(iChainName);
        if (iChain == null) {
            return;
        }
        int len = iChain.size();
        int i = 0;
        while (i < len) {
            if (name.equals(iChain.getName(i))) {
                iChain.remove(i);
                break;
            }
            ++i;
        }
    }

    public InterceptorEntry[] getInterceptors() {
        String iChainName = this.getInterceptorsID(false);
        InterceptorChain iChain = this.iRepo.getChain(iChainName);
        if (iChain == null) {
            return EMPTY_IE_ARRAY;
        }
        InterceptorChain interceptorChain = iChain;
        synchronized (interceptorChain) {
            int len = iChain.size();
            InterceptorEntry[] retval = new InterceptorEntry[len];
            int i = 0;
            while (i < len) {
                retval[i] = new InterceptorEntry();
                retval[i].name = iChain.getName(i);
                retval[i].direction = iChain.getDirection(i);
                retval[i].interceptor = iChain.get(i);
                retval[i].position = i;
                ++i;
            }
            InterceptorEntry[] interceptorEntryArray = retval;
            return interceptorEntryArray;
        }
    }

    public abstract String getInterceptorsID(boolean var1);

    public String toString() {
        StringBuffer sb = new StringBuffer(500);
        sb.append("interceptors count: " + this.size());
        if (this.isRegistered()) {
            sb.append("\tthis processing is already registered with id " + this.getInterceptorsID(false));
        } else {
            sb.append("\tthis processing is not registered yet.");
        }
        sb.append("\n  listing: ");
        int i = 0;
        while (i < this.size()) {
            String name = this.get(i).toString();
            int direction = this.getDirection(i);
            sb.append("\n\t[#" + i + "]\tname: " + name + ", direction: " + direction + ", " + this.get(i).toString());
            ++i;
        }
        return sb.toString();
    }

    public synchronized Object clone() {
        InterceptorsImpl clone = this.createClone();
        if (!this.isRegistered()) {
            Iterator it = this.dirtyInterceptors.iterator();
            while (it.hasNext()) {
                InterceptorEntry entry = (InterceptorEntry)it.next();
                clone.insert(entry.position, entry.interceptor, entry.direction);
            }
        } else {
            String interceptorsID = this.getInterceptorsID(false);
            InterceptorChain iChain = this.iRepo.getChain(interceptorsID);
            if (iChain != null) {
                InterceptorChain interceptorChain = iChain;
                synchronized (interceptorChain) {
                    int len = iChain.size();
                    InterceptorEntry[] retval = new InterceptorEntry[len];
                    int i = 0;
                    while (i < len) {
                        retval[i] = new InterceptorEntry();
                        retval[i].name = iChain.getName(i);
                        if (retval[i].name != null && !this.isDefault(retval[i].name)) {
                            retval[i].direction = iChain.getDirection(i);
                            retval[i].interceptor = iChain.get(i);
                            retval[i].position = i;
                            if (retval[i].position > clone.size()) {
                                retval[i].position = Integer.MAX_VALUE;
                            }
                            clone.insert(retval[i].position, retval[i].interceptor, retval[i].direction);
                        }
                        ++i;
                    }
                }
            }
        }
        return clone;
    }

    protected abstract InterceptorsImpl createClone();

    protected abstract boolean isDefault(String var1);

    public void onFinalize() {
        String interceptorsID = this.getInterceptorsID(false);
        this.iRepo.removeChain(interceptorsID);
    }

    protected static class InterceptorEntry {
        public String name;
        public int direction;
        public int position;
        public Interceptor interceptor;

        public InterceptorEntry(String name, Interceptor interceptor, int direction) {
            this.name = name;
            this.direction = direction;
            this.position = Integer.MAX_VALUE;
            this.interceptor = interceptor;
        }

        public InterceptorEntry(String name, Interceptor interceptor, int direction, int position) {
            this.name = name;
            this.direction = direction;
            this.position = position;
            this.interceptor = interceptor;
        }

        public InterceptorEntry() {
        }
    }
}

