/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.webservice;

import com.systinet.wasp.async.AsyncCallbackService;
import com.systinet.wasp.client.XMLInvocationHelperImpl;
import com.systinet.wasp.rpc.handler.SOAPMessageContextFactory;
import com.systinet.wasp.webservice.CallContextImpl;
import com.systinet.wasp.webservice.CurrentImpl;
import com.systinet.wasp.webservice.ServiceClientImpl;
import java.rmi.RemoteException;
import java.util.Map;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import org.idoox.wasp.Context;
import org.systinet.logging.Category;
import org.systinet.wasp.addressing.AddressingHeaders;
import org.systinet.wasp.handler.HandlerRepository;
import org.systinet.wasp.policy.EffectivePolicy;
import org.systinet.wasp.policy.IPolicyManager;
import org.systinet.wasp.rpc.handler.Bookmark;
import org.systinet.wasp.rpc.handler.ContextHolder;
import org.systinet.wasp.rpc.handler.WaspContextHolder;
import org.systinet.wasp.rpc.handler.soap.WaspSOAPMessageContext;
import org.systinet.wasp.soap.WaspInternalSOAPMessage;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.Processing;
import org.systinet.wasp.webservice.ServiceClient;
import org.systinet.wasp.webservice.ServiceClientContext;

public class ClientBookmarkImpl
extends Bookmark {
    static final long serialVersionUID = 1987543704401003212L;
    private static final Category dbg = Category.getCategory("com.systinet.wasp.webservice.ClientBookmarkImpl");
    private static final IPolicyManager policyManager = (IPolicyManager)Context.getInstance("org.systinet.wasp.policy.PolicyManager");
    private ServiceClientContext serviceClientContext;
    private transient ServiceClient serviceClient;

    public ClientBookmarkImpl() {
    }

    public ClientBookmarkImpl(HandlerRepository.DirectionPositionEntry position) {
        this.position = position;
    }

    public synchronized void init(Processing processing) {
        dbg.debug("Initialization of client bookmark " + this + ", " + processing);
        this.serviceClient = (ServiceClient)processing;
        this.serviceClientContext = this.serviceClient.getContext();
    }

    public ServiceClient getServiceClient() {
        return this.serviceClient;
    }

    public ServiceClientContext getServiceClientContext() {
        return this.serviceClientContext;
    }

    public WaspContextHolder handleOutput(WaspContextHolder contextHolder) throws RemoteException {
        WaspContextHolder waspContextHolder;
        AddressingHeaders outAddr;
        Map messageProperties = contextHolder.getMessageProperties();
        Map callContextData = contextHolder.getCallContextData();
        EffectivePolicy ep = (EffectivePolicy)callContextData.get("policy.output");
        if (ep == null && (outAddr = (AddressingHeaders)callContextData.get("addressing.output")) != null) {
            EffectivePolicy policy = policyManager.getEffectivePolicy(outAddr.to);
            callContextData.put("policy.output", policy);
        }
        this.applyToCurrentThread(contextHolder);
        try {
            SOAPMessageContext soapMessageContext = SOAPMessageContextFactory.newInstance();
            soapMessageContext.setMessage(contextHolder.getSoapMessage());
            ((WaspSOAPMessageContext)soapMessageContext).initProperties(messageProperties);
            WaspSOAPMessageContext responseContext = (WaspSOAPMessageContext)XMLInvocationHelperImpl.sendRequest(soapMessageContext, this.serviceClient, this.position);
            if (responseContext != null) {
                WaspContextHolder waspContextHolder2 = WaspContextHolder.create(Current.getCallContext(), responseContext.getProperties(), responseContext.getMessage());
                Object var9_9 = null;
                return waspContextHolder2;
            }
            waspContextHolder = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            throw throwable;
        }
        Object var9_10 = null;
        return waspContextHolder;
    }

    public WaspContextHolder handleInput(WaspContextHolder invocationState) {
        return this.handleShortInput(invocationState);
    }

    public WaspContextHolder handleShortOutput(WaspContextHolder invocationState) {
        dbg.error("This method should never be called");
        return null;
    }

    public void oneWayAck(String correlationId) {
        AsyncCallbackService.Frontend frontend = ((ServiceClientImpl)this.serviceClient).getAsyncService();
        frontend.oneWayAck(correlationId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WaspContextHolder handleShortInput(WaspContextHolder contextHolder) {
        AddressingHeaders inAddr;
        Map contextProperties = contextHolder.getMessageProperties();
        Map callContextData = contextHolder.getCallContextData();
        EffectivePolicy ep = (EffectivePolicy)callContextData.get("policy.input");
        if (ep == null && (inAddr = (AddressingHeaders)callContextData.get("addressing.input")) != null) {
            EffectivePolicy policy = policyManager.getEffectivePolicy(inAddr.to);
            callContextData.put("policy.input", policy);
        }
        this.applyToCurrentThread(contextHolder);
        try {
            SOAPMessageContext soapMessageContext = SOAPMessageContextFactory.newInstance();
            soapMessageContext.setMessage(contextHolder.getSoapMessage());
            ((WaspSOAPMessageContext)soapMessageContext).initProperties(contextProperties);
            try {
                int pos = (((WaspInternalSOAPMessage)soapMessageContext.getMessage()).hasFault(null) ? this.position.getFaultChainPosition() : this.position.getInChainPosition()) - 1;
                WaspSOAPMessageContext responseContext = (WaspSOAPMessageContext)XMLInvocationHelperImpl.handleShortResponse(soapMessageContext, this.serviceClient, pos);
                if (responseContext == null) return null;
                return WaspContextHolder.create(Current.getCallContext(), responseContext.getProperties(), responseContext.getMessage());
            }
            catch (Exception e) {
                dbg.error(e);
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            throw throwable;
        }
    }

    public synchronized void applyToCurrentThread(ContextHolder contextHolder) {
        CallContextImpl callContext = new CallContextImpl(contextHolder.getCallContextData(), this.serviceClientContext.getContextData());
        super.applyToCurrentThread(callContext, contextHolder.getMessageProperties());
        CurrentImpl.ThreadLocals threadLocals = Bookmark.getCurrent().getThreadLocals();
        threadLocals.processingType = 1;
        threadLocals.serviceClientContext = this.serviceClientContext;
    }
}

