/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.util;

import java.util.ArrayList;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.idoox.util.RuntimeWrappedException;
import org.systinet.wasp.soap.WaspSOAPMessage;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.Processing;

public class AttachmentsHandler
implements Handler {
    public static final String ATTACHMENTS_CONTEXT_KEY = "com.systinet.wasp.handlers.AttachmentsHandler.data";
    private static final DataHandler[] emptyAttachmentArray = new DataHandler[0];

    private void addAttachmentsToContext(MessageContext messageContext) {
        SOAPMessageContext smc = (SOAPMessageContext)messageContext;
        SOAPMessage msg = smc.getMessage();
        Iterator i = msg.getAttachments();
        ArrayList<DataHandler> al = new ArrayList<DataHandler>(3);
        while (i.hasNext()) {
            try {
                al.add(((AttachmentPart)i.next()).getDataHandler());
            }
            catch (SOAPException e) {
                throw new RuntimeWrappedException("error while getting DataHandler of attachment", e);
            }
        }
        Current.getCallContext().getContextData().put(ATTACHMENTS_CONTEXT_KEY, al.toArray(emptyAttachmentArray));
    }

    private void addAttachmentsToMessage(MessageContext messageContext) {
        SOAPMessageContext smc = (SOAPMessageContext)messageContext;
        WaspSOAPMessage msg = (WaspSOAPMessage)smc.getMessage();
        DataHandler[] attachments = (DataHandler[])Current.getCallContext().getContextData().get(ATTACHMENTS_CONTEXT_KEY);
        if (attachments != null) {
            int i = 0;
            while (i < attachments.length) {
                DataHandler dataHandler = attachments[i];
                AttachmentPart ap = msg.createAttachmentPart(dataHandler);
                msg.addAttachmentPart(ap);
                ++i;
            }
        }
    }

    public boolean handleRequest(MessageContext messageContext) throws SOAPFaultException {
        if (Current.getProcessingType() == 1) {
            this.addAttachmentsToMessage(messageContext);
        } else {
            this.addAttachmentsToContext(messageContext);
        }
        return true;
    }

    public boolean handleResponse(MessageContext messageContext) {
        if (Current.getProcessingType() == 1) {
            this.addAttachmentsToContext(messageContext);
        } else {
            this.addAttachmentsToMessage(messageContext);
        }
        return true;
    }

    public boolean handleFault(MessageContext messageContext) {
        return true;
    }

    public void init(HandlerInfo config) {
    }

    public QName[] getHeaders() {
        return new QName[0];
    }

    public void destroy() {
    }

    public static void registerAttachmentsHandler(Processing processing) {
        processing.getHandlers().insert(new AttachmentsHandler());
    }
}

