/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.soap;

import com.systinet.wasp.soap.ProtocolDetector;
import java.io.IOException;
import org.idoox.transport.InputMessage;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.systinet.wasp.webservice.Current;

public class SOAP11ProtocolDetector
implements ProtocolDetector {
    private Tokenizer tokenizer;

    public boolean canHandle(Tokenizer tokenizer, InputMessage inputMessage) throws TokenizerException, IOException {
        Object protocol;
        if (Current.getCallContext() != null && (protocol = Current.getCallContext().getContextData().get("wasp.xml.protocol")) != null && !protocol.equals(this.getXMLProtocol())) {
            return false;
        }
        byte state = tokenizer.currentState();
        while (state != 2 && state != 1) {
            state = tokenizer.next();
        }
        if (state != 2) {
            throw new TokenizerException("Error: unable to read input message. Start element not found!");
        }
        this.tokenizer = tokenizer;
        String uri = tokenizer.getNamespace();
        if (uri == null) {
            return false;
        }
        return this.isThisProtocol(uri);
    }

    protected boolean isThisProtocol(String namespace) {
        return namespace.equals("http://schemas.xmlsoap.org/soap/envelope/");
    }

    public Tokenizer getTokenizer() {
        return this.tokenizer;
    }

    protected String getXMLProtocol() {
        return "soap11";
    }
}

