/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.soap;

import com.idoox.debug.Category;
import com.idoox.soap.EnvelopeCaching;
import com.idoox.soap.EnvelopeInCache;
import com.idoox.soap.PushbackTokenizer;
import com.idoox.soap.VersionMismatchException;
import com.idoox.util.Pool;
import com.idoox.xml.ReaderTokenizer;
import com.idoox.xml.ReaderTokenizerPool;
import com.systinet.wasp.soap.GETProtocolDetector;
import com.systinet.wasp.soap.MessagePartImpl;
import com.systinet.wasp.soap.MessagePartPool;
import com.systinet.wasp.soap.MimeHeadersSourceImpl;
import com.systinet.wasp.soap.ProtocolDetector;
import com.systinet.wasp.soap.SOAP11ProtocolDetector;
import com.systinet.wasp.soap.SOAP12ProtocolDetector;
import com.systinet.wasp.soap.StreamCloseListener;
import com.systinet.wasp.webservice.CurrentImpl;
import com.systinet.wasp.webservice.ServiceClientImpl;
import com.systinet.wasp.webservice.ServiceEndpointImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import org.idoox.transport.InputMessage;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.xml.DeclaredPrefixesStack;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.systinet.wasp.soap.AutoCloseListener;
import org.systinet.wasp.soap.MessagePart;
import org.systinet.wasp.soap.MessageSource;
import org.systinet.wasp.soap.UnsupportedMessageTypeException;
import org.systinet.wasp.webservice.CallContext;
import org.systinet.wasp.webservice.Current;

public class MessageSourceImpl
implements MessageSource,
StreamCloseListener {
    private Pool pool;
    private InputMessage message;
    private MessagePartImpl xmlPart;
    private List parts = new ArrayList();
    private MimeHeadersSourceImpl headers = new MimeHeadersSourceImpl();
    private Tokenizer tokenizer;
    private String multipartType;
    private Map handlerMap = new HashMap();
    private String protocol;
    private int openedStreams;
    private boolean autoClose;
    private boolean autoRelease;
    private InputStream xmlPartInputStream;
    private ReaderTokenizer toRelease;
    private AutoCloseListener autoCloseListener;
    private static final Category cat = Category.getCategory("com.systinet.wasp.soap.MessageSourceImpl");
    private static Map STATUS_CODE2MSG = new HashMap(){
        {
            this.put(new Integer(200), "OK");
            this.put(new Integer(201), "Created");
            this.put(new Integer(202), "Accepted");
            this.put(new Integer(204), "No content");
            this.put(new Integer(400), "Bad message");
            this.put(new Integer(401), "Unauthorized");
            this.put(new Integer(403), "Forbidden");
            this.put(new Integer(404), "Not found");
            this.put(new Integer(405), "Method not allowed");
            this.put(new Integer(408), "Request Timeout");
            this.put(new Integer(415), "Method not allowed");
            this.put(new Integer(427), "SOAP action required");
            this.put(new Integer(500), "Internal error");
            this.put(new Integer(503), "Service unavailable");
            this.put(new Integer(505), "Protocol not supported");
        }
    };
    public static final String SOAP_MCONTEXT_HEADER_PRESENT = "MessageSourceImpl.headerPresent";
    private DeclaredPrefixesStack declaredPrefixesStackEnvelope = new DeclaredPrefixesStack();
    private Token envelopeToken = new Token();
    private DeclaredPrefixesStack declaredPrefixesStackBody = new DeclaredPrefixesStack();
    private Token bodyToken = new Token();

    protected MessageSourceImpl() {
        this.handlerMap.put("soap11", new SOAP11ProtocolDetector());
        this.handlerMap.put("soap12", new SOAP12ProtocolDetector());
        this.handlerMap.put("httpget", new GETProtocolDetector());
    }

    public void init(InputMessage message, SOAPMessageContext messageContext) throws IOException, TokenizerException, UnsupportedMessageTypeException, VersionMismatchException {
        this.message = message;
        this.multipartType = message.getMultipartType();
        this.headers.init(message, this.multipartType != null);
        if (this.multipartType != null && !"multipart/related".equalsIgnoreCase(this.multipartType) && !"application/dime".equalsIgnoreCase(this.multipartType)) {
            throw new UnsupportedMessageTypeException(this.multipartType);
        }
        this.xmlPart = (MessagePartImpl)this.nextPart();
        this.xmlPart.setXmlPart(true);
        this.tokenizer = ReaderTokenizerPool.getReaderTokenizer();
        this.toRelease = (ReaderTokenizer)this.tokenizer;
        this.xmlPartInputStream = this.xmlPart.getInputStream();
        String contentType = this.xmlPart.getContentType();
        String content = null;
        CurrentImpl.ThreadLocals threadLocals = null;
        if (contentType != null && (contentType.startsWith("text/html") || contentType.startsWith("text/plain"))) {
            content = this.readStremAsString(this.xmlPartInputStream);
        } else {
            if (messageContext != null) {
                EnvelopeCaching envelopeCache;
                String envelopeIdHeader = this.xmlPart.getMimeHeader(EnvelopeCaching.HTTP_HEADER_NAME_LC);
                threadLocals = (CurrentImpl.ThreadLocals)messageContext.getProperty("core.current.threadlocals");
                if (threadLocals.processingType == 1) {
                    ServiceClientImpl serviceClient = (ServiceClientImpl)threadLocals.serviceClientContext.getServiceClient();
                    envelopeCache = serviceClient.getEnvelopeCache();
                } else {
                    ServiceEndpointImpl serviceEndpoint = (ServiceEndpointImpl)threadLocals.serviceEndpointContext.getServiceEndpoint();
                    envelopeCache = serviceEndpoint.getEnvelopeCache();
                }
                EnvelopeInCache.prepareEnvelopeInCache(envelopeCache, envelopeIdHeader, this.xmlPartInputStream, this.toRelease);
            } else {
                this.toRelease.setInput(this.xmlPartInputStream);
                this.toRelease.next();
            }
            Iterator it = this.handlerMap.entrySet().iterator();
            try {
                while (it.hasNext()) {
                    Map cData;
                    Map.Entry entry = it.next();
                    ProtocolDetector handler = (ProtocolDetector)entry.getValue();
                    if (!handler.canHandle(this.tokenizer, message)) continue;
                    this.protocol = (String)entry.getKey();
                    CallContext cc = Current.getCallContext();
                    if (cc != null && (cData = cc.getContextData()).get("wasp.xml.protocol") == null) {
                        cData.put("wasp.xml.protocol", this.protocol);
                    }
                    this.tokenizer = handler.getTokenizer();
                    this.tokenizer = this.setContainsHeader(this.tokenizer, messageContext, threadLocals);
                    return;
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (this.isClientProcessing(messageContext)) {
            int sc = message.getStatusCode();
            if (contentType == null || !contentType.startsWith("text/plain") && !contentType.startsWith("text/html")) {
                throw new VersionMismatchException(this.getGenericMessage(sc, contentType, content, " server response", " Incoming message is not SOAP 1.1 nor SOAP 1.2"));
            }
            throw new IOException(this.getGenericMessage(sc, contentType, content, " server response", ""));
        }
        if (contentType == null || !contentType.startsWith("text/plain") && !contentType.startsWith("text/html")) {
            throw new VersionMismatchException(this.getGenericMessage(-1, contentType, content, " client request", " Incoming message is not SOAP 1.1 nor SOAP 1.2"));
        }
        throw new IOException(this.getGenericMessage(-1, contentType, content, " client request", ""));
    }

    private boolean isClientProcessing(SOAPMessageContext messageContext) {
        CurrentImpl.ThreadLocals threadLocals;
        return messageContext != null && (threadLocals = (CurrentImpl.ThreadLocals)messageContext.getProperty("core.current.threadlocals")) != null && threadLocals.processingType == 1;
    }

    private String getGenericMessage(int sc, String contentType, String content, String what, String appendix) {
        if (sc > 0) {
            String x = (String)STATUS_CODE2MSG.get(new Integer(sc));
            String status = x != null ? " Server returned status code:" + sc + " (" + x + ")" : " Server returned status code:" + sc;
            return "Unable to read" + what + "." + status + appendix;
        }
        String status = "";
        String msgContent = content != null ? ":\n" + content + "\n" : ".";
        if (contentType != null) {
            return "Unable to read" + what + " (Content-type:" + contentType + ")" + msgContent + appendix;
        }
        return "Unable to read" + what + status + msgContent + appendix;
    }

    /*
     * WARNING - void declaration
     */
    private String readStremAsString(InputStream inputStream) throws IOException {
        int nextRead;
        byte[] buff = new byte[128];
        StringBuffer result = new StringBuffer();
        while ((nextRead = inputStream.read(buff)) > 0) {
            void var3_4;
            result.append(new String(buff, 0, (int)var3_4));
        }
        return result.toString();
    }

    public String getXMLProtocol() {
        return this.protocol;
    }

    public Tokenizer getXMLPartTokenizer() {
        return this.tokenizer;
    }

    public Iterator getParts() throws IOException {
        return new PartIterator();
    }

    public void setAutoClose(boolean autoClose, AutoCloseListener listener) {
        this.autoCloseListener = listener;
        this.autoClose = autoClose;
    }

    public synchronized void release() {
        try {
            if (this.xmlPartInputStream != null && this.multipartType == null) {
                this.xmlPartInputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.autoClose) {
            if (this.openedStreams < 2) {
                if (this.autoCloseListener != null) {
                    this.autoCloseListener.close();
                }
                this.clear();
            } else {
                this.autoRelease = true;
            }
        } else {
            this.clear();
        }
    }

    public String getAttachmentType() {
        return this.multipartType;
    }

    private void clear() {
        this.headers.clear();
        this.multipartType = null;
        this.xmlPart = null;
        if (this.toRelease != null) {
            ReaderTokenizerPool.releaseReaderTokenizer(this.toRelease);
            this.toRelease = null;
        }
        this.tokenizer = null;
        this.autoClose = false;
        this.autoCloseListener = null;
        this.autoRelease = false;
        this.openedStreams = 0;
        Pool tmp = this.pool;
        if (this.message != null) {
            try {
                this.message.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.message = null;
        }
        Iterator i = this.parts.iterator();
        while (i.hasNext()) {
            ((MessagePartImpl)i.next()).release();
        }
        this.parts.clear();
        if (this.pool != null) {
            this.pool = null;
            tmp.release(this);
        }
    }

    public void setPool(Pool pool) {
        this.pool = pool;
    }

    /*
     * Enabled aggressive block sorting
     */
    private synchronized MessagePart nextPart() throws IOException {
        if (this.xmlPart != null) {
            if (this.multipartType == null) return null;
        }
        if (this.message == null) {
            return null;
        }
        MessagePartImpl theLast = null;
        if (this.parts.size() > 0) {
            theLast = (MessagePartImpl)this.parts.get(this.parts.size() - 1);
        }
        if (theLast != null) {
            theLast.fillIn();
            if (this.message.nextPart()) {
                theLast = (MessagePartImpl)MessagePartPool.getMessagePart();
                theLast.initInput(this.message, this);
                this.parts.add(theLast);
                return theLast;
            }
            this.message.close();
            this.message = null;
            return null;
        }
        theLast = (MessagePartImpl)MessagePartPool.getMessagePart();
        if (this.multipartType == null) {
            theLast.setOnlyXmlPart(true);
        } else {
            this.message.nextPart();
            theLast.setNoFillCache();
            theLast.setOnlyXmlPart(false);
        }
        theLast.initInput(this.message, this);
        this.parts.add(theLast);
        return theLast;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized boolean hasNextPart(int index) {
        try {
            if (index < this.parts.size()) {
                return true;
            }
            if (this.message == null) {
                return false;
            }
            do {
                if (this.parts.size() <= index && this.message != null) continue;
                if (this.message == null) return false;
                return true;
            } while (this.nextPart() != null);
            return false;
        }
        catch (IOException e) {
            throw new RuntimeWrappedException(e);
        }
    }

    private synchronized Object getNextPart(int index) {
        if (this.parts.size() > index) {
            return this.parts.get(index);
        }
        if (this.hasNextPart(index)) {
            return this.parts.get(index);
        }
        return null;
    }

    public synchronized void newStream(String contentId, String contentLocation) {
        ++this.openedStreams;
    }

    public synchronized void streamClosed(String contentId, String contentLocation) {
        --this.openedStreams;
        if (this.openedStreams < 2) {
            if (this.autoRelease) {
                this.clear();
            }
            if (this.autoCloseListener != null) {
                this.autoCloseListener.close();
            }
        }
    }

    public MessagePart getXMLPart() {
        return this.xmlPart;
    }

    private Tokenizer setContainsHeader(Tokenizer input, SOAPMessageContext context, CurrentImpl.ThreadLocals threadLocals) throws TokenizerException, IOException {
        if (context == null) {
            return input;
        }
        byte state = input.currentState();
        while (state != 2 && state != 1) {
            state = input.next();
        }
        if (state == 1) {
            throw new RuntimeException("Premature end of source.");
        }
        input.readToken(this.envelopeToken);
        this.declaredPrefixesStackEnvelope.used = 0;
        input.pushNewlyDeclaredPrefixes(this.declaredPrefixesStackEnvelope);
        Map envelpePrefixMap = input.getCurrentPrefixMap();
        state = input.next();
        while (state != 2 && state != 1) {
            state = input.next();
        }
        if (state == 1) {
            throw new RuntimeException("Premature end of source.");
        }
        if (input.getLocalName().equals("Header")) {
            context.setProperty(SOAP_MCONTEXT_HEADER_PRESENT, null);
        } else if (threadLocals.processingType == 1) {
            input.readToken(this.bodyToken);
            this.declaredPrefixesStackBody.used = 0;
            input.pushNewlyDeclaredPrefixes(this.declaredPrefixesStackBody);
            Map bodyPrefixMap = input.getCurrentPrefixMap();
            state = input.next();
            while (state != 2 && state != 1 && state != 3) {
                state = input.next();
            }
            if (state == 1) {
                throw new RuntimeException("Premature end of source.");
            }
            if (!(state != 3 && input.getLocalName().equals("Fault") || threadLocals == null)) {
                threadLocals.callContext.getContextData().put("MessageSourceImpl.faultNotPresent", Boolean.TRUE);
            }
            input = new PushbackTokenizer(input, this.bodyToken, this.declaredPrefixesStackBody, bodyPrefixMap);
        }
        PushbackTokenizer output = new PushbackTokenizer(input, this.envelopeToken, this.declaredPrefixesStackEnvelope, envelpePrefixMap);
        return output;
    }

    public String getMimeHeader(String name) throws IOException {
        return this.headers.getMimeHeader(name);
    }

    public Set getHeaderNames() throws IOException {
        return this.headers.getHeaderNames();
    }

    public String getContentType() {
        return this.headers.getContentType();
    }

    public void cache() {
        try {
            Iterator parts = this.getParts();
            while (parts.hasNext()) {
                parts.next();
            }
        }
        catch (IOException e) {
            cat.warn(e);
        }
    }

    private class PartIterator
    implements Iterator {
        int index;

        private PartIterator() {
        }

        public boolean hasNext() {
            return MessageSourceImpl.this.hasNextPart(this.index);
        }

        public Object next() {
            Object ret = MessageSourceImpl.this.getNextPart(this.index);
            if (ret != null) {
                ++this.index;
            } else {
                throw new NoSuchElementException("Interator has reached the last element");
            }
            return ret;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

