/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.soap;

import com.idoox.util.Pool;
import com.systinet.wasp.soap.MimeHeadersSourceImpl;
import com.systinet.wasp.soap.StreamCloseListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Set;
import org.idoox.transport.InputMessage;
import org.idoox.util.RuntimeWrappedException;
import org.systinet.wasp.soap.MessagePart;

public class MessagePartImpl
implements MessagePart {
    private InputMessage iMessage;
    private MimeHeadersSourceImpl headers = new MimeHeadersSourceImpl();
    private static int readChunkSize = 2048;
    private static int defaultMemoryLimit = 1024;
    private int currentCacheSize = 10;
    private byte[] cache = new byte[this.currentCacheSize * readChunkSize];
    private int inMemoryPointer;
    private int lastChunk = -1;
    private int inMemoryCacheBegin;
    private RandomAccessFile file;
    private File fileName;
    private boolean onlyXmlPart;
    private int memoryLimit = defaultMemoryLimit;
    private Pool pool;
    private boolean xmlPart;
    StreamCloseListener closer;
    private static final String CONTENT_LOCATION_HEADER_LC = "Content-Location".toLowerCase();
    private static final String CONTENT_ID_HEADER_LC = "Content-Id".toLowerCase();

    protected MessagePartImpl() {
    }

    public void initInput(InputMessage iMessage, StreamCloseListener closer) {
        this.iMessage = iMessage;
        this.closer = closer;
        this.headers.clear();
        try {
            this.headers.init(iMessage, !this.onlyXmlPart);
        }
        catch (IOException e) {
            throw new RuntimeWrappedException(e);
        }
    }

    public void setCloser(StreamCloseListener closer) {
        this.closer = closer;
    }

    public InputStream getInputStream() throws IOException {
        if (this.onlyXmlPart) {
            return this.iMessage;
        }
        return new CachedInputStream(this.closer, this.getContentId(), this.getContentLocation());
    }

    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    public String getContentLocation() throws IOException {
        return this.headers.getMimeHeader(CONTENT_LOCATION_HEADER_LC);
    }

    public String getContentId() throws IOException {
        return this.headers.getMimeHeader(CONTENT_ID_HEADER_LC);
    }

    public String getName() {
        return null;
    }

    public synchronized void destroy() {
        if (this.file != null) {
            try {
                this.file.close();
                this.file = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fileName.delete();
        }
    }

    public void setOnlyXmlPart(boolean onlyXmlPart) {
        this.onlyXmlPart = onlyXmlPart;
    }

    public void setNoFillCache() {
        this.memoryLimit = Integer.MAX_VALUE;
    }

    public void release() {
        this.destroy();
        this.iMessage = null;
        this.inMemoryCacheBegin = 0;
        this.headers.clear();
        this.inMemoryPointer = 0;
        this.lastChunk = -1;
        this.onlyXmlPart = false;
        this.memoryLimit = defaultMemoryLimit;
        this.xmlPart = false;
        if (this.pool != null) {
            this.pool.release(this);
        }
    }

    public void setPool(Pool pool) {
        this.pool = pool;
    }

    public int fillIn() throws IOException {
        this.readChunk(null, Integer.MAX_VALUE);
        return (this.inMemoryCacheBegin + this.inMemoryPointer - 1) * readChunkSize + this.lastChunk;
    }

    synchronized int readChunk(byte[] b, int off) throws IOException {
        while (off >= this.inMemoryCacheBegin + this.inMemoryPointer) {
            int readed = this.readNextChunk();
            if (readed == -1) {
                return -1;
            }
            if (off >= this.inMemoryCacheBegin + this.inMemoryPointer && readed < readChunkSize) break;
        }
        if (off >= this.inMemoryCacheBegin) {
            if (off > this.inMemoryCacheBegin + this.inMemoryPointer) {
                return -1;
            }
            int len = off == this.inMemoryCacheBegin + this.inMemoryPointer ? this.lastChunk : readChunkSize;
            System.arraycopy(this.cache, (off - this.inMemoryCacheBegin) * readChunkSize, b, 0, len);
            return len;
        }
        this.file.seek(off * readChunkSize);
        this.file.read(b);
        return readChunkSize;
    }

    int readNextChunk() throws IOException {
        if (this.lastChunk != -1 && this.lastChunk < readChunkSize) {
            return this.lastChunk;
        }
        if (this.inMemoryPointer == this.memoryLimit) {
            if (this.file == null) {
                this.file = this.newFile();
            }
            this.file.seek(this.inMemoryCacheBegin * readChunkSize);
            this.file.write(this.cache, 0, this.inMemoryPointer * readChunkSize);
            this.inMemoryCacheBegin += this.inMemoryPointer;
            this.inMemoryPointer = 0;
        }
        int readed = 0;
        while (readed < readChunkSize) {
            this.ensureCahceSize(this.inMemoryPointer + 1);
            int aux = this.iMessage.read(this.cache, this.inMemoryPointer * readChunkSize + readed, readChunkSize - readed);
            if (aux == -1) {
                this.lastChunk = readed;
                return readed;
            }
            readed += aux;
        }
        ++this.inMemoryPointer;
        this.lastChunk = readChunkSize;
        return readChunkSize;
    }

    public boolean isXmlPart() {
        return this.xmlPart;
    }

    public void setXmlPart(boolean xmlPart) {
        this.xmlPart = xmlPart;
    }

    void ensureCahceSize(int size) {
        if (size <= this.currentCacheSize) {
            return;
        }
        this.currentCacheSize = this.currentCacheSize * 2 > this.memoryLimit ? this.memoryLimit : this.currentCacheSize * 2;
        byte[] newCache = new byte[this.currentCacheSize * readChunkSize];
        System.arraycopy(this.cache, 0, newCache, 0, (this.inMemoryPointer - 1) * readChunkSize + this.lastChunk);
        this.cache = newCache;
    }

    RandomAccessFile newFile() {
        try {
            this.fileName = File.createTempFile("saaj", null);
            this.fileName.deleteOnExit();
        }
        catch (IOException e) {
            throw new RuntimeWrappedException(e);
        }
        try {
            RandomAccessFile ret = new RandomAccessFile(this.fileName, "rw");
            return e;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeWrappedException(e);
        }
    }

    public String getMimeHeader(String name) throws IOException {
        return this.headers.getMimeHeader(name);
    }

    public Set getHeaderNames() throws IOException {
        return this.headers.getHeaderNames();
    }

    public String getContentType() {
        return this.headers.getContentType();
    }

    private class CachedInputStream
    extends InputStream {
        private byte[] buffer = new byte[MessagePartImpl.access$000()];
        private int pointer;
        private int lastChunk;
        private boolean onEnd;
        private int lastChunkSize;
        private StreamCloseListener closer;
        private String contentId;
        private String contentLocation;
        private boolean closed;

        public CachedInputStream(StreamCloseListener closer, String contentId, String contentLocation) {
            this.closer = closer;
            this.contentId = contentId;
            this.contentLocation = contentLocation;
            if (this.closer != null) {
                this.closer.newStream(contentId, contentLocation);
            }
            this.lastChunk = -1;
        }

        public int read() throws IOException {
            int p;
            if (this.closed) {
                return -1;
            }
            int neededChunk = this.pointer / readChunkSize;
            if (this.onEnd) {
                return -1;
            }
            if (this.lastChunk < neededChunk) {
                this.lastChunkSize = MessagePartImpl.this.readChunk(this.buffer, neededChunk);
                if (this.lastChunkSize == -1) {
                    this.onEnd = true;
                    return -1;
                }
                this.lastChunk = neededChunk;
            }
            if ((p = this.pointer++ % readChunkSize) < this.lastChunkSize) {
                return this.buffer[p] & 0xFF;
            }
            this.onEnd = true;
            return -1;
        }

        /*
         * Unable to fully structure code
         */
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.closed) {
                return -1;
            }
            readed = 0;
            if (!this.onEnd) ** GOTO lbl22
            return -1;
lbl-1000:
            // 1 sources

            {
                neededChunk = this.pointer / MessagePartImpl.access$000();
                if (this.lastChunk < neededChunk) {
                    this.lastChunkSize = MessagePartImpl.this.readChunk(this.buffer, neededChunk);
                    if (this.lastChunkSize == -1) {
                        this.onEnd = true;
                        return readed > 0 ? readed : -1;
                    }
                    this.lastChunk = neededChunk;
                }
                if ((canCopy = this.lastChunkSize - this.pointer % MessagePartImpl.access$000()) == 0) {
                    this.onEnd = true;
                    return readed > 0 ? readed : -1;
                }
                if (canCopy > len) {
                    canCopy = len;
                }
                System.arraycopy(this.buffer, this.pointer % MessagePartImpl.access$000(), b, off + readed, canCopy);
                readed += canCopy;
                len -= canCopy;
                this.pointer += canCopy;
lbl22:
                // 2 sources

                ** while (len > 0 && !this.onEnd)
            }
lbl23:
            // 1 sources

            return readed;
        }

        public void close() throws IOException {
            if (!this.closed && this.closer != null) {
                this.closer.streamClosed(this.contentId, this.contentLocation);
                this.closed = true;
            }
        }
    }
}

