/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.server.adaptor;

import com.idoox.Namespaces;
import com.idoox.wasp.serialization.DuplicateAccessException;
import com.idoox.wasp.serialization.MultirefHandler;
import com.idoox.wasp.serialization.SerializationHelper;
import com.idoox.wasp.serialization.WaspSerializationHelper;
import com.idoox.xml.schema.util.XMLSchemaUtil;
import com.idoox.xmlrpc.encoding.EncodingRepository;
import com.systinet.wasp.server.adaptor.JavaInvoker;
import com.systinet.wasp.webservice.CurrentImpl;
import com.systinet.wasp.webservice.ServiceEndpointImpl;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.util.WrappedException;
import org.idoox.wasp.serialization.PostSerializationHandler;
import org.idoox.wasp.serialization.SchemaContext;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.SerializationRepository;
import org.idoox.wasp.wsdl.SOAPMethodInfo;
import org.idoox.xml.ElementFinalizingTokenizerWrapper;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.TokenizerException;
import org.idoox.xml.XMLWriterReader;
import org.idoox.xml.schema.Member;
import org.idoox.xml.schema.Schema;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xml.schema.Type;
import org.idoox.xmlrpc.Constants;
import org.idoox.xmlrpc.MessageCreatingException;
import org.idoox.xmlrpc.encoding.EncodingTokenWriter;
import org.idoox.xmlrpc.encoding.NoSuchEncodingException;
import org.systinet.wasp.soap.FirstElementSkippingTokenizer;
import org.systinet.wasp.soap.SOAPElementContent;
import org.systinet.wasp.soap.WaspInternalSOAPMessage;

public class FaultSerializationHelper {
    private static final String className = "com.systinet.wasp.server.adaptor.FaultSerializationHelper";
    private Type schemaType;
    private String currentEncodingURI;
    private SOAPMethodInfo.FaultPartInfo partInfo;
    private Schema schema;
    private SerializationRepository serializationRepository;
    private String encodingId;
    private String encodingURI;
    private String serializationId;
    private SOAPMethodInfo methodInfo;
    private boolean useConfigEncoding;
    private boolean doMultirefs;
    private EncodingRepository encodingRepository;
    private static Object[] EMPTY_PARAMS = new Object[0];
    private static final QName FAULT_CODE_NAME11 = new QName(null, "faultcode");
    private static final QName SERVER_FAULT_CODE11 = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server");
    private static final QName FAULT_STRING_NAME11 = new QName(null, "faultstring");
    private static final QName DETAIL_NAME11 = new QName(null, "detail");
    private static final QName FAULT_CODE_NAME12 = new QName(Namespaces.SOAP12_ENV_NS, "Code");
    private static final QName SERVER_FAULT_CODE12 = Constants.RECEIVER_FAULT_CODE_12;
    private static final QName FAULT_STRING_NAME12 = new QName(Namespaces.SOAP12_ENV_NS, "Reason");
    private static final QName DETAIL_NAME12 = new QName(Namespaces.SOAP12_ENV_NS, "Detail");

    public FaultSerializationHelper(SerializationRepository serializationRepository, EncodingRepository encodingRepository, SOAPMethodInfo methodInfo, Schema schema, String serializationId, String encodingId, String encodingURI, boolean useConfigEncoding, boolean doMultirefs) {
        this.serializationId = serializationId;
        this.encodingId = encodingId;
        this.serializationRepository = serializationRepository;
        this.schema = schema;
        this.encodingURI = encodingURI;
        this.methodInfo = methodInfo;
        this.useConfigEncoding = useConfigEncoding;
        this.doMultirefs = doMultirefs;
        this.encodingRepository = encodingRepository;
    }

    public boolean startFault(JavaInvoker javaInvoker, CurrentImpl.ThreadLocals threadLocals, SOAPMessageContext messageContext, ServiceEndpointImpl serviceEndpoint, Throwable e) throws SOAPException, MessageCreatingException, NoSuchEncodingException, SchemaException, InvocationTargetException, NoSuchMethodException, DuplicateAccessException, IntrospectionException, IllegalAccessException {
        if ((e = this.getUserException(e)) instanceof SOAPFaultException) {
            return false;
        }
        String javaTypeName = e.getClass().getName();
        WaspInternalSOAPMessage message = (WaspInternalSOAPMessage)messageContext.getMessage();
        boolean soap12operation = message.getXMLProtocol().equals("soap12");
        boolean uddiEncoding = "UDDIClientEncoding".equals(this.encodingId);
        SerializationContext serContext = this.createSerializationContext(javaTypeName);
        if (serContext == null) {
            return false;
        }
        serContext.clearMultirefs();
        try {
            if (this.partInfo == null) {
                this.findFaultPartWithBaseClass();
            }
            if (this.partInfo == null) {
                QName name = this.schemaType.getName();
                if (name == null) {
                    throw new RuntimeException("Internal error! Name of type is null!");
                }
                Member memeber = new Member(name, this.schemaType);
                this.partInfo = new SOAPMethodInfo.FaultPartInfo(name.getLocalPart(), this.schemaType, memeber, this.currentEncodingURI, 1);
            }
            javaInvoker.setEnvelopePrefixes(serviceEndpoint, message, this.schema, uddiEncoding);
            SOAPEnvelope envelope = message.getSOAPPart().getEnvelope();
            XMLWriterReader bodyTokenizer = new XMLWriterReader();
            this.setPrefixesOnWriter(bodyTokenizer, envelope);
            if (soap12operation) {
                this.writeFaultStart12(bodyTokenizer, envelope, e);
            } else {
                this.writeFaultStart11(bodyTokenizer, envelope, e);
            }
            if (!soap12operation && this.currentEncodingURI != null && !uddiEncoding) {
                bodyTokenizer.writeAttribute("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle", this.currentEncodingURI);
            }
            Object toSerialize = this.prepareSerialization(e, this.partInfo);
            if (this.currentEncodingURI != null || this.partInfo.getUse() == 0) {
                this.serializeEncoded(serContext, this.partInfo, toSerialize, bodyTokenizer, soap12operation);
            } else {
                this.serializeLiteral(serContext, this.partInfo, toSerialize, bodyTokenizer);
            }
            bodyTokenizer.leave();
            SOAPBody body = envelope.getBody();
            ElementFinalizingTokenizerWrapper bodyTokenizerWithEnd = new ElementFinalizingTokenizerWrapper(new ElementFinalizingTokenizerWrapper(new FirstElementSkippingTokenizer(bodyTokenizer, false, true), body), envelope);
            bodyTokenizerWithEnd.next();
            ((SOAPElementContent)((Object)body)).setContent(bodyTokenizerWithEnd);
            message.startProcessing();
        }
        catch (IOException e1) {
            throw new RuntimeWrappedException(e1);
        }
        catch (TokenizerException e1) {
            throw new RuntimeWrappedException(e1);
        }
        return true;
    }

    private void findFaultPartWithBaseClass() {
        SOAPMethodInfo.FaultPartInfo[] infos = this.methodInfo.faultsInfo.getFaultParts();
        int i = 0;
        block0: while (i < infos.length) {
            SOAPMethodInfo.FaultPartInfo ci = infos[i];
            Type cBaseType = ci.getSchemaType();
            Type cCheckType = this.schemaType;
            while (cCheckType != null) {
                if (cCheckType.equals(cBaseType)) {
                    this.partInfo = ci;
                    break block0;
                }
                cCheckType = cCheckType.getBaseType();
            }
            ++i;
        }
    }

    private Object prepareSerialization(Throwable e, SOAPMethodInfo.FaultPartInfo part) throws InvocationTargetException, IllegalAccessException, DuplicateAccessException, IntrospectionException {
        Type schemaType = part.getSchemaType();
        if (schemaType == null) {
            return null;
        }
        Class<?> c = e.getClass();
        if ((schemaType.getKind() & 0x10) > 0 || XMLSchemaUtil.isArray(schemaType) || XMLSchemaUtil.isMSArray(schemaType)) {
            Map props = WaspSerializationHelper.getProperties(c);
            Object ret = this.getObject(e, props, Introspector.decapitalize(part.getName()));
            if (ret != null) {
                return ret;
            }
            String name = null;
            Member element = part.getElement();
            if (element != null) {
                name = element.getName().getLocalPart();
            }
            if (name == null) {
                QName qname = schemaType.getName();
                if (qname != null) {
                    name = qname.getLocalPart();
                }
                if ((ret = this.getObject(e, props, name)) != null) {
                    return ret;
                }
            }
            if ((ret = this.getObject((Object)e, props)) != null) {
                return ret;
            }
        }
        return e;
    }

    private Object getObject(Object o, Map props) throws InvocationTargetException, IllegalAccessException {
        Iterator iterator = props.values().iterator();
        PropertyDescriptor prop = null;
        while (iterator.hasNext()) {
            Object o1 = iterator.next();
            if (!(o1 instanceof PropertyDescriptor)) continue;
            prop = (PropertyDescriptor)o1;
        }
        if (prop != null) {
            return prop.getReadMethod().invoke(o, EMPTY_PARAMS);
        }
        return null;
    }

    private Object getObject(Object o, Map props, String name) throws InvocationTargetException, IllegalAccessException {
        Object fieldOrMethod = props.get(name);
        if (fieldOrMethod != null) {
            return this.getObject(o, fieldOrMethod);
        }
        return null;
    }

    private Object getObject(Object o, Object fieldOrMethod) throws InvocationTargetException, IllegalAccessException {
        if (fieldOrMethod instanceof PropertyDescriptor) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)fieldOrMethod;
            return propertyDescriptor.getReadMethod().invoke(o, EMPTY_PARAMS);
        }
        return ((Field)fieldOrMethod).get(o);
    }

    private Throwable getUserException(Throwable e) {
        if (e instanceof InvocationTargetException) {
            InvocationTargetException invocationTargetException = (InvocationTargetException)e;
            return invocationTargetException.getTargetException();
        }
        if (e instanceof RuntimeWrappedException) {
            RuntimeWrappedException runtimeWrappedException = (RuntimeWrappedException)e;
            return runtimeWrappedException.getRootException();
        }
        if (e instanceof WrappedException) {
            WrappedException wrappedException = (WrappedException)e;
            return wrappedException.getRootException();
        }
        return e;
    }

    private Type getSchemaType(SerializationContext serContext, Schema schema, String javaTypeName) throws SchemaException {
        Type schemaType = schema.getSchemaType(javaTypeName);
        if (schemaType != null) {
            return schemaType;
        }
        QName schemaTypeName = serContext.getSchemaType(javaTypeName);
        if (schemaTypeName != null) {
            schemaType = serContext.getSchemaType(schemaTypeName);
        }
        return schemaType;
    }

    private SerializationContext createSerializationContext(String javaTypeName) throws SchemaException {
        SerializationContext serContext2;
        this.partInfo = this.methodInfo.faultsInfo.getFaultPart(javaTypeName);
        if (this.partInfo != null) {
            String partName = this.partInfo.getName();
            if (partName != null && partName.startsWith("idoox-java-mapping.")) {
                return null;
            }
            SerializationContext serContext2 = this.createSerializationContext(this.serializationId, this.partInfo.getEncodingURI());
            this.schemaType = this.partInfo.getSchemaType();
            serContext2.setSchema(this.schema, true);
            return serContext2;
        }
        boolean serContextEncodingOK = true;
        if (this.useConfigEncoding) {
            serContext2 = this.createSerializationContext(this.serializationId, this.encodingURI);
        } else {
            Set encodings = this.methodInfo.faultsInfo.getEncodings();
            int size = encodings.size();
            if (size == 0) {
                serContext2 = this.createSerializationContext(this.serializationId, null);
            } else if (size == 1) {
                String partEncodingURI = (String)encodings.iterator().next();
                serContext2 = this.createSerializationContext(this.serializationId, partEncodingURI);
                serContextEncodingOK = false;
            } else {
                serContext2 = this.createSerializationContext(this.serializationId, null);
                serContextEncodingOK = false;
            }
        }
        this.schemaType = this.getSchemaType(serContext2, this.schema, javaTypeName);
        if (this.schemaType == null) {
            return null;
        }
        this.partInfo = this.methodInfo.faultsInfo.getFaultPart(this.schemaType);
        if (this.partInfo == null) {
            this.serializationRepository.releaseSerializationContext(serContext2);
            serContext2 = this.createSerializationContext(this.serializationId, this.encodingURI);
            serContext2.setSchema(this.schema, true);
            return serContext2;
        }
        String partName = this.partInfo.getName();
        if (partName != null && partName.startsWith("idoox-java-mapping.")) {
            this.serializationRepository.releaseSerializationContext(serContext2);
            return null;
        }
        if (serContextEncodingOK) {
            serContext2.setSchema(this.schema, true);
            return serContext2;
        }
        this.serializationRepository.releaseSerializationContext(serContext2);
        serContext2 = this.createSerializationContext(this.serializationId, this.partInfo.getEncodingURI());
        serContext2.setSchema(this.schema, true);
        return serContext2;
    }

    private SerializationContext createSerializationContext(String serializationID, String encodingURI) {
        this.currentEncodingURI = encodingURI;
        SerializationContext serContext = this.serializationRepository.createSerializationContext(serializationID, encodingURI);
        return serContext;
    }

    private void serializeLiteral(SerializationContext serContext, SOAPMethodInfo.FaultPartInfo partInfo, Object e, TokenWriter writer) throws MessageCreatingException, IOException {
        Member element;
        if (this.doMultirefs) {
            WaspSerializationHelper.grabReferences(e, serContext, partInfo.getElement(), partInfo.getType(), new QName(partInfo.getNamespaceURI(), partInfo.getName()));
        }
        QName targetQName = (element = partInfo.getElement()) != null ? element.getName() : new QName(partInfo.getNamespaceURI(), partInfo.getName());
        WaspSerializationHelper.writeObject(writer, e, serContext, partInfo.getElement(), partInfo.getType(), targetQName);
        Iterator i = serContext.getPostSerializationHandlers();
        while (i.hasNext()) {
            PostSerializationHandler h = (PostSerializationHandler)i.next();
            h.serializationFinished(serContext);
        }
        this.serializationRepository.releaseSerializationContext(serContext);
        writer.leave();
        writer.leave();
    }

    private void serializeEncoded(SerializationContext serContext, SOAPMethodInfo.FaultPartInfo partInfo, Object e, TokenWriter w, boolean soap12operation) throws MessageCreatingException, NoSuchEncodingException, IOException {
        if (this.doMultirefs) {
            WaspSerializationHelper.grabReferences(e, serContext, partInfo.getElement(), partInfo.getType(), new QName(partInfo.getNamespaceURI(), partInfo.getName()));
        }
        EncodingTokenWriter writer = this.encodingRepository.getEncodingTokenWriter(this.encodingId, this.encodingURI);
        writer.setTokenWriter(w);
        if (soap12operation) {
            serContext.setMultirefsInline(true);
        }
        QName tartgetQName = new QName(partInfo.getNamespaceURI(), partInfo.getName());
        WaspSerializationHelper.writeObject(writer, e, serContext, partInfo.getElement(), partInfo.getType(), tartgetQName);
        w.leave();
        w.leave();
        if (this.doMultirefs && !serContext.isMultirefsInline()) {
            Iterator i = ((MultirefHandler)((Object)serContext)).getReferencesIterator();
            while (i.hasNext()) {
                serContext.setSerializingMultirefs(true);
                MultirefHandler.MultirefHolder holder = (MultirefHandler.MultirefHolder)i.next();
                if (holder.id == null) continue;
                SchemaContext.State state = serContext.putSchemaConstruct(new Member(new QName(null, "reference"), holder.schemaType, true));
                SerializationHelper.serialize(writer, holder.value, null, serContext);
                serContext.leave(state);
            }
        }
        this.serializationRepository.releaseSerializationContext(serContext);
    }

    private void setPrefixesOnWriter(XMLWriterReader writer, SOAPEnvelope envelope) {
        writer.enter("paddingNamespace123", "PADDING");
        Iterator namespacePrefixes = envelope.getNamespacePrefixes();
        while (namespacePrefixes.hasNext()) {
            String prefix = (String)namespacePrefixes.next();
            writer.setPrefixForNamespace(prefix, envelope.getNamespaceURI(prefix));
        }
    }

    private void writeFaultStart(TokenWriter writer, SOAPEnvelope envelope, Throwable e, QName fcName, QName faultCode, QName fsName, QName detailName, boolean soap12) {
        try {
            Name envName = envelope.getElementName();
            writer.enter(envName.getURI(), "Fault");
            String prefixString = writer.getPrefixForNamespace(faultCode.getNamespaceURI());
            prefixString = prefixString != null && prefixString.length() > 0 ? prefixString + ":" : "";
            writer.enter(fcName.getNamespaceURI(), fcName.getLocalPart());
            if (soap12) {
                writer.enter(fcName.getNamespaceURI(), "Value");
            }
            writer.writeContent(prefixString + faultCode.getLocalPart());
            if (soap12) {
                writer.leave();
            }
            writer.leave();
            writer.enter(fsName.getNamespaceURI(), fsName.getLocalPart());
            if (soap12) {
                writer.enter(fsName.getNamespaceURI(), "Text");
                writer.writeXmlAttribute("lang", "en");
            }
            String message = e.getMessage();
            writer.writeContent(e.getClass() + ":" + (message == null ? "" : message));
            if (soap12) {
                writer.leave();
            }
            writer.leave();
            writer.enter(detailName.getNamespaceURI(), detailName.getLocalPart());
        }
        catch (IOException e1) {
            throw new RuntimeWrappedException(e);
        }
        catch (IllegalStateException e1) {
            throw new RuntimeWrappedException(e);
        }
    }

    private void writeFaultStart11(TokenWriter writer, SOAPEnvelope envelope, Throwable e) {
        this.writeFaultStart(writer, envelope, e, FAULT_CODE_NAME11, SERVER_FAULT_CODE11, FAULT_STRING_NAME11, DETAIL_NAME11, false);
    }

    private void writeFaultStart12(TokenWriter writer, SOAPEnvelope envelope, Throwable e) {
        this.writeFaultStart(writer, envelope, e, FAULT_CODE_NAME12, SERVER_FAULT_CODE12, FAULT_STRING_NAME12, DETAIL_NAME12, true);
    }
}

