/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.sequence;

import com.idoox.debug.Category;
import com.idoox.util.UUID;
import com.idoox.wasp.InitialReferencesRegistrar;
import com.systinet.wasp.sequence.SequenceCache;
import com.systinet.wasp.sequence.SequenceImpl;
import com.systinet.wasp.sequence.SequenceQueueImpl;
import com.systinet.wasp.webservice.ServiceEndpointImpl;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.idoox.config.Configurable;
import org.idoox.wasp.Context;
import org.idoox.wasp.Module;
import org.idoox.wasp.WaspInternalException;
import org.systinet.wasp.sequence.ISequence;
import org.systinet.wasp.sequence.ISequenceRegistry;
import org.systinet.wasp.sequence.PersistentSequenceStore;
import org.systinet.wasp.sequence.PersistentStoreException;
import org.systinet.wasp.sequence.Provider;
import org.systinet.wasp.sequence.Sequence;
import org.systinet.wasp.sequence.SequenceException;
import org.systinet.wasp.sequence.SequenceListener;
import org.systinet.wasp.sequence.SequenceQueue;
import org.systinet.wasp.transaction.Checker;
import org.systinet.wasp.transaction.CompletionException;
import org.systinet.wasp.transaction.PropagationContext;
import org.systinet.wasp.transaction.ResourceOperationException;
import org.systinet.wasp.transaction.Template;
import org.systinet.wasp.transaction.Worker;
import org.systinet.wasp.webservice.IServiceEndpointListener;
import org.systinet.wasp.webservice.Processing;
import org.systinet.wasp.webservice.PublishException;
import org.systinet.wasp.webservice.Registry;
import org.systinet.wasp.webservice.ServiceClient;
import org.systinet.wasp.webservice.ServiceEndpoint;

public class SequenceRegistryImpl
implements Module,
ISequenceRegistry,
IServiceEndpointListener {
    private static final Category log = Category.getCategory((class$com$systinet$wasp$sequence$SequenceRegistryImpl == null ? (class$com$systinet$wasp$sequence$SequenceRegistryImpl = SequenceRegistryImpl.class$("com.systinet.wasp.sequence.SequenceRegistryImpl")) : class$com$systinet$wasp$sequence$SequenceRegistryImpl).getName());
    private static final Map providers = new HashMap();
    private static SequenceQueue expirationQueue;
    private static final SequenceCache sequenceCache;
    private static PersistentSequenceStore persistentStore;
    private List publishedServices = new LinkedList();
    private IServiceEndpointListener endpointListener = new IServiceEndpointListener(){

        public void onPublish(ServiceEndpoint serviceEndpoint) throws PublishException {
        }

        public void onUnpublish(ServiceEndpoint serviceEndpoint) throws PublishException {
        }

        public void onPublishDone(ServiceEndpoint serviceEndpoint) {
            1 var2_2 = this;
            synchronized (var2_2) {
                SequenceRegistryImpl.this.publishedServices.add(serviceEndpoint);
            }
        }
    };
    private static final ISequence[] NO_ISEQUENCE;
    private static final ProcessingHelper processingHelper;
    static /* synthetic */ Class class$com$systinet$wasp$sequence$SequenceRegistryImpl;
    static /* synthetic */ Class class$org$systinet$wasp$sequence$PersistentSequenceStore;

    public void load(Configurable config) throws WaspInternalException {
        InitialReferencesRegistrar.addInitialReference("org.systinet.wasp.sequence.ISequenceRegistry", this);
        SequenceImpl.setRegistry(this);
        IServiceEndpointListener iServiceEndpointListener = this.endpointListener;
        synchronized (iServiceEndpointListener) {
            Registry.addListener(this.endpointListener);
        }
    }

    public void init() throws WaspInternalException {
        if (persistentStore == null) {
            persistentStore = Context.isRegistered(class$org$systinet$wasp$sequence$PersistentSequenceStore == null ? (class$org$systinet$wasp$sequence$PersistentSequenceStore = SequenceRegistryImpl.class$("org.systinet.wasp.sequence.PersistentSequenceStore")) : class$org$systinet$wasp$sequence$PersistentSequenceStore) ? (PersistentSequenceStore)Context.getInstance(class$org$systinet$wasp$sequence$PersistentSequenceStore == null ? (class$org$systinet$wasp$sequence$PersistentSequenceStore = SequenceRegistryImpl.class$("org.systinet.wasp.sequence.PersistentSequenceStore")) : class$org$systinet$wasp$sequence$PersistentSequenceStore) : null;
        }
        if (persistentStore == null) {
            log.info("Persistent sequence store not found/loaded. Sequence API will not work!");
        } else {
            IServiceEndpointListener iServiceEndpointListener = this.endpointListener;
            synchronized (iServiceEndpointListener) {
                Registry.addListener(this);
                Iterator it = this.publishedServices.iterator();
                while (it.hasNext()) {
                    ServiceEndpoint endpoint = (ServiceEndpoint)it.next();
                    this.onPublishDone(endpoint);
                }
                this.publishedServices.clear();
                this.publishedServices = null;
                Registry.removeListener(this.endpointListener);
                this.endpointListener = null;
            }
            Map map = providers;
            synchronized (map) {
                if (!providers.isEmpty()) {
                    this.startExpirationThreadOnce();
                }
            }
        }
    }

    public void destroy() {
        if (persistentStore != null) {
            Registry.removeListener(this);
        }
        providers.clear();
        sequenceCache.clear();
        processingHelper.clear();
        if (expirationQueue != null) {
            expirationQueue.stop();
            expirationQueue = null;
        }
        persistentStore = null;
    }

    public ISequence createSequence(String prefix, boolean generateSuffix, final Processing processing, boolean output) throws SequenceException {
        String generatedID;
        ISequence existingSequence;
        if (providers.size() == 0) {
            throw new IllegalStateException("No Sequence API provider installed, can not create sequence!");
        }
        if (!generateSuffix && (existingSequence = this.getSequence(prefix, false, processing, output)) != null) {
            throw new SequenceException("Can not create sequence which already exists (id = " + existingSequence.getID() + ")");
        }
        if (generateSuffix) {
            String suffix = UUID.uuidgen();
            generatedID = prefix == null ? "urn:" + suffix : prefix + suffix;
        } else {
            generatedID = prefix;
        }
        final SequenceImpl sequence = new SequenceImpl(generatedID, output, processing);
        this.invocationTemplate(null, new ISequenceRegistry.Worker(){

            public Object work() throws SequenceException {
                try {
                    Template.registerNewResource(SequenceQueueImpl.getResource());
                    Template.registerNewResource(sequence);
                    Date date = sequence.getExpires();
                    expirationQueue.insert(sequence, -date.getTime());
                    Iterator it = ((Map)((HashMap)providers).clone()).entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        Provider provider = (Provider)entry.getValue();
                        provider.onCreate(sequence);
                    }
                    SequenceRegistryImpl.this.storeNewSequence(sequence);
                    sequence.setActive(true);
                    return null;
                }
                catch (ResourceOperationException e) {
                    throw new SequenceException(e);
                }
            }
        }, new PropagationContext.TransactionListener(){

            public void beforeCompletion(PropagationContext transaction) {
            }

            public void afterCompletion(PropagationContext transaction, int result) {
                Iterator listeners;
                if (result == 0 && (listeners = SequenceRegistryImpl.this.getCloneListenersForProcessing(processing)) != null) {
                    while (listeners.hasNext()) {
                        ((SequenceListener)listeners.next()).onCreate(sequence);
                    }
                }
            }
        });
        return sequence;
    }

    private void storeNewSequence(SequenceImpl sequence) throws ResourceOperationException {
        persistentStore.insertSequence(sequence);
        sequenceCache.put(sequence);
    }

    public ISequence getSequence(String sequenceID, boolean output) throws SequenceException {
        return this.getSequence(sequenceID, output, null);
    }

    private SequenceImpl getSequence(final String id, final boolean output, final Processing processing) throws SequenceException {
        return (SequenceImpl)this.invocationTemplate(null, new ISequenceRegistry.Worker(){

            public Object work() throws SequenceException {
                SequenceImpl sequence = sequenceCache.get(id, output);
                if (sequence == null) {
                    sequence = SequenceRegistryImpl.this.getSequenceFromStore(id, output, processing);
                }
                return sequence;
            }
        }, null);
    }

    private SequenceImpl getSequenceFromStore(final String id, final boolean output, final Processing processing) throws SequenceException {
        return (SequenceImpl)this.invocationTemplate(null, new ISequenceRegistry.Worker(){

            public Object work() throws SequenceException {
                PersistentSequenceStore.SequenceData sequenceData = null;
                try {
                    sequenceData = persistentStore.getSequence(id, output);
                }
                catch (PersistentStoreException e) {
                    throw new SequenceException(e);
                }
                if (sequenceData == null) {
                    return null;
                }
                SequenceImpl sequence = new SequenceImpl(sequenceData, processing);
                sequenceCache.put(sequence);
                return sequence;
            }
        }, null);
    }

    public ISequence getSequence(final String prefix, boolean matchPrefix, final Processing processing, final boolean output) throws SequenceException {
        SequenceImpl sequence = !matchPrefix ? this.getSequence(prefix, output, processing) : (SequenceImpl)this.invocationTemplate(null, new ISequenceRegistry.Worker(){

            public Object work() throws SequenceException {
                PersistentSequenceStore.SequenceData sequenceData = null;
                try {
                    sequenceData = persistentStore.findSequence(prefix, output);
                }
                catch (PersistentStoreException e) {
                    throw new SequenceException(e);
                }
                if (sequenceData == null) {
                    return null;
                }
                SequenceImpl sequence = new SequenceImpl(sequenceData, processing);
                sequenceCache.put(sequence);
                return sequence;
            }
        }, null);
        return sequence;
    }

    public ISequence[] getOutputSequences(String prefix, Processing processing) throws SequenceException {
        return this.getSequences(prefix, processing, true);
    }

    public final ISequence getAndCreateSequence(final String sequenceId, final Processing processing, final String providerName) throws SequenceException {
        ISequence destinationSequence = (ISequence)this.invocationTemplate(null, new ISequenceRegistry.Worker(){

            public Object work() throws SequenceException {
                ISequence destinationSequence = SequenceRegistryImpl.this.getSequence(sequenceId, false, processing, false);
                if (destinationSequence == null) {
                    destinationSequence = SequenceRegistryImpl.this.createSequence(sequenceId, false, processing, false);
                    destinationSequence.setProviderName(providerName);
                }
                return destinationSequence;
            }
        }, null);
        return destinationSequence;
    }

    public void addProvider(String providerName, Provider listener) {
        Map map = providers;
        synchronized (map) {
            providers.put(providerName, listener);
            if (persistentStore != null) {
                this.startExpirationThreadOnce();
            }
        }
    }

    public void removeProvider(String providerName) {
        providers.remove(providerName);
    }

    public void onPublishDone(final ServiceEndpoint serviceEndpoint) {
        if (providers.size() == 0) {
            return;
        }
        final String endpointPath = serviceEndpoint.getPath();
        try {
            this.invocationTemplate(new ISequenceRegistry.Worker(){

                public Object work() throws SequenceException {
                    String[] sequenceIDs = null;
                    try {
                        sequenceIDs = persistentStore.findSequenceIDs(endpointPath);
                    }
                    catch (PersistentStoreException e) {
                        log.error("An exception while finding sequences, no sequence has been loaded, not processed messages may remain blocked.", e);
                        throw new SequenceException(e);
                    }
                    int i = 0;
                    while (i < sequenceIDs.length) {
                        String sequenceID = sequenceIDs[i];
                        SequenceRegistryImpl.this.getSequence(sequenceID, false, serviceEndpoint);
                        SequenceRegistryImpl.this.getSequence(sequenceID, true, serviceEndpoint);
                        ++i;
                    }
                    return null;
                }
            });
        }
        catch (SequenceException e) {
            log.error("An exception during unblocking the input sequences of the service at " + endpointPath + " not processed sequences may remain blocked.", e);
        }
    }

    public void onPublish(ServiceEndpoint serviceEndpoint) throws PublishException {
    }

    public void onUnpublish(ServiceEndpoint serviceEndpoint) throws PublishException {
        if (providers.size() == 0) {
            return;
        }
        String endpointPath = serviceEndpoint.getPath();
        String[] sequenceIDs = null;
        try {
            sequenceIDs = persistentStore.findSequenceIDs(endpointPath);
        }
        catch (PersistentStoreException e) {
            log.error("An exception while finding sequences, no sequence has been loaded, not processed messages may remain unblocked.", e);
            return;
        }
        try {
            int i = 0;
            while (i < sequenceIDs.length) {
                SequenceImpl sequence;
                String sequenceID = sequenceIDs[i];
                SequenceImpl iSequence = this.getSequence(sequenceID, false, serviceEndpoint);
                SequenceImpl oSequence = this.getSequence(sequenceID, true, serviceEndpoint);
                SequenceImpl sequenceImpl = sequence = iSequence == null ? oSequence : iSequence;
                if (sequence != null) {
                    Provider provider = (Provider)providers.get(((ISequence)sequence).getProviderName());
                    if (provider == null) {
                        log.error("Provider " + ((ISequence)sequence).getProviderName() + "is not registered, the input sequence " + sequenceID + "cannot be stopped!!");
                    }
                    provider.blockSequence(sequence, true);
                    if (iSequence != null) {
                        this.removeSequence(iSequence);
                    }
                    if (oSequence != null) {
                        this.removeSequence(oSequence);
                    }
                    this.unregisterSequenceForProcessing(serviceEndpoint);
                }
                ++i;
            }
        }
        catch (SequenceException e) {
            throw new PublishException(e);
        }
    }

    private final void removeSequence(final ISequence sequence) throws SequenceException {
        this.invocationTemplate(new ISequenceRegistry.Checker(){

            public boolean check() throws SequenceException {
                return !sequence.isExpired();
            }
        }, new ISequenceRegistry.Worker(){

            public Object work() throws SequenceException {
                sequenceCache.remove(sequence);
                sequence.release();
                return null;
            }
        }, null);
    }

    void update(SequenceImpl sequence) throws SequenceException {
        try {
            persistentStore.updateSequence(sequence);
        }
        catch (PersistentStoreException e) {
            throw new SequenceException(e);
        }
    }

    void onMessageConfirmation(ISequence sequence, long messageNumber) throws ResourceOperationException, SequenceException {
        Provider provider = (Provider)providers.get(sequence.getProviderName());
        if (provider != null) {
            provider.onMessageConfirmation(sequence, messageNumber);
        }
    }

    void onSetState(ISequence sequence, Sequence.State previousState, Sequence.State newState, SequenceException exception) throws SequenceException {
        int newStateValue = newState.getValue();
        Iterator listeners = this.getCloneListenersForProcessing(sequence.getProcessing());
        if (listeners != null) {
            block5: while (listeners.hasNext()) {
                SequenceListener sequenceListener = (SequenceListener)listeners.next();
                switch (newStateValue) {
                    case 3: {
                        sequenceListener.onBroken(exception, previousState);
                        break;
                    }
                    case 2: {
                        sequenceListener.onComplete(sequence, previousState);
                        break;
                    }
                    case 1: {
                        sequenceListener.onDelivered(sequence, previousState);
                        break;
                    }
                    default: {
                        break block5;
                    }
                }
            }
        }
    }

    void onBroken(String sequenceId, boolean isOutput) throws SequenceException {
        Iterator it = ((Map)((HashMap)providers).clone()).entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Provider provider = (Provider)entry.getValue();
            provider.onBroken(sequenceId, isOutput);
        }
    }

    private Iterator getCloneListenersForProcessing(Processing processing) {
        ServiceEndpointImpl se;
        if (processing != null && processing instanceof ServiceEndpointImpl && (se = (ServiceEndpointImpl)processing).getType() == 1) {
            processing = (ServiceClient)se.getContext().getContextData().get("async.client");
        }
        return processingHelper.getListenersIteratorClone(processing);
    }

    void onSetExpires(ISequence sequence) throws SequenceException {
        Date date = sequence.getExpires();
        expirationQueue.update(sequence, -date.getTime());
    }

    Provider getProvider(String providerName) {
        if (providerName == null) {
            return null;
        }
        return (Provider)providers.get(providerName);
    }

    private ISequence[] getSequences(final String prefix, final Processing processing, final boolean output) throws SequenceException {
        return (ISequence[])this.invocationTemplate(null, new ISequenceRegistry.Worker(){

            public Object work() throws SequenceException {
                ISequence[] sequences = NO_ISEQUENCE;
                List list = null;
                try {
                    list = persistentStore.findSequences(prefix, output);
                }
                catch (PersistentStoreException e) {
                    throw new SequenceException(e);
                }
                if (list == null || list.size() == 0) {
                    return sequences;
                }
                sequences = new ISequence[list.size()];
                int i = 0;
                while (i < list.size()) {
                    PersistentSequenceStore.SequenceData data = (PersistentSequenceStore.SequenceData)list.get(i);
                    SequenceImpl sequence = new SequenceImpl(data, processing);
                    sequenceCache.put(sequence);
                    sequences[i] = sequence;
                    ++i;
                }
                return sequences;
            }
        }, null);
    }

    private void startExpirationThreadOnce() {
        if (expirationQueue == null) {
            expirationQueue = new SequenceQueueImpl(persistentStore, this, "SequenceExpirationQueue");
            expirationQueue.start();
        }
    }

    protected void expire(final ISequence sequence) throws SequenceException {
        this.expire(sequence.getID(), sequence.isOutput(), new PropagationContext.TransactionListener(){

            public void beforeCompletion(PropagationContext transaction) {
            }

            public void afterCompletion(PropagationContext transaction, int result) {
                if (result == 0) {
                    SequenceRegistryImpl.this.unregisterSequenceForProcessing(sequence.getProcessing());
                }
            }
        });
    }

    protected void expire(String sequenceId, boolean output) throws SequenceException {
        this.expire(sequenceId, output, null);
    }

    private void expire(final String sequenceId, final boolean isOutput, PropagationContext.TransactionListener listener) throws SequenceException {
        this.invocationTemplate(null, new ISequenceRegistry.Worker(){

            public Object work() throws SequenceException {
                SequenceRegistryImpl.this.onBroken(sequenceId, isOutput);
                sequenceCache.remove(sequenceId, isOutput);
                try {
                    persistentStore.removeSequence(sequenceId, isOutput);
                }
                catch (PersistentStoreException e) {
                    throw new SequenceException(e);
                }
                return null;
            }
        }, listener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Sequence.MessageState getMessageState(ISequence sequence, long messageNumber) throws SequenceException {
        Sequence.MessageState messageState;
        sequence.lock();
        try {
            try {
                String providerName = sequence.getProviderName();
                if (providerName == null) {
                    Sequence.MessageState messageState2 = Sequence.MessageState.NOT_PRESENT;
                    Object var8_8 = null;
                    sequence.unlock();
                    return messageState2;
                }
                Provider provider = (Provider)providers.get(providerName);
                messageState = provider.getMessageState(sequence, messageNumber);
            }
            catch (ResourceOperationException e) {
                throw new SequenceException(e);
            }
            catch (CompletionException e) {
                throw new SequenceException(e);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            sequence.unlock();
            throw throwable;
        }
        Object var8_9 = null;
        sequence.unlock();
        return messageState;
    }

    public Object invocationTemplate(ISequenceRegistry.Checker checker, ISequenceRegistry.Worker worker, PropagationContext.TransactionListener listener) throws SequenceException {
        try {
            return Template.invoke(sequenceCache, (Checker)checker, (Worker)worker, listener);
        }
        catch (SequenceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SequenceException(e);
        }
    }

    public Object invocationTemplate(ISequenceRegistry.Worker worker, PropagationContext.TransactionListener listener) throws SequenceException {
        return this.invocationTemplate(null, worker, listener);
    }

    public Object invocationTemplate(ISequenceRegistry.Worker worker) throws SequenceException {
        return this.invocationTemplate(null, worker, null);
    }

    public Object invocationTemplate(Invoker invoker, PropagationContext.TransactionListener listener) throws SequenceException {
        return this.invocationTemplate(invoker, invoker, listener);
    }

    public Object invocationTemplate(Invoker invoker) throws SequenceException {
        return this.invocationTemplate(invoker, invoker, null);
    }

    public void addSequenceListener(SequenceListener listener, Processing processing) {
        processingHelper.addSequenceListener(listener, processing);
    }

    public void removeSequenceListener(SequenceListener listener, Processing processing) {
        processingHelper.removeSequenceListener(listener, processing);
    }

    public Processing getProcessing(long processingID) {
        return processingHelper.getProcessing(processingID);
    }

    public long registerSequenceForProcessing(Processing processing) throws SequenceException {
        return processingHelper.registerSequenceForProcessing(processing);
    }

    public void unregisterSequenceForProcessing(Processing processing) {
        processingHelper.unregisterSequenceForProcessing(processing);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        sequenceCache = new SequenceCache();
        NO_ISEQUENCE = new ISequence[0];
        processingHelper = new ProcessingHelper();
    }

    private static class ProcessingHelper {
        private static final Map processingIDToProcessing = new HashMap();
        private static final Map processingToProcessingInfo = new HashMap();
        private static final Map sequenceListeners = new WeakHashMap();

        private ProcessingHelper() {
        }

        synchronized Processing getProcessing(long processingID) {
            Processing returnValue = (Processing)processingIDToProcessing.get(new Long(processingID));
            return returnValue;
        }

        synchronized long registerSequenceForProcessing(Processing processing) throws SequenceException {
            if (processing == null) {
                throw new SequenceException("Processing is null!!");
            }
            ProcessingInfo processingInfo = (ProcessingInfo)processingToProcessingInfo.get(processing);
            if (processingInfo == null) {
                processingInfo = new ProcessingInfo();
                processingToProcessingInfo.put(processing, processingInfo);
                processingIDToProcessing.put(new Long(processingInfo.getId()), processing);
            }
            processingInfo.registerSequence();
            return processingInfo.getId();
        }

        synchronized void unregisterSequenceForProcessing(Processing processing) {
            ProcessingInfo processingInfo = (ProcessingInfo)processingToProcessingInfo.get(processing);
            long sequences = processingInfo.unregisterSequence();
            if (sequences == 0L) {
                processingToProcessingInfo.remove(processing);
                processingIDToProcessing.remove(new Long(processingInfo.getId()));
            }
        }

        synchronized void addSequenceListener(SequenceListener listener, Processing processing) {
            Map map = sequenceListeners;
            synchronized (map) {
                LinkedList<SequenceListener> list = (LinkedList<SequenceListener>)sequenceListeners.get(processing);
                if (list == null) {
                    list = new LinkedList<SequenceListener>();
                    sequenceListeners.put(processing, list);
                }
                if (!list.contains(listener)) {
                    list.add(listener);
                }
            }
        }

        synchronized void removeSequenceListener(SequenceListener listener, Processing processing) {
            List listeners = (List)sequenceListeners.get(processing);
            if (listeners != null) {
                listeners.remove(listener);
                if (listeners.isEmpty()) {
                    sequenceListeners.remove(processing);
                }
            }
        }

        synchronized Iterator getListenersIteratorClone(Processing processing) {
            LinkedList original = (LinkedList)sequenceListeners.get(processing);
            return original == null ? null : ((List)original.clone()).iterator();
        }

        synchronized void clear() {
            processingIDToProcessing.clear();
            processingToProcessingInfo.clear();
            sequenceListeners.clear();
        }

        private static class ProcessingInfo {
            private long id = topOfIDs++;
            private long sequences = 0L;
            private static volatile long topOfIDs = 0L;

            public long getId() {
                return this.id;
            }

            public long getSequences() {
                return this.sequences;
            }

            public long registerSequence() {
                return ++this.sequences;
            }

            public long unregisterSequence() {
                return --this.sequences;
            }

            public String toString() {
                return "ProcessingInfo, id: " + this.id + " registered for " + this.sequences + " sequences";
            }
        }
    }

    private static interface Invoker
    extends ISequenceRegistry.Checker,
    ISequenceRegistry.Worker {
    }
}

