/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.sequence;

import com.idoox.debug.Category;
import com.systinet.util.Condition;
import com.systinet.util.ReentrantLock;
import com.systinet.util.ReentrantThreadLockImpl;
import com.systinet.wasp.sequence.SequenceRegistryImpl;
import org.systinet.wasp.sequence.ISequence;
import org.systinet.wasp.sequence.ISequenceRegistry;
import org.systinet.wasp.sequence.PersistentSequenceStore;
import org.systinet.wasp.sequence.PersistentStoreException;
import org.systinet.wasp.sequence.Sequence;
import org.systinet.wasp.sequence.SequenceException;
import org.systinet.wasp.sequence.SequenceQueue;
import org.systinet.wasp.transaction.LockableResource;
import org.systinet.wasp.transaction.Template;
import org.systinet.wasp.transaction.Worker;

public class SequenceQueueImpl
extends Thread
implements SequenceQueue {
    protected static final Category log = Category.getCategory((class$com$systinet$wasp$sequence$SequenceQueueImpl == null ? (class$com$systinet$wasp$sequence$SequenceQueueImpl = SequenceQueueImpl.class$("com.systinet.wasp.sequence.SequenceQueueImpl")) : class$com$systinet$wasp$sequence$SequenceQueueImpl).getName());
    private final ISequenceRegistry sequenceRegistry;
    private final PersistentSequenceStore store;
    private final String queueID;
    private long maxPriority = Long.MIN_VALUE;
    private static final LockableResource resource = new LockableResource(){
        private ReentrantLock lock = new ReentrantThreadLockImpl("queue");

        public void lock() {
            this.lock.lock();
        }

        public void unlock() {
            this.lock.unlock();
        }

        public void begin() {
        }

        public void commit() {
        }

        public void rollback() {
        }
    };
    private final ReentrantLock lock;
    private final Condition cond;
    long maxPriorityClone;
    static /* synthetic */ Class class$com$systinet$wasp$sequence$SequenceQueueImpl;

    public static final LockableResource getResource() {
        return resource;
    }

    public SequenceQueueImpl(PersistentSequenceStore store, ISequenceRegistry sequenceRegistry, String queueID) {
        this.store = store;
        this.sequenceRegistry = sequenceRegistry;
        this.setName(queueID);
        this.setDaemon(true);
        this.queueID = queueID;
        this.lock = new ReentrantThreadLockImpl(queueID);
        this.cond = this.lock.newCondition();
    }

    public void insert(final Sequence sequence, final long priority) throws SequenceException {
        try {
            Template.invoke(new LockableResource[]{resource, this}, null, new Worker(){

                public Object work() throws PersistentStoreException {
                    SequenceQueueImpl.this.store.enqueueSequence(sequence.getID(), sequence.isOutput(), SequenceQueueImpl.this.queueID, priority);
                    if (priority >= SequenceQueueImpl.this.maxPriority) {
                        SequenceQueueImpl.this.maxPriority = priority;
                        SequenceQueueImpl.this.signal();
                    }
                    return null;
                }
            }, null);
        }
        catch (SequenceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SequenceException("Error putting sequence " + sequence + " to the " + this.queueID, e);
        }
    }

    public void update(final Sequence sequence, final long priority) throws SequenceException {
        try {
            Template.invoke(new LockableResource[]{resource, this}, null, new Worker(){

                public Object work() throws PersistentStoreException {
                    SequenceQueueImpl.this.store.updateSequence(sequence.getID(), sequence.isOutput(), SequenceQueueImpl.this.queueID, priority);
                    if (priority >= SequenceQueueImpl.this.maxPriority) {
                        SequenceQueueImpl.this.maxPriority = priority;
                        SequenceQueueImpl.this.signal();
                    }
                    return null;
                }
            }, null);
        }
        catch (SequenceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SequenceException("Error putting sequence " + sequence + " to the " + this.queueID, e);
        }
    }

    private PersistentSequenceStore.QueueRecord get() throws Exception {
        while (true) {
            Object var5_3;
            long delay;
            PersistentSequenceStore.QueueRecord record;
            if ((record = (PersistentSequenceStore.QueueRecord)Template.invoke(resource, null, new Worker(){

                public Object work() throws PersistentStoreException {
                    return SequenceQueueImpl.this.store.getFirstSequence(SequenceQueueImpl.this.queueID);
                }
            }, null)) != null) {
                delay = -record.getPriority() - System.currentTimeMillis();
                if (delay <= 0L) {
                    return record;
                }
            } else {
                delay = 0L;
            }
            this.lock();
            try {
                this.await(delay);
                var5_3 = null;
                this.unlock();
            }
            catch (Throwable throwable) {
                var5_3 = null;
                this.unlock();
                throw throwable;
            }
        }
    }

    public void remove(final String sequenceId, final boolean isOutput) throws SequenceException {
        try {
            Template.invoke(resource, null, new Worker(){

                public Object work() throws PersistentStoreException {
                    SequenceQueueImpl.this.maxPriority = Long.MIN_VALUE;
                    SequenceQueueImpl.this.store.removeSequence(sequenceId, isOutput, SequenceQueueImpl.this.queueID);
                    return null;
                }
            }, null);
        }
        catch (SequenceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SequenceException("Error removing " + (isOutput ? "out" : "in") + "put sequence " + sequenceId + " from the " + this.queueID, e);
        }
    }

    public void run() {
        try {
            while (true) {
                PersistentSequenceStore.QueueRecord sequenceToExpire = null;
                try {
                    sequenceToExpire = this.get();
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    log.warn("exception while getting sequence from the " + this.queueID + " queue", e);
                    Thread.sleep(1000L);
                    sequenceToExpire = null;
                }
                final String sequenceId = sequenceToExpire.getID();
                final boolean output = sequenceToExpire.isOutput();
                try {
                    this.sequenceRegistry.invocationTemplate(null, new ISequenceRegistry.Worker(){

                        public Object work() throws SequenceException {
                            Template.registerNewResource(resource);
                            ISequence sequence = SequenceQueueImpl.this.sequenceRegistry.getSequence(sequenceId, output);
                            SequenceQueueImpl.this.remove(sequenceId, output);
                            sequence.expire();
                            return null;
                        }
                    }, null);
                }
                catch (SequenceException e) {
                    log.debug("An exception when expiring the " + (output ? "out" : "in") + "put sequence " + sequenceId + ".", e);
                    try {
                        this.remove(sequenceId, output);
                        ((SequenceRegistryImpl)this.sequenceRegistry).expire(sequenceId, output);
                    }
                    catch (SequenceException ex) {
                        log.warn("An exception when expiring the " + (output ? "out" : "in") + "put sequence " + sequenceId + ".", e);
                    }
                }
            }
        }
        catch (InterruptedException e) {
            log.error("The sequence expiration thread has been interrupted", e);
            return;
        }
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    private void signal() {
        this.cond.signal();
    }

    private void await(long timeout) throws InterruptedException {
        this.cond.await(timeout);
    }

    public void begin() {
        this.maxPriorityClone = this.maxPriority;
    }

    public void commit() {
    }

    public void rollback() {
        this.maxPriority = this.maxPriorityClone;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

