/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.sequence;

import com.idoox.debug.Category;
import com.systinet.util.ReentrantLock;
import com.systinet.util.ReentrantThreadLockImpl;
import com.systinet.wasp.sequence.SequenceQueueImpl;
import com.systinet.wasp.sequence.SequenceRegistryImpl;
import java.util.Date;
import java.util.Map;
import org.systinet.wasp.sequence.ISequence;
import org.systinet.wasp.sequence.PersistentSequenceStore;
import org.systinet.wasp.sequence.Provider;
import org.systinet.wasp.sequence.Sequence;
import org.systinet.wasp.sequence.SequenceException;
import org.systinet.wasp.sequence.SequenceProviderData;
import org.systinet.wasp.transaction.CompletionException;
import org.systinet.wasp.transaction.LockableResource;
import org.systinet.wasp.transaction.PropagationContext;
import org.systinet.wasp.transaction.ResourceOperationException;
import org.systinet.wasp.transaction.Template;
import org.systinet.wasp.webservice.CallContext;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.Processing;
import org.systinet.wasp.webservice.ServiceClient;
import org.systinet.wasp.webservice.ServiceEndpoint;

public class SequenceImpl
extends ISequence
implements LockableResource {
    protected static final Category log = Category.getCategory((class$com$systinet$wasp$sequence$SequenceImpl == null ? (class$com$systinet$wasp$sequence$SequenceImpl = SequenceImpl.class$("com.systinet.wasp.sequence.SequenceImpl")) : class$com$systinet$wasp$sequence$SequenceImpl).getName());
    public static final int UNKNOWN = -1;
    private final String id;
    private final boolean output;
    private final String endpointPath;
    private long processingId;
    private final Processing processing;
    private String providerName;
    private Sequence.State state;
    private Date expires = new Date(System.currentTimeMillis() + 31536000000L);
    private boolean expired = false;
    private boolean explicitConfirmation = false;
    private long length = -1L;
    private long currentLength = 0L;
    private boolean lastMessage;
    private final SequenceProviderData providerMetadata;
    Sequence.State stateClone;
    Date expiresClone;
    boolean expiredClone;
    boolean explicitConfirmationClone;
    long lengthClone;
    long currentLengthClone;
    boolean lastMessageClone;
    long processingIdClone;
    String providerNameClone;
    private boolean active = false;
    private Object cacheKeyReference;
    private final InheritableThreadLocal currentMessageNumber = new InheritableThreadLocal();
    protected static SequenceRegistryImpl registry;
    private final ExpirationBrokenChecker expirationBrokenChecker = new ExpirationBrokenChecker();
    private final ReentrantLock lock;
    static /* synthetic */ Class class$com$systinet$wasp$sequence$SequenceImpl;

    public SequenceImpl(String id, boolean output, Processing processing) throws SequenceException {
        this.id = id;
        this.output = output;
        this.lock = new ReentrantThreadLockImpl("sequence " + (output ? "out" : "in") + "put " + id);
        this.endpointPath = processing instanceof ServiceEndpoint ? ((ServiceEndpoint)processing).getPath() : null;
        this.processingId = registry.registerSequenceForProcessing(processing);
        this.processing = processing;
        this.providerMetadata = new SequenceProviderData();
        this.state = output ? Sequence.State.DELIVERED : Sequence.State.OPEN;
    }

    public SequenceImpl(PersistentSequenceStore.SequenceData data, Processing processing) throws SequenceException {
        this.id = data.getIdPK();
        this.output = data.isOutputPK();
        this.lock = new ReentrantThreadLockImpl("sequence " + (this.output ? "out" : "in") + "put " + this.id);
        this.endpointPath = data.getEndpointPath();
        this.providerName = data.getProviderName();
        this.state = Sequence.State.fromValue(data.getState());
        this.expires = new Date(data.getExpires());
        this.expired = data.isExpired();
        this.explicitConfirmation = data.isExplicitConfirmation();
        this.length = data.getLength();
        this.currentLength = data.getCurrentLength();
        this.lastMessage = data.isLastMessage();
        this.providerMetadata = (SequenceProviderData)data.getProviderMetadata();
        long processingId = data.getProcessingId();
        if (processingId == -1L) {
            this.processing = processing;
            this.processingId = registry.registerSequenceForProcessing(processing);
            Provider provider = registry.getProvider(this.providerName);
            if (provider != null) {
                provider.blockSequence(this, false);
            }
            this.update();
        } else {
            this.processingId = processingId;
            this.processing = registry.getProcessing(this.processingId);
        }
    }

    protected static void setRegistry(SequenceRegistryImpl registry) {
        SequenceImpl.registry = registry;
    }

    public void release() throws SequenceException {
        this.invocationTemplate(null, new Worker(){

            public Object work() throws SequenceException {
                SequenceImpl.this.processingId = -1L;
                return null;
            }
        }, new PropagationContext.TransactionListener(){

            public void beforeCompletion(PropagationContext transaction) throws CompletionException {
                try {
                    SequenceImpl.this.update();
                }
                catch (SequenceException e) {
                    throw new CompletionException(e);
                }
            }

            public void afterCompletion(PropagationContext transaction, int result) {
            }
        });
    }

    public String getProviderName() {
        this.lock();
        try {
            String string = this.providerName;
            Object var3_2 = null;
            this.unlock();
            return string;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    public void setProviderName(final String providerName) throws SequenceException {
        this.invocationTemplate(new ExpirationBrokenChecker("provider name"), new Worker(){

            public Object work() {
                SequenceImpl.this.providerName = providerName;
                return null;
            }
        }, null);
    }

    public Processing getProcessing() {
        return this.processing;
    }

    public SequenceProviderData getProviderData() {
        return this.providerMetadata;
    }

    public Sequence.State getState() {
        this.lock();
        try {
            Sequence.State state = this.state;
            Object var3_2 = null;
            this.unlock();
            return state;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    public void setState(Sequence.State state) throws SequenceException {
        this.setState(state, null);
    }

    private void setState(final Sequence.State newState, final SequenceException exception) throws SequenceException {
        Checker checker = new Checker(){

            public boolean check() throws SequenceException {
                if (SequenceImpl.this.expired) {
                    throw new SequenceException("Can't set state on expired sequence");
                }
                return !newState.equals(SequenceImpl.this.getState());
            }
        };
        this.invocationTemplate(!newState.equals(Sequence.State.BROKEN) ? new ExpirationBrokenChecker("state", checker) : checker, new Worker(){

            public Object work() throws SequenceException {
                if (!SequenceImpl.this.state.equals(Sequence.State.BROKEN) && newState.equals(Sequence.State.BROKEN)) {
                    registry.onBroken(SequenceImpl.this.id, SequenceImpl.this.output);
                }
                SequenceImpl.this.state = newState;
                return null;
            }
        }, new PropagationContext.TransactionListener(){
            final Sequence.State previousState;
            {
                this.previousState = SequenceImpl.this.getState();
            }

            public void beforeCompletion(PropagationContext transaction) {
            }

            public void afterCompletion(PropagationContext transaction, int result) {
                if (result == 0) {
                    try {
                        registry.onSetState(SequenceImpl.this, this.previousState, newState, exception);
                    }
                    catch (SequenceException e) {
                        log.warn("exception while invoking sequence listeners", e);
                    }
                }
            }
        });
    }

    public String getID() {
        return this.id;
    }

    public boolean isActive() {
        this.lock();
        try {
            boolean bl = this.active;
            Object var3_2 = null;
            this.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    public void setActive(boolean active) throws SequenceException {
        this.lock();
        try {
            Map contextData;
            this.expirationBrokenChecker.check();
            if (this.processing instanceof ServiceClient) {
                contextData = ((ServiceClient)this.processing).getContext().getContextData();
            } else {
                CallContext callContext = Current.getCallContext();
                if (callContext == null) {
                    Object var6_4 = null;
                    this.unlock();
                    return;
                }
                contextData = callContext.getContextData();
            }
            if (this.output) {
                ThreadLocal<SequenceImpl> tl = (ThreadLocal<SequenceImpl>)contextData.get("sequence.output");
                if (tl == null) {
                    if (active) {
                        tl = new ThreadLocal<SequenceImpl>();
                        contextData.put("sequence.output", tl);
                        tl.set(this);
                    }
                } else {
                    SequenceImpl sequenceToInactivate = (SequenceImpl)tl.get();
                    if (sequenceToInactivate != null) {
                        sequenceToInactivate.lock();
                        sequenceToInactivate.active = false;
                        tl.set(active ? this : null);
                        sequenceToInactivate.unlock();
                    } else {
                        tl.set(active ? this : null);
                    }
                }
                ISequence.setActiveOutputSequence(active ? this : null, contextData);
            } else if (active) {
                SequenceImpl sequenceToInactivate = (SequenceImpl)contextData.get("sequence.input");
                if (sequenceToInactivate != null) {
                    sequenceToInactivate.lock();
                    sequenceToInactivate.active = false;
                    contextData.put("sequence.input", this);
                    sequenceToInactivate.unlock();
                } else {
                    contextData.put("sequence.input", this);
                }
            } else {
                contextData.remove("sequence.input");
            }
            this.active = active;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.unlock();
            throw throwable;
        }
        Object var6_5 = null;
        this.unlock();
    }

    public void abort() throws SequenceException {
        this.setState(Sequence.State.BROKEN, new SequenceException("Sequence aborted.", (Sequence)this));
    }

    public Date getExpires() {
        this.lock();
        try {
            Date date = this.expires;
            Object var3_2 = null;
            this.unlock();
            return date;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    public void setExpires(final Date expires) throws SequenceException {
        try {
            Template.invoke(new LockableResource[]{SequenceQueueImpl.getResource(), this}, (org.systinet.wasp.transaction.Checker)new ExpirationBrokenChecker("expires"), (org.systinet.wasp.transaction.Worker)new Worker(){

                public Object work() throws SequenceException {
                    SequenceImpl.this.expires = expires;
                    registry.onSetExpires(SequenceImpl.this);
                    return null;
                }
            }, new PropagationContext.TransactionListener(){

                public void beforeCompletion(PropagationContext transaction) throws CompletionException {
                    try {
                        SequenceImpl.this.update();
                    }
                    catch (SequenceException e) {
                        throw new CompletionException(e);
                    }
                }

                public void afterCompletion(PropagationContext transaction, int result) {
                }
            });
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (SequenceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SequenceException(e);
        }
    }

    public void expire() throws SequenceException {
        final StateHolder stateHolder = new StateHolder();
        this.invocationTemplate(new Checker(){

            public boolean check() {
                return !SequenceImpl.this.expired;
            }
        }, new Worker(){

            public Object work() throws SequenceException {
                stateHolder.setState(SequenceImpl.this.state);
                SequenceImpl.this.state = Sequence.State.BROKEN;
                SequenceImpl.this.expired = true;
                registry.expire(SequenceImpl.this);
                return null;
            }
        }, new PropagationContext.TransactionListener(){

            public void beforeCompletion(PropagationContext transaction) {
            }

            public void afterCompletion(PropagationContext transaction, int result) {
                Sequence.State previousState = stateHolder.getState();
                if (result == 0) {
                    try {
                        registry.onSetState(SequenceImpl.this, previousState, Sequence.State.BROKEN, new SequenceException("Sequence expired in " + previousState + " state.", (Sequence)SequenceImpl.this));
                    }
                    catch (SequenceException e) {
                        log.warn("exception while expiring sequence", e);
                    }
                }
            }
        });
    }

    public boolean isExpired() {
        this.lock();
        try {
            boolean bl = this.expired;
            Object var3_2 = null;
            this.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    public long getLength() {
        this.lock();
        try {
            long l = this.length;
            Object var4_2 = null;
            this.unlock();
            return l;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    public void setCurrentLength(final long currentLength) throws SequenceException {
        this.invocationTemplate(new ExpirationBrokenChecker("current length"), new Worker(){

            public Object work() {
                SequenceImpl.this.currentLength = currentLength;
                return null;
            }
        }, null);
    }

    public long getCurrentLength() {
        this.lock();
        try {
            long l = this.currentLength;
            Object var4_2 = null;
            this.unlock();
            return l;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    public void setLength(final long length) throws SequenceException {
        this.invocationTemplate(new ExpirationBrokenChecker("length", new Checker(){

            public boolean check() throws SequenceException {
                if (SequenceImpl.this.length != -1L && SequenceImpl.this.length != length) {
                    throw new SequenceException("Can not change sequence length from " + SequenceImpl.this.length + " to " + length);
                }
                return true;
            }
        }), new Worker(){

            public Object work() {
                SequenceImpl.this.length = length;
                return null;
            }
        }, null);
    }

    public void setLastMessage() throws SequenceException {
        this.invocationTemplate(new ExpirationBrokenChecker("last message", new Checker(){

            public boolean check() throws SequenceException {
                if (SequenceImpl.this.lastMessage) {
                    throw new SequenceException("Last message has been already set!!");
                }
                return true;
            }
        }), new Worker(){

            public Object work() {
                SequenceImpl.this.lastMessage = true;
                return null;
            }
        }, null);
    }

    public boolean isLastMessage() {
        this.lock();
        try {
            boolean bl = this.lastMessage;
            Object var3_2 = null;
            this.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    public Sequence.MessageState getMessageState(final long messageNumber) throws SequenceException {
        return (Sequence.MessageState)this.invocationTemplate(new ExpirationChecker(), new Worker(){

            public Object work() throws SequenceException {
                if (SequenceImpl.this.state == Sequence.State.COMPLETE) {
                    return messageNumber >= 1L && messageNumber <= SequenceImpl.this.length ? Sequence.MessageState.DELIVERED : Sequence.MessageState.NOT_PRESENT;
                }
                return registry.getMessageState(SequenceImpl.this, messageNumber);
            }
        }, null);
    }

    public boolean isOutput() {
        return this.output;
    }

    public long getCurrentMessageNumber() {
        Long value = (Long)this.currentMessageNumber.get();
        return value == null ? -1L : value;
    }

    public void setCurrentMessageNumber(long currentMessageNumber) throws SequenceException {
        this.expirationBrokenChecker.check("current message number");
        Long value = (Long)this.currentMessageNumber.get();
        if (value == null || value != currentMessageNumber) {
            this.currentMessageNumber.set(new Long(currentMessageNumber));
        }
    }

    public void setExplicitConfirmation(final boolean explicitConfirmation) throws SequenceException {
        this.invocationTemplate(new ExpirationBrokenChecker("explicit confirmation", new Checker(){

            public boolean check() throws SequenceException {
                if (SequenceImpl.this.output && explicitConfirmation) {
                    throw new SequenceException("Can not enable explicit confirmation on an output sequence " + SequenceImpl.this.id);
                }
                return true;
            }
        }), new Worker(){

            public Object work() {
                SequenceImpl.this.explicitConfirmation = explicitConfirmation;
                return null;
            }
        }, null);
    }

    public boolean isExplicitConfirmation() {
        this.lock();
        try {
            boolean bl = this.explicitConfirmation;
            Object var3_2 = null;
            this.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    public String getEndpointPath() {
        return this.endpointPath;
    }

    public long getProcessingId() {
        return this.processingId;
    }

    public void confirmMessage(final long messageNumber) throws SequenceException {
        this.invocationTemplate(new ExpirationBrokenChecker("explicit confirmation", new Checker(){

            public boolean check() throws SequenceException {
                if (SequenceImpl.this.output) {
                    throw new SequenceException("Can not confirm message in output sequence!");
                }
                return true;
            }
        }), new Worker(){

            public Object work() throws SequenceException {
                try {
                    registry.onMessageConfirmation(SequenceImpl.this, messageNumber);
                }
                catch (ResourceOperationException e) {
                    throw new SequenceException(e);
                }
                return null;
            }
        }, null);
    }

    public void confirmCurrentMessage() throws SequenceException {
        this.confirmMessage(this.getCurrentMessageNumber());
    }

    private void update() throws SequenceException {
        Sequence.State state = this.getState();
        if (!this.isExpired() && state != Sequence.State.BROKEN && state != Sequence.State.DESTROYED) {
            registry.update(this);
        }
    }

    public void setPersistent(boolean persistent) {
    }

    public boolean isPersistent() {
        return true;
    }

    public void setCacheKeyReference(Object cacheKeyReference) {
        this.cacheKeyReference = cacheKeyReference;
    }

    public String toString() {
        Long msgNumber;
        StringBuffer sb = new StringBuffer();
        sb.append(this.output ? "output" : "input");
        sb.append(" sequence(id=\"");
        sb.append(this.id);
        sb.append("\",provider=\"");
        sb.append(this.providerName == null ? "<unknown>" : this.providerName);
        sb.append("\",processing=\"");
        if (this.processing instanceof ServiceClient) {
            sb.append("client:WSDL=\"");
            sb.append(((ServiceClient)this.processing).getWSDLLocation());
            sb.append("\"");
        } else if (this.processing instanceof ServiceEndpoint) {
            sb.append("endpoint:path=\"");
            sb.append(((ServiceEndpoint)this.processing).getPath());
            sb.append("\"");
        } else {
            sb.append("<unknown>");
        }
        sb.append(",processingId=");
        sb.append(this.processingId);
        sb.append("\",state=");
        sb.append(this.state);
        sb.append(',');
        if (!this.active) {
            sb.append("in");
        }
        sb.append("active,");
        if (this.expired) {
            sb.append("expired,");
        }
        if (this.expires != null) {
            sb.append("expires=");
            sb.append(this.expires);
            sb.append(',');
        }
        if ((msgNumber = (Long)this.currentMessageNumber.get()) != null) {
            sb.append("currentMessageNumber=");
            sb.append(msgNumber);
            sb.append(',');
        }
        sb.append("length=");
        sb.append(this.length == -1L ? "<unknown>" : Long.toString(this.length));
        sb.append(",currentLength=");
        sb.append(this.currentLength);
        if (this.explicitConfirmation) {
            sb.append(",explicit confirmation on");
        }
        sb.append(')');
        return sb.toString();
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public void unlock(int level) {
        this.lock.unlock(level);
    }

    public Object invocationTemplate(Checker checker, Worker worker, final PropagationContext.TransactionListener listener) throws SequenceException {
        PropagationContext.TransactionListener storeListener = new PropagationContext.TransactionListener(){

            public void beforeCompletion(PropagationContext transaction) throws CompletionException {
                try {
                    SequenceImpl.this.update();
                }
                catch (SequenceException e) {
                    throw new CompletionException(e);
                }
                if (listener != null) {
                    listener.beforeCompletion(transaction);
                }
            }

            public void afterCompletion(PropagationContext transaction, int result) {
                if (listener != null) {
                    listener.afterCompletion(transaction, result);
                }
            }
        };
        try {
            return Template.invoke(this, (org.systinet.wasp.transaction.Checker)checker, (org.systinet.wasp.transaction.Worker)worker, storeListener);
        }
        catch (SequenceException e) {
            throw e;
        }
        catch (CompletionException e) {
            throw new SequenceException(e);
        }
        catch (ResourceOperationException e) {
            throw new SequenceException(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            log.error("Should never happen ", e);
            e.printStackTrace();
            return null;
        }
    }

    public void begin() {
        this.processingIdClone = this.processingId;
        this.providerNameClone = this.providerName;
        this.stateClone = this.state;
        this.expiresClone = this.expires;
        this.expiredClone = this.expired;
        this.explicitConfirmationClone = this.explicitConfirmation;
        this.lengthClone = this.length;
        this.currentLengthClone = this.currentLength;
        this.lastMessageClone = this.lastMessage;
        this.providerMetadata.begin();
    }

    public void commit() {
        this.providerMetadata.commit();
    }

    public void rollback() {
        this.processingIdClone = this.processingId;
        this.providerNameClone = this.providerName;
        this.state = this.stateClone;
        this.expires = this.expiresClone;
        this.expired = this.expiredClone;
        this.explicitConfirmation = this.explicitConfirmationClone;
        this.length = this.lengthClone;
        this.currentLength = this.currentLengthClone;
        this.lastMessage = this.lastMessageClone;
        this.providerMetadata.rollback();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ExpirationBrokenChecker
    implements Checker {
        private final ExpirationChecker inner;

        public ExpirationBrokenChecker() {
            this(null);
        }

        public ExpirationBrokenChecker(String what) {
            this(what, null);
        }

        public ExpirationBrokenChecker(String what, Checker inner) {
            this.inner = new ExpirationChecker(what, new BrokenChecker(what, inner));
        }

        public boolean check() throws SequenceException {
            return this.inner.check();
        }

        public boolean check(String what) throws SequenceException {
            return this.inner.check(what);
        }
    }

    private class ExpirationChecker
    implements Checker {
        private final String what;
        private final Checker inner;

        public ExpirationChecker() {
            this(null, null);
        }

        public ExpirationChecker(String what) {
            this(what, null);
        }

        public ExpirationChecker(String what, Checker inner) {
            this.what = what;
            this.inner = inner;
        }

        public boolean check() throws SequenceException {
            return this.check(this.what);
        }

        public boolean check(String what) throws SequenceException {
            if (SequenceImpl.this.expired) {
                throw new SequenceException("Can not change/get " + what + " on already expired sequence!");
            }
            if (this.inner != null) {
                return this.inner.check();
            }
            return true;
        }
    }

    private class BrokenChecker
    implements Checker {
        private final String what;
        private final Checker inner;

        public BrokenChecker(String what) {
            this(what, null);
        }

        public BrokenChecker(String what, Checker inner) {
            this.what = what;
            this.inner = inner;
        }

        public boolean check() throws SequenceException {
            if (SequenceImpl.this.state == Sequence.State.BROKEN || SequenceImpl.this.state == Sequence.State.DESTROYED) {
                throw new SequenceException("Can not change " + this.what + " on " + SequenceImpl.this.state + " sequence!");
            }
            if (this.inner != null) {
                return this.inner.check();
            }
            return true;
        }
    }

    public static interface Worker
    extends org.systinet.wasp.transaction.Worker {
        public Object work() throws SequenceException;
    }

    public static interface Checker
    extends org.systinet.wasp.transaction.Checker {
        public boolean check() throws SequenceException;
    }

    private static class StateHolder {
        private Sequence.State state;

        private StateHolder() {
        }

        public Sequence.State getState() {
            return this.state;
        }

        public void setState(Sequence.State state) {
            this.state = state;
        }
    }
}

