/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.sequence;

import com.idoox.debug.Category;
import com.systinet.util.ReentrantLock;
import com.systinet.util.ReentrantThreadLockImpl;
import com.systinet.wasp.sequence.SequenceImpl;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.systinet.wasp.sequence.ISequence;
import org.systinet.wasp.sequence.Sequence;
import org.systinet.wasp.transaction.LockableResource;

public class SequenceCache
implements LockableResource {
    protected static final Category log = Category.getCategory((class$com$systinet$wasp$sequence$SequenceCache == null ? (class$com$systinet$wasp$sequence$SequenceCache = SequenceCache.class$("com.systinet.wasp.sequence.SequenceCache")) : class$com$systinet$wasp$sequence$SequenceCache).getName());
    private final Map cache = new WeakHashMap();
    private final ReentrantLock lock = new ReentrantThreadLockImpl("sequence cache");
    private boolean inTransaction;
    private final Map tempCache = new HashMap();
    private final List tempRemoved = new LinkedList();
    static /* synthetic */ Class class$com$systinet$wasp$sequence$SequenceCache;

    public static final Object createKey(String id, boolean output) {
        return (output ? "1" : "0") + id;
    }

    public static final Object createKey(Sequence sequence) {
        return SequenceCache.createKey(sequence.getID(), sequence.isOutput());
    }

    public void put(SequenceImpl sequence) {
        this.put(SequenceCache.createKey(sequence), sequence);
    }

    private void put(Object key, SequenceImpl sequence) {
        try {
            this.lock();
            SequenceImpl cachedSequence = null;
            if (this.inTransaction) {
                if (!this.tempRemoved.contains(key)) {
                    cachedSequence = (SequenceImpl)this.tempCache.get(key);
                }
            } else {
                SoftReference ref = (SoftReference)this.cache.get(key);
                if (ref != null) {
                    cachedSequence = (SequenceImpl)ref.get();
                }
            }
            if (cachedSequence != null) {
                if (cachedSequence == sequence) {
                    Object var6_5 = null;
                    this.unlock();
                    return;
                }
                cachedSequence.setCacheKeyReference(null);
            }
            if (this.inTransaction) {
                if (this.tempRemoved.contains(key)) {
                    this.tempRemoved.remove(key);
                }
                this.tempCache.put(key, sequence);
            } else {
                sequence.setCacheKeyReference(key);
                this.cache.put(key, new SoftReference<SequenceImpl>(sequence));
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.unlock();
            throw throwable;
        }
        Object var6_6 = null;
        this.unlock();
    }

    public SequenceImpl get(String id, boolean output) {
        return this.get(SequenceCache.createKey(id, output));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SequenceImpl get(Object key) {
        SequenceImpl sequenceImpl;
        block8: {
            block7: {
                SequenceImpl sequenceImpl2;
                block6: {
                    try {
                        SoftReference ref;
                        this.lock();
                        if (this.inTransaction) {
                            if (this.tempRemoved.contains(key)) {
                                SequenceImpl sequenceImpl3 = null;
                                Object var6_4 = null;
                                this.unlock();
                                return sequenceImpl3;
                            }
                            SequenceImpl ret = (SequenceImpl)this.tempCache.get(key);
                            if (ret != null) {
                                sequenceImpl2 = ret;
                                break block6;
                            }
                        }
                        if ((ref = (SoftReference)this.cache.get(key)) != null) {
                            sequenceImpl = (SequenceImpl)ref.get();
                            break block7;
                        }
                        sequenceImpl = null;
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        this.unlock();
                        throw throwable;
                    }
                }
                Object var6_5 = null;
                this.unlock();
                return sequenceImpl2;
            }
            Object var6_6 = null;
            this.unlock();
            return sequenceImpl;
        }
        Object var6_7 = null;
        this.unlock();
        return sequenceImpl;
    }

    public SequenceImpl remove(String sequenceId, boolean output) {
        return this.remove(SequenceCache.createKey(sequenceId, output));
    }

    public SequenceImpl remove(ISequence sequence) {
        return this.remove(SequenceCache.createKey(sequence));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SequenceImpl remove(Object key) {
        SequenceImpl sequenceImpl;
        block8: {
            SequenceImpl sequenceImpl2;
            block7: {
                SequenceImpl sequenceImpl3;
                block6: {
                    try {
                        this.lock();
                        if (this.inTransaction) {
                            if (this.tempRemoved.contains(key)) {
                                SequenceImpl sequenceImpl4 = null;
                                Object var6_4 = null;
                                this.unlock();
                                return sequenceImpl4;
                            }
                            SequenceImpl ret = this.get(key);
                            if (ret != null) {
                                this.tempRemoved.add(key);
                            }
                            sequenceImpl3 = ret;
                            break block6;
                        }
                        SoftReference ref = (SoftReference)this.cache.remove(key);
                        if (ref != null) {
                            sequenceImpl2 = (SequenceImpl)ref.get();
                            break block7;
                        }
                        sequenceImpl = null;
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        this.unlock();
                        throw throwable;
                    }
                }
                Object var6_5 = null;
                this.unlock();
                return sequenceImpl3;
            }
            Object var6_6 = null;
            this.unlock();
            return sequenceImpl2;
        }
        Object var6_7 = null;
        this.unlock();
        return sequenceImpl;
    }

    public void clear() {
        try {
            this.lock();
            this.cache.clear();
            Object var2_1 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.unlock();
            throw throwable;
        }
    }

    public void begin() {
        this.inTransaction = true;
        this.tempCache.clear();
    }

    public void commit() {
        this.inTransaction = false;
        Iterator i = this.tempCache.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Object key = entry.getKey();
            if (this.tempRemoved.contains(key)) {
                this.tempRemoved.remove(key);
                this.remove(key);
                continue;
            }
            this.put(key, (SequenceImpl)entry.getValue());
        }
        Iterator i2 = this.tempRemoved.iterator();
        while (i2.hasNext()) {
            this.remove(i2.next());
        }
        this.tempCache.clear();
        this.tempRemoved.clear();
    }

    public void rollback() {
        this.tempCache.clear();
        this.tempRemoved.clear();
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public void unlock(int level) {
        this.lock.unlock(level);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

