/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.rpc.handler.config;

import com.idoox.debug.Category;
import com.idoox.wasp.ClassSpace;
import com.idoox.xmlrpc.config.HeaderInstanceConfig;
import com.idoox.xmlrpc.header.HPInstance;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.idoox.transport.client.Endpoint;
import org.idoox.xmlrpc.header.Header;
import org.idoox.xmlrpc.header.Schema;

public class HandlerConfigHelper {
    private static Category cat = Category.getCategory("com.systinet.wasp.rpc.handler.config.HandlerConfigHelper");

    public static Header[] getHPHeaders(HeaderInstanceConfig config, ClassSpace classSpace) {
        ArrayList<Header> ret = new ArrayList<Header>();
        HeaderInstanceConfig.Header[] headers = config.getHeaders();
        if (headers != null) {
            int i = 0;
            while (i < headers.length) {
                int direction = 3;
                if (headers[i].getDirection() != null) {
                    if ("".equals(headers[i].getDirection())) {
                        direction = 0;
                    } else if (headers[i].getDirection().equals("in")) {
                        direction = 1;
                    } else if (headers[i].getDirection().equals("out")) {
                        direction = 2;
                    }
                }
                Class<?> clazz = null;
                if (headers[i].getClazz() != null) {
                    try {
                        clazz = Class.forName(headers[i].getClazz(), true, classSpace.getClassLoader());
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
                Header header = new Header(headers[i].getQname(), headers[i].getType(), clazz, direction);
                ret.add(header);
                ++i;
            }
        }
        return ret.toArray(new Header[ret.size()]);
    }

    public static Schema[] getHPSchemas(HeaderInstanceConfig config, ClassSpace classSpace) {
        ClassLoader cl = classSpace.getClassLoader();
        HeaderInstanceConfig.Schema[] schemas = config.getSchemas();
        ArrayList<Schema> ret = new ArrayList<Schema>();
        if (schemas != null) {
            int i = 0;
            while (i < schemas.length) {
                String locationURL = schemas[i].getSchemaLocation();
                Endpoint endpoint = null;
                URL url = null;
                try {
                    endpoint = new Endpoint(locationURL);
                }
                catch (MalformedURLException e) {
                    break;
                }
                if ("resource".equals(endpoint.getScheme())) {
                    String path = endpoint.getPath();
                    while (path.startsWith("/")) {
                        path = path.substring(1);
                    }
                    url = cl.getResource(path);
                }
                if (url == null) {
                    cat.error("Cannot load schema: " + endpoint);
                    break;
                }
                Schema schema = new Schema(url.toExternalForm(), schemas[i].getNamespaceURI());
                ret.add(schema);
                ++i;
            }
        }
        return ret.toArray(new Schema[ret.size()]);
    }

    public static QName[] toQNames(Header[] headers) {
        ArrayList<QName> ret = new ArrayList<QName>();
        int i = 0;
        while (i < headers.length) {
            ret.add(headers[i].getName());
            ++i;
        }
        return ret.toArray(new QName[0]);
    }

    public static HPInstance.Header[] toBCheaders(Header[] headers) {
        HPInstance.Header[] oldHeaders = new HPInstance.Header[headers.length];
        int i = 0;
        while (i < headers.length) {
            Header header = headers[i];
            oldHeaders[i] = new HPInstance.Header(header.getName(), header.getType(), header.getClazz(), header.getDirection());
            ++i;
        }
        return oldHeaders;
    }

    public static HPInstance.Schema[] toBCschemas(Schema[] schemas) {
        HPInstance.Schema[] oldSchemas = new HPInstance.Schema[schemas.length];
        int i = 0;
        while (i < schemas.length) {
            Schema schema = schemas[i];
            oldSchemas[i] = new HPInstance.Schema(schema.getLocation(), schema.getNamespace());
            ++i;
        }
        return oldSchemas;
    }
}

