/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.rpc.handler;

import com.idoox.debug.Category;
import com.idoox.wasp.ClassSpace;
import com.idoox.wasp.ClassSpaceHelper;
import com.idoox.wasp.InitialReferencesRegistrar;
import com.idoox.xmlrpc.config.HeaderInstanceConfig;
import com.idoox.xmlrpc.header.HPInstance;
import com.idoox.xmlrpc.header.HeaderProcessorChain;
import com.idoox.xmlrpc.header.HeaderProcessorRepositoryImpl;
import com.systinet.wasp.rpc.handler.HandlerChainRepresentationImpl;
import com.systinet.wasp.rpc.handler.WaspHandlerInfoImpl;
import com.systinet.wasp.rpc.handler.config.HandlerConfigHelper;
import com.systinet.wasp.rpc.handler.config.HandlersConfig;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.idoox.wasp.Context;
import org.idoox.wasp.Module;
import org.idoox.wasp.WaspInternalException;
import org.idoox.xmlrpc.header.Header;
import org.idoox.xmlrpc.header.Schema;
import org.systinet.wasp.handler.HandlerRepository;

public class HandlerRepositoryImpl
implements Module,
HandlerRepository {
    private static final Category cat = Category.getCategory("com.systinet.wasp.rpc.handler.HandlerRepositoryImpl");
    private static final String HANDLERS_ELEMENT = "Handlers";
    private static final String DEF_HANDLERS = "DefaultHandlers";
    private static final String HEADER_INSTANCE_ELEMENT = "HeaderInstance";
    private static final String HANDLER_INSTANCE_ELEMENT = "HandlerInstance";
    private Configurator configurator;
    private static HeaderProcessorRepositoryImpl hrepo;
    private Map processingIDTohandlerChain = new HashMap(11, 0.75f);
    private Set creationStack = new HashSet(11, 0.75f);
    static /* synthetic */ Class class$com$idoox$xmlrpc$header$HeaderProcessorRepository;
    static /* synthetic */ Class class$com$systinet$wasp$rpc$handler$config$HandlersConfig;
    static /* synthetic */ Class class$org$idoox$xmlrpc$header$HeaderProcessor;
    static /* synthetic */ Class class$com$idoox$xmlrpc$config$HeaderInstanceConfig;
    static /* synthetic */ Class class$java$lang$String;

    public HandlerRepository.HandlerChainRepresentation getHandlerChain(String processingID) {
        HandlerRepository.HandlerChainRepresentation repre;
        Map map = this.processingIDTohandlerChain;
        synchronized (map) {
            repre = (HandlerRepository.HandlerChainRepresentation)this.processingIDTohandlerChain.get(processingID);
            if (repre == null) {
                repre = this.createNewHandlerChain(processingID);
            }
        }
        return repre;
    }

    private void registerNewHandlerChain(String processingID, HandlerRepository.HandlerChainRepresentation handlerChain) {
        Map map = this.processingIDTohandlerChain;
        synchronized (map) {
            this.processingIDTohandlerChain.put(processingID, handlerChain);
        }
    }

    public void registerHandlerChain(Configurable handlersConfig) {
        if (handlersConfig == null) {
            return;
        }
        String name = handlersConfig.getName();
        Map map = this.processingIDTohandlerChain;
        synchronized (map) {
            if (!this.processingIDTohandlerChain.containsKey(name)) {
                this.parseHandlerChain(handlersConfig, handlersConfig.getName());
            }
        }
    }

    public void unregisterHandlerChain(Configurable handlersConfig) {
        this.unregisterHandlerChain(handlersConfig.getName());
    }

    public void unregisterHandlerChain(String processingID) {
        HandlerRepository.HandlerChainRepresentation entry = this.getHandlerChain(processingID);
        if (entry != null) {
            entry.destroy();
            Map map = this.processingIDTohandlerChain;
            synchronized (map) {
                this.processingIDTohandlerChain.remove(processingID);
            }
        }
    }

    public void load(Configurable moduleConfig) throws WaspInternalException {
        InitialReferencesRegistrar.addInitialReference("wasp.core.jaxrpc_handler_repository", this);
        this.configurator = (Configurator)Context.getInstance("org.idoox.config.Configurator");
        hrepo = (HeaderProcessorRepositoryImpl)Context.getInstance(class$com$idoox$xmlrpc$header$HeaderProcessorRepository == null ? (class$com$idoox$xmlrpc$header$HeaderProcessorRepository = HandlerRepositoryImpl.class$("com.idoox.xmlrpc.header.HeaderProcessorRepository")) : class$com$idoox$xmlrpc$header$HeaderProcessorRepository);
        Configurable[] configs = Configurator.getTopEntries(HANDLERS_ELEMENT);
        int i = 0;
        while (i < configs.length) {
            HandlerRepository.HandlerChainRepresentation entry;
            String name = configs[i].getName();
            if (!this.processingIDTohandlerChain.containsKey(name) && (entry = this.parseHandlerChain(configs[i], configs[i].getName())) == null) {
                cat.info("Cannot load handler processors configuration " + name);
            }
            ++i;
        }
    }

    private HandlerRepository.HandlerChainRepresentation parseHandlerChain(Configurable c, String processingID) {
        HandlersConfig config = (HandlersConfig)c.narrow(class$com$systinet$wasp$rpc$handler$config$HandlersConfig == null ? (class$com$systinet$wasp$rpc$handler$config$HandlersConfig = HandlerRepositoryImpl.class$("com.systinet.wasp.rpc.handler.config.HandlersConfig")) : class$com$systinet$wasp$rpc$handler$config$HandlersConfig);
        this.creationStack.add(processingID);
        HandlersConfig.Import[] imports = config.getImports();
        HandlerChainRepresentationImpl[] im = new HandlerChainRepresentationImpl[imports.length];
        int i = 0;
        while (i < imports.length) {
            String ref = imports[i].getRef();
            im[i] = this.getHandlerChain(processingID);
            if (im[i] == null) {
                if (this.creationStack.contains(ref)) {
                    cat.info("Cyclic dependency detected during initialization of " + processingID);
                    break;
                }
                Configurable c0 = Configurator.getConfigurable(HANDLERS_ELEMENT, ref);
                if (c0 == null) {
                    cat.info("Cannot create handlers " + ref + " - configuration does not exist");
                    break;
                }
                im[i] = this.parseHandlerChain(c0, processingID);
                if (im[i] == null) break;
            }
            ++i;
        }
        this.creationStack.remove(processingID);
        if (i < imports.length) {
            return null;
        }
        HandlerChainRepresentationImpl entry = new HandlerChainRepresentationImpl();
        this.registerNewHandlerChain(processingID, entry);
        i = 0;
        while (i < im.length) {
            entry.registerHandlers(im[i].getHandlers());
            ++i;
        }
        HandlersConfig.In inChain = config.getIn();
        String[] inHandlers = null;
        if (inChain != null) {
            inHandlers = inChain.getHandlers();
        }
        if (inHandlers != null && !this.fillChain(processingID, entry, inHandlers, 1)) {
            return null;
        }
        HandlersConfig.Out outChain = config.getOut();
        String[] outHandlers = null;
        if (outChain != null) {
            outHandlers = outChain.getHandlers();
        }
        if (outHandlers != null && !this.fillChain(processingID, entry, outHandlers, 2)) {
            return null;
        }
        HandlersConfig.Fault faultChain = config.getFault();
        String[] faultHandlers = null;
        if (faultChain != null) {
            faultHandlers = faultChain.getHandlers();
        }
        if (faultHandlers != null && !this.fillChain(processingID, entry, faultHandlers, 12)) {
            return null;
        }
        return entry;
    }

    private boolean fillChain(String processingID, HandlerRepository.HandlerChainRepresentation entry, String[] handlerInstances, int direction) {
        int i = 0;
        while (i < handlerInstances.length) {
            WaspHandlerInfoImpl handlerInfo;
            if ((class$org$idoox$xmlrpc$header$HeaderProcessor == null ? HandlerRepositoryImpl.class$("org.idoox.xmlrpc.header.HeaderProcessor") : class$org$idoox$xmlrpc$header$HeaderProcessor).isAssignableFrom((handlerInfo = this.handlerConfigToHandlerInfo(handlerInstances[i], processingID, direction)).getHandlerClass())) {
                this.registerHeaderProcessorBC(handlerInfo, processingID, direction);
            } else {
                entry.registerHandler(handlerInfo);
            }
            ++i;
        }
        return true;
    }

    private WaspHandlerInfoImpl handlerConfigToHandlerInfo(String instanceName, String processingID, int direction) {
        Class<?> handlerClazz;
        ClassSpace classSpace;
        Configurable c = Configurator.getConfigurable(HANDLER_INSTANCE_ELEMENT, instanceName);
        if (c == null) {
            c = Configurator.getConfigurable(HEADER_INSTANCE_ELEMENT, instanceName);
        }
        if (c == null) {
            cat.error("Unable to find handler instance in configuration:" + instanceName);
            return null;
        }
        HeaderInstanceConfig hiConfig = (HeaderInstanceConfig)c.narrow(class$com$idoox$xmlrpc$config$HeaderInstanceConfig == null ? (class$com$idoox$xmlrpc$config$HeaderInstanceConfig = HandlerRepositoryImpl.class$("com.idoox.xmlrpc.config.HeaderInstanceConfig")) : class$com$idoox$xmlrpc$config$HeaderInstanceConfig);
        String classSpaceName = hiConfig.getClassSpaceName();
        try {
            classSpace = ClassSpaceHelper.getClassSpace(classSpaceName, c.getReferenceLocation());
            handlerClazz = Class.forName(hiConfig.getClassName(), true, classSpace.getClassLoader());
        }
        catch (MalformedURLException e) {
            cat.error("Cannot create class space for the HP instance " + processingID);
            e.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException e) {
            cat.error("Cannot find implementation class " + hiConfig.getClassName() + " for the HP instance " + processingID);
            e.printStackTrace();
            return null;
        }
        WaspHandlerInfoImpl hi = new WaspHandlerInfoImpl(handlerClazz);
        Boolean needsBody = hiConfig.getNeedsBody();
        if (needsBody != null) {
            hi.setNeedsBody(needsBody);
        }
        hi.setDirection(direction);
        hi.setConfiguration(c);
        hi.setInstanceName(hiConfig.getName());
        Header[] headers = HandlerConfigHelper.getHPHeaders(hiConfig, classSpace);
        hi.setHeaders(HandlerConfigHelper.toQNames(headers));
        Schema[] schemas = HandlerConfigHelper.getHPSchemas(hiConfig, classSpace);
        hi.setWASPHeaders(headers, schemas);
        hi.getHandlerConfig().putAll(this.createHandlerConfiguration(hiConfig));
        return hi;
    }

    private void registerHeaderProcessorBC(WaspHandlerInfoImpl info, String processingID, int direction) {
        HeaderProcessorRepositoryImpl hrepo = this.getHPRepository();
        HeaderProcessorChain hpChain = null;
        HeaderProcessorChain hpChain2 = null;
        switch (direction) {
            case 1: {
                hpChain = hrepo.getIncomingHeaderProcessors(processingID);
                break;
            }
            case 2: {
                hpChain = hrepo.getOutgoingHeaderProcessors(processingID);
                break;
            }
            case 12: {
                hpChain = hrepo.getInputFaultHeaderProcessors(processingID);
                hpChain2 = hrepo.getOutputFaultHeaderProcessors(processingID);
            }
        }
        if (info.getWASPHeaders().length > 0) {
            HPInstance.Header[] oldHeaders = HandlerConfigHelper.toBCheaders(info.getWASPHeaders());
            HPInstance.Schema[] oldSchemas = HandlerConfigHelper.toBCschemas(info.getSchemas());
            hrepo.addHeaderProcessor(hpChain, info.getInstanceName(), oldHeaders, oldSchemas, info.isNeedsBody());
            if (hpChain2 != null) {
                hrepo.addHeaderProcessor(hpChain2, info.getInstanceName(), oldHeaders, oldSchemas, info.isNeedsBody());
            }
        } else {
            hrepo.addHeaderProcessor(hpChain, info.getInstanceName(), info.getHeaders(), info.isNeedsBody());
            if (hpChain2 != null) {
                hrepo.addHeaderProcessor(hpChain2, info.getInstanceName(), info.getHeaders(), info.isNeedsBody());
            }
        }
    }

    public void init() throws WaspInternalException {
    }

    public void destroy() {
        Map map = this.processingIDTohandlerChain;
        synchronized (map) {
            Iterator it = this.processingIDTohandlerChain.keySet().iterator();
            while (it.hasNext()) {
                HandlerRepository.HandlerChainRepresentation entry = this.getHandlerChain((String)it.next());
                entry.destroy();
            }
            this.processingIDTohandlerChain.clear();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.processingIDTohandlerChain.keySet().iterator();
        while (it.hasNext()) {
            String processingID = (String)it.next();
            HandlerRepository.HandlerChainRepresentation entry = (HandlerRepository.HandlerChainRepresentation)this.processingIDTohandlerChain.get(processingID);
            sb.append("Processing ID:" + processingID + "\n");
            sb.append(entry);
            sb.append("--------------------------------------------\n");
        }
        return sb.toString();
    }

    public HandlerRepository.HandlerChainRepresentation newHandlerChain() {
        HandlerRepository.HandlerChainRepresentation defClientEntry;
        HandlerChainRepresentationImpl entry = new HandlerChainRepresentationImpl();
        Map map = this.processingIDTohandlerChain;
        synchronized (map) {
            defClientEntry = (HandlerRepository.HandlerChainRepresentation)this.processingIDTohandlerChain.get(DEF_HANDLERS);
        }
        if (defClientEntry != null) {
            entry.registerHandlers(defClientEntry.getHandlers());
        }
        return entry;
    }

    private HandlerRepository.HandlerChainRepresentation createNewHandlerChain(String processingID) {
        HandlerRepository.HandlerChainRepresentation entry = this.newHandlerChain();
        this.registerNewHandlerChain(processingID, entry);
        return entry;
    }

    private HeaderProcessorRepositoryImpl getHPRepository() {
        return hrepo;
    }

    public String cloneHandlerChain(String srcProcessingID) {
        HandlerChainRepresentationImpl handlerChain = (HandlerChainRepresentationImpl)this.getHandlerChain(srcProcessingID);
        HandlerRepository.HandlerChainRepresentation targetHandlerChain = (HandlerRepository.HandlerChainRepresentation)handlerChain.clone();
        String newProcessingID = this.getHPRepository().cloneHeadersID(srcProcessingID);
        this.registerNewHandlerChain(newProcessingID, targetHandlerChain);
        return newProcessingID;
    }

    private Map createHandlerConfiguration(HeaderInstanceConfig config) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        HeaderInstanceConfig.InitParam[] initParams = config.getInitParams();
        if (initParams != null) {
            int i = 0;
            while (i < initParams.length) {
                HeaderInstanceConfig.InitParam initParam = initParams[i];
                try {
                    Object instance = this.createInstance(initParam.getType(), initParam.getValue());
                    if (initParam.getName() != null) {
                        ret.put(initParam.getName(), instance);
                    } else {
                        cat.warn("Init param without name!");
                    }
                }
                catch (Throwable e) {
                    cat.warn("Can't instantiate " + (initParam.getName() != null ? initParam.getName() : "null") + " <init-param>: ", e);
                }
                ++i;
            }
        }
        return ret;
    }

    private Object createInstance(String type, String value) throws Exception {
        Class clazz;
        Class clazz2 = clazz = class$java$lang$String == null ? (class$java$lang$String = HandlerRepositoryImpl.class$("java.lang.String")) : class$java$lang$String;
        if (type != null && !type.equals("")) {
            clazz = Class.forName(type);
        }
        Constructor<?> cons = clazz.getDeclaredConstructor(class$java$lang$String == null ? (class$java$lang$String = HandlerRepositoryImpl.class$("java.lang.String")) : class$java$lang$String);
        return cons.newInstance(value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

