/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.rpc.handler;

import com.systinet.wasp.rpc.handler.WaspHandlerInfoImpl;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import org.idoox.xmlrpc.Message;
import org.idoox.xmlrpc.header.HeaderProcessingException;
import org.idoox.xmlrpc.header.HeaderProcessor;
import org.systinet.wasp.handler.WaspHandlerInfo;
import org.systinet.wasp.soap.WaspSOAPMessage;
import org.systinet.wasp.soap.bc.MessageConvertor;
import org.systinet.wasp.webservice.Current;

public class HPAdaptor
extends GenericHandler {
    private HeaderProcessor hpInstance;
    private int direction;
    private QName[] understandsHeaders;
    private boolean needsBody;
    private int processingType = -1;

    public HPAdaptor(HeaderProcessor hpInstance, WaspHandlerInfo info) {
        this.hpInstance = hpInstance;
        this.direction = info.getDirection();
        this.understandsHeaders = info.getHeaders();
        this.needsBody = ((WaspHandlerInfoImpl)info).isNeedsBody();
    }

    public boolean handleRequest(MessageContext context) {
        if (this.getProcessingType() == 1) {
            if ((this.direction & 2) == 2) {
                try {
                    this.hpInstance.processOutput(this.convertMessage(context, false));
                }
                catch (HeaderProcessingException e) {
                    throw new JAXRPCException("Exception during processing " + this.hpInstance.getClass().getName() + "." + e);
                }
            }
        } else if ((this.direction & 1) == 1) {
            try {
                this.hpInstance.processInput(this.convertMessage(context, true));
            }
            catch (HeaderProcessingException e) {
                throw new JAXRPCException("Exception during processing " + this.hpInstance.getClass().getName() + "." + e);
            }
        }
        return true;
    }

    public boolean handleResponse(MessageContext context) {
        if (this.getProcessingType() == 1) {
            if ((this.direction & 1) == 1) {
                try {
                    this.hpInstance.processInput(this.convertMessage(context, true));
                }
                catch (HeaderProcessingException e) {
                    throw new JAXRPCException("Exception during processing " + this.hpInstance.getClass().getName() + "." + e);
                }
            }
        } else if ((this.direction & 2) == 2) {
            try {
                this.hpInstance.processOutput(this.convertMessage(context, false));
            }
            catch (HeaderProcessingException e) {
                throw new JAXRPCException("Exception during processing " + this.hpInstance.getClass().getName() + "." + e);
            }
        }
        return true;
    }

    public boolean handleFault(MessageContext context) {
        if (this.getProcessingType() == 1) {
            if ((this.direction & 0xC) == 12) {
                try {
                    this.hpInstance.processInputFault(this.convertMessage(context, true));
                }
                catch (HeaderProcessingException e) {
                    throw new JAXRPCException("Exception during processing " + this.hpInstance.getClass().getName() + "." + e);
                }
            }
        } else if ((this.direction & 0xC) == 12) {
            try {
                this.hpInstance.processOutputFault(this.convertMessage(context, false));
            }
            catch (HeaderProcessingException e) {
                throw new JAXRPCException("Exception during processing " + this.hpInstance.getClass().getName() + "." + e);
            }
        }
        return true;
    }

    public QName[] getHeaders() {
        return this.understandsHeaders;
    }

    private int getProcessingType() {
        if (this.processingType == -1) {
            this.processingType = Current.getProcessingType();
        }
        return this.processingType;
    }

    private Message convertMessage(MessageContext context, boolean isInput) {
        WaspSOAPMessage saajMess = (WaspSOAPMessage)((SOAPMessageContext)context).getMessage();
        return MessageConvertor.convertSOAPMessage(saajMess, isInput, this.needsBody);
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }
}

