/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.rpc;

import com.idoox.wasp.serialization.PrimitiveTypeAccessor;
import com.idoox.wasp.serialization.SerializationHelper;
import com.idoox.xml.schema.util.XMLSchemaUtil;
import com.systinet.wasp.rpc.ExceptionDeserializerHelper;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.DeserializationChain;
import org.idoox.wasp.serialization.DeserializationContext;
import org.idoox.wasp.serialization.SchemaContext;
import org.idoox.wasp.serialization.XMLDeserializer;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xml.schema.Member;
import org.idoox.xml.schema.SchemaConstruct;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xml.schema.Type;
import org.idoox.xmlrpc.MessageProcessingException;

public final class XMLExceptionDeserializer
implements XMLDeserializer {
    static /* synthetic */ Class class$java$lang$Exception;
    static /* synthetic */ Class class$java$lang$Object;

    public void init(Configurable configurable) {
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }

    public Object deserialize(Tokenizer dataTokenizer, Token currentToken, Class targetClass, DeserializationContext context, DeserializationChain chain) throws MessageProcessingException {
        try {
            if (context.getCurrentConstructType() != SchemaConstruct.ConstructType.MEMBER) {
                throw new MessageProcessingException("Internall error");
            }
            QName xsiType = SerializationHelper.getXsiType(dataTokenizer, currentToken);
            if (xsiType != null) {
                Type schemaType = context.getSchemaType(xsiType);
                if (schemaType == null) {
                    throw new MessageProcessingException("Unable to find schema type with name:" + xsiType);
                }
            } else {
                Type schemaType = context.getCurrentConstructSchemaType();
            }
            if (!(class$java$lang$Exception == null ? (class$java$lang$Exception = XMLExceptionDeserializer.class$("java.lang.Exception")) : class$java$lang$Exception).isAssignableFrom(targetClass)) {
                throw new MessageProcessingException("Unable to deserialize exception to class:" + targetClass.getName() + ". It does not inherit from java.lang.Exception!");
            }
            Constructor constructor = ExceptionDeserializerHelper.getConstructor(targetClass);
            DeserializedParametersWithTypes params = this.deserializeParams(dataTokenizer, currentToken, targetClass, context, constructor);
            return ExceptionDeserializerHelper.constructException(constructor, params.values, params.javaTypes, targetClass);
        }
        catch (MessageProcessingException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageProcessingException(e);
        }
    }

    private DeserializedParametersWithTypes deserializeParams(Tokenizer dataTokenizer, Token currentToken, Class targetClass, DeserializationContext context, Constructor constructor) throws MessageProcessingException, IOException, TokenizerException {
        Member member;
        ArrayList<Object> retValues = new ArrayList<Object>(11);
        ArrayList<String> retTypes = new ArrayList<String>(11);
        Type typeToDeserialize = context.getCurrentConstructSchemaType();
        SchemaConstruct.ConstructType t = context.getCurrentConstructType();
        if (t == SchemaConstruct.ConstructType.MEMBER && (member = (Member)context.getCurrentSchemaConstruct()).getMaxOccurs() == 1 && (XMLExceptionDeserializer.getPrimitiveClass(typeToDeserialize) != null || (typeToDeserialize.getKind() & 0x10) != 0)) {
            return new DeserializedParametersWithTypes(this.deserializeByChain(constructor, retValues, dataTokenizer, currentToken, context), null);
        }
        if (XMLSchemaUtil.isArray(typeToDeserialize) || XMLSchemaUtil.isMSArray(typeToDeserialize)) {
            return new DeserializedParametersWithTypes(this.deserializeByChain(constructor, retValues, dataTokenizer, currentToken, context), null);
        }
        SchemaContext.State state = context.enterCurrentMember();
        int index = 0;
        Class<?>[] parameterTypes = null;
        if (constructor != null) {
            parameterTypes = constructor.getParameterTypes();
        }
        ArrayList<Object> arrayValues = new ArrayList<Object>(11);
        boolean isArray = false;
        String arrayMemmberNS = null;
        String arrayMemmberLocal = null;
        Class<?> memberClass = null;
        while (true) {
            byte tok = SerializationHelper.nextNonWhitespace(dataTokenizer);
            if (isArray) {
                String namespace = dataTokenizer.getNamespace();
                if (arrayMemmberNS != null && !arrayMemmberNS.equals(namespace) || arrayMemmberNS == null && namespace != null || !arrayMemmberLocal.equals(dataTokenizer.getLocalName())) {
                    retTypes.add(index, null);
                    retValues.add(index++, arrayValues.toArray((Object[])Array.newInstance(memberClass, 0)));
                    arrayValues.clear();
                }
            }
            if (tok == 3) break;
            if (context.nextSchemaConstruct(dataTokenizer.getNamespace(), dataTokenizer.getLocalName()) == null) {
                throw new MessageProcessingException("Unexpected input element {" + dataTokenizer.getNamespace() + "}" + dataTokenizer.getLocalName() + context.getCurrentSchemaConstruct());
            }
            QName currentConstructName = context.getCurrentConstructName();
            isArray = context.isCurrentConstructArray();
            SchemaContext.State arrayState = null;
            if (isArray) {
                arrayMemmberNS = dataTokenizer.getNamespace();
                arrayMemmberLocal = dataTokenizer.getLocalName();
                arrayState = context.putSchemaConstruct(new Member(currentConstructName, context.getCurrentConstructSchemaType()));
            }
            if (parameterTypes != null && parameterTypes.length <= index) {
                throw new MessageProcessingException("Unable to deserialize exception " + targetClass + ". Constructor " + constructor + " has less parameters than" + (index + 1) + ".");
            }
            if (parameterTypes != null) {
                memberClass = parameterTypes[index];
            } else {
                Class<Object> clazz = memberClass = class$java$lang$Object == null ? XMLExceptionDeserializer.class$("java.lang.Object") : class$java$lang$Object;
            }
            if (isArray) {
                memberClass = memberClass.getComponentType();
            }
            String currentJavaType = this.extractCurrentJavaType(context);
            DeserializationChain chain = context.getDeserializationChain(memberClass);
            XMLDeserializer deserializer = (XMLDeserializer)chain.getNextDeserializerAs("systinet:xmlser/1.0");
            dataTokenizer.readToken(currentToken);
            Object member2 = deserializer.deserialize(dataTokenizer, currentToken, memberClass, context, chain);
            context.releaseDeserializationChain(chain);
            if (isArray) {
                context.leave(arrayState);
                arrayValues.add(member2);
                continue;
            }
            retValues.add(index, member2);
            retTypes.add(index, currentJavaType);
            ++index;
        }
        context.leave(state);
        return new DeserializedParametersWithTypes(retValues, retTypes);
    }

    private String extractCurrentJavaType(DeserializationContext context) {
        try {
            Type schemaType = context.getCurrentConstructSchemaType();
            if (schemaType == null) {
                return null;
            }
            return context.getType(schemaType);
        }
        catch (SchemaException e) {
            return null;
        }
    }

    private List deserializeByChain(Constructor constructor, List ret, Tokenizer dataTokenizer, Token currentToken, DeserializationContext context) throws MessageProcessingException {
        Class<?>[] parameterTypes;
        Class<?> memberClass = null;
        if (constructor != null && (parameterTypes = constructor.getParameterTypes()).length == 1) {
            memberClass = parameterTypes[0];
        }
        ret.add(SerializationHelper.deserializeElement(dataTokenizer, currentToken, memberClass, context));
        return ret;
    }

    public static Class getPrimitiveClass(Type type) {
        while (type != null) {
            Class ret;
            QName name = type.getName();
            if (name != null && (ret = PrimitiveTypeAccessor.getPrimitiveClass(name.getNamespaceURI(), name.getLocalPart())) != null) {
                return ret;
            }
            type = type.getBaseType();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DeserializedParametersWithTypes {
        List values;
        List javaTypes;

        public DeserializedParametersWithTypes(List values, List javaTypes) {
            this.values = values;
            this.javaTypes = javaTypes;
        }
    }
}

