/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.rpc;

import com.idoox.Namespaces;
import com.idoox.debug.Category;
import com.idoox.soap.EnvelopeOutCache;
import com.idoox.util.Pool;
import com.idoox.wasp.CachedEncodingTokenizer;
import com.idoox.wasp.ProtocolRepositoryImpl;
import com.idoox.wasp.serialization.FaultSerializationHelper;
import com.idoox.wasp.serialization.SerializationHelper;
import com.idoox.wasp.serialization.WaspSerializationHelper;
import com.idoox.xml.CachingTokenizer;
import com.idoox.xml.TokenPool;
import com.idoox.xmlrpc.encoding.EncodingRepository;
import com.systinet.wasp.async.AsyncConversationImpl;
import com.systinet.wasp.client.ClientAttachments;
import com.systinet.wasp.client.GetClientAttachments;
import com.systinet.wasp.rpc.ClientLazySerializationHelper;
import com.systinet.wasp.rpc.FaultDeserializationHelper;
import com.systinet.wasp.webservice.CurrentImpl;
import com.systinet.wasp.webservice.ServiceClientImpl;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.rmi.RemoteException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ParameterMode;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.idoox.security.Credentials;
import org.idoox.transport.Connection;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.Context;
import org.idoox.wasp.MessageAttachment;
import org.idoox.wasp.RequestMessageAttachment;
import org.idoox.wasp.ResponseMessageAttachment;
import org.idoox.wasp.WaspSecurity;
import org.idoox.wasp.serialization.DeserializationContext;
import org.idoox.wasp.serialization.PostDeserializationHandler;
import org.idoox.wasp.serialization.Reference;
import org.idoox.wasp.serialization.SerializationRepository;
import org.idoox.wasp.serialization.TopLevelReferenceHolder;
import org.idoox.wasp.types.Holder;
import org.idoox.wasp.wsdl.SOAPMethodInfo;
import org.idoox.wasp.wsdl.SOAPPortInfo;
import org.idoox.wasp.wsdl.SOAPServiceInfo;
import org.idoox.xml.Attribute;
import org.idoox.xml.ElementFinalizingTokenizerWrapper;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xml.schema.Member;
import org.idoox.xml.schema.Schema;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xml.schema.Type;
import org.idoox.xmlrpc.Message;
import org.idoox.xmlrpc.MessageProcessingException;
import org.idoox.xmlrpc.encoding.EncodingToken;
import org.idoox.xmlrpc.encoding.EncodingTokenizer;
import org.idoox.xmlrpc.encoding.NoSuchEncodingException;
import org.systinet.wasp.IWasp;
import org.systinet.wasp.async.AsyncConversation;
import org.systinet.wasp.client.XMLInvocationException;
import org.systinet.wasp.client.XMLInvocationHelper;
import org.systinet.wasp.rpc.IWaspCall;
import org.systinet.wasp.soap.SOAPElementContent;
import org.systinet.wasp.soap.WaspInternalSOAPMessage;
import org.systinet.wasp.soap.WaspSOAPMessage;
import org.systinet.wasp.soap.bc.MessageConvertor;
import org.systinet.wasp.soap.util.LazyFillingTokenizer;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.LookupException;
import org.systinet.wasp.webservice.ServiceClient;

public class WaspCallImpl
implements IWaspCall {
    private static final String className = "com.systinet.wasp.rpc.WaspCallImpl";
    private static final Category dbg = Category.getCategory("com.systinet.wasp.rpc.WaspCallImpl");
    private ServiceClient serviceClient;
    private SOAPPortInfo portInfo;
    private MessageFactory messageFactory;
    private String serializationID;
    private String encoding = null;
    private String encodingID = null;
    private Boolean doPolymorphism = Boolean.TRUE;
    private boolean doMultirefs = true;
    private String protocol;
    private ClassLoader classLoader;
    private Map properties = new HashMap();
    private Pool pool;
    private QName operationName;
    private SOAPMethodInfo methodInfo;
    private List parameters = new ArrayList();
    private Class returnType;
    private QName returnTypeQName;
    private Map outputParams;
    private static Map protocolHandlers = new HashMap();
    private MethodInvocationState oldMis;
    private MethodInvocationState currentMis;
    private boolean release;
    private Schema schema;
    private static SOAPFactory soapFactory;
    private Token token = new Token();
    private static ProtocolRepositoryImpl pRepo;
    private static SerializationRepository serializationRepository;
    private static EncodingRepository encodingRepository;
    private static IWasp iWasp;
    private static final Category log;
    private int statusCode = -1;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$idoox$wasp$types$MessageAttachment;
    static /* synthetic */ Class class$org$idoox$wasp$RequestMessageAttachment;
    static /* synthetic */ Class class$org$idoox$wasp$ResponseMessageAttachment;
    static /* synthetic */ Class class$org$idoox$wasp$MessageAttachment;
    static /* synthetic */ Class class$org$idoox$wasp$types$RequestMessageAttachment;
    static /* synthetic */ Class class$org$idoox$wasp$types$ResponseMessageAttachment;
    static /* synthetic */ Class class$com$idoox$wasp$serialization$ArrayItemReferenceIface;
    static /* synthetic */ Class class$com$idoox$wasp$serialization$attachments$AttachmentReference;
    static /* synthetic */ Class class$java$lang$Void;

    public void init(ServiceClient serviceClient) {
        this.init(serviceClient, (QName)null);
    }

    public void init(ServiceClient serviceClient, SOAPMethodInfo methodInfo) {
        this.methodInfo = methodInfo;
        this.init(serviceClient);
        this.operationName = new QName(this.portInfo.getServiceInfo().getServiceQName().getNamespaceURI(), methodInfo.operationName);
    }

    public void init(ServiceClient serviceClient, QName operationName) {
        this.serviceClient = serviceClient;
        this.operationName = operationName;
        this.portInfo = ((ServiceClientImpl)this.serviceClient).getPortInfo();
        if (this.portInfo != null) {
            this.protocol = this.portInfo.getProtocol();
            if (protocolHandlers.containsKey(this.protocol)) {
                this.messageFactory = (MessageFactory)protocolHandlers.get(this.protocol);
            } else {
                this.messageFactory = (MessageFactory)((Object)pRepo.getProtocolHandler(this.protocol));
                protocolHandlers.put(this.protocol, this.messageFactory);
            }
        } else {
            throw new RuntimeException("Port not set properly.");
        }
        this.serializationID = ((ServiceClientImpl)this.serviceClient).getSerializationID();
        this.encoding = ((ServiceClientImpl)this.serviceClient).getEncoding();
        this.encodingID = ((ServiceClientImpl)this.serviceClient).getEncodingID();
        this.doMultirefs = ((ServiceClientImpl)this.serviceClient).isMultirefs();
    }

    public void setServiceCient(ServiceClient serviceClient) {
        this.serviceClient = serviceClient;
    }

    public AsyncConversation beginInvoke(Object[] inputParams) throws RemoteException {
        return this.beginInvoke(this.operationName, inputParams);
    }

    public AsyncConversation beginInvoke(QName operationName, Object[] inputParams) throws RemoteException {
        if (this.methodInfo == null && operationName == null && this.oldMis == null) {
            throw new RemoteException("To invoke, operation name must be specified!");
        }
        ServiceClientImpl.CurrentSaver oldCurrent = ((ServiceClientImpl)this.serviceClient).startProcessing();
        MethodInvocationState mis = this.prepareInvocationState(inputParams, operationName, true);
        if (this.methodInfo.operationType == 1) {
            this.serviceClient.getCallContext().getContextData().put("oneway.method", "true");
        }
        try {
            this.serializeRequest(mis);
            AsyncConversationImpl asyncResult = null;
            try {
                asyncResult = (AsyncConversationImpl)XMLInvocationHelper.beginCall(mis.request, this.serviceClient, false);
            }
            catch (XMLInvocationException e) {
                throw new JAXRPCException("Exception while starting asynchronous invocation. " + e.getRootException().getMessage(), e);
            }
            AsyncConversationImpl asyncConversationImpl = asyncResult;
            Object var8_8 = null;
            ((ServiceClientImpl)this.serviceClient).endProcessing(oldCurrent);
            return asyncConversationImpl;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            ((ServiceClientImpl)this.serviceClient).endProcessing(oldCurrent);
            throw throwable;
        }
    }

    public void setRelease(boolean release) {
        this.release = release;
    }

    public Object endInvoke(AsyncConversation asyncResult) throws RemoteException {
        if (asyncResult != null) {
            CurrentImpl current = (CurrentImpl)Context.getInstance("org.systinet.wasp.webservice.ICurrent");
            CurrentImpl.ThreadLocals threadLocals = current.getThreadLocals();
            ServiceClientImpl.CurrentSaver oldCurrent = new ServiceClientImpl.CurrentSaver(threadLocals.callContext, threadLocals.serviceClientContext, threadLocals.processingType);
            threadLocals.callContext = ((AsyncConversationImpl)asyncResult).getCallContext();
            threadLocals.serviceClientContext = ((AsyncConversationImpl)asyncResult).getServiceClient().getContext();
            threadLocals.processingType = 1;
            try {
                MethodInvocationState mis;
                this.currentMis = mis = this.prepareEndInvocationState(this.operationName);
                SOAPMethodInfo methodInfo = mis.method.weakMethodInfo.getMethodInfo();
                if (this.returnType == null) {
                    this.returnType = methodInfo.returnValuePart != null ? (class$java$lang$Object == null ? (class$java$lang$Object = WaspCallImpl.class$("java.lang.Object")) : class$java$lang$Object) : Void.TYPE;
                }
                mis.method.returnType = this.returnType;
                try {
                    mis.response = XMLInvocationHelper.endCall(asyncResult, this.serviceClient, false);
                }
                catch (XMLInvocationException e) {
                    throw new JAXRPCException("Exception while receiving asynchronous response. " + e.getRootException().getMessage(), e);
                }
                if (mis.response != null) {
                    Object ret = this.deserializeResponse(mis, threadLocals);
                    this.outputParams = this.readOutputParameters(mis);
                    if (!methodInfo.containsResponseAttachment) {
                        if (((WaspSOAPMessage)mis.response).getAttachmentType() == null) {
                            ((WaspSOAPMessage)mis.response).release();
                        } else {
                            Iterator i = mis.response.getAttachments();
                            if (!i.hasNext()) {
                                ((WaspSOAPMessage)mis.response).release();
                            }
                        }
                    }
                    Object object = ret;
                    Object var10_10 = null;
                    ((ServiceClientImpl)this.serviceClient).getCallContext().getContextData().putAll(threadLocals.callContext.getContextData());
                    ((ServiceClientImpl)this.serviceClient).endProcessing(oldCurrent);
                    return object;
                }
                this.outputParams = new HashMap(0, 0.75f);
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                ((ServiceClientImpl)this.serviceClient).getCallContext().getContextData().putAll(threadLocals.callContext.getContextData());
                ((ServiceClientImpl)this.serviceClient).endProcessing(oldCurrent);
                throw throwable;
            }
            Object var10_11 = null;
            ((ServiceClientImpl)this.serviceClient).getCallContext().getContextData().putAll(threadLocals.callContext.getContextData());
            ((ServiceClientImpl)this.serviceClient).endProcessing(oldCurrent);
            {
            }
        }
        return null;
    }

    public boolean isParameterAndReturnSpecRequired(QName operationName) {
        return false;
    }

    public void addParameter(String paramName, QName xmlType, ParameterMode parameterMode) {
        this.parameters.add(new Parameter(paramName, xmlType, null, parameterMode));
    }

    public void addParameter(String paramName, QName xmlType, Class javaType, ParameterMode parameterMode) {
        this.parameters.add(new Parameter(paramName, xmlType, javaType, parameterMode));
    }

    public QName getParameterTypeByName(String paramName) {
        int size = this.parameters.size();
        int i = 0;
        while (i < size) {
            Parameter param = (Parameter)this.parameters.get(i);
            if (param.partName.equals(paramName)) {
                return param.typeQName;
            }
            ++i;
        }
        return null;
    }

    public void setReturnType(QName xmlType) {
        this.returnTypeQName = xmlType;
    }

    public void setReturnType(QName xmlType, Class javaType) {
        this.returnTypeQName = xmlType;
        this.returnType = javaType;
    }

    public QName getReturnType() {
        return this.returnTypeQName;
    }

    public void removeAllParameters() {
        this.parameters.clear();
    }

    public QName getOperationName() {
        return this.operationName;
    }

    public void setOperationName(QName operationName) {
        this.operationName = operationName;
    }

    public QName getPortTypeName() {
        if (this.portInfo != null) {
            return this.portInfo.getPortTypeQName();
        }
        return null;
    }

    public void setPortTypeName(QName portType) {
    }

    public void setTargetEndpointAddress(String address) {
        this.serviceClient.setServiceURL(address);
    }

    public String getTargetEndpointAddress() {
        try {
            return this.serviceClient.getServiceURL();
        }
        catch (LookupException e) {
            throw new RuntimeWrappedException(e);
        }
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    public Iterator getPropertyNames() {
        return this.properties.entrySet().iterator();
    }

    public Object invoke(Object[] inputParams) throws RemoteException {
        return this.invoke(this.operationName, inputParams);
    }

    public Object invoke(QName operationName, Object[] inputParams) throws RemoteException {
        Object object;
        if (this.methodInfo == null && operationName == null && this.oldMis == null) {
            throw new RemoteException("To invoke, operation name must be specified!");
        }
        ServiceClientImpl.CurrentSaver oldCurrent = ((ServiceClientImpl)this.serviceClient).startProcessing();
        MethodInvocationState mis = this.prepareInvocationState(inputParams, operationName, false);
        SOAPMethodInfo methodInfo = mis.method.weakMethodInfo.getMethodInfo();
        try {
            this.serializeRequest(mis);
            if (methodInfo.operationType == 1) {
                XMLInvocationHelper.send(mis.request, this.serviceClient);
                Object var6_6 = null;
                Object var13_8 = null;
                ((ServiceClientImpl)this.serviceClient).endProcessing(oldCurrent);
                return var6_6;
            }
            String username = (String)this.getProperty("javax.xml.rpc.security.auth.username");
            if (username != null) {
                try {
                    Credentials credentials = WaspSecurity.acquireClientCredentials(username, (String)this.getProperty("javax.xml.rpc.security.auth.password"), "HttpBasic");
                    WaspSecurity.setInitiatingProvider(this.serviceClient, "HttpBasic");
                    WaspSecurity.setCredentials(this.serviceClient, new Credentials[]{credentials});
                }
                catch (NoSuchProviderException e) {
                    throw new RemoteException("", e);
                }
            }
            try {
                mis.response = XMLInvocationHelper.call(mis.request, this.serviceClient, false);
                if (mis.response == null) {
                    throw new JAXRPCException("Response from server can not be read.");
                }
            }
            catch (XMLInvocationException e) {
                if (e.getRootException() instanceof IOException) {
                    this.closeConnection();
                }
                throw new JAXRPCException("Exception while performing call. " + e.getRootException().getMessage(), e);
            }
            ((WaspSOAPMessage)mis.request).release();
            CurrentImpl current = (CurrentImpl)Context.getInstance("org.systinet.wasp.webservice.ICurrent");
            CurrentImpl.ThreadLocals threadLocals = current.getThreadLocals();
            Object ret = null;
            try {
                ret = this.deserializeResponse(mis, threadLocals);
            }
            catch (RemoteException e) {
                ((WaspSOAPMessage)mis.response).release();
                throw e;
            }
            this.outputParams = this.readOutputParameters(mis);
            String attachmentType = ((WaspSOAPMessage)mis.response).getAttachmentType();
            if (!methodInfo.containsResponseAttachment) {
                if (attachmentType == null) {
                    ((WaspSOAPMessage)mis.response).release();
                } else {
                    Iterator i = mis.response.getAttachments();
                    if (!i.hasNext()) {
                        ((WaspSOAPMessage)mis.response).release();
                    }
                }
            } else if ("application/dime".equals(attachmentType) && !mis.response.getAttachments().hasNext()) {
                ((WaspSOAPMessage)mis.response).release();
            }
            object = ret;
        }
        catch (Throwable throwable) {
            Object var13_10 = null;
            ((ServiceClientImpl)this.serviceClient).endProcessing(oldCurrent);
            throw throwable;
        }
        Object var13_9 = null;
        ((ServiceClientImpl)this.serviceClient).endProcessing(oldCurrent);
        return object;
    }

    public void invokeOneWay(Object[] inputParams) {
        try {
            this.invoke(this.operationName, inputParams);
        }
        catch (RemoteException e) {
            throw new JAXRPCException(e);
        }
    }

    public List getOutputValues(AsyncConversation asyncResult) throws RemoteException {
        if (asyncResult != null) {
            if (this.outputParams == null) {
                throw new RemoteException("endInvoke(AsyncConversation) should be called first");
            }
            return this.getOutputValuesInternalAsync(this.currentMis.method.weakMethodInfo.getMethodInfo(), this.outputParams);
        }
        throw new RemoteException("Uknown async result.");
    }

    public Map getOutputParams(AsyncConversation asyncResult) throws RemoteException {
        if (asyncResult != null) {
            if (this.outputParams == null) {
                throw new RemoteException("endInvoke(AsyncConversation) should be called first");
            }
            return this.outputParams;
        }
        throw new RemoteException("Uknown async result.");
    }

    public Map getOutputParams() {
        return this.outputParams;
    }

    public List getOutputValues() {
        return this.getOutputValuesInternal(this.methodInfo);
    }

    private List getOutputValuesInternal(SOAPMethodInfo methodInfo) {
        ArrayList ret = new ArrayList();
        int i = 0;
        while (i < methodInfo.parts.length) {
            if (methodInfo.parts[i].partType != 1 && this.outputParams.containsKey(methodInfo.parts[i].partName)) {
                ret.add(this.outputParams.get(methodInfo.parts[i].partName));
            }
            ++i;
        }
        return ret;
    }

    private List getOutputValuesInternalAsync(SOAPMethodInfo methodInfo, Map outputParams) {
        ArrayList ret = new ArrayList();
        int i = 0;
        while (i < methodInfo.parts.length) {
            if (methodInfo.parts[i].partType != 1 && outputParams.containsKey(methodInfo.parts[i].partName)) {
                ret.add(outputParams.get(methodInfo.parts[i].partName));
            }
            ++i;
        }
        return ret;
    }

    public Schema getSchema() {
        if (this.oldMis != null && this.oldMis.method.schema != null) {
            return this.oldMis.method.schema;
        }
        return this.schema;
    }

    public void setSchema(Schema schema) {
        if (this.oldMis != null) {
            this.oldMis.method.schema = schema;
        } else {
            this.schema = schema;
        }
    }

    public void release() {
        this.parameters.clear();
        this.methodInfo = null;
        this.serviceClient = null;
        this.currentMis = null;
        if (!this.release) {
            Pool old = this.pool;
            this.pool = null;
            if (this.oldMis != null) {
                this.oldMis.params = null;
                this.oldMis.request = null;
                this.oldMis.response = null;
            }
            old.release(this);
        } else {
            this.operationName = null;
            this.properties.clear();
            this.returnType = null;
            this.returnTypeQName = null;
            this.protocol = null;
            this.classLoader = null;
            this.oldMis = null;
            Pool old = this.pool;
            this.schema = null;
            if (old != null) {
                this.pool = null;
                old.release(this);
            }
        }
    }

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    public void setPool(Pool pool) {
        this.pool = pool;
    }

    private MethodInvocationState prepareInvocationState(Object[] inputParams, QName operationName, boolean async) throws RemoteException {
        MethodInvocationState mis;
        if (inputParams == null) {
            inputParams = new Object[]{};
        }
        if ((mis = this.oldMis) == null) {
            mis = new MethodInvocationState();
            if (this.returnType == null) {
                this.returnType = Void.TYPE;
            }
            mis.method = this.getMethodProperties(operationName, inputParams);
            mis.method.operationName = operationName;
            mis.method.parameters = new ArrayList(this.parameters);
            mis.method.returnTypeQName = this.returnTypeQName;
            mis.method.encodingId = this.encodingID;
            mis.method.doPolymorphism = this.doPolymorphism;
            if (mis.method.weakMethodInfo.getMethodInfo() == null) {
                throw new RuntimeException("Operation " + mis.method.operationName + "has not been found in WSDL.");
            }
            if (this.returnType == Void.TYPE && mis.method.weakMethodInfo.getMethodInfo().returnValuePart != null) {
                this.returnType = class$java$lang$Object == null ? (class$java$lang$Object = WaspCallImpl.class$("java.lang.Object")) : class$java$lang$Object;
            }
            mis.method.returnType = this.returnType;
            this.oldMis = mis;
        }
        mis.params = this.prepareParamsForSerialization(inputParams, mis, async);
        return mis;
    }

    private MethodInvocationState prepareEndInvocationState(QName operationName) throws RemoteException {
        MethodInvocationState mis = this.oldMis;
        if (mis == null) {
            mis = new MethodInvocationState();
            if (this.returnType == null) {
                this.returnType = Void.TYPE;
            }
            mis.method = this.getMethodProperties(operationName, null);
            mis.method.operationName = operationName;
            mis.method.parameters = new ArrayList(this.parameters);
            mis.method.returnTypeQName = this.returnTypeQName;
            mis.method.encodingId = this.encodingID;
            mis.method.doPolymorphism = this.doPolymorphism;
            if (mis.method.weakMethodInfo.getMethodInfo() == null) {
                throw new RuntimeException("Operation " + mis.method.operationName + "has not been found in WSDL.");
            }
            if (this.returnType == Void.TYPE && mis.method.weakMethodInfo.getMethodInfo().returnValuePart != null) {
                this.returnType = class$java$lang$Object == null ? (class$java$lang$Object = WaspCallImpl.class$("java.lang.Object")) : class$java$lang$Object;
            }
            mis.method.returnType = this.returnType;
            mis.params = this.prepareEndParamsForSerialization(mis);
            this.oldMis = null;
        }
        return mis;
    }

    private Map readOutputParameters(MethodInvocationState mis) {
        HashMap<String, Object> outP = new HashMap<String, Object>();
        SOAPMethodInfo methodInfo = mis.method.weakMethodInfo.getMethodInfo();
        int size = methodInfo.parts.length;
        boolean hasReturnValue = !mis.method.returnType.equals(Void.TYPE) && !mis.method.returnType.equals(Void.TYPE);
        boolean generateFirstOutAsReturn = methodInfo.returnValuePart == null && methodInfo.requestMessageEncodingURI == null && methodInfo.parts.length == 2;
        boolean firstOutAsReturnGenerated = false;
        int realParam = 0;
        int i = 0;
        while (i < size) {
            SOAPMethodInfo.PartInfo p = methodInfo.parts[i];
            if (generateFirstOutAsReturn && hasReturnValue && !firstOutAsReturnGenerated && p.partType == 2) {
                firstOutAsReturnGenerated = true;
            } else {
                if (p.partType != 1) {
                    if (!p.isAttachment) {
                        outP.put(p.partName, ((TopLevelReferenceHolder)mis.params[realParam]).getObjectValue());
                    } else {
                        outP.put(p.partName, mis.params[realParam]);
                    }
                }
                ++realParam;
            }
            ++i;
        }
        return outP;
    }

    private Object[] prepareParamsForSerialization(Object[] inputParams, MethodInvocationState mis, boolean async) {
        SOAPMethodInfo mi = mis.method.weakMethodInfo.getMethodInfo();
        Object[] rpcParams = new Object[mi.parts.length];
        List parameters = mis.method.parameters;
        int realParmIndex = 0;
        int inputParamIndex = 0;
        int size = rpcParams.length;
        boolean hasReturnValue = !mis.method.returnType.equals(Void.TYPE) && !mis.method.returnType.equals(Void.TYPE);
        boolean generateFirstOutAsReturn = mi.returnValuePart == null && mi.requestMessageEncodingURI == null && mi.parts.length == 2;
        boolean firstOutAsReturnGenerated = false;
        if (!async) {
            int i = 0;
            while (i < size) {
                SOAPMethodInfo.PartInfo p = mi.parts[i];
                if (generateFirstOutAsReturn && hasReturnValue && !firstOutAsReturnGenerated && p.partType == 2) {
                    firstOutAsReturnGenerated = true;
                    ++realParmIndex;
                } else if (p.partType == 3 && !p.isAttachment) {
                    Object v = inputParams[inputParamIndex];
                    rpcParams[realParmIndex] = new TopLevelReferenceHolder(v, this.getClass(parameters, p, v), p.inSchemaType);
                    ++realParmIndex;
                    ++inputParamIndex;
                } else if (p.partType == 2 && !p.isAttachment) {
                    rpcParams[realParmIndex] = new TopLevelReferenceHolder(this.getClass(parameters, p, null), p.outSchemaType);
                    ++realParmIndex;
                } else {
                    rpcParams[realParmIndex] = inputParams[inputParamIndex];
                    ++realParmIndex;
                    ++inputParamIndex;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < size) {
                org.idoox.wasp.types.MessageAttachment attin;
                org.idoox.wasp.types.MessageAttachment att;
                SOAPMethodInfo.PartInfo p = mi.parts[i];
                if (generateFirstOutAsReturn && hasReturnValue && !firstOutAsReturnGenerated && p.partType == 2) {
                    firstOutAsReturnGenerated = true;
                } else if (p.partType == 3) {
                    if (p.isAttachment) {
                        att = new org.idoox.wasp.types.MessageAttachment();
                        attin = (org.idoox.wasp.types.MessageAttachment)inputParams[inputParamIndex];
                        try {
                            att.setContentId(attin.getContentId());
                            att.setContentLocation(attin.getContentLocation());
                            att.setContentType(attin.getContentType());
                            att.setData(attin.getData());
                        }
                        catch (IOException e) {
                            throw new RuntimeWrappedException("Problem reading attachment", e);
                        }
                        rpcParams[realParmIndex] = att;
                    } else {
                        Object v = inputParams[inputParamIndex];
                        rpcParams[realParmIndex] = new TopLevelReferenceHolder(v, this.getClass(parameters, p, v), p.inSchemaType);
                    }
                    ++realParmIndex;
                    ++inputParamIndex;
                } else if (p.partType == 2) {
                    if (p.isAttachment) {
                        rpcParams[realParmIndex] = new org.idoox.wasp.types.ResponseMessageAttachment();
                        ++realParmIndex;
                    } else {
                        rpcParams[realParmIndex] = new TopLevelReferenceHolder(this.getClass(parameters, p, null), p.outSchemaType);
                        ++realParmIndex;
                    }
                } else {
                    if (p.isAttachment) {
                        att = new org.idoox.wasp.types.RequestMessageAttachment();
                        attin = (org.idoox.wasp.types.RequestMessageAttachment)inputParams[inputParamIndex];
                        try {
                            att.setContentId(attin.getContentId());
                            att.setContentLocation(attin.getContentLocation());
                            att.setContentType(attin.getContentType());
                            att.setData(attin.getData());
                        }
                        catch (IOException e) {
                            throw new RuntimeWrappedException("Problem reading attachment", e);
                        }
                        rpcParams[realParmIndex] = att;
                    } else {
                        rpcParams[realParmIndex] = inputParams[inputParamIndex];
                    }
                    ++realParmIndex;
                    ++inputParamIndex;
                }
                ++i;
            }
        }
        return rpcParams;
    }

    private Object[] prepareEndParamsForSerialization(MethodInvocationState mis) {
        SOAPMethodInfo mi = mis.method.weakMethodInfo.getMethodInfo();
        Object[] rpcParams = new Object[mi.parts.length];
        List parameters = mis.method.parameters;
        int realParmIndex = 0;
        int inputParamIndex = 0;
        int size = rpcParams.length;
        boolean hasReturnValue = !mis.method.returnType.equals(Void.TYPE) && !mis.method.returnType.equals(Void.TYPE);
        boolean generateFirstOutAsReturn = mi.returnValuePart == null && mi.requestMessageEncodingURI == null && mi.parts.length == 2;
        boolean firstOutAsReturnGenerated = false;
        int i = 0;
        while (i < size) {
            SOAPMethodInfo.PartInfo p = mi.parts[i];
            if (generateFirstOutAsReturn && hasReturnValue && !firstOutAsReturnGenerated && p.partType == 2) {
                firstOutAsReturnGenerated = true;
            } else if (p.partType == 3) {
                if (p.isAttachment) {
                    org.idoox.wasp.types.MessageAttachment att = new org.idoox.wasp.types.MessageAttachment();
                    rpcParams[realParmIndex] = att;
                } else {
                    rpcParams[realParmIndex] = new TopLevelReferenceHolder(this.getClass(parameters, p, null), p.outSchemaType);
                }
                ++realParmIndex;
                ++inputParamIndex;
            } else if (p.partType == 2) {
                if (p.isAttachment) {
                    rpcParams[realParmIndex] = new org.idoox.wasp.types.ResponseMessageAttachment();
                    ++realParmIndex;
                } else {
                    rpcParams[realParmIndex] = new TopLevelReferenceHolder(this.getClass(parameters, p, null), p.outSchemaType);
                    ++realParmIndex;
                }
            } else {
                rpcParams[realParmIndex] = null;
                ++realParmIndex;
                ++inputParamIndex;
            }
            ++i;
        }
        return rpcParams;
    }

    private Class getClass(List parameters, SOAPMethodInfo.PartInfo part, Object inValue) {
        if (inValue != null) {
            return inValue.getClass();
        }
        int s = parameters.size();
        int i = 0;
        while (i < s) {
            Parameter p = (Parameter)parameters.get(i);
            if (p.partName.equals(part.partName)) {
                return p.clazz;
            }
            ++i;
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = WaspCallImpl.class$("java.lang.Object")) : class$java$lang$Object;
    }

    private void serializeRequest(MethodInvocationState mis) throws RemoteException {
        int numOfParts = 0;
        SOAPMethodInfo methodInfo = mis.method.weakMethodInfo.getMethodInfo();
        int i = 0;
        while (i < methodInfo.parts.length) {
            if (methodInfo.parts[i].partType != 2) {
                ++numOfParts;
            } else if (methodInfo.parts[i].isAttachment) {
                ++numOfParts;
            }
            ++i;
        }
        Map contextData = Current.getCallContext().getContextData();
        contextData.put("java.methodName", mis.method.operationName);
        contextData.put("wasp.encodingID", mis.method.encodingId);
        contextData.put("wasp.encodingURI", mis.method.encoding);
        contextData.put("wasp.polymorphism", mis.method.doPolymorphism);
        try {
            WaspInternalSOAPMessage message = (WaspInternalSOAPMessage)this.messageFactory.createMessage();
            message.setEnvelopePrefix(((ServiceClientImpl)this.serviceClient).getEnvelopePrefix());
            message.setSOAPAction(methodInfo.soapAction);
            if (methodInfo.containsRequestAttachment) {
                message.setAttachmentType(methodInfo.useDime ? "application/dime" : "multipart/related");
            } else {
                message.setAttachmentType(null);
            }
            Map messageAttributes = message.getAttributes();
            messageAttributes.put("get.operationLocation", methodInfo.httpLocationURI);
            messageAttributes.put("get.operationEncoding", methodInfo.httpUriEncoding);
            SOAPPart soapPart = message.getSOAPPart();
            SOAPEnvelope envelope = soapPart.getEnvelope();
            boolean uddiEncoding = "UDDIClientEncoding".equals(this.encoding);
            if (!uddiEncoding) {
                if (Boolean.TRUE.equals(((ServiceClientImpl)this.serviceClient).getNamespaceOptimization())) {
                    boolean writeNamespaces = !methodInfo.isVoid();
                    Set namespaces = mis.method.schema.getNamespaces();
                    message.writeNamespaces(methodInfo, namespaces, writeNamespaces);
                    EnvelopeOutCache.prepareOutput(message, namespaces, methodInfo, writeNamespaces);
                }
            } else {
                this.doMultirefs = false;
                message.setEnvelopePrefix("");
            }
            SOAPBody body = envelope.getBody();
            boolean soap12operation = message.getXMLProtocol().equals("soap12");
            if (!soap12operation && mis.method.encoding != null && !uddiEncoding) {
                body.addAttribute(soapFactory.createName("encodingStyle", null, "http://schemas.xmlsoap.org/soap/envelope/"), mis.method.encoding);
            }
            mis.request = message;
            LazyFillingTokenizer lazyTokenizer = new LazyFillingTokenizer(new ClientLazySerializationHelper(mis, this.serializationID, this.doMultirefs, this.protocol), body);
            message.setLazyFillingTokenizer(lazyTokenizer);
            LazyFillingTokenizer bodyTokenizer = lazyTokenizer;
            ElementFinalizingTokenizerWrapper bodyTokenizerWithEnd = new ElementFinalizingTokenizerWrapper(new ElementFinalizingTokenizerWrapper(bodyTokenizer, body), envelope);
            ((SOAPElementContent)((Object)body)).setContent(bodyTokenizerWithEnd);
            message.startProcessing();
        }
        catch (SOAPException e) {
            throw new RemoteException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    private Object deserializeResponse(MethodInvocationState mis, CurrentImpl.ThreadLocals threadLocals) throws RemoteException {
        Object ret;
        try {
            if (((WaspInternalSOAPMessage)mis.response).hasFault(threadLocals.callContext)) {
                this.deserializeFault(mis, mis.response);
            }
            DeserializationContext dectx = serializationRepository.createDeserializationContext(this.serializationID, mis.method.encoding);
            dectx.setSchema(mis.method.schema, true);
            ret = this.readResponse(mis, dectx);
            ret = WaspCallImpl.readAttachments(ret, mis, dectx);
            if (ret != null && ret instanceof Reference) {
                ret = ((Reference)ret).getObjectValue();
            }
            Iterator i = dectx.getPostDeserializationHandlers();
            while (i.hasNext()) {
                PostDeserializationHandler h = (PostDeserializationHandler)i.next();
                h.deserializationFinished(dectx);
            }
            serializationRepository.releaseDeserializationContext(dectx);
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (IOException e) {
            this.closeConnection();
            throw new RemoteException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), e);
        }
        return ret;
    }

    static Object readAttachments(Object ret, MethodInvocationState mis, DeserializationContext deserContext) throws MessageProcessingException {
        block12: {
            SOAPMessage msg;
            block13: {
                Object[] parameters;
                msg = mis.response;
                Object protocol = Current.getCallContext().getContextData().get("wasp.xml.protocol");
                if (protocol == null || !"httpget".equals(protocol)) break block13;
                int counter = 0;
                GetClientAttachments attachments = new GetClientAttachments(msg);
                Class returnType = mis.method.returnType;
                if (returnType != null && (class$org$idoox$wasp$types$MessageAttachment == null ? (class$org$idoox$wasp$types$MessageAttachment = WaspCallImpl.class$("org.idoox.wasp.types.MessageAttachment")) : class$org$idoox$wasp$types$MessageAttachment).isAssignableFrom(returnType)) {
                    if (ret != null) {
                        ((org.idoox.wasp.types.MessageAttachment)ret).setAttachment(new ClientMessageAttachment(attachments, String.valueOf(counter++)));
                    } else {
                        ret = (class$org$idoox$wasp$RequestMessageAttachment == null ? (class$org$idoox$wasp$RequestMessageAttachment = WaspCallImpl.class$("org.idoox.wasp.RequestMessageAttachment")) : class$org$idoox$wasp$RequestMessageAttachment).isAssignableFrom(returnType) ? new RequestMessageAttachment() : ((class$org$idoox$wasp$ResponseMessageAttachment == null ? (class$org$idoox$wasp$ResponseMessageAttachment = WaspCallImpl.class$("org.idoox.wasp.ResponseMessageAttachment")) : class$org$idoox$wasp$ResponseMessageAttachment).isAssignableFrom(returnType) ? new ResponseMessageAttachment() : ((class$org$idoox$wasp$MessageAttachment == null ? (class$org$idoox$wasp$MessageAttachment = WaspCallImpl.class$("org.idoox.wasp.MessageAttachment")) : class$org$idoox$wasp$MessageAttachment).isAssignableFrom(returnType) ? new MessageAttachment() : ((class$org$idoox$wasp$types$RequestMessageAttachment == null ? (class$org$idoox$wasp$types$RequestMessageAttachment = WaspCallImpl.class$("org.idoox.wasp.types.RequestMessageAttachment")) : class$org$idoox$wasp$types$RequestMessageAttachment).isAssignableFrom(returnType) ? new org.idoox.wasp.types.RequestMessageAttachment() : ((class$org$idoox$wasp$types$ResponseMessageAttachment == null ? (class$org$idoox$wasp$types$ResponseMessageAttachment = WaspCallImpl.class$("org.idoox.wasp.types.ResponseMessageAttachment")) : class$org$idoox$wasp$types$ResponseMessageAttachment).isAssignableFrom(returnType) ? new org.idoox.wasp.types.ResponseMessageAttachment() : new org.idoox.wasp.types.MessageAttachment()))));
                        ((org.idoox.wasp.types.MessageAttachment)ret).setAttachment(new ClientMessageAttachment(attachments, String.valueOf(counter++)));
                    }
                }
                if ((parameters = mis.params) == null) break block12;
                int i = 0;
                while (i < parameters.length) {
                    Object parameter = parameters[i];
                    if (parameter != null && parameter instanceof org.idoox.wasp.types.MessageAttachment) {
                        ((org.idoox.wasp.types.MessageAttachment)parameter).setAttachment(new ClientMessageAttachment(attachments, String.valueOf(counter++)));
                    }
                    ++i;
                }
                break block12;
            }
            Iterator attachmentHolders = deserContext.getRemoteReferences();
            ClientAttachments attachments = new ClientAttachments(msg);
            while (attachmentHolders.hasNext()) {
                Holder attachmentHolder;
                Map.Entry h = (Map.Entry)attachmentHolders.next();
                String attachmentId = (String)h.getKey();
                if ((class$com$idoox$wasp$serialization$ArrayItemReferenceIface == null ? WaspCallImpl.class$("com.idoox.wasp.serialization.ArrayItemReferenceIface") : class$com$idoox$wasp$serialization$ArrayItemReferenceIface).isAssignableFrom((attachmentHolder = (Holder)h.getValue()).getClass())) {
                    Class clazz;
                    if (!(class$org$idoox$wasp$types$MessageAttachment == null ? WaspCallImpl.class$("org.idoox.wasp.types.MessageAttachment") : class$org$idoox$wasp$types$MessageAttachment).isAssignableFrom(clazz = attachmentHolder.getValueClass())) break;
                    org.idoox.wasp.types.MessageAttachment att = null;
                    try {
                        att = (org.idoox.wasp.types.MessageAttachment)clazz.newInstance();
                    }
                    catch (Exception e) {
                        throw new RuntimeWrappedException(e);
                    }
                    ClientMessageAttachment attach = new ClientMessageAttachment(attachments, attachmentId);
                    att.setAttachment(attach);
                    attachmentHolder.setObjectValue(att);
                    continue;
                }
                if ((class$com$idoox$wasp$serialization$attachments$AttachmentReference == null ? WaspCallImpl.class$("com.idoox.wasp.serialization.attachments.AttachmentReference") : class$com$idoox$wasp$serialization$attachments$AttachmentReference).isAssignableFrom(attachmentHolder.getClass())) {
                    org.idoox.wasp.types.MessageAttachment att = (org.idoox.wasp.types.MessageAttachment)attachmentHolder.getObjectValue();
                    att.setAttachment(new ClientMessageAttachment(attachments, attachmentId));
                    continue;
                }
                if (attachmentHolder.getValueClass() == null) {
                    throw new MessageProcessingException("null can not be passed for MessageAttachment");
                }
                if ((class$org$idoox$wasp$types$MessageAttachment == null ? WaspCallImpl.class$("org.idoox.wasp.types.MessageAttachment") : class$org$idoox$wasp$types$MessageAttachment).isAssignableFrom(attachmentHolder.getValueClass())) {
                    attachmentHolder.setObjectValue(new ClientMessageAttachment(attachments, attachmentId));
                    continue;
                }
                ClientMessageAttachment attach = new ClientMessageAttachment(attachments, attachmentId);
                attachmentHolder.setObjectValue(attach);
            }
        }
        return ret;
    }

    private Object readResponse(MethodInvocationState mis, DeserializationContext dectx) throws MessageProcessingException, TokenizerException, IOException, NoSuchEncodingException, SOAPException {
        boolean useEncoding;
        EncodingTokenizer encodingTokenizer = null;
        SOAPMethodInfo methodInfo = mis.method.weakMethodInfo.getMethodInfo();
        String encURI = mis.method.encoding;
        Tokenizer bodyTokenizer = ((WaspInternalSOAPMessage)mis.response).getBodyTokenzier();
        if (encURI != null) {
            useEncoding = true;
            encodingTokenizer = encodingRepository.getEncodingTokenizer(mis.method.encodingId, encURI);
            try {
                byte token;
                while ((token = bodyTokenizer.next()) == 4) {
                }
                if (token == 1) {
                    throw new MessageProcessingException("Invalid message.");
                }
                encodingTokenizer.setInput(bodyTokenizer, this.serviceClient.getServiceURL());
            }
            catch (LookupException e) {
                throw new MessageProcessingException(e);
            }
        } else {
            useEncoding = false;
        }
        int tok = this.skipOperationStart(methodInfo.rpcOperation, useEncoding, bodyTokenizer, encodingTokenizer);
        this.setClassLoader(mis, dectx);
        Object ret = null;
        ret = useEncoding ? this.deserializeFromEncoding(tok, encodingTokenizer, methodInfo, mis.method.returnType, mis.params, dectx, this.protocol.equals("soap12")) : this.deserializeFromXml(tok, bodyTokenizer, methodInfo, mis.method.returnType, mis.params, dectx, this.protocol.equals("soap12"));
        if (methodInfo.responseMessageEncodingURI != null) {
            if (useEncoding) {
                if (encodingTokenizer.getCurrentToken() != 0) {
                    this.deserializeReferences(encodingTokenizer, dectx);
                }
            } else {
                this.deserializeReferences(bodyTokenizer, dectx);
            }
            dectx.resolveLocalReferences();
        }
        if (useEncoding) {
            encodingRepository.releaseEncodingTokenizer(mis.method.encodingId, encURI, encodingTokenizer);
        }
        this.methodInfo = mis.method.weakMethodInfo.getMethodInfo();
        return ret;
    }

    private void setClassLoader(MethodInvocationState mis, DeserializationContext dectx) {
        this.classLoader = this.getClassLoader(mis);
        dectx.setClassLoader(this.classLoader);
    }

    private ClassLoader getClassLoader(MethodInvocationState mis) {
        ClassLoader classLoader = this.classLoader;
        if (classLoader == null) {
            int i = 0;
            while (mis.params.length > i) {
                if (mis.params[i] != null) {
                    classLoader = mis.params[i].getClass().getClassLoader();
                    break;
                }
                ++i;
            }
        }
        if (classLoader == null && mis.method.returnType != null) {
            classLoader = mis.method.returnType.getClassLoader();
        }
        return classLoader;
    }

    private int skipOperationStart(boolean rpcOperation, boolean useEncoding, Tokenizer bodyTokenizer, EncodingTokenizer encodingTokenizer) throws MessageProcessingException, IOException, TokenizerException {
        int tok;
        if (rpcOperation) {
            if (useEncoding) {
                tok = encodingTokenizer.nextToken();
                if (tok != 1 && tok != 4) {
                    throw new RuntimeException("No request/response in message [no operation], token " + EncodingToken.tokenNames[tok] + ", " + encodingTokenizer.getTokenName());
                }
                if (tok == 4) {
                    return 2;
                }
                tok = encodingTokenizer.next();
            } else {
                tok = SerializationHelper.nextNonWhitespace(bodyTokenizer);
                if (tok != 2) {
                    throw new RuntimeException("No response in message (no operation), token " + EncodingToken.tokenNames[tok] + ", " + bodyTokenizer.getLocalName());
                }
                tok = SerializationHelper.nextNonWhitespace(bodyTokenizer);
            }
        } else if (useEncoding) {
            tok = encodingTokenizer.next();
        } else {
            tok = SerializationHelper.nextNonWhitespace(bodyTokenizer);
            if (tok == 1) {
                return tok;
            }
        }
        return tok;
    }

    private Object deserializeFromXml(int tok, Tokenizer bodyTokenizer, SOAPMethodInfo methodInfo, Class returnValue, Object[] params, DeserializationContext dectx, boolean soap12operation) throws IOException, TokenizerException, MessageProcessingException {
        Object ret = null;
        boolean firstResponseParam = true;
        String presumedReturnParamName = null;
        String presumedReturnParamNamespace = null;
        String expectedReturnParamName = null;
        String expectedReturnParamNamespace = null;
        boolean fakeReturn = false;
        if (!methodInfo.rpcOperation && methodInfo.outWrapperQName != null) {
            tok = SerializationHelper.nextNonWhitespace(bodyTokenizer);
        }
        SOAPMethodInfo.RequiredElements requiredElements = null;
        SOAPMethodInfo.RequiredElements.Invocation invocation = null;
        if (!methodInfo.rpcOperation) {
            requiredElements = methodInfo.getRequiredOutElements();
            invocation = requiredElements.newInvocation();
        }
        while (tok != 3) {
            int argPos;
            int retPos;
            boolean isReturn;
            String paramNamespace;
            String paramName;
            block43: {
                block44: {
                    block46: {
                        block45: {
                            paramName = bodyTokenizer.getLocalName();
                            paramNamespace = bodyTokenizer.getNamespace();
                            if ("result".equals(paramName) && Namespaces.SOAP12_RPC_NS.equals(paramNamespace)) {
                                if (expectedReturnParamName != null) {
                                    throw new MessageProcessingException("Duplicate SOAP 1.2 rpc:result accessor");
                                }
                                QName returnParamQName = this.deserializeResultXML(bodyTokenizer);
                                expectedReturnParamName = returnParamQName.getLocalPart();
                                expectedReturnParamNamespace = returnParamQName.getNamespaceURI();
                                if (presumedReturnParamName != null) {
                                    if (presumedReturnParamNamespace == null) {
                                        presumedReturnParamNamespace = "";
                                    }
                                    if (expectedReturnParamNamespace == null) {
                                        expectedReturnParamNamespace = "";
                                    }
                                    if (!presumedReturnParamName.equals(expectedReturnParamName) || !presumedReturnParamNamespace.equals(expectedReturnParamNamespace)) {
                                        throw new MessageProcessingException("Unmatched out parameter " + presumedReturnParamName + " in SOAP call. Declared parameters : " + this.formatParameters(methodInfo));
                                    }
                                }
                                tok = SerializationHelper.nextNonWhitespace(bodyTokenizer);
                                firstResponseParam = false;
                                continue;
                            }
                            if (!methodInfo.rpcOperation) {
                                QName elementQName = new QName(paramNamespace, paramName);
                                bodyTokenizer.readToken(this.token);
                                boolean nillable = false;
                                int i = 0;
                                while (i < this.token.getAttributeCount()) {
                                    Attribute attribute = this.token.getAttribute(i);
                                    if (attribute.localName.equals("nil") && attribute.value.equals("true")) {
                                        invocation.nillElement(elementQName);
                                        nillable = true;
                                        break;
                                    }
                                    ++i;
                                }
                                if (!nillable) {
                                    invocation.notNillElement(elementQName);
                                }
                            }
                            isReturn = false;
                            retPos = -1;
                            if (returnValue == null || returnValue.equals(class$java$lang$Void == null ? WaspCallImpl.class$("java.lang.Void") : class$java$lang$Void) || returnValue.equals(Void.TYPE)) break block43;
                            if (methodInfo.returnValuePart == null) break block44;
                            if (!methodInfo.rpcOperation) break block45;
                            if (firstResponseParam && !soap12operation) {
                                if (methodInfo.returnValuePart != null && methodInfo.returnValuePart.partName.equals(paramName)) {
                                    isReturn = true;
                                } else {
                                    ret = null;
                                }
                            }
                            firstResponseParam = false;
                            break block43;
                        }
                        if (methodInfo.returnValuePart.outSchemaElement == null) break block46;
                        if (paramName.equals(methodInfo.returnValuePart.outSchemaElement.getName().getLocalPart())) {
                            isReturn = true;
                        }
                        break block43;
                    }
                    if (!paramName.equals(methodInfo.returnValuePart.partName)) break block43;
                    isReturn = true;
                    break block43;
                }
                if (firstResponseParam) {
                    argPos = 0;
                    while (argPos < methodInfo.parts.length) {
                        if (methodInfo.parts[argPos].outSchemaElement != null && methodInfo.parts[argPos].outSchemaElement.getName().getLocalPart().equals(paramName) && methodInfo.parts[argPos].partType == 2) {
                            isReturn = true;
                            retPos = argPos;
                            fakeReturn = true;
                            firstResponseParam = false;
                            break;
                        }
                        ++argPos;
                    }
                }
            }
            argPos = 0;
            int outArgPos = 0;
            if (!isReturn) {
                argPos = 0;
                while (argPos < methodInfo.parts.length) {
                    if (methodInfo.parts[argPos].outSchemaElement == null ? paramName.equals(methodInfo.parts[argPos].partName) : paramName.equals(methodInfo.parts[argPos].outSchemaElement.getName().getLocalPart())) break;
                    if ((methodInfo.parts[argPos].partType & 2) != 0) {
                        ++outArgPos;
                    }
                    ++argPos;
                }
                if (argPos == methodInfo.parts.length) {
                    paramName = WaspSerializationHelper.mapElementName(paramName);
                    outArgPos = 0;
                    argPos = 0;
                    while (argPos < methodInfo.parts.length) {
                        if (methodInfo.parts[argPos].outSchemaElement == null ? paramName.equals(methodInfo.parts[argPos].partName) : paramName.equals(methodInfo.parts[argPos].outSchemaElement.getName().getLocalPart())) break;
                        if ((methodInfo.parts[argPos].partType & 2) != 0) {
                            ++outArgPos;
                        }
                        ++argPos;
                    }
                    if (argPos == methodInfo.parts.length) {
                        if (soap12operation && presumedReturnParamName == null) {
                            if (expectedReturnParamName != null && (!expectedReturnParamName.equals(paramName) || expectedReturnParamNamespace == null && paramNamespace != null || expectedReturnParamNamespace != null && !expectedReturnParamNamespace.equals(paramNamespace))) {
                                throw new MessageProcessingException("Unmatched out parameter " + paramName + " in SOAP call. Declared parameters : " + this.formatParameters(methodInfo));
                            }
                            presumedReturnParamName = paramName;
                            presumedReturnParamNamespace = paramNamespace;
                            isReturn = true;
                        } else {
                            throw new MessageProcessingException("Unmatched out parameter " + paramName + (presumedReturnParamName != null ? " or " + presumedReturnParamName : "") + " in SOAP call. Declared parameters : " + this.formatParameters(methodInfo));
                        }
                    }
                }
            }
            if (!isReturn) {
                int pos = argPos;
                if (fakeReturn && pos != 0) {
                    if (params[pos - 1] != null && params[pos - 1] instanceof org.idoox.wasp.types.MessageAttachment) {
                        WaspSerializationHelper.deserializeMessageAttachment(bodyTokenizer, (org.idoox.wasp.types.MessageAttachment)params[pos - 1], dectx);
                    } else {
                        WaspSerializationHelper.deserializeHolder(bodyTokenizer, params[pos - 1], dectx, methodInfo.parts[argPos].outSchemaType, methodInfo.parts[argPos].outSchemaElement);
                    }
                } else if (params[pos] != null && params[pos] instanceof org.idoox.wasp.types.MessageAttachment) {
                    WaspSerializationHelper.deserializeMessageAttachment(bodyTokenizer, (org.idoox.wasp.types.MessageAttachment)params[pos], dectx);
                } else {
                    WaspSerializationHelper.deserializeHolder(bodyTokenizer, params[pos], dectx, methodInfo.parts[argPos].outSchemaType, methodInfo.parts[argPos].outSchemaElement);
                }
            }
            if (isReturn) {
                if (returnValue != null && (class$org$idoox$wasp$types$MessageAttachment == null ? WaspCallImpl.class$("org.idoox.wasp.types.MessageAttachment") : class$org$idoox$wasp$types$MessageAttachment).isAssignableFrom(returnValue)) {
                    ret = (class$org$idoox$wasp$RequestMessageAttachment == null ? WaspCallImpl.class$("org.idoox.wasp.RequestMessageAttachment") : class$org$idoox$wasp$RequestMessageAttachment).isAssignableFrom(returnValue) ? new RequestMessageAttachment() : ((class$org$idoox$wasp$ResponseMessageAttachment == null ? WaspCallImpl.class$("org.idoox.wasp.ResponseMessageAttachment") : class$org$idoox$wasp$ResponseMessageAttachment).isAssignableFrom(returnValue) ? new ResponseMessageAttachment() : ((class$org$idoox$wasp$MessageAttachment == null ? WaspCallImpl.class$("org.idoox.wasp.MessageAttachment") : class$org$idoox$wasp$MessageAttachment).isAssignableFrom(returnValue) ? new MessageAttachment() : ((class$org$idoox$wasp$types$RequestMessageAttachment == null ? WaspCallImpl.class$("org.idoox.wasp.types.RequestMessageAttachment") : class$org$idoox$wasp$types$RequestMessageAttachment).isAssignableFrom(returnValue) ? new org.idoox.wasp.types.RequestMessageAttachment() : ((class$org$idoox$wasp$types$ResponseMessageAttachment == null ? WaspCallImpl.class$("org.idoox.wasp.types.ResponseMessageAttachment") : class$org$idoox$wasp$types$ResponseMessageAttachment).isAssignableFrom(returnValue) ? new org.idoox.wasp.types.ResponseMessageAttachment() : new org.idoox.wasp.types.MessageAttachment()))));
                    WaspSerializationHelper.deserializeMessageAttachment(bodyTokenizer, (org.idoox.wasp.types.MessageAttachment)ret, dectx);
                } else {
                    ret = retPos < 0 ? WaspSerializationHelper.deserialize(bodyTokenizer, returnValue, dectx, methodInfo.returnValuePart.outSchemaType, methodInfo.returnValuePart.outSchemaElement) : WaspSerializationHelper.deserialize(bodyTokenizer, returnValue, dectx, methodInfo.parts[retPos].outSchemaType, methodInfo.parts[retPos].outSchemaElement);
                }
            }
            tok = SerializationHelper.nextNonWhitespace(bodyTokenizer);
        }
        if (!methodInfo.rpcOperation) {
            invocation.endInvocation();
        }
        if (!methodInfo.rpcOperation && methodInfo.outWrapperQName != null) {
            tok = SerializationHelper.nextNonWhitespace(bodyTokenizer);
        }
        if (soap12operation && (presumedReturnParamName != null && (!presumedReturnParamName.equals(expectedReturnParamName) || presumedReturnParamNamespace != null && !presumedReturnParamNamespace.equals(expectedReturnParamNamespace) || presumedReturnParamNamespace == null && expectedReturnParamNamespace != null) || expectedReturnParamName != null && presumedReturnParamName == null)) {
            throw new MessageProcessingException("Invalid SOAP 1.2 return value accessor " + expectedReturnParamName + ", return value present: " + presumedReturnParamName + ". Declared parameters : " + this.formatParameters(methodInfo));
        }
        return ret;
    }

    private Object deserializeFromEncoding(int tok, EncodingTokenizer encodingTokenizer, SOAPMethodInfo methodInfo, Class returnValue, Object[] params, DeserializationContext dectx, boolean soap12operation) throws MessageProcessingException, IOException, TokenizerException {
        Object ret = null;
        boolean firstResponseParam = true;
        String presumedReturnParamName = null;
        String presumedReturnParamNamespace = null;
        String expectedReturnParamName = null;
        String expectedReturnParamNamespace = null;
        boolean fakeReturn = false;
        while (methodInfo.rpcOperation && tok != 2 || !methodInfo.rpcOperation && tok != 0) {
            int argPos;
            int retPos;
            boolean isReturn;
            String paramNamespace;
            String paramName;
            block25: {
                block26: {
                    block28: {
                        block27: {
                            paramName = encodingTokenizer.getTokenName();
                            paramNamespace = encodingTokenizer.getTokenNamespaceURI();
                            if ("result".equals(paramName) && Namespaces.SOAP12_RPC_NS.equals(paramNamespace)) {
                                if (expectedReturnParamName != null) {
                                    throw new MessageProcessingException("Duplicate SOAP 1.2 rpc:result accessor");
                                }
                                QName returnParamQName = encodingTokenizer.convertToQName(encodingTokenizer.getPrimitiveTokenValue());
                                expectedReturnParamName = returnParamQName.getLocalPart();
                                expectedReturnParamNamespace = returnParamQName.getNamespaceURI();
                                if (presumedReturnParamName != null && (!presumedReturnParamName.equals(expectedReturnParamName) || presumedReturnParamNamespace == null && expectedReturnParamNamespace != null || presumedReturnParamNamespace != null && !presumedReturnParamNamespace.equals(expectedReturnParamNamespace))) {
                                    throw new MessageProcessingException("Unmatched out parameter " + presumedReturnParamName + " in SOAP call. Declared parameters : " + this.formatParameters(methodInfo));
                                }
                                tok = encodingTokenizer.next();
                                firstResponseParam = false;
                                continue;
                            }
                            isReturn = false;
                            retPos = -1;
                            if (returnValue == null || returnValue.equals(class$java$lang$Void == null ? WaspCallImpl.class$("java.lang.Void") : class$java$lang$Void) || returnValue.equals(Void.TYPE)) break block25;
                            if (methodInfo.returnValuePart == null) break block26;
                            if (!methodInfo.rpcOperation) break block27;
                            isReturn = firstResponseParam && !soap12operation;
                            break block25;
                        }
                        if (methodInfo.returnValuePart.outSchemaElement == null) break block28;
                        if (paramName.equals(methodInfo.returnValuePart.outSchemaElement.getName().getLocalPart())) {
                            isReturn = true;
                        }
                        break block25;
                    }
                    if (!paramName.equals(methodInfo.returnValuePart.partName)) break block25;
                    isReturn = true;
                    break block25;
                }
                if (firstResponseParam) {
                    argPos = 0;
                    while (argPos < methodInfo.parts.length) {
                        if (methodInfo.parts[argPos].partName.equals(paramName) && methodInfo.parts[argPos].partType == 2) {
                            isReturn = true;
                            retPos = argPos;
                            fakeReturn = true;
                            firstResponseParam = false;
                            break;
                        }
                        ++argPos;
                    }
                }
            }
            argPos = 0;
            int outArgPos = 0;
            if (!isReturn) {
                argPos = 0;
                while (argPos < methodInfo.parts.length) {
                    if (methodInfo.parts[argPos].outSchemaElement == null ? paramName.equals(methodInfo.parts[argPos].partName) : paramName.equals(methodInfo.parts[argPos].outSchemaElement.getName().getLocalPart())) break;
                    if ((methodInfo.parts[argPos].partType & 2) != 0) {
                        ++outArgPos;
                    }
                    ++argPos;
                }
                if (argPos == methodInfo.parts.length) {
                    String mappedParamName = WaspSerializationHelper.mapElementName(paramName);
                    outArgPos = 0;
                    argPos = 0;
                    while (argPos < methodInfo.parts.length) {
                        if (methodInfo.parts[argPos].outSchemaElement == null ? mappedParamName.equals(methodInfo.parts[argPos].partName) : mappedParamName.equals(methodInfo.parts[argPos].outSchemaElement.getName().getLocalPart())) break;
                        if ((methodInfo.parts[argPos].partType & 2) != 0) {
                            ++outArgPos;
                        }
                        ++argPos;
                    }
                    if (argPos == methodInfo.parts.length) {
                        if (soap12operation && presumedReturnParamName == null) {
                            if (expectedReturnParamName != null && (!expectedReturnParamName.equals(paramName) || expectedReturnParamNamespace == null && paramNamespace != null || expectedReturnParamNamespace != null && !expectedReturnParamNamespace.equals(paramNamespace))) {
                                throw new MessageProcessingException("Unmatched out parameter " + paramName + " in SOAP call. Declared parameters : " + this.formatParameters(methodInfo));
                            }
                            presumedReturnParamName = paramName;
                            presumedReturnParamNamespace = paramNamespace;
                            isReturn = true;
                        } else {
                            throw new MessageProcessingException("Unmatched out parameter " + paramName + (presumedReturnParamName != null ? " or " + presumedReturnParamName : "") + " in SOAP call. Declared parameters : " + this.formatParameters(methodInfo));
                        }
                    }
                }
            }
            if (isReturn) {
                if (returnValue != null && (class$org$idoox$wasp$types$MessageAttachment == null ? WaspCallImpl.class$("org.idoox.wasp.types.MessageAttachment") : class$org$idoox$wasp$types$MessageAttachment).isAssignableFrom(returnValue)) {
                    ret = (class$org$idoox$wasp$RequestMessageAttachment == null ? WaspCallImpl.class$("org.idoox.wasp.RequestMessageAttachment") : class$org$idoox$wasp$RequestMessageAttachment).isAssignableFrom(returnValue) ? new RequestMessageAttachment() : ((class$org$idoox$wasp$ResponseMessageAttachment == null ? WaspCallImpl.class$("org.idoox.wasp.ResponseMessageAttachment") : class$org$idoox$wasp$ResponseMessageAttachment).isAssignableFrom(returnValue) ? new ResponseMessageAttachment() : ((class$org$idoox$wasp$MessageAttachment == null ? WaspCallImpl.class$("org.idoox.wasp.MessageAttachment") : class$org$idoox$wasp$MessageAttachment).isAssignableFrom(returnValue) ? new MessageAttachment() : ((class$org$idoox$wasp$types$RequestMessageAttachment == null ? WaspCallImpl.class$("org.idoox.wasp.types.RequestMessageAttachment") : class$org$idoox$wasp$types$RequestMessageAttachment).isAssignableFrom(returnValue) ? new org.idoox.wasp.types.RequestMessageAttachment() : ((class$org$idoox$wasp$types$ResponseMessageAttachment == null ? WaspCallImpl.class$("org.idoox.wasp.types.ResponseMessageAttachment") : class$org$idoox$wasp$types$ResponseMessageAttachment).isAssignableFrom(returnValue) ? new org.idoox.wasp.types.ResponseMessageAttachment() : new org.idoox.wasp.types.MessageAttachment()))));
                    WaspSerializationHelper.deserializeMessageAttachment(encodingTokenizer, (org.idoox.wasp.types.MessageAttachment)ret, dectx);
                } else {
                    ret = retPos < 0 ? WaspSerializationHelper.deserialize(encodingTokenizer, returnValue, dectx, methodInfo.returnValuePart.outSchemaType, methodInfo.returnValuePart.outSchemaElement) : WaspSerializationHelper.deserialize(encodingTokenizer, returnValue, dectx, methodInfo.parts[retPos].outSchemaType, methodInfo.parts[retPos].outSchemaElement);
                }
            } else if (params[argPos] != null && params[argPos] instanceof org.idoox.wasp.types.MessageAttachment) {
                WaspSerializationHelper.deserializeMessageAttachment(encodingTokenizer, (org.idoox.wasp.types.MessageAttachment)params[argPos], dectx);
            } else {
                WaspSerializationHelper.deserializeHolder(encodingTokenizer, params[argPos], dectx, methodInfo.parts[argPos].outSchemaType, methodInfo.parts[argPos].outSchemaElement);
            }
            tok = encodingTokenizer.next();
            firstResponseParam = false;
        }
        if (soap12operation && (presumedReturnParamName != null && (!presumedReturnParamName.equals(expectedReturnParamName) || presumedReturnParamNamespace != null && !presumedReturnParamNamespace.equals(expectedReturnParamNamespace) || presumedReturnParamNamespace == null && expectedReturnParamNamespace != null) || expectedReturnParamName != null && presumedReturnParamName == null)) {
            throw new MessageProcessingException("Invalid SOAP 1.2 return value accessor " + expectedReturnParamName + ", return value present: " + presumedReturnParamName + ". Declared parameters : " + this.formatParameters(methodInfo));
        }
        return ret;
    }

    public void deserializeReferences(EncodingTokenizer tokenizer, DeserializationContext deserContext) throws MessageProcessingException, TokenizerException, IOException {
        try {
            int tok = tokenizer.next();
            LinkedList<CachedEncodingTokenizer> cachingTokenizers = null;
            while (tok != 0 && tok != 2) {
                String id = tokenizer.getID();
                if (id == null) {
                    throw new RuntimeException("no id for element {" + tokenizer.getTokenNamespaceURI() + "}" + tokenizer.getTokenName());
                }
                Class deserializationClass = deserContext.getReferencedClass(id);
                if (deserializationClass == null) {
                    CachedEncodingTokenizer et = new CachedEncodingTokenizer();
                    et.fill(tokenizer);
                    if (cachingTokenizers == null) {
                        cachingTokenizers = new LinkedList<CachedEncodingTokenizer>();
                    }
                    cachingTokenizers.add(et);
                    tok = tokenizer.getCurrentToken();
                    continue;
                }
                this.deserializeOneReference(deserContext, tokenizer, deserializationClass, id);
                tok = tokenizer.getCurrentToken();
                if (tok == 0) continue;
                tok = tokenizer.next();
            }
            boolean somethingDeserialized = true;
            if (cachingTokenizers != null) {
                while (cachingTokenizers.size() > 0 && somethingDeserialized) {
                    somethingDeserialized = false;
                    Iterator i = cachingTokenizers.iterator();
                    while (i.hasNext()) {
                        EncodingTokenizer cachedTokenizer = (EncodingTokenizer)i.next();
                        String id = cachedTokenizer.getID();
                        Class deserializationClass = deserContext.getReferencedClass(id);
                        if (deserializationClass == null) continue;
                        this.deserializeOneReference(deserContext, cachedTokenizer, deserializationClass, id);
                        somethingDeserialized = true;
                        i.remove();
                    }
                }
                if (cachingTokenizers.size() > 0) {
                    throw new RuntimeException("No reference for id " + ((EncodingTokenizer)cachingTokenizers.get(0)).getID());
                }
            }
        }
        catch (SchemaException e) {
            throw new MessageProcessingException(e);
        }
    }

    private void deserializeReferences(Tokenizer tokenizer, DeserializationContext deserContext) throws MessageProcessingException, TokenizerException, IOException {
        try {
            byte tok = tokenizer.currentState();
            if (tok != 1) {
                tok = SerializationHelper.nextNonWhitespace(tokenizer);
            }
            LinkedList<CachingTokenizer> cachingTokenizers = null;
            Token currentToken = TokenPool.getToken();
            while (tok != 1 && tok != 3) {
                if (tok == 4) continue;
                tokenizer.readToken(currentToken);
                String id = SerializationHelper.getId(currentToken);
                if (id == null) {
                    throw new RuntimeException("no id for element {" + tokenizer.getNamespace() + "}" + tokenizer.getLocalName());
                }
                Class deserializationClass = deserContext.getReferencedClass(id);
                if (deserializationClass == null) {
                    CachingTokenizer et = new CachingTokenizer();
                    et.init(tokenizer);
                    et.fillCache();
                    if (cachingTokenizers == null) {
                        cachingTokenizers = new LinkedList<CachingTokenizer>();
                    }
                    cachingTokenizers.add(et);
                    tok = SerializationHelper.nextNonWhitespace(tokenizer);
                    continue;
                }
                this.deserializeOneReference(deserContext, tokenizer, currentToken, deserializationClass, id);
                tok = SerializationHelper.nextNonWhitespace(tokenizer);
            }
            boolean somethingDeserialized = true;
            if (cachingTokenizers != null) {
                while (cachingTokenizers.size() > 0 && somethingDeserialized) {
                    somethingDeserialized = false;
                    Iterator i = cachingTokenizers.iterator();
                    while (i.hasNext()) {
                        Tokenizer cachedTokenizer = (Tokenizer)i.next();
                        cachedTokenizer.readToken(currentToken);
                        String id = SerializationHelper.getId(currentToken);
                        Class deserializationClass = deserContext.getReferencedClass(id);
                        if (deserializationClass == null) continue;
                        this.deserializeOneReference(deserContext, cachedTokenizer, currentToken, deserializationClass, id);
                        somethingDeserialized = true;
                        i.remove();
                    }
                }
                if (cachingTokenizers.size() > 0) {
                    ((Tokenizer)cachingTokenizers.get(0)).readToken(currentToken);
                    throw new RuntimeException("No reference for id " + SerializationHelper.getId(currentToken));
                }
            }
            TokenPool.releaseToken(currentToken);
        }
        catch (SchemaException e) {
            throw new MessageProcessingException(e);
        }
    }

    private void deserializeOneReference(DeserializationContext deserContext, Tokenizer tokenizer, Token currentToken, Class deserializationClass, String id) throws SchemaException, MessageProcessingException {
        Type type = deserContext.getReferencedSchemaType(id);
        Member m = new Member(new QName("", "item"), type);
        try {
            WaspSerializationHelper.deserialize(tokenizer, deserializationClass, deserContext, type, m);
        }
        catch (Exception e) {
            throw new MessageProcessingException(e);
        }
    }

    private void deserializeOneReference(DeserializationContext deserContext, EncodingTokenizer tokenizer, Class deserializationClass, String id) throws SchemaException, MessageProcessingException {
        Type type = deserContext.getReferencedSchemaType(id);
        String typeNamespaceURI = tokenizer.getTokenTypeNamespaceURI();
        String typeName = tokenizer.getTokenTypeName();
        QName xsiType = null;
        if (typeName != null && typeName.length() > 0) {
            xsiType = new QName(typeNamespaceURI, typeName);
        } else if (type == null) {
            xsiType = deserContext.getSchemaType(deserializationClass.getName());
        }
        if (xsiType == null && type == null) {
            throw new MessageProcessingException("No type for reference. use xsi:type or explicit mapping in configuration.");
        }
        if (xsiType != null) {
            try {
                type = deserContext.getSchemaType(xsiType);
            }
            catch (SchemaException e) {
                throw new MessageProcessingException(e);
            }
        }
        Member m = new Member(new QName("", "item"), type);
        try {
            WaspSerializationHelper.deserialize(tokenizer, deserializationClass, deserContext, type, m);
        }
        catch (Exception e) {
            throw new MessageProcessingException(e);
        }
    }

    private String formatParameters(SOAPMethodInfo methodInfo) {
        StringBuffer out = new StringBuffer();
        boolean comma = false;
        if (methodInfo.returnValuePart != null) {
            comma = true;
            out.append(methodInfo.returnValuePart.partName);
            out.append("[" + methodInfo.returnValuePart.outSchemaElement + "]");
        }
        int i = 0;
        while (i < methodInfo.parts.length) {
            if (methodInfo.parts[i].partType != 1) {
                if (comma) {
                    out.append(", ");
                } else {
                    comma = true;
                }
                out.append(methodInfo.parts[i].partName);
                out.append("[" + methodInfo.parts[i].outSchemaElement + "]");
            }
            ++i;
        }
        return out.toString();
    }

    private QName deserializeResultXML(Tokenizer tok) throws MessageProcessingException, TokenizerException, IOException {
        String value = SerializationHelper.readTextContent(tok);
        if (value == null) {
            throw new MessageProcessingException("malformed content of SOAP 1.2 rpc:result element");
        }
        QName retval = tok.parseQName(value);
        byte token = tok.currentState();
        while (token != 3 && token != 1) {
            if (token == 2) {
                this.skipUnknownElement(tok);
            }
            token = tok.next();
        }
        return retval;
    }

    private void deserializeFault(MethodInvocationState mis, SOAPMessage response) throws RemoteException {
        Exception e = null;
        ServiceClientImpl serviceClientImpl = (ServiceClientImpl)this.serviceClient;
        ClassLoader classloader = this.getClassLoader(mis);
        this.setClassLoader(classloader);
        String faultSerializationID = serviceClientImpl.getFaultSerializationID();
        try {
            FaultDeserializationHelper faultHelper = new FaultDeserializationHelper(this, serializationRepository, encodingRepository, this.serializationID, this.encodingID, faultSerializationID, mis.method.schema, serviceClientImpl.getEncoding() != null, classloader);
            e = faultHelper.deserializeFault(mis, response);
        }
        catch (Throwable e1) {
            dbg.warn("Unable to deserialize fault according to WSDL:" + response.getSOAPPart() + " Caused by:", e1);
        }
        try {
            if (e == null) {
                Message msg = MessageConvertor.convertSOAPMessage((WaspSOAPMessage)response, true, false);
                e = FaultSerializationHelper.deserializeFault(faultSerializationID, msg.getFault());
            }
        }
        catch (Throwable e1) {
            StringBuffer msg = new StringBuffer("Unable to read server response.");
            if (this.statusCode > 0) {
                msg.append(" Server returned error code: " + this.statusCode + " Response probably does not contain SOAP message.");
            }
            throw new RemoteException(msg.toString(), e1);
        }
        throw new RemoteException("Service returned error", e);
    }

    private void skipUnknownElement(Tokenizer tok) throws MessageProcessingException, TokenizerException, IOException {
        int depth = 1;
        do {
            byte state = tok.next();
            switch (state) {
                case 2: {
                    ++depth;
                    break;
                }
                case 3: {
                    --depth;
                    break;
                }
                case 1: {
                    throw new MessageProcessingException("Unexpected tokenizer end of document.");
                }
            }
        } while (depth > 0);
    }

    private SOAPMethodInfo getMethodInfo(QName operationName, Class[] params, Class returnType) throws RemoteException {
        boolean unwrapped = this.isUnwrapped();
        Boolean aux = (Boolean)Current.getCallContext().getContextData().get("client.proxy.unwrapped");
        if (aux != null) {
            unwrapped = aux;
        }
        try {
            SOAPMethodInfo ret = this.portInfo.getMethodInfo(this.serializationID, operationName.getLocalPart(), null, params, returnType, unwrapped);
            if (ret != null) {
                return ret;
            }
            SOAPMethodInfo[] infos = this.portInfo.getMethodInfos(this.serializationID, unwrapped);
            int i = 0;
            while (i < infos.length) {
                if (infos[i].operationName.equals(operationName.getLocalPart())) {
                    this.methodInfo = infos[i];
                    return this.methodInfo;
                }
                ++i;
            }
        }
        catch (SchemaException e) {
            throw new RemoteException(e.getMessage(), e);
        }
        catch (WSDLException e) {
            throw new RemoteException(e.getMessage(), e);
        }
        throw new RemoteException(operationName + " not in WSDL.");
    }

    private boolean isUnwrapped() {
        Boolean unwrapped = (Boolean)this.getProperty("com.systinet.wasp.client.invocation.unwrapped");
        if (unwrapped != null) {
            return unwrapped;
        }
        return iWasp.getDefaultBindingStyle().equals("wrapped");
    }

    private MethodProperties getMethodProperties(QName operationName, Object[] inputParams) throws RemoteException {
        SOAPServiceInfo sOAPServiceInfo = this.portInfo.getServiceInfo();
        synchronized (sOAPServiceInfo) {
            if (this.methodInfo == null) {
                int size = this.parameters.size();
                Class[] paramTypes = new Class[this.parameters.size()];
                int i = 0;
                while (i < size) {
                    Class<Object> clazz = ((Parameter)this.parameters.get((int)i)).clazz;
                    if (clazz == null) {
                        clazz = inputParams != null && inputParams[i] != null ? inputParams[i].getClass() : (class$java$lang$Object == null ? WaspCallImpl.class$("java.lang.Object") : class$java$lang$Object);
                    }
                    paramTypes[i] = clazz;
                    ++i;
                }
                this.methodInfo = this.getMethodInfo(operationName, paramTypes, this.returnType);
            }
            MethodProperties methodProperties = new MethodProperties();
            methodProperties.weakMethodInfo = new MethodProperties.WeakMethodInfo(this.methodInfo);
            methodProperties.encoding = this.encoding != null ? this.encoding : this.methodInfo.requestMessageEncodingURI;
            methodProperties.operationName = this.operationName;
            try {
                if (this.schema == null) {
                    this.schema = this.portInfo.getSchema(this.serializationID, methodProperties.encoding);
                }
                if (this.schema == null) {
                    this.portInfo.prepareSchema(this.serializationID, methodProperties.encoding);
                    this.schema = this.portInfo.getSchema(this.serializationID, methodProperties.encoding);
                }
                methodProperties.schema = this.schema;
            }
            catch (SchemaException e1) {
                throw new RemoteException(e1.getMessage(), e1);
            }
            MethodProperties methodProperties2 = methodProperties;
            return methodProperties2;
        }
    }

    private final void closeConnection() {
        Connection connection = (Connection)Current.getCallContext().getContextData().get("wasp.transport.connection");
        if (connection != null && connection.getInputMessage() != null) {
            try {
                connection.getInputMessage().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            soapFactory = SOAPFactory.newInstance();
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
        log = Category.getCategory(className);
        pRepo = (ProtocolRepositoryImpl)Context.getInstance("org.idoox.wasp.ProtocolRepository");
        serializationRepository = (SerializationRepository)Context.getInstance("org.idoox.wasp.serialization.SerializationRepository");
        encodingRepository = (EncodingRepository)Context.getInstance("com.idoox.xmlrpc.encoding.EncodingRepository");
        iWasp = (IWasp)Context.getInstance("org.systinet.wasp.Wasp");
    }

    public static class ClientMessageAttachment
    extends org.idoox.wasp.types.MessageAttachment {
        boolean useForOutput = false;
        boolean alreadyLoaded;
        String requiredContentId;
        String requiredContentLocation;
        ClientAttachments attachments;

        ClientMessageAttachment(ClientAttachments attachments, String id) {
            this.attachments = attachments;
            if (id.startsWith("cid:")) {
                this.requiredContentId = id.substring(4);
                attachments.registerAttachmentById(this.requiredContentId, this);
            } else {
                this.requiredContentLocation = id;
                attachments.registerAttachmentByLocation(this.requiredContentLocation, this);
            }
        }

        ClientMessageAttachment() {
        }

        public void setData(InputStream attachmentStream) throws IOException {
            super.setData(attachmentStream);
            this.useForOutput = true;
            this.alreadyLoaded = true;
        }

        public void setContentType(String contentType) throws IOException {
            super.setContentType(contentType);
            this.useForOutput = true;
            this.alreadyLoaded = true;
        }

        public InputStream getData() throws IOException {
            if (!this.alreadyLoaded) {
                this.load();
            }
            return super.getData();
        }

        public String getContentType() throws IOException {
            if (!this.alreadyLoaded) {
                this.load();
            }
            return super.getContentType();
        }

        public String getContentId() throws IOException {
            if (!this.alreadyLoaded) {
                this.load();
            }
            return super.getContentId();
        }

        public void setContentId(String contentId) throws IOException {
            super.setContentId(contentId);
            this.alreadyLoaded = true;
        }

        public String getContentLocation() throws IOException {
            if (!this.alreadyLoaded) {
                this.load();
            }
            return this.contentLocation;
        }

        public void setContentLocation(String location) throws IOException {
            super.setContentLocation(location);
            this.alreadyLoaded = true;
        }

        private void load() throws IOException {
            this.alreadyLoaded = true;
            if (this.requiredContentId != null) {
                this.attachments.fillAttachmentWithId(this.requiredContentId);
            } else {
                this.attachments.fillAttachmentWithLocation(this.requiredContentLocation);
            }
        }
    }

    public static class MethodProperties {
        public QName operationName;
        public WeakMethodInfo weakMethodInfo;
        public String encoding;
        public String encodingId;
        public Schema schema;
        public List parameters;
        public Class returnType;
        public QName returnTypeQName;
        public Boolean doPolymorphism;

        public static class WeakMethodInfo
        extends WeakReference {
            public WeakMethodInfo(SOAPMethodInfo methodInfo) {
                super(methodInfo);
            }

            public SOAPMethodInfo getMethodInfo() {
                return (SOAPMethodInfo)this.get();
            }
        }
    }

    private static class Parameter {
        String partName;
        QName typeQName;
        Class clazz;
        ParameterMode mode;

        Parameter(String s, QName q, Class c, ParameterMode m) {
            this.partName = s;
            this.typeQName = q;
            this.clazz = c;
            this.mode = m;
        }
    }

    private static class StateHolder {
        MethodInvocationState mis;
        Map outputParams;

        public StateHolder(MethodInvocationState mis) {
            this.mis = mis;
        }
    }

    public static class MethodInvocationState
    implements Cloneable {
        protected Object[] params;
        protected SOAPMessage request;
        protected SOAPMessage response;
        protected MethodProperties method;

        public Object clone() {
            MethodInvocationState ret = new MethodInvocationState();
            ret.params = this.params;
            ret.request = this.request;
            ret.response = this.response;
            ret.method = this.method;
            return ret;
        }
    }
}

