/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.rpc;

import com.idoox.util.ObjectPool;
import com.idoox.util.Pool;
import com.systinet.wasp.rpc.WaspCallImpl;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.namespace.QName;
import org.idoox.wasp.wsdl.SOAPMethodInfo;
import org.systinet.wasp.rpc.IWaspCall;
import org.systinet.wasp.rpc.WaspCall;
import org.systinet.wasp.rpc.WaspCallFactory;
import org.systinet.wasp.webservice.ServiceClient;

public class WaspCallFactoryImpl
extends WaspCallFactory {
    Pool waspCallPool = new ObjectPool(new WaspCallFactoryInternal(), 10);
    Map methodInfoTowaspCallBuffer = Collections.synchronizedMap(new WeakHashMap());

    public WaspCall createWaspCall(ServiceClient serviceClient) {
        IWaspCall call = (IWaspCall)this.waspCallPool.get();
        call.setPool(this.waspCallPool);
        call.setRelease(true);
        call.init(serviceClient);
        return call;
    }

    public WaspCall createWaspCall(ServiceClient serviceClient, SOAPMethodInfo methodInfo) {
        IWaspCall call = null;
        CallBuffer callBuffer = (CallBuffer)this.methodInfoTowaspCallBuffer.get(methodInfo);
        if (null != callBuffer && (call = callBuffer.pop()) != null) {
            call.setServiceCient(serviceClient);
        }
        if (call == null) {
            call = (IWaspCall)this.waspCallPool.get();
            call.init(serviceClient, methodInfo);
        }
        call.setRelease(false);
        call.setPool(new WaspCallPool(methodInfo));
        return call;
    }

    public WaspCall createWaspCall(ServiceClient serviceClient, QName operationName) {
        WaspCallImpl call = new WaspCallImpl();
        call.setPool(this.waspCallPool);
        call.setRelease(true);
        call.init(serviceClient, operationName);
        return call;
    }

    private static class CallBuffer {
        private IWaspCall[] calls = new IWaspCall[1];
        private int top = 0;

        private CallBuffer() {
        }

        public IWaspCall pop() {
            IWaspCall[] iWaspCallArray = this.calls;
            synchronized (iWaspCallArray) {
                if (this.top > 0) {
                    IWaspCall iWaspCall = this.calls[this.top--];
                    return iWaspCall;
                }
            }
            return null;
        }

        public void push(IWaspCall call) {
            IWaspCall[] iWaspCallArray = this.calls;
            synchronized (iWaspCallArray) {
                this.ensureCapacity(++this.top);
                this.calls[this.top] = call;
            }
        }

        private void ensureCapacity(int len) {
            if (len >= this.calls.length) {
                IWaspCall[] newCalls = new IWaspCall[this.calls.length * 2];
                System.arraycopy(this.calls, 0, newCalls, 0, this.calls.length);
                this.calls = newCalls;
            }
        }
    }

    private class WaspCallPool
    implements Pool {
        SOAPMethodInfo methodInfo;

        public WaspCallPool(SOAPMethodInfo methodInfo) {
            this.methodInfo = methodInfo;
        }

        public void init(Pool.Factory fact, int size) {
        }

        public Object get() {
            return WaspCallFactoryImpl.this.waspCallPool.get();
        }

        public void release(Object obj) {
            CallBuffer callBuffer;
            Map map = WaspCallFactoryImpl.this.methodInfoTowaspCallBuffer;
            synchronized (map) {
                callBuffer = (CallBuffer)WaspCallFactoryImpl.this.methodInfoTowaspCallBuffer.get(this.methodInfo);
                if (null == callBuffer) {
                    callBuffer = new CallBuffer();
                    WaspCallFactoryImpl.this.methodInfoTowaspCallBuffer.put(this.methodInfo, callBuffer);
                }
            }
            callBuffer.push((IWaspCall)obj);
        }
    }

    class WaspCallFactoryInternal
    implements Pool.Factory {
        WaspCallFactoryInternal() {
        }

        public Object getNewInstance() {
            return new WaspCallImpl();
        }
    }
}

