/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.rpc;

import com.idoox.Namespaces;
import com.idoox.wasp.serialization.SerializationHelper;
import com.idoox.wasp.serialization.SerializationRepositoryImpl;
import com.idoox.wasp.serialization.WaspSerializationHelper;
import com.idoox.xml.schema.util.XMLSchemaUtil;
import com.idoox.xmlrpc.encoding.EncodingRepository;
import com.systinet.wasp.rpc.WaspCallImpl;
import com.systinet.wasp.soap.util.SAAJUtils;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import org.idoox.wasp.serialization.DeserializationContext;
import org.idoox.wasp.serialization.Reference;
import org.idoox.wasp.serialization.SerializationRepository;
import org.idoox.wasp.wsdl.SOAPMethodInfo;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xml.TokenizerWrapper;
import org.idoox.xml.schema.Member;
import org.idoox.xml.schema.Schema;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xml.schema.Type;
import org.idoox.xmlrpc.MessageProcessingException;
import org.idoox.xmlrpc.encoding.EncodingTokenizer;
import org.idoox.xmlrpc.encoding.NoSuchEncodingException;
import org.systinet.wasp.soap.SOAPElementContent;
import org.systinet.wasp.soap.WaspInternalSOAPMessage;
import org.systinet.wasp.soap.WaspSOAPMessage;

public class FaultDeserializationHelper {
    private SerializationRepository serializationRepository;
    private EncodingRepository encodingRepository;
    private String serializationID;
    private String encodingID;
    private String fsID;
    private Schema schema;
    private boolean useConfigEncoding;
    private ClassLoader classLoader;
    private WaspCallImpl waspCall;
    private static final QName DETAIL_NAME12 = new QName(Namespaces.SOAP12_ENV_NS, "Detail");
    private static final QName DETAIL_NAME11 = new QName(null, "detail");
    private static final QName DETAIL_NAMEGET = new QName(null, "detail");

    public FaultDeserializationHelper(WaspCallImpl waspCall, SerializationRepository serializationRepository, EncodingRepository encodingRepository, String serializationID, String encodingID, String fsID, Schema schema, boolean useConfigEncoding, ClassLoader classLoader) {
        this.waspCall = waspCall;
        this.serializationRepository = serializationRepository;
        this.encodingRepository = encodingRepository;
        this.serializationID = serializationID;
        this.encodingID = encodingID;
        this.fsID = fsID;
        this.schema = schema;
        this.useConfigEncoding = useConfigEncoding;
        this.classLoader = classLoader;
    }

    Exception deserializeFault(WaspCallImpl.MethodInvocationState mis, SOAPMessage response) throws SOAPException, SchemaException, IOException, TokenizerException, ClassNotFoundException, MessageProcessingException, NoSuchEncodingException {
        SOAPEnvelope envelope = response.getSOAPPart().getEnvelope();
        SOAPBody body = envelope.getBody();
        SOAPFault fault = body.getFault();
        if (fault == null) {
            throw new RuntimeException("Unable to deserialize fault - NO FAULT");
        }
        if (((SerializationRepositoryImpl)this.serializationRepository).hasCustomFaultDeserializers(this.fsID, fault)) {
            return null;
        }
        Detail detail = fault.getDetail();
        Exception exception = null;
        if (detail != null) {
            Iterator childElements = detail.getChildElements();
            SOAPElement firstChild = null;
            while (childElements.hasNext()) {
                Object o = childElements.next();
                if (!(o instanceof SOAPElement)) continue;
                firstChild = (SOAPElement)o;
            }
            if (firstChild != null) {
                String firstElementName = firstChild.getElementName().getLocalName();
                if (firstElementName.startsWith("idoox-java-mapping.")) {
                    return null;
                }
                exception = this.deserializeFault(firstChild, mis, firstElementName, body, response, detail);
            }
        }
        if (exception != null) {
            return exception;
        }
        WaspInternalSOAPMessage wiResponse = (WaspInternalSOAPMessage)response;
        wiResponse = (WaspInternalSOAPMessage)wiResponse.clone();
        fault = wiResponse.getSOAPPart().getEnvelope().getBody().getFault();
        detail = fault.getDetail();
        QName faultCodeQName = wiResponse.getFaultCode();
        exception = new SOAPFaultException(faultCodeQName, fault.getFaultString(), fault.getFaultActor(), detail);
        return exception;
    }

    private Exception deserializeFault(SOAPElement firstChild, WaspCallImpl.MethodInvocationState mis, String firstElementName, SOAPBody body, SOAPMessage response, Detail detail) throws SchemaException, IOException, TokenizerException, ClassNotFoundException, MessageProcessingException, NoSuchEncodingException {
        SOAPMethodInfo.FaultPartInfo faultPart;
        QName xsiType = SAAJUtils.getXSIType(firstChild);
        Type schemaType = null;
        if (xsiType != null) {
            schemaType = XMLSchemaUtil.getSchemaType(this.schema, xsiType);
        }
        if ((faultPart = mis.method.weakMethodInfo.getMethodInfo().faultsInfo.getFaultPart(firstChild)) == null) {
            faultPart = this.createFaultPartInfo(schemaType, firstElementName, firstChild);
        } else {
            if (faultPart.getName().startsWith("idoox-java-mapping.")) {
                return null;
            }
            faultPart = this.updateFaultPart(faultPart, schemaType, firstChild.getEncodingStyle());
        }
        if (faultPart == null) {
            return null;
        }
        DeserializationContext dectx = this.createDeserializationContext(mis, faultPart);
        if (dectx == null) {
            return null;
        }
        Tokenizer content = ((SOAPElementContent)((Object)body)).getContent();
        this.moveToDetail(content, ((WaspSOAPMessage)response).getXMLProtocol());
        dectx.setClassLoader(this.classLoader);
        Type partType = faultPart.getType();
        if (partType == null) {
            partType = faultPart.getElement().getType();
        }
        if (partType == null) {
            return null;
        }
        String javaTypeName = this.getJavaType(dectx, faultPart);
        if (javaTypeName == null) {
            return null;
        }
        Class<?> javaClass = dectx.getClassLoader().loadClass(javaTypeName);
        String encodingURI = detail.getEncodingStyle();
        if (encodingURI == null) {
            encodingURI = faultPart.getEncodingURI();
        }
        Exception ex = null;
        ex = encodingURI != null ? this.deserializeEnc(content, javaClass, dectx, faultPart, encodingURI) : this.deserializeXml(content, javaClass, dectx, faultPart);
        if (ex == null) {
            throw new RuntimeException("Unable to deserialize exception. Deserialized exception == null");
        }
        return ex;
    }

    /*
     * Unable to fully structure code
     */
    private void moveToDetail(Tokenizer content, String protocol) throws IOException, TokenizerException {
        tok = TokenizerWrapper.nextElement(content);
        if (tok != 2) {
            throw new RuntimeException("Internall error");
        }
        tok = TokenizerWrapper.nextElement(content);
        if (tok == 2) ** GOTO lbl9
        throw new RuntimeException("Internall error");
lbl-1000:
        // 1 sources

        {
            if (!this.isDetail(content, protocol)) continue;
            return;
lbl9:
            // 2 sources

            ** while (TokenizerWrapper.nextSibling((Tokenizer)content) == 2)
        }
lbl10:
        // 1 sources

        throw new RuntimeException("Internal error - unable to find detail");
    }

    private boolean isDetail(Tokenizer content, String protocol) throws TokenizerException {
        return "soap11".equals(protocol) ? DETAIL_NAME11.getLocalPart().equals(content.getLocalName()) : ("soap12".equals(protocol) ? DETAIL_NAME12.getLocalPart().equals(content.getLocalName()) && DETAIL_NAME12.getNamespaceURI().equals(content.getNamespace()) : "httpget".equals(protocol) && DETAIL_NAMEGET.getLocalPart().equals(content.getLocalName()));
    }

    private Exception deserializeEnc(Tokenizer content, Class javaClass, DeserializationContext dectx, SOAPMethodInfo.FaultPartInfo faultPart, String encodingURI) throws IOException, TokenizerException, MessageProcessingException, NoSuchEncodingException {
        byte token;
        EncodingTokenizer encodingTokenizer = this.encodingRepository.getEncodingTokenizer(this.encodingID, encodingURI);
        while ((token = content.next()) == 4) {
        }
        if (token == 1) {
            throw new MessageProcessingException("Invalid message.");
        }
        encodingTokenizer.setInput(content, this.encodingID);
        encodingTokenizer.next();
        Object ret = WaspSerializationHelper.deserializeFault(encodingTokenizer, javaClass, dectx, faultPart.getType(), faultPart.getElement());
        this.moveToFaultEnd(content);
        if (content.currentState() == 2) {
            encodingTokenizer.setInput(content, this.encodingID);
            this.waspCall.deserializeReferences(encodingTokenizer, dectx);
        }
        dectx.resolveLocalReferences();
        if (ret instanceof Reference) {
            return (Exception)((Reference)ret).getObjectValue();
        }
        return (Exception)ret;
    }

    private void moveToFaultEnd(Tokenizer content) throws IOException, TokenizerException {
        byte tok = TokenizerWrapper.nextElement(content);
        if (tok != 3) {
            throw new RuntimeException("Internall error");
        }
        byte by = TokenizerWrapper.nextElement(content);
    }

    private Exception deserializeXml(Tokenizer content, Class javaClass, DeserializationContext dectx, SOAPMethodInfo.FaultPartInfo faultPart) throws IOException, TokenizerException, MessageProcessingException {
        SerializationHelper.nextNonWhitespace(content);
        return WaspSerializationHelper.deserializeFault(content, javaClass, dectx, faultPart.getType(), faultPart.getElement());
    }

    private SOAPMethodInfo.FaultPartInfo updateFaultPart(SOAPMethodInfo.FaultPartInfo faultPart, Type schemaType, String encodingURI) {
        QName schemaTypeName;
        Member newMember = null;
        String newEncodingURI = null;
        if (schemaType != null && !(schemaTypeName = schemaType.getName()).equals(faultPart.getSchemaTypeName())) {
            Member element = faultPart.getElement();
            QName newPartName = element != null ? element.getName() : new QName(faultPart.getName());
            newMember = new Member(newPartName, schemaType);
        }
        String partEncodingURI = faultPart.getEncodingURI();
        if (encodingURI != null && partEncodingURI == null || partEncodingURI != null && !partEncodingURI.equals(encodingURI)) {
            newEncodingURI = faultPart.getEncodingURI();
        }
        if (newMember == null && newEncodingURI == null) {
            return faultPart;
        }
        if (newMember == null) {
            newMember = faultPart.getElement();
        }
        if (newEncodingURI == null) {
            newEncodingURI = faultPart.getEncodingURI();
        }
        return new SOAPMethodInfo.FaultPartInfo(faultPart.getName(), schemaType, newMember, newEncodingURI, faultPart.getNamespaceURI());
    }

    private SOAPMethodInfo.FaultPartInfo createFaultPartInfo(Type schemaType, String firstElementName, SOAPElement firstChild) {
        if (schemaType == null) {
            return null;
        }
        QName name = schemaType.getName();
        if (name == null) {
            throw new RuntimeException("Internal error! Name of type is null!");
        }
        Member memeber = new Member(name, schemaType);
        return new SOAPMethodInfo.FaultPartInfo(firstElementName, schemaType, memeber, firstChild.getEncodingStyle(), 1);
    }

    private DeserializationContext createDeserializationContext(String serializationID, String encodingURI) {
        DeserializationContext dectx = this.serializationRepository.createDeserializationContext(serializationID, encodingURI);
        return dectx;
    }

    private DeserializationContext createDeserializationContext(WaspCallImpl.MethodInvocationState mis, SOAPMethodInfo.FaultPartInfo faultPart) throws SchemaException {
        DeserializationContext dectx = this.useConfigEncoding ? this.createDeserializationContext(this.serializationID, mis.method.encoding) : this.createDeserializationContext(this.serializationID, faultPart.getEncodingURI());
        dectx.setSchema(this.schema, true);
        return dectx;
    }

    private String getJavaType(DeserializationContext dectx, SOAPMethodInfo.FaultPartInfo faultPart) throws SchemaException {
        String javaType = faultPart.getJavaType();
        if (javaType != null) {
            return javaType;
        }
        Type schemaType = faultPart.getType();
        if (schemaType == null) {
            schemaType = faultPart.getElement().getType();
        }
        return dectx.getType(schemaType);
    }
}

