/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.rpc;

import com.idoox.debug.Category;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.idoox.xmlrpc.MessageProcessingException;

public final class ExceptionDeserializerHelper {
    private static final Category log = Category.getCategory("com.systinet.wasp.rpc.ExceptionDeserializerHelper");
    private static Map primitiveToWrapper = new HashMap(13);
    private static Comparator exactMatch;
    private static Comparator inheritanceMatch;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Void;

    private ExceptionDeserializerHelper() {
    }

    public static Constructor getConstructor(Class targetClass) throws MessageProcessingException {
        Constructor<?>[] constructors = targetClass.getConstructors();
        if (constructors == null || constructors.length == 0) {
            constructors = targetClass.getDeclaredConstructors();
        }
        if (constructors == null || constructors.length == 0) {
            throw new MessageProcessingException("Unable to deserialize exception " + targetClass + ". No constructor found!");
        }
        if (constructors.length != 1) {
            return null;
        }
        return constructors[0];
    }

    public static Object constructException(Constructor constructor, List params, Class targetClass) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        return ExceptionDeserializerHelper.constructException(constructor, params, null, targetClass);
    }

    public static Object constructException(Constructor constructor, List params, List paramTypes, Class targetClass) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (constructor != null) {
            return constructor.newInstance(params.toArray());
        }
        constructor = ExceptionDeserializerHelper.findConstructor(params, paramTypes, targetClass);
        return constructor.newInstance(params.toArray());
    }

    private static Constructor findConstructor(List params, List paramTypes, Class targetClass) {
        Constructor[] constructors = targetClass.getConstructors();
        ArrayList foundCtors = new ArrayList(1);
        ExceptionDeserializerHelper.filterCtorsByParamList(foundCtors, constructors, params, null, exactMatch);
        if (foundCtors.size() == 0) {
            ExceptionDeserializerHelper.filterCtorsByParamList(foundCtors, constructors, params, null, inheritanceMatch);
        }
        if (foundCtors.size() > 1) {
            ExceptionDeserializerHelper.filterCtorsByParamList(foundCtors, constructors, params, paramTypes, inheritanceMatch);
        }
        if (foundCtors.size() == 1) {
            return (Constructor)foundCtors.get(0);
        }
        throw new RuntimeException("Unable to construct exception class(" + targetClass.getName() + ") with parameters(" + params + "). Found constructors:" + foundCtors);
    }

    private static void filterCtorsByParamList(List foundCtors, Constructor[] constructors, List params, List paramTypes, Comparator typeCmp) {
        int i = 0;
        while (i < constructors.length) {
            Constructor constructor = constructors[i];
            Class[] ctorArgTypes = constructor.getParameterTypes();
            if (ExceptionDeserializerHelper.compareParameters(ctorArgTypes, params, paramTypes, typeCmp)) {
                foundCtors.add(constructor);
            }
            ++i;
        }
    }

    private static boolean compareParameters(Class[] ctorArgTypes, List params, List paramTypes, Comparator typeCmp) {
        if (ctorArgTypes.length != params.size()) {
            return false;
        }
        int i = 0;
        while (i < ctorArgTypes.length) {
            Class c;
            Class parameterType = ctorArgTypes[i];
            Object o = params.get(i);
            Class clazz = c = o != null ? o.getClass() : ExceptionDeserializerHelper.getClass(paramTypes, i);
            if (c != null && typeCmp.compare(parameterType, c) != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static Class getClass(List paramTypes, int index) {
        try {
            if (paramTypes == null || paramTypes.size() <= index) {
                return null;
            }
            String className = (String)paramTypes.get(index);
            if (className == null) {
                return null;
            }
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            Class<?> resultClass = contextClassLoader == null ? Class.forName(className) : Class.forName(className, true, contextClassLoader);
            return resultClass;
        }
        catch (LinkageError le) {
            log.error(le);
            return null;
        }
        catch (Exception e) {
            log.debug(e);
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        primitiveToWrapper.put(Boolean.TYPE, class$java$lang$Boolean == null ? (class$java$lang$Boolean = ExceptionDeserializerHelper.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        primitiveToWrapper.put(Byte.TYPE, class$java$lang$Byte == null ? (class$java$lang$Byte = ExceptionDeserializerHelper.class$("java.lang.Byte")) : class$java$lang$Byte);
        primitiveToWrapper.put(Character.TYPE, class$java$lang$Character == null ? (class$java$lang$Character = ExceptionDeserializerHelper.class$("java.lang.Character")) : class$java$lang$Character);
        primitiveToWrapper.put(Short.TYPE, class$java$lang$Short == null ? (class$java$lang$Short = ExceptionDeserializerHelper.class$("java.lang.Short")) : class$java$lang$Short);
        primitiveToWrapper.put(Integer.TYPE, class$java$lang$Integer == null ? (class$java$lang$Integer = ExceptionDeserializerHelper.class$("java.lang.Integer")) : class$java$lang$Integer);
        primitiveToWrapper.put(Long.TYPE, class$java$lang$Long == null ? (class$java$lang$Long = ExceptionDeserializerHelper.class$("java.lang.Long")) : class$java$lang$Long);
        primitiveToWrapper.put(Float.TYPE, class$java$lang$Float == null ? (class$java$lang$Float = ExceptionDeserializerHelper.class$("java.lang.Float")) : class$java$lang$Float);
        primitiveToWrapper.put(Double.TYPE, class$java$lang$Double == null ? (class$java$lang$Double = ExceptionDeserializerHelper.class$("java.lang.Double")) : class$java$lang$Double);
        primitiveToWrapper.put(Void.TYPE, class$java$lang$Void == null ? (class$java$lang$Void = ExceptionDeserializerHelper.class$("java.lang.Void")) : class$java$lang$Void);
        exactMatch = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 == o2) {
                    return 0;
                }
                Class c1 = (Class)o1;
                if (c1.isPrimitive() && primitiveToWrapper.get(c1) == o2) {
                    return 0;
                }
                return 1;
            }
        };
        inheritanceMatch = new Comparator(){

            public int compare(Object o1, Object o2) {
                Class c1 = (Class)o1;
                Class c2 = (Class)o2;
                if (c1.isPrimitive()) {
                    if (c1 == c2) {
                        return 0;
                    }
                    c1 = (Class)primitiveToWrapper.get(c1);
                }
                if (c1.isAssignableFrom(c2)) {
                    return 0;
                }
                return 1;
            }
        };
    }
}

