/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.policy;

import com.idoox.debug.Category;
import com.idoox.util.ElementHelper;
import com.idoox.wasp.ClassSpace;
import com.idoox.wasp.ClassSpaceHelper;
import com.idoox.wasp.InitialReferencesRegistrar;
import com.idoox.wasp.config.PolicyElementConfig;
import com.idoox.wasp.config.PolicyManagerConfig;
import com.systinet.wasp.policy.EffectivePolicyImpl;
import com.systinet.wasp.policy.PolicyAttachmentImpl;
import com.systinet.wasp.policy.PolicyImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.idoox.config.Configurable;
import org.idoox.config.IConfigurator;
import org.idoox.transport.client.Endpoint;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.Context;
import org.idoox.wasp.Module;
import org.idoox.wasp.WaspInternalException;
import org.systinet.wasp.policy.DomainExpression;
import org.systinet.wasp.policy.EffectivePolicy;
import org.systinet.wasp.policy.IPolicyManager;
import org.systinet.wasp.policy.Policy;
import org.systinet.wasp.policy.PolicyAllOperator;
import org.systinet.wasp.policy.PolicyAssertion;
import org.systinet.wasp.policy.PolicyAttachment;
import org.systinet.wasp.policy.PolicyCompositor;
import org.systinet.wasp.policy.PolicyElement;
import org.systinet.wasp.policy.PolicyExactlyOneOperator;
import org.systinet.wasp.policy.PolicyException;
import org.systinet.wasp.policy.PolicyOneOrMoreOperator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PolicyManagerImpl
implements Module,
IPolicyManager {
    private IConfigurator configurator;
    private static final Category cat = Category.getCategory("com.systinet.wasp.policy.PolicyManagerImpl");
    DocumentBuilder documentBuilder;
    private static TransformerFactory factory = TransformerFactory.newInstance();
    private Map de2policyAttachment = new HashMap();
    private List policies = new ArrayList();
    private Map policyFile2PolicyElements = new HashMap();
    private Map registeredPolicyElements = new HashMap();
    static /* synthetic */ Class class$com$idoox$wasp$config$PolicyManagerConfig;
    static /* synthetic */ Class class$org$systinet$wasp$policy$DomainExpression;
    static /* synthetic */ Class class$javax$xml$transform$Source;
    static /* synthetic */ Class class$com$idoox$wasp$config$PolicyElementConfig;
    static /* synthetic */ Class class$org$systinet$wasp$policy$PolicyAssertion;

    public void load(Configurable config) throws WaspInternalException {
        InitialReferencesRegistrar.addInitialReference("org.systinet.wasp.policy.PolicyManager", this);
        this.configurator = (IConfigurator)Context.getInstance("org.idoox.config.IConfigurator");
        Configurable[] configs = this.configurator.getTopEntries("domainExpression");
        int i = 0;
        while (i < configs.length) {
            try {
                this.addPolicyElement(configs[i]);
            }
            catch (Exception e) {
                cat.error("Exception during registering domain expression", e);
            }
            ++i;
        }
        configs = this.configurator.getTopEntries("policyAssertion");
        int i2 = 0;
        while (i2 < configs.length) {
            try {
                this.addPolicyElement(configs[i2]);
            }
            catch (Exception e) {
                cat.error("Exception during registering policy assertion", e);
            }
            ++i2;
        }
        this.initializeDocumentBuilder();
        this.readDefaultPolicy(config);
    }

    public void init() throws WaspInternalException {
    }

    public void destroy() {
        this.de2policyAttachment.clear();
        this.policies.clear();
        this.policyFile2PolicyElements.clear();
        this.registeredPolicyElements.clear();
    }

    private void initializeDocumentBuilder() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setCoalescing(true);
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            this.documentBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Can not initialize parser for PolicyManager");
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readDefaultPolicy(Configurable configurable) throws WaspInternalException {
        Endpoint waspEndpoint;
        PolicyManagerConfig policyManagerConfig = (PolicyManagerConfig)configurable.narrow(class$com$idoox$wasp$config$PolicyManagerConfig == null ? (class$com$idoox$wasp$config$PolicyManagerConfig = PolicyManagerImpl.class$("com.idoox.wasp.config.PolicyManagerConfig")) : class$com$idoox$wasp$config$PolicyManagerConfig);
        String fileName = "policy.xml";
        if (policyManagerConfig != null) {
            try {
                fileName = policyManagerConfig.getDefaultPolicy();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            waspEndpoint = new Endpoint(this.configurator.getWaspLocation());
        }
        catch (MalformedURLException e) {
            throw new WaspInternalException(e);
        }
        String waspLocation = waspEndpoint.getPath();
        if (waspLocation.length() > 0 && waspLocation.charAt(waspLocation.length() - 1) != '/') {
            waspLocation = waspLocation + '/';
        }
        fileName = waspLocation + "conf/" + fileName;
        fileName.replace('/', File.separatorChar);
        FileInputStream inputStream = null;
        File policyFile = new File(fileName);
        inputStream = new FileInputStream(policyFile);
        this.addPolicy(policyFile.toURL().toExternalForm(), inputStream);
        Object var10_11 = null;
        if (inputStream == null) return;
        try {
            inputStream.close();
            return;
        }
        catch (IOException e2) {}
        return;
        {
            catch (FileNotFoundException e) {
                Object var10_12 = null;
                if (inputStream == null) return;
                try {
                    inputStream.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
            catch (MalformedURLException e) {
                Object var10_13 = null;
                if (inputStream == null) return;
                try {
                    inputStream.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public synchronized PolicyAttachment createPolicyAttachment(DomainExpression domainExpression, Policy[] policies) throws PolicyException {
        if (domainExpression == null) {
            return null;
        }
        PolicyAttachment policyAttachment = (PolicyAttachment)this.de2policyAttachment.get(domainExpression);
        if (policyAttachment != null) {
            Policy[] ps = policies;
            if (ps != null) {
                int i = 0;
                while (i < ps.length) {
                    policyAttachment.addPolicy(ps[i]);
                    ++i;
                }
            }
            return policyAttachment;
        }
        policyAttachment = new PolicyAttachmentImpl(domainExpression, policies);
        this.de2policyAttachment.put(domainExpression, policyAttachment);
        return policyAttachment;
    }

    public synchronized PolicyAttachment createPolicyAttachment(DomainExpression domainExpression, Policy policy) throws PolicyException {
        if (domainExpression == null) {
            return null;
        }
        PolicyAttachment policyAttachment = (PolicyAttachment)this.de2policyAttachment.get(domainExpression);
        if (policyAttachment != null) {
            throw new PolicyException("Policy attachment to this domain expression already exists.");
        }
        policyAttachment = new PolicyAttachmentImpl(domainExpression);
        policyAttachment.addPolicy(policy);
        this.de2policyAttachment.put(domainExpression, policyAttachment);
        return policyAttachment;
    }

    public synchronized PolicyAttachment attachPolicy(DomainExpression domainExpression, Policy policy) {
        if (domainExpression == null) {
            return null;
        }
        PolicyAttachment policyAttachment = (PolicyAttachment)this.de2policyAttachment.get(domainExpression);
        if (policyAttachment != null) {
            policyAttachment.addPolicy(policy);
            return policyAttachment;
        }
        policyAttachment = new PolicyAttachmentImpl(domainExpression);
        policyAttachment.addPolicy(policy);
        this.de2policyAttachment.put(domainExpression, policyAttachment);
        return policyAttachment;
    }

    public synchronized PolicyAttachment getPolicyAttachment(DomainExpression domainExpression) {
        if (domainExpression == null) {
            return null;
        }
        return (PolicyAttachment)this.de2policyAttachment.get(domainExpression);
    }

    public synchronized PolicyAttachment[] getPolicyAttachments() {
        return this.de2policyAttachment.values().toArray(new PolicyAttachment[0]);
    }

    public synchronized void removePolicyAttachment(PolicyAttachment policyAttachment) {
        if (policyAttachment == null) {
            return;
        }
        Map.Entry[] entries = this.de2policyAttachment.entrySet().toArray(new Map.Entry[0]);
        int i = 0;
        while (i < entries.length) {
            Map.Entry entry = entries[i];
            if (policyAttachment == entry.getValue()) {
                this.de2policyAttachment.remove(entry.getKey());
            }
            ++i;
        }
    }

    public synchronized Policy createPolicy() {
        PolicyImpl policy = new PolicyImpl();
        this.policies.add(policy);
        return policy;
    }

    public synchronized Policy createPolicy(QName name) throws PolicyException {
        if (this.getPolicy(name) != null) {
            throw new PolicyException("Policy with name: " + name + " already exists.");
        }
        PolicyImpl policy = new PolicyImpl(name);
        this.policies.add(policy);
        return policy;
    }

    public synchronized Policy getPolicy(QName name) {
        if (name == null) {
            return null;
        }
        int i = 0;
        while (i < this.policies.size()) {
            Policy policy = (Policy)this.policies.get(i);
            if (name.equals(policy.getName())) {
                return policy;
            }
            ++i;
        }
        return null;
    }

    public Policy[] getPolices() {
        return this.policies.toArray(new Policy[0]);
    }

    public void removePolicy(Policy policy) {
        this.policies.remove(policy);
    }

    public EffectivePolicy getEffectivePolicy(DomainExpression domainExpression) {
        return new EffectivePolicyImpl(domainExpression);
    }

    public synchronized Policy calculateEffectivePolicy(DomainExpression domainExpression) {
        ArrayList<Policy> list = new ArrayList<Policy>();
        Iterator iterator = this.de2policyAttachment.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            DomainExpression de = (DomainExpression)entry.getKey();
            if (!de.includes(domainExpression)) continue;
            list.addAll(Arrays.asList(((PolicyAttachment)entry.getValue()).getPolicies()));
        }
        PolicyImpl effectivePolicy = new PolicyImpl();
        int i = 0;
        while (i < list.size()) {
            Policy policy = (Policy)list.get(i);
            PolicyElement[] policyElements = policy.getElements();
            int j = 0;
            while (j < policyElements.length) {
                try {
                    policyElements[j].setParentElement(null);
                    effectivePolicy.add(policyElements[j]);
                }
                catch (PolicyException e) {
                    // empty catch block
                }
                ++j;
            }
            ++i;
        }
        return effectivePolicy;
    }

    public synchronized EffectivePolicy getEffectivePolicy(DomainExpression domainExpression, EffectivePolicy effectivePolicy) {
        PolicyAttachment pa = (PolicyAttachment)this.de2policyAttachment.get(domainExpression);
        if (pa == null) {
            return effectivePolicy;
        }
        EffectivePolicy effPol = effectivePolicy;
        if (effPol == null) {
            effPol = new EffectivePolicyImpl(domainExpression);
        }
        Policy pol = effPol.getPolicy();
        ArrayList<Policy> list = new ArrayList<Policy>();
        list.addAll(Arrays.asList(pa.getPolicies()));
        int i = 0;
        while (i < list.size()) {
            Policy policy = (Policy)list.get(i);
            PolicyElement[] policyElements = policy.getElements();
            int j = 0;
            while (j < policyElements.length) {
                try {
                    policyElements[j].setParentElement(null);
                    pol.add(policyElements[j]);
                }
                catch (PolicyException e) {
                    // empty catch block
                }
                ++j;
            }
            ++i;
        }
        return effPol;
    }

    public synchronized PolicyAttachment[] loadPolicyAttachment(Source source) throws PolicyException {
        if (source == null) {
            return null;
        }
        if (source instanceof DOMSource) {
            Element element = (Element)((DOMSource)source).getNode();
            return this.createPolicyAttachment(element, source.getSystemId());
        }
        try {
            if (source != null) {
                Transformer transformer = factory.newTransformer();
                DOMResult domResult = new DOMResult();
                transformer.transform(source, domResult);
                return this.createPolicyAttachment((Element)domResult.getNode(), source.getSystemId());
            }
        }
        catch (TransformerException e) {
            throw new PolicyException(e);
        }
        return null;
    }

    public synchronized Policy loadPolicy(Source source) throws PolicyException {
        if (source == null) {
            return null;
        }
        if (source instanceof DOMSource) {
            Element element = (Element)((DOMSource)source).getNode();
            return this.createPolicy(element, source.getSystemId());
        }
        try {
            if (source != null) {
                Transformer transformer = factory.newTransformer();
                DOMResult domResult = new DOMResult();
                transformer.transform(source, domResult);
                return this.createPolicy((Element)domResult.getNode(), source.getSystemId());
            }
        }
        catch (TransformerException e) {
            throw new PolicyException(e);
        }
        return null;
    }

    private PolicyAttachment[] createPolicyAttachment(Element element, String systemId) throws PolicyException {
        if (element == null) {
            throw new PolicyException("Element doesn't contain content.");
        }
        if (!"http://schemas.xmlsoap.org/ws/2002/12/policy".equals(element.getNamespaceURI()) || !"PolicyAttachment".equals(element.getLocalName())) {
            throw new PolicyException("Element doesn't contain PolicyAttachment.");
        }
        ArrayList<PolicyAttachment> policyAttachments = new ArrayList<PolicyAttachment>();
        Element e = ElementHelper.getChildElementByTagName(element, "http://schemas.xmlsoap.org/ws/2002/12/policy", "AppliesTo");
        if (e != null) {
            NodeList nodeList = e.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                block12: {
                    Node subNode = nodeList.item(i);
                    if (subNode.getNodeType() == 1) {
                        String localName = subNode.getLocalName();
                        String namespaceURI = subNode.getNamespaceURI();
                        Class domainExpressionClass = this.getPolicyElementClass(new QName(namespaceURI, localName));
                        if (domainExpressionClass != null && (class$org$systinet$wasp$policy$DomainExpression == null ? PolicyManagerImpl.class$("org.systinet.wasp.policy.DomainExpression") : class$org$systinet$wasp$policy$DomainExpression).isAssignableFrom(domainExpressionClass)) {
                            try {
                                Constructor constructor = null;
                                try {
                                    constructor = domainExpressionClass.getConstructor(class$javax$xml$transform$Source == null ? PolicyManagerImpl.class$("javax.xml.transform.Source") : class$javax$xml$transform$Source);
                                }
                                catch (NoSuchMethodException e1) {
                                    cat.error("Cannot find constructor with javax.xml.transform.Source for domain expression: " + domainExpressionClass.getName() + " in " + systemId);
                                    break block12;
                                }
                                DomainExpression domainExpression = (DomainExpression)constructor.newInstance(new DOMSource(subNode, systemId));
                                Element[] es = ElementHelper.getChildrenElementsByTagName(element, "http://schemas.xmlsoap.org/ws/2002/12/policy", "Policy");
                                ArrayList<Policy> temp = new ArrayList<Policy>();
                                if (es != null) {
                                    int j = 0;
                                    while (j < es.length) {
                                        Policy policy = this.createPolicy(es[j], systemId);
                                        temp.add(policy);
                                        ++j;
                                    }
                                }
                                PolicyAttachment policyAttachment = this.createPolicyAttachment(domainExpression, temp.toArray(new Policy[0]));
                                policyAttachments.add(policyAttachment);
                            }
                            catch (Exception e1) {
                                throw new PolicyException("Exception during creating policy element " + localName, e1);
                            }
                        }
                    }
                }
                ++i;
            }
        }
        return policyAttachments.toArray(new PolicyAttachment[0]);
    }

    private Policy createPolicy(Element element, String systemId) throws PolicyException {
        if (element == null) {
            throw new PolicyException("Element doesn't contain content.");
        }
        if (!"http://schemas.xmlsoap.org/ws/2002/12/policy".equals(element.getNamespaceURI()) || !"Policy".equals(element.getLocalName())) {
            throw new PolicyException("Element doesn't contain Policy.");
        }
        PolicyImpl policy = new PolicyImpl(new DOMSource(element, systemId));
        this.policies.add(policy);
        return policy;
    }

    public synchronized void addPolicy(String policyUrl, InputStream inputStream) {
        try {
            if (inputStream != null) {
                int i;
                Document document = this.documentBuilder.parse(inputStream);
                Element root = document.getDocumentElement();
                Element[] elements = ElementHelper.getChildrenElementsByTagName(root, "http://schemas.xmlsoap.org/ws/2002/12/policy", "PolicyAttachment");
                ArrayList<Object> list = null;
                if (policyUrl != null && (list = (ArrayList<Object>)this.policyFile2PolicyElements.get(policyUrl)) == null) {
                    list = new ArrayList<Object>();
                    this.policyFile2PolicyElements.put(policyUrl, list);
                }
                if (elements != null) {
                    i = 0;
                    while (i < elements.length) {
                        PolicyAttachment[] attachments = this.createPolicyAttachment(elements[i], policyUrl);
                        int j = 0;
                        while (j < attachments.length) {
                            PolicyAttachment attachment = attachments[j];
                            if (list != null) {
                                list.add(attachment.getDomainExpression());
                                Policy[] policies = attachment.getPolicies();
                                int k = 0;
                                while (k < policies.length) {
                                    list.add(policies[k]);
                                    ++k;
                                }
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                if ((elements = ElementHelper.getChildrenElementsByTagName(root, "http://schemas.xmlsoap.org/ws/2002/12/policy", "Policy")) != null) {
                    i = 0;
                    while (i < elements.length) {
                        Policy policy = this.createPolicy(elements[i], policyUrl);
                        if (list != null) {
                            list.add(policy);
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Exception e) {
            cat.error("Error when adding policy from file " + policyUrl, e);
        }
    }

    public synchronized void removePolicy(String policyUrl) {
        List list;
        if (policyUrl != null && (list = (List)this.policyFile2PolicyElements.get(policyUrl)) != null) {
            int i = 0;
            while (i < list.size()) {
                Object o = list.get(i);
                if (o instanceof DomainExpression) {
                    this.de2policyAttachment.remove(o);
                } else if (o instanceof Policy) {
                    this.policies.remove(o);
                }
                ++i;
            }
            this.policyFile2PolicyElements.remove(policyUrl);
        }
    }

    public Class getPolicyElementClass(QName name) {
        return (Class)this.registeredPolicyElements.get(name);
    }

    public void addPolicyElement(Configurable c) {
        PolicyElementConfig policyElement = (PolicyElementConfig)c.narrow(class$com$idoox$wasp$config$PolicyElementConfig == null ? (class$com$idoox$wasp$config$PolicyElementConfig = PolicyManagerImpl.class$("com.idoox.wasp.config.PolicyElementConfig")) : class$com$idoox$wasp$config$PolicyElementConfig);
        QName name = policyElement.getName();
        String className = policyElement.getClassName();
        String classSpaceName = policyElement.getClassSpaceName();
        ClassSpace classSpace = null;
        if (classSpaceName != null) {
            try {
                classSpace = ClassSpaceHelper.getClassSpace(classSpaceName, c.getReferenceLocation());
            }
            catch (MalformedURLException e) {
                throw new RuntimeWrappedException("Could not find class space " + classSpaceName + " for policy element" + name, e);
            }
        } else {
            classSpace = ClassSpaceHelper.getWaspClassSpace();
        }
        try {
            Class<?> pClass = Class.forName(className, true, classSpace.getClassLoader());
            this.registeredPolicyElements.put(name, pClass);
        }
        catch (Exception e) {
            throw new RuntimeWrappedException("Could not found policy element class " + className, e);
        }
    }

    public void removePolicyElement(Configurable c) {
        PolicyElementConfig policyElement = (PolicyElementConfig)c.narrow(class$com$idoox$wasp$config$PolicyElementConfig == null ? (class$com$idoox$wasp$config$PolicyElementConfig = PolicyManagerImpl.class$("com.idoox.wasp.config.PolicyElementConfig")) : class$com$idoox$wasp$config$PolicyElementConfig);
        QName name = policyElement.getName();
        this.registeredPolicyElements.remove(name);
    }

    public void loadPolicyCompositor(DOMSource domSource, PolicyCompositor compositor) throws PolicyException {
        Element element = (Element)domSource.getNode();
        String id = ElementHelper.getAttributeNS(element, "http://schemas.xmlsoap.org/ws/2002/07/utility", "Id");
        if (id != null) {
            compositor.setId(id);
        }
        NodeList nodeList = element.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node subNode = nodeList.item(i);
            if (subNode.getNodeType() == 1) {
                Element e = (Element)subNode;
                String localName = e.getLocalName();
                String namespaceURI = e.getNamespaceURI();
                if (localName.equals("All") && namespaceURI.equals("http://schemas.xmlsoap.org/ws/2002/12/policy")) {
                    PolicyAllOperator all = new PolicyAllOperator(new DOMSource(e, domSource.getSystemId()));
                    compositor.add(all);
                } else if (localName.equals("OneOrMore") && namespaceURI.equals("http://schemas.xmlsoap.org/ws/2002/12/policy")) {
                    PolicyOneOrMoreOperator oneOrMore = new PolicyOneOrMoreOperator(new DOMSource(e, domSource.getSystemId()));
                    compositor.add(oneOrMore);
                } else if (localName.equals("ExactlyOne") && namespaceURI.equals("http://schemas.xmlsoap.org/ws/2002/12/policy")) {
                    PolicyExactlyOneOperator exactlyOne = new PolicyExactlyOneOperator(new DOMSource(e, domSource.getSystemId()));
                    compositor.add(exactlyOne);
                } else {
                    Class policyAssertionClass = this.getPolicyElementClass(new QName(namespaceURI, localName));
                    if (policyAssertionClass == null) {
                        throw new PolicyException("Unknown impl. class for policy assertion: " + new QName(namespaceURI, localName));
                    }
                    if (!(class$org$systinet$wasp$policy$PolicyAssertion == null ? PolicyManagerImpl.class$("org.systinet.wasp.policy.PolicyAssertion") : class$org$systinet$wasp$policy$PolicyAssertion).isAssignableFrom(policyAssertionClass)) {
                        throw new PolicyException("Class: " + policyAssertionClass.getName() + " ins't a PolicyAssertion for assertion: " + new QName(namespaceURI, localName));
                    }
                    try {
                        Constructor constructor = null;
                        try {
                            constructor = policyAssertionClass.getConstructor(class$javax$xml$transform$Source == null ? PolicyManagerImpl.class$("javax.xml.transform.Source") : class$javax$xml$transform$Source);
                            PolicyAssertion policyAssertion = (PolicyAssertion)constructor.newInstance(new DOMSource(e, domSource.getSystemId()));
                            compositor.add(policyAssertion);
                        }
                        catch (NoSuchMethodException e1) {
                            throw new PolicyException("Cannot find constructor with javax.xml.transform.Source for assertion: " + policyAssertionClass.getName() + " in " + domSource.getSystemId());
                        }
                    }
                    catch (Exception e1) {
                        throw new PolicyException("Exception during creating policy element " + localName, e1);
                    }
                }
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

