/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.policy;

import com.idoox.util.ElementHelper;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import org.idoox.wasp.Context;
import org.systinet.wasp.policy.IPolicyManager;
import org.systinet.wasp.policy.Policy;
import org.systinet.wasp.policy.PolicyElement;
import org.systinet.wasp.policy.PolicyException;
import org.systinet.xml.XMLSourceHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PolicyImpl
extends Policy {
    private static final String LOCAL_NAME = "Policy";
    private static final QName ELEMENT_QNAME = new QName("http://schemas.xmlsoap.org/ws/2002/12/policy", "Policy");
    private QName name;

    public PolicyImpl() {
    }

    public PolicyImpl(QName name) {
        this.name = name;
    }

    public QName getName() {
        return this.name;
    }

    public void setName(QName name) {
        this.name = name;
    }

    public PolicyImpl(Source source) throws PolicyException {
        this.load(source);
    }

    private void load(Source source) throws PolicyException {
        try {
            DOMSource domSource = XMLSourceHelper.transformToDOMSource(source);
            if (domSource != null) {
                Element element = (Element)domSource.getNode();
                if (element == null || !ElementHelper.getTagName(element).equals(ELEMENT_QNAME)) {
                    throw new PolicyException("There is no " + ELEMENT_QNAME + " element in " + source.getSystemId());
                }
                String name = ElementHelper.getAttribute(element, "Name");
                String targetNamespace = ElementHelper.getAttribute(element, "TargetNamespace");
                if (name != null && targetNamespace != null) {
                    this.setName(new QName(targetNamespace, name));
                } else if (name != null) {
                    this.setName(new QName(name));
                }
                this.readStandardAttributes(domSource);
                this.getPolicyManager().loadPolicyCompositor(domSource, this);
            }
        }
        catch (TransformerException e) {
            throw new PolicyException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Source getContent() throws PolicyException {
        try {
            void e;
            DOMSource domSource = XMLSourceHelper.createDOMSource("http://schemas.xmlsoap.org/ws/2002/12/policy", "wsp:Policy");
            Element element = (Element)domSource.getNode();
            if (this.name != null) {
                element.setAttribute("Name", this.name.getLocalPart());
                if (this.name.getNamespaceURI() != null) {
                    element.setAttribute("TargetNamespace", this.name.getNamespaceURI());
                }
            }
            if (this.getId() != null) {
                element.setAttributeNS("http://schemas.xmlsoap.org/ws/2002/07/utility", "wsu:Id", this.getId());
                element.setAttribute("xmlns:wsu", "http://schemas.xmlsoap.org/ws/2002/07/utility");
            }
            PolicyElement[] elements = this.getElements();
            int i = 0;
            while (i < elements.length) {
                PolicyElement policyElement = elements[i];
                DOMSource childDomSource = XMLSourceHelper.transformToDOMSource(policyElement.getContent());
                if (childDomSource.getNode().getOwnerDocument() != element.getOwnerDocument()) {
                    Node imported = element.getOwnerDocument().importNode(childDomSource.getNode(), true);
                    element.appendChild(imported);
                } else {
                    element.appendChild(childDomSource.getNode());
                }
                ++i;
            }
            return e;
        }
        catch (Exception e) {
            throw new PolicyException(e);
        }
    }

    private IPolicyManager getPolicyManager() {
        return (IPolicyManager)Context.getInstance("org.systinet.wasp.policy.PolicyManager");
    }
}

