/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.policy;

import java.util.Iterator;
import java.util.TreeMap;
import org.idoox.wasp.Context;
import org.systinet.wasp.policy.DomainExpression;
import org.systinet.wasp.policy.EffectivePolicy;
import org.systinet.wasp.policy.IPolicyManager;
import org.systinet.wasp.policy.Policy;
import org.systinet.wasp.policy.PolicyAllOperator;
import org.systinet.wasp.policy.PolicyAssertion;
import org.systinet.wasp.policy.PolicyCompositor;
import org.systinet.wasp.policy.PolicyElement;
import org.systinet.wasp.policy.PolicyExactlyOneOperator;
import org.systinet.wasp.policy.PolicyOneOrMoreOperator;

public class EffectivePolicyImpl
implements EffectivePolicy {
    private DomainExpression domainExpression;
    private Policy policy;
    private ElementHolder root = null;
    boolean initialized = false;

    public EffectivePolicyImpl(DomainExpression domainExpression) {
        this.domainExpression = domainExpression;
    }

    private void initialize() {
        IPolicyManager policyManager = (IPolicyManager)Context.getInstance("org.systinet.wasp.policy.PolicyManager");
        this.policy = policyManager.calculateEffectivePolicy(this.domainExpression);
        this.root = new ElementHolder(null, this.policy);
        this.buildPolicyTree(this.root, this.policy);
    }

    public PolicyAssertion getAssertion(PolicyAssertion assertion) {
        ElementHolder holder;
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
        if ((holder = this.findElement(this.root, assertion)) != null) {
            return (PolicyAssertion)holder.value;
        }
        return null;
    }

    private final ElementHolder findElement(ElementHolder holder, PolicyElement element) {
        if (holder.value.equals(element)) {
            return holder;
        }
        Iterator iterator = holder.childs.keySet().iterator();
        while (iterator.hasNext()) {
            ElementHolder h = (ElementHolder)iterator.next();
            ElementHolder h2 = this.findElement(h, element);
            if (h2 == null) continue;
            return h2;
        }
        return null;
    }

    public Policy getPolicy() {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
        return this.policy;
    }

    public boolean isPolicySatisfied() {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
        return this.root.asserted || this.root.couldBeAsserted;
    }

    public PolicyAssertion setSatisfied(PolicyAssertion assertion) {
        ElementHolder h;
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
        if ((h = this.findElement(this.root, assertion)) != null) {
            h.asserted = true;
            this.evaluateAssertedToParents(h.parent);
            return (PolicyAssertion)h.value;
        }
        return null;
    }

    public boolean isSatisfied(PolicyAssertion assertion) {
        ElementHolder holder;
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
        if ((holder = this.findElement(this.root, assertion)) != null) {
            return holder.asserted;
        }
        return false;
    }

    private final void evaluateAssertedToParents(ElementHolder holder) {
        if (holder != null) {
            if (holder.value instanceof PolicyExactlyOneOperator) {
                holder.asserted = true;
                this.evaluateAssertedToParents(holder.parent);
            } else if (holder.value instanceof PolicyAllOperator) {
                boolean allAsserted = true;
                Iterator iterator = holder.childs.keySet().iterator();
                while (iterator.hasNext()) {
                    ElementHolder elementHolder = (ElementHolder)iterator.next();
                    if (elementHolder.asserted) continue;
                    allAsserted = false;
                    break;
                }
                if (allAsserted) {
                    holder.asserted = true;
                    this.evaluateAssertedToParents(holder.parent);
                }
            } else if (holder.value instanceof PolicyOneOrMoreOperator) {
                boolean allAsserted = true;
                boolean couldBeAsserted = false;
                Iterator iterator = holder.childs.keySet().iterator();
                while (iterator.hasNext()) {
                    ElementHolder elementHolder = (ElementHolder)iterator.next();
                    if (!elementHolder.asserted) {
                        allAsserted = false;
                        continue;
                    }
                    couldBeAsserted = true;
                }
                if (allAsserted) {
                    holder.asserted = true;
                    this.evaluateAssertedToParents(holder.parent);
                } else if (couldBeAsserted) {
                    holder.couldBeAsserted = true;
                    this.evaluateAssertedToParents(holder.parent);
                }
            }
        }
    }

    private final void buildPolicyTree(ElementHolder parent, PolicyCompositor compositor) {
        PolicyElement[] elements = compositor.getElements();
        int i = 0;
        while (i < elements.length) {
            PolicyElement element = elements[i];
            ElementHolder child = new ElementHolder(parent, element);
            parent.childs.put(child, child);
            if (element instanceof PolicyCompositor) {
                this.buildPolicyTree(child, (PolicyCompositor)element);
            }
            ++i;
        }
    }

    private static class ElementHolder
    implements Comparable {
        public ElementHolder parent;
        public TreeMap childs = new TreeMap();
        public PolicyElement value;
        boolean asserted = false;
        boolean couldBeAsserted = false;

        public ElementHolder(ElementHolder parent, PolicyElement value) {
            this.parent = parent;
            this.value = value;
        }

        public int compareTo(Object o) {
            PolicyElement e1 = this.value;
            PolicyElement e2 = ((ElementHolder)o).value;
            if (e1.getPreference() < e2.getPreference()) {
                return 1;
            }
            if (e1.getPreference() > e2.getPreference()) {
                return -1;
            }
            if (e1.equals(e2)) {
                return 0;
            }
            return 2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ElementHolder)) {
                return false;
            }
            ElementHolder elementHolder = (ElementHolder)o;
            return this.value.equals(elementHolder.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

