/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.monitoring.events;

import com.systinet.monitoring.LogEvent;
import com.systinet.wasp.monitoring.WaspEventConfigurator;
import com.systinet.wasp.monitoring.config.EventConfig;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import org.systinet.monitoring.Severities;

public class WaspLogEvent
extends LogEvent {
    static String serverName = null;

    public String getServerName() {
        if (serverName != null) {
            return serverName;
        }
        try {
            serverName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return serverName;
    }

    protected WaspLogEvent(String type) {
        this.type = type;
        EventConfig eventConfig = WaspEventConfigurator.getInstance().getEventConfig(type);
        if (eventConfig != null) {
            this.severity = Severities.severityNameToInt(eventConfig.getSeverity());
            this.message = eventConfig.getMessage();
            this.categoryName = eventConfig.getCategoryName();
        }
    }

    public String getMessageText() {
        StringBuffer ret = new StringBuffer();
        ret.append("<").append(Severities.getSeverityName(this.severity)).append("> ");
        ret.append("<").append(this.type).append("> ");
        if (this.subsystem != null) {
            ret.append("<").append(this.subsystem).append("> ");
        }
        if (this.message != null && this.messageParameters != null) {
            ret.append(MessageFormat.format(this.message, this.messageParameters));
        } else {
            if (this.message != null) {
                return this.message;
            }
            ret.toString();
        }
        return ret.toString();
    }
}

