/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.monitoring;

import com.idoox.config.xml.XMLConfigurator;
import com.idoox.debug.Category;
import com.systinet.wasp.monitoring.config.DescriptorConfig;
import com.systinet.wasp.monitoring.config.EventConfig;
import com.systinet.wasp.monitoring.config.EventConfigImpl;
import com.systinet.wasp.monitoring.config.EventListenerConfig;
import com.systinet.wasp.monitoring.config.EventListenersConfig;
import com.systinet.wasp.monitoring.config.MainConfig;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.idoox.config.IConfigurator;
import org.idoox.wasp.Context;
import org.systinet.monitoring.EventListener;
import org.systinet.monitoring.EventManager;
import org.systinet.monitoring.LogLog;
import org.systinet.wasp.admin.PackageInfo;
import org.systinet.wasp.admin.PackageListener;
import org.systinet.wasp.admin.PackageRepository;

public class WaspEventConfigurator
implements PackageListener {
    private static Category cat = Category.getCategory((class$com$systinet$wasp$monitoring$WaspEventConfigurator == null ? (class$com$systinet$wasp$monitoring$WaspEventConfigurator = WaspEventConfigurator.class$("com.systinet.wasp.monitoring.WaspEventConfigurator")) : class$com$systinet$wasp$monitoring$WaspEventConfigurator).getName());
    private static WaspEventConfigurator instance;
    IConfigurator configurator;
    MainConfig mainConfig;
    Configurable configurable;
    protected Map dynamicallyLoadedListeners = new HashMap();
    Map listenerInstances = new HashMap();
    Map eventConfigs = new HashMap();
    static /* synthetic */ Class class$com$systinet$wasp$monitoring$WaspEventConfigurator;
    static /* synthetic */ Class class$com$systinet$wasp$monitoring$config$MainConfig;
    static /* synthetic */ Class class$com$systinet$wasp$monitoring$config$DescriptorConfig;

    public static synchronized WaspEventConfigurator getInstance(String fileName) {
        if (instance == null) {
            instance = new WaspEventConfigurator(fileName);
        }
        return instance;
    }

    public static synchronized WaspEventConfigurator getInstance() {
        if (instance == null) {
            instance = new WaspEventConfigurator();
        }
        return instance;
    }

    public static synchronized WaspEventConfigurator getInstance(Configurable configurable) {
        instance = new WaspEventConfigurator(configurable);
        return instance;
    }

    private WaspEventConfigurator(String fileName) {
        Configurable configurable;
        ((PackageRepository)Context.getInstance("org.systinet.wasp.admin.PackageRepository")).addListener(this);
        LogLog.warn("WaspEventConfigurator is loaded from file: " + fileName);
        this.configurator = new XMLConfigurator();
        HashMap<String, String> initParam = new HashMap<String, String>();
        File file = new File(fileName);
        String confFilePath = null;
        try {
            confFilePath = file.getCanonicalPath();
        }
        catch (IOException e) {
            cat.error("Unable to read configuration!", e);
        }
        confFilePath = confFilePath.replace('\\', '/');
        int index = confFilePath.lastIndexOf(47);
        initParam.put("wasp.location", confFilePath.substring(0, index));
        initParam.put("wasp.config.location", confFilePath.substring(index + 1));
        this.configurator.init(initParam);
        this.configurable = configurable = this.configurator.getConfigurable("logging", "main");
        this.mainConfig = (MainConfig)configurable.narrow(class$com$systinet$wasp$monitoring$config$MainConfig == null ? (class$com$systinet$wasp$monitoring$config$MainConfig = WaspEventConfigurator.class$("com.systinet.wasp.monitoring.config.MainConfig")) : class$com$systinet$wasp$monitoring$config$MainConfig);
        this.registerHandlers();
    }

    private WaspEventConfigurator(Configurable configurable) {
        ((PackageRepository)Context.getInstance("org.systinet.wasp.admin.PackageRepository")).addListener(this);
        this.configurable = configurable;
        this.mainConfig = (MainConfig)configurable.narrow(class$com$systinet$wasp$monitoring$config$MainConfig == null ? (class$com$systinet$wasp$monitoring$config$MainConfig = WaspEventConfigurator.class$("com.systinet.wasp.monitoring.config.MainConfig")) : class$com$systinet$wasp$monitoring$config$MainConfig);
        this.registerHandlers();
    }

    public WaspEventConfigurator() {
    }

    private void registerHandlers() {
        String[] globalListeners = this.mainConfig.getLogEvents().getEventListener();
        EventConfig[] eventConfigs = this.mainConfig.getLogEvents().getEvent();
        int i = 0;
        while (i < eventConfigs.length) {
            EventConfig eventConfig = eventConfigs[i];
            String eventType = eventConfig.getType();
            int j = 0;
            while (j < globalListeners.length) {
                String globalListener = globalListeners[j];
                EventListener listener = this.getEventListenerInstance(globalListener);
                if (listener != null) {
                    EventManager.addListener(eventType, listener);
                }
                ++j;
            }
            String[] listenersNames = eventConfig.getEventListener();
            int j2 = 0;
            while (j2 < listenersNames.length) {
                String listenersName = listenersNames[j2];
                EventListener listener = this.getEventListenerInstance(listenersName);
                if (listener != null) {
                    EventManager.addListener(eventType, listener);
                }
                ++j2;
            }
            ++i;
        }
    }

    EventListener getEventListenerInstance(String name) {
        if (this.mainConfig == null) {
            return null;
        }
        EventListener listener = (EventListener)this.listenerInstances.get(name);
        if (listener == null) {
            EventListenerConfig[] eventListenerConfigs = this.mainConfig.getEventListeners().getEventListener();
            int i = 0;
            while (i < eventListenerConfigs.length) {
                EventListenerConfig eventListenerConfig = eventListenerConfigs[i];
                String listenerName = eventListenerConfig.getName();
                if (listenerName.equals(name)) {
                    try {
                        cat.debug("Registering " + eventListenerConfig.getClassName());
                        listener = (EventListener)Class.forName(eventListenerConfig.getClassName()).newInstance();
                        if (this.configurator != null) {
                            listener.init(this.configurator.getConfigurable(eventListenerConfig));
                        } else {
                            listener.init(Configurator.getConfigurable(eventListenerConfig));
                        }
                        this.listenerInstances.put(name, listener);
                        break;
                    }
                    catch (Exception e) {
                        cat.error("Unable to create instance of EventListener. ", e);
                    }
                }
                ++i;
            }
        }
        return listener;
    }

    public EventConfig getEventConfig(String eventType) {
        if (eventType == null) {
            throw new NullPointerException("LogEvent type can not be NULL.");
        }
        EventConfig eventConfig = (EventConfig)this.eventConfigs.get(eventType);
        if (eventConfig != null) {
            return eventConfig;
        }
        if (this.mainConfig == null) {
            return null;
        }
        EventConfig[] configs = this.mainConfig.getLogEvents().getEvent();
        int i = 0;
        while (i < configs.length) {
            eventConfig = configs[i];
            if (eventConfig.getType().equals(eventType)) {
                EventConfigImpl eventConfigImpl = new EventConfigImpl(eventConfig);
                this.eventConfigs.put(eventType, eventConfigImpl);
                return eventConfigImpl;
            }
            ++i;
        }
        return null;
    }

    public Map getListenerInstances() {
        return this.listenerInstances;
    }

    public static void destroyListeners() {
        Collection listeners = WaspEventConfigurator.instance.listenerInstances.values();
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            EventListener l = (EventListener)iterator.next();
            try {
                l.destroy();
            }
            catch (Exception e) {
                LogLog.error("Exception while destroying event listener." + l, e);
            }
        }
    }

    public void onDeploy(PackageInfo packageInfo, ClassLoader classLoader, Configurable configurable) {
        DescriptorConfig descriptorConfig = (DescriptorConfig)configurable.narrow(class$com$systinet$wasp$monitoring$config$DescriptorConfig == null ? (class$com$systinet$wasp$monitoring$config$DescriptorConfig = WaspEventConfigurator.class$("com.systinet.wasp.monitoring.config.DescriptorConfig")) : class$com$systinet$wasp$monitoring$config$DescriptorConfig);
        DescriptorConfig.Module module = descriptorConfig.getModule();
        EventListenersConfig eventListenersConfig = null;
        EventListenerConfig[] eventListenerConfigs = null;
        if (module != null) {
            eventListenersConfig = module.getEventListeners();
        }
        if (eventListenersConfig != null) {
            eventListenerConfigs = eventListenersConfig.getEventListener();
        }
        if (eventListenerConfigs != null) {
            HashMap<String, EventListener> eventListenersInstances = new HashMap<String, EventListener>();
            int i = 0;
            while (i < eventListenerConfigs.length) {
                EventListenerConfig eventListenerConfig = eventListenerConfigs[i];
                if (eventListenerConfig != null && eventListenerConfig.getClassName() != null) {
                    String listenerName = eventListenerConfig.getName();
                    try {
                        EventListener listener = (EventListener)Class.forName(eventListenerConfig.getClassName(), true, classLoader).newInstance();
                        listener.init(Configurator.getConfigurable(eventListenerConfig));
                        this.listenerInstances.put(listenerName, listener);
                        EventConfig[] eventConfigs = this.mainConfig.getLogEvents().getEvent();
                        int j = 0;
                        while (j < eventConfigs.length) {
                            EventConfig eventConfig = eventConfigs[j];
                            String eventType = eventConfig.getType();
                            cat.debug("Registering event=" + eventType + " listener=" + listener.getClass().getName());
                            EventManager.addListener(eventType, listener);
                            ++j;
                        }
                        cat.debug("Registering dynamically loaded listener " + listener.getClass().getName());
                        eventListenersInstances.put(listenerName, listener);
                    }
                    catch (Exception e) {
                        cat.error("Unable to create instance of EventListener!", e);
                    }
                }
                ++i;
            }
            this.dynamicallyLoadedListeners.put(packageInfo.pckg.context + "/" + packageInfo.pckg.name, eventListenersInstances);
        }
    }

    public void onUndeploy(PackageInfo packageInfo) {
        String key = packageInfo.pckg.context + "/" + packageInfo.pckg.name;
        cat.debug("Removing listeners of package " + key);
        Map listeners = (Map)this.dynamicallyLoadedListeners.get(key);
        if (listeners != null) {
            Iterator i = listeners.keySet().iterator();
            while (i.hasNext()) {
                String mapKey = (String)i.next();
                EventListener listener = (EventListener)listeners.get(mapKey);
                if (listener != null) {
                    EventConfig[] eventConfigs = this.mainConfig.getLogEvents().getEvent();
                    int j = 0;
                    while (j < eventConfigs.length) {
                        EventConfig eventConfig = eventConfigs[j];
                        String eventType = eventConfig.getType();
                        cat.debug("Unregistering event=" + eventType + " listener=" + listener.getClass().getName());
                        EventManager.removeListener(eventType, listener);
                        ++j;
                    }
                }
                this.listenerInstances.remove(mapKey);
            }
            this.dynamicallyLoadedListeners.remove(key);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

