/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.dd;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.systinet.wasp.dd.OrderedPart;
import org.systinet.wasp.webservice.PublishException;

class QNameDAG {
    public static final boolean ELEMENT_OF_GROUP = false;
    public static final boolean GROUP = true;
    public static final int NO_PREFERRED_ORDER = Integer.MIN_VALUE;
    private int preferredOrder = 0;
    private GraphNode groupNode;
    private List firstNodes = new LinkedList();
    private List lastNodes = new LinkedList();
    private HashMap qNames = new HashMap();
    private HashMap objects = new HashMap();
    private HashSet zeroInDegreeNodes = new HashSet();

    QNameDAG() {
    }

    public void insertOrderInfo(OrderedPart part, QName qName, boolean group) {
        GraphNode node = this.getNode(qName, part, this.preferredOrder++);
        if (group) {
            this.groupNode = node;
            node.setGroup();
        } else if (this.groupNode != null) {
            this.groupNode.addGroupMember(node);
        }
        if (part.getFollowingParts() == OrderedPart.ALL_PARTS) {
            this.firstNodes.add(node);
            return;
        }
        if (part.getPrecedingParts() == OrderedPart.ALL_PARTS) {
            this.lastNodes.add(node);
            return;
        }
        QName[] names = part.getFollowingParts();
        if (names != null) {
            int i = 0;
            while (i < names.length) {
                GraphNode nodeB = this.getNode(names[i]);
                node.addLink(nodeB);
                ++i;
            }
        }
        if ((names = part.getPrecedingParts()) != null) {
            int i = 0;
            while (i < names.length) {
                GraphNode nodeA = this.getNode(names[i]);
                nodeA.addLink(node);
                ++i;
            }
        }
    }

    public void insertOrderInfo(OrderedPart part) {
        this.getNode(null, part, this.preferredOrder++);
    }

    private GraphNode getNode(QName qName, Object object, int preferredOrder) {
        if (this.qNames.containsKey(qName)) {
            GraphNode node = (GraphNode)this.qNames.get(qName);
            node.object = object;
            if (node.preferredOrder == Integer.MIN_VALUE) {
                node.preferredOrder = preferredOrder;
            }
            this.objects.put(object, node);
            return node;
        }
        GraphNode node = new GraphNode(qName, object, preferredOrder);
        this.objects.put(object, node);
        if (qName != null) {
            this.qNames.put(qName, node);
        }
        return node;
    }

    private GraphNode getNode(QName qName) {
        if (this.qNames.containsKey(qName)) {
            return (GraphNode)this.qNames.get(qName);
        }
        GraphNode node = new GraphNode(qName, null, Integer.MIN_VALUE);
        this.qNames.put(qName, node);
        return node;
    }

    public List getSortedObjects() throws PublishException {
        LinkedList<Object> sorted = null;
        try {
            GraphNode prevNode;
            Iterator j;
            Collection allNodes = this.qNames.values();
            Iterator i = this.firstNodes.iterator();
            while (i.hasNext()) {
                GraphNode node = (GraphNode)i.next();
                HashSet suitableNodes = new HashSet(allNodes);
                LinkedList<GraphNode> toVisit = new LinkedList<GraphNode>();
                toVisit.add(node);
                while (!toVisit.isEmpty()) {
                    GraphNode examinedNode = (GraphNode)toVisit.remove(0);
                    suitableNodes.remove(examinedNode);
                    j = examinedNode.prev.iterator();
                    while (j.hasNext()) {
                        prevNode = (GraphNode)j.next();
                        if (!suitableNodes.contains(prevNode)) continue;
                        toVisit.add(prevNode);
                    }
                }
                Iterator j2 = suitableNodes.iterator();
                while (j2.hasNext()) {
                    GraphNode nextNode = (GraphNode)j2.next();
                    node.addLink(nextNode);
                }
            }
            Iterator i2 = this.lastNodes.iterator();
            while (i2.hasNext()) {
                GraphNode node = (GraphNode)i2.next();
                HashSet suitableNodes = new HashSet(allNodes);
                LinkedList<GraphNode> toVisit = new LinkedList<GraphNode>();
                toVisit.add(node);
                while (!toVisit.isEmpty()) {
                    GraphNode examinedNode = (GraphNode)toVisit.remove(0);
                    suitableNodes.remove(examinedNode);
                    Iterator j3 = examinedNode.next.iterator();
                    while (j3.hasNext()) {
                        GraphNode nextNode = (GraphNode)j3.next();
                        if (!suitableNodes.contains(nextNode)) continue;
                        toVisit.add(nextNode);
                    }
                }
                j = suitableNodes.iterator();
                while (j.hasNext()) {
                    prevNode = (GraphNode)j.next();
                    prevNode.addLink(node);
                }
            }
            sorted = new LinkedList<Object>();
            TreeSet zeroInDegreeNodes = new TreeSet();
            Iterator nodes = this.zeroInDegreeNodes.iterator();
            while (nodes.hasNext()) {
                zeroInDegreeNodes.add(nodes.next());
            }
            while (!zeroInDegreeNodes.isEmpty()) {
                GraphNode node = (GraphNode)zeroInDegreeNodes.first();
                zeroInDegreeNodes.remove(node);
                if (!node.groupNode && node.object != null) {
                    sorted.add(node.object);
                }
                this.qNames.remove(node.key);
                Iterator i3 = node.next.iterator();
                while (i3.hasNext()) {
                    GraphNode child = (GraphNode)i3.next();
                    if (--child.inDegree != 0) continue;
                    zeroInDegreeNodes.add(child);
                }
            }
            Iterator partsInCycle = this.qNames.keySet().iterator();
            if (partsInCycle.hasNext()) {
                StringBuffer message = new StringBuffer("Cyclic dependency fromed by preceding-parts or following-parts attributes! Parts in cycle:");
                while (partsInCycle.hasNext()) {
                    message.append(' ');
                    message.append(partsInCycle.next().toString());
                }
                throw new PublishException(message.toString());
            }
        }
        catch (GraphNodeException e) {
            throw new PublishException("QName " + e.getqName() + " specified in preceding-parts or following-parts" + " not found.");
        }
        return sorted;
    }

    class GraphNodeException
    extends RuntimeException {
        QName qName;

        public QName getqName() {
            return this.qName;
        }

        public GraphNodeException(QName qName) {
            this.qName = qName;
        }
    }

    class GraphNode
    implements Comparable {
        public int inDegree = 0;
        public HashSet next = new HashSet();
        public HashSet prev = new HashSet();
        public boolean groupNode = false;
        public GraphNode groupEnd = null;
        public QName key;
        public Object object;
        public int preferredOrder;

        public GraphNode(QName key, Object object, int preferredOrder) {
            this.key = key;
            this.object = object;
            this.preferredOrder = preferredOrder;
            QNameDAG.this.zeroInDegreeNodes.add(this);
        }

        public void addLink(GraphNode child) {
            if (!this.next.contains(child)) {
                if (child.inDegree == 0) {
                    QNameDAG.this.zeroInDegreeNodes.remove(child);
                }
                ++child.inDegree;
                this.next.add(child);
                child.prev.add(this);
            }
        }

        private void addLink(GraphNode child, boolean group) {
            if (group && this.groupEnd != null) {
                this.groupEnd.addLink(child, false);
            } else {
                this.addLink(child);
            }
        }

        public void setGroup() {
            if (this.groupEnd == null) {
                this.groupNode = true;
                GraphNode tmp = new GraphNode(null, null, this.preferredOrder);
                tmp.groupNode = true;
                Iterator children = this.next.iterator();
                while (children.hasNext()) {
                    tmp.next.add(children.next());
                }
                this.next.clear();
                this.addLink(tmp);
                this.groupEnd = tmp;
            }
        }

        public void addGroupMember(GraphNode child) {
            this.addLink(child, false);
            child.addLink(this.groupEnd);
        }

        public int compareTo(Object o) {
            if (this.preferredOrder == Integer.MIN_VALUE) {
                throw new GraphNodeException(this.key);
            }
            if (((GraphNode)o).preferredOrder == Integer.MIN_VALUE) {
                throw new GraphNodeException(((GraphNode)o).key);
            }
            return this.preferredOrder - ((GraphNode)o).preferredOrder;
        }
    }
}

