/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.dd;

import com.systinet.wasp.dd.QNameDAG;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.systinet.wasp.dd.Dependency;
import org.systinet.wasp.dd.DeploymentDescriptor;
import org.systinet.wasp.dd.Export;
import org.systinet.wasp.dd.FaultSerialization;
import org.systinet.wasp.dd.Handler;
import org.systinet.wasp.dd.HeaderProcessor;
import org.systinet.wasp.dd.Interceptor;
import org.systinet.wasp.dd.Processing;
import org.systinet.wasp.dd.Serialization;
import org.systinet.wasp.dd.TypeMapping;
import org.systinet.wasp.webservice.PublishException;

public class DescriptorHelper {
    private static final FaultSerializationExtractor FAULT_SERIALIZATION_EXTRACTOR = new FaultSerializationExtractor();
    private static final HeaderProcessorExtractor HEADER_PROCESSOR_EXTRACTOR = new HeaderProcessorExtractor();
    private static final HandlerExtractor HANDLER_EXTRACTOR = new HandlerExtractor();
    private static final InterceptorExtractor INTERCEPTOR_EXTRACTOR = new InterceptorExtractor();
    private static final SerializationExtractor SERIALIZATION_EXTRACTOR = new SerializationExtractor();
    private static final TypeMappingExtractor TYPE_MAPPING_EXTRACTOR = new TypeMappingExtractor();
    private static final SchemaProcessingExtractor SCHEMA_PROCESSING_EXTRACTOR = new SchemaProcessingExtractor();

    public static Iterator getProcessedFaultSerializations(Processing processing) throws PublishException {
        return DescriptorHelper.extractProcessings(processing, FAULT_SERIALIZATION_EXTRACTOR);
    }

    public static Iterator getProcessedHeaderProcessors(Processing processing) throws PublishException {
        return DescriptorHelper.extractProcessings(processing, HEADER_PROCESSOR_EXTRACTOR);
    }

    public static List getProcessedHeaderProcessorsAsList(Processing processing) throws PublishException {
        return DescriptorHelper.extractProcessingsAsList(processing, HEADER_PROCESSOR_EXTRACTOR);
    }

    public static Iterator getProcessedHandlers(Processing processing) throws PublishException {
        return DescriptorHelper.extractProcessings(processing, HANDLER_EXTRACTOR);
    }

    public static List getProcessedHandlersAsList(Processing processing) throws PublishException {
        return DescriptorHelper.extractProcessingsAsList(processing, HANDLER_EXTRACTOR);
    }

    public static Iterator getProcessedSerializations(Processing processing) throws PublishException {
        return DescriptorHelper.extractProcessings(processing, SERIALIZATION_EXTRACTOR);
    }

    public static Iterator getProcessedInterceptors(Processing processing) throws PublishException {
        return DescriptorHelper.extractProcessings(processing, INTERCEPTOR_EXTRACTOR);
    }

    public static Iterator getProcessedTypeMappings(Processing processing) throws PublishException {
        return DescriptorHelper.extractProcessings(processing, TYPE_MAPPING_EXTRACTOR);
    }

    public static Iterator getProcessedSchemaProcessings(Processing processing) throws PublishException {
        return DescriptorHelper.extractProcessings(processing, SCHEMA_PROCESSING_EXTRACTOR);
    }

    private static Iterator extractProcessings(Processing processing, ProcessingExtractor extractor) throws PublishException {
        return DescriptorHelper.extractProcessingsAsList(processing, extractor).iterator();
    }

    private static List extractProcessingsAsList(Processing processing, ProcessingExtractor extractor) throws PublishException {
        DeploymentDescriptor dd;
        QNameDAG graph = new QNameDAG();
        HashSet visitedProcessings = new HashSet();
        if (!processing.isIgnorePushed() && (dd = processing.getDeploymentDescriptor()) != null) {
            Iterator dependencies = dd.getDependencies().iterator();
            while (dependencies.hasNext()) {
                DeploymentDescriptor parentDD = ((Dependency)dependencies.next()).getReferredDeploymentDescriptor();
                if (parentDD == null) continue;
                Iterator exports = parentDD.getExports().iterator();
                while (exports.hasNext()) {
                    Export export = (Export)exports.next();
                    if (!export.isPush()) continue;
                    Iterator processings = export.getProcessings().iterator();
                    while (processings.hasNext()) {
                        DescriptorHelper.extractProcessing(graph, (Processing)processings.next(), extractor, visitedProcessings);
                    }
                    extractor.extract(graph, processing, export);
                }
            }
        }
        DescriptorHelper.extractProcessing(graph, processing, extractor, visitedProcessings);
        return graph.getSortedObjects();
    }

    private static void extractProcessing(QNameDAG graph, Processing processing, ProcessingExtractor extractor, Set visitedProcessings) {
        if (!visitedProcessings.contains(processing)) {
            visitedProcessings.add(processing);
            Iterator nProcessings = processing.getProcessings().iterator();
            while (nProcessings.hasNext()) {
                DescriptorHelper.extractProcessing(graph, (Processing)nProcessings.next(), extractor, visitedProcessings);
            }
            graph.insertOrderInfo(processing, processing.getName(), true);
            extractor.extract(graph, processing, null);
        }
    }

    static class SchemaProcessingExtractor
    implements ProcessingExtractor {
        SchemaProcessingExtractor() {
        }

        public void extract(QNameDAG graph, Processing processing, Export export) {
            List data = processing.getSchemas();
            if (data.size() != 0) {
                graph.insertOrderInfo(processing);
            }
        }
    }

    static class TypeMappingExtractor
    implements ProcessingExtractor {
        TypeMappingExtractor() {
        }

        public void extract(QNameDAG graph, Processing processing, Export export) {
            List data = processing.getTypeMappings();
            Iterator i = data.iterator();
            while (i.hasNext()) {
                TypeMapping obj = (TypeMapping)i.next();
                graph.insertOrderInfo(obj, obj.getName(), false);
            }
        }
    }

    static class SerializationExtractor
    implements ProcessingExtractor {
        SerializationExtractor() {
        }

        public void extract(QNameDAG graph, Processing processing, Export export) {
            List data = export == null ? processing.getSerializations() : export.getSerializations();
            Iterator i = data.iterator();
            while (i.hasNext()) {
                Serialization obj = (Serialization)i.next();
                graph.insertOrderInfo(obj, obj.getName(), false);
            }
        }
    }

    static class InterceptorExtractor
    implements ProcessingExtractor {
        InterceptorExtractor() {
        }

        public void extract(QNameDAG graph, Processing processing, Export export) {
            List data = export == null ? processing.getInterceptors() : export.getInterceptors();
            Iterator i = data.iterator();
            while (i.hasNext()) {
                Interceptor obj = (Interceptor)i.next();
                graph.insertOrderInfo(obj, obj.getName(), false);
            }
        }
    }

    static class HandlerExtractor
    implements ProcessingExtractor {
        HandlerExtractor() {
        }

        public void extract(QNameDAG graph, Processing processing, Export export) {
            List data = export == null ? processing.getHandlers() : export.getHandlers();
            Iterator i = data.iterator();
            while (i.hasNext()) {
                Handler obj = (Handler)i.next();
                graph.insertOrderInfo(obj, obj.getName(), false);
            }
        }
    }

    static class HeaderProcessorExtractor
    implements ProcessingExtractor {
        HeaderProcessorExtractor() {
        }

        public void extract(QNameDAG graph, Processing processing, Export export) {
            List data = export == null ? processing.getHeaderProcessors() : export.getHeaderProcessors();
            Iterator i = data.iterator();
            while (i.hasNext()) {
                HeaderProcessor obj = (HeaderProcessor)i.next();
                graph.insertOrderInfo(obj, obj.getName(), false);
            }
        }
    }

    static class FaultSerializationExtractor
    implements ProcessingExtractor {
        FaultSerializationExtractor() {
        }

        public void extract(QNameDAG graph, Processing processing, Export export) {
            List data = export == null ? processing.getFaultSerializations() : export.getFaultSerializations();
            Iterator i = data.iterator();
            while (i.hasNext()) {
                FaultSerialization obj = (FaultSerialization)i.next();
                graph.insertOrderInfo(obj, obj.getName(), false);
            }
        }
    }

    static interface ProcessingExtractor {
        public void extract(QNameDAG var1, Processing var2, Export var3);
    }
}

