/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.client;

import com.idoox.debug.Category;
import com.idoox.soap.MustUnderstandException;
import com.systinet.wasp.async.AsyncCallbackService;
import com.systinet.wasp.async.AsyncConversationImpl;
import com.systinet.wasp.async.AsyncRuntimeManager;
import com.systinet.wasp.async.MessageQueue;
import com.systinet.wasp.rpc.handler.HandlerChainInvoker;
import com.systinet.wasp.rpc.handler.SOAPMessageContextFactory;
import com.systinet.wasp.soap.GETInputMessageWrapper;
import com.systinet.wasp.webservice.CurrentImpl;
import com.systinet.wasp.webservice.ServiceClientImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.idoox.transport.Connection;
import org.idoox.transport.InputMessage;
import org.idoox.transport.TransportMethod;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.Context;
import org.idoox.wasp.interceptor.StopProcessingException;
import org.idoox.xml.TokenizerException;
import org.systinet.wasp.async.AsyncCallback;
import org.systinet.wasp.async.AsyncConversation;
import org.systinet.wasp.async.TimeoutException;
import org.systinet.wasp.client.RAWInvocationHelper;
import org.systinet.wasp.client.XMLInvocationException;
import org.systinet.wasp.handler.HandlerRepository;
import org.systinet.wasp.sequence.ISequence;
import org.systinet.wasp.sequence.Sequence;
import org.systinet.wasp.sequence.SequenceException;
import org.systinet.wasp.soap.MessageSource;
import org.systinet.wasp.soap.MessageSourceFactory;
import org.systinet.wasp.soap.UnsupportedMessageTypeException;
import org.systinet.wasp.soap.WaspInternalSOAPMessage;
import org.systinet.wasp.soap.WaspMessageFactory;
import org.systinet.wasp.soap.WaspSOAPMessage;
import org.systinet.wasp.webservice.CallContext;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.LookupException;
import org.systinet.wasp.webservice.ServiceClient;

public class XMLInvocationHelperImpl {
    private static Category log = Category.getCategory("com.systinet.wasp.client.XMLInvocationHelperImpl");
    private static MessageSourceFactory messageSourceFactory = MessageSourceFactory.newInstance();
    private static XMLInvocationHelperImpl instance;
    private static CurrentImpl current;
    static /* synthetic */ Class class$org$systinet$wasp$webservice$ICurrent;

    private static synchronized XMLInvocationHelperImpl getInstance() {
        if (instance == null) {
            instance = new XMLInvocationHelperImpl();
        }
        return instance;
    }

    public static SOAPMessage call(SOAPMessage message, ServiceClient serviceClient, boolean setupContexts) throws XMLInvocationException, RemoteException {
        SOAPMessageContext soapMessageContext = XMLInvocationHelperImpl.getInstance().createAndSetupMessageContext(message);
        SOAPMessage ret = XMLInvocationHelperImpl.getInstance()._call(soapMessageContext, serviceClient, setupContexts);
        return ret;
    }

    private static void _confirmCurrentInputMessage() {
        Sequence sequence = null;
        try {
            sequence = Sequence.getActiveInputSequence();
            if (sequence != null && !sequence.isExplicitConfirmation()) {
                sequence.confirmCurrentMessage();
            }
        }
        catch (SequenceException ep) {
            if (sequence == null) {
                log.error("Cannot confirm the message!!");
            }
            log.error("Cannot confirm the message " + sequence.getID() + " - " + sequence.getCurrentMessageNumber());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SOAPMessage _call(SOAPMessageContext soapMessageContext, ServiceClient serviceClient, boolean setupContexts) throws XMLInvocationException, RemoteException {
        SOAPMessage sOAPMessage;
        ServiceClientImpl.CurrentSaver oldCurrent = null;
        if (setupContexts) {
            oldCurrent = ((ServiceClientImpl)serviceClient).startProcessing();
        }
        try {
            Connection con;
            if (serviceClient.getAsyncTransport() != null) {
                SOAPMessage sOAPMessage2;
                AsyncConversation ac = XMLInvocationHelperImpl.beginCall(soapMessageContext.getMessage(), serviceClient, false);
                InvocatoinHelperCallbackListener listener = new InvocatoinHelperCallbackListener();
                ac.setCallback(listener);
                try {
                    SOAPMessage response;
                    sOAPMessage2 = response = listener.getResponse(ac);
                    Object var10_15 = null;
                    ac.finish();
                }
                catch (Throwable throwable) {
                    Object var10_16 = null;
                    ac.finish();
                    throw throwable;
                }
                Object var12_17 = null;
                if (!setupContexts) return sOAPMessage2;
                ((ServiceClientImpl)serviceClient).endProcessing(oldCurrent);
                return sOAPMessage2;
            }
            try {
                if (((WaspMessageFactory)((WaspInternalSOAPMessage)soapMessageContext.getMessage()).getMessageFactory()).getTransportMethod().equals("get")) {
                    this.processMessage(serviceClient, soapMessageContext);
                    con = XMLInvocationHelperImpl._connect(serviceClient, XMLInvocationHelperImpl.createGetUri(serviceClient, soapMessageContext));
                } else {
                    this.processMessage(serviceClient, soapMessageContext);
                    con = XMLInvocationHelperImpl._connect(serviceClient);
                    this.sendMessage(soapMessageContext.getMessage(), con);
                }
            }
            catch (StopProcessingException e) {
                XMLInvocationHelperImpl._confirmCurrentInputMessage();
                SOAPMessage sOAPMessage3 = soapMessageContext.getMessage();
                Object var12_18 = null;
                if (!setupContexts) return sOAPMessage3;
                ((ServiceClientImpl)serviceClient).endProcessing(oldCurrent);
                return sOAPMessage3;
            }
            SOAPMessage response = this._receive(con, serviceClient, soapMessageContext);
            if (response != null) {
                XMLInvocationHelperImpl._confirmCurrentInputMessage();
            }
            sOAPMessage = response;
        }
        catch (Throwable throwable) {
            Object var12_20 = null;
            if (!setupContexts) throw throwable;
            ((ServiceClientImpl)serviceClient).endProcessing(oldCurrent);
            throw throwable;
        }
        Object var12_19 = null;
        if (!setupContexts) return sOAPMessage;
        ((ServiceClientImpl)serviceClient).endProcessing(oldCurrent);
        return sOAPMessage;
    }

    public static void send(SOAPMessage message, ServiceClient serviceClient) throws RemoteException {
        serviceClient.getCallContext().getContextData().put("oneway.method", "true");
        ServiceClientImpl.CurrentSaver oldCurrent = ((ServiceClientImpl)serviceClient).startProcessing();
        try {
            AsyncConversation ac = XMLInvocationHelperImpl.beginCall(message, serviceClient, false);
            InvocatoinHelperCallbackListener listener = new InvocatoinHelperCallbackListener();
            ac.setCallback(listener);
            try {
                block6: {
                    WaspSOAPMessage responseMessage = (WaspSOAPMessage)listener.getResponse(ac);
                    if (responseMessage == null) break block6;
                    responseMessage.release();
                }
                Object var7_7 = null;
                ac.finish();
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                ac.finish();
                throw throwable;
            }
            Object var9_10 = null;
            ((ServiceClientImpl)serviceClient).endProcessing(oldCurrent);
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            ((ServiceClientImpl)serviceClient).endProcessing(oldCurrent);
            throw throwable;
        }
    }

    public static AsyncConversation beginSend(SOAPMessage message, ServiceClient serviceClient) throws RemoteException {
        serviceClient.getCallContext().getContextData().put("oneway.method", "true");
        ServiceClientImpl.CurrentSaver oldCurrent = ((ServiceClientImpl)serviceClient).startProcessing();
        try {
            AsyncConversation asyncConversation = XMLInvocationHelperImpl.beginCall(message, serviceClient, false);
            Object var5_4 = null;
            ((ServiceClientImpl)serviceClient).endProcessing(oldCurrent);
            return asyncConversation;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((ServiceClientImpl)serviceClient).endProcessing(oldCurrent);
            throw throwable;
        }
    }

    public static void endSend(AsyncConversation asyncConversation) throws RemoteException {
        XMLInvocationHelperImpl.endCall(asyncConversation, true);
    }

    public static void endSend(AsyncConversation asyncConversation, ServiceClient serviceClient) throws RemoteException {
        XMLInvocationHelperImpl.endCall(asyncConversation, serviceClient, true);
    }

    public static SOAPMessageContext handleShortResponse(SOAPMessageContext soapMessageContext, ServiceClient serviceClient, int fromPosition) throws RemoteException {
        if (fromPosition == -1) {
            return soapMessageContext;
        }
        XMLInvocationHelperImpl instance = XMLInvocationHelperImpl.getInstance();
        String handlersID = ((ServiceClientImpl)serviceClient).getHandlersID();
        try {
            boolean fault = ((WaspInternalSOAPMessage)soapMessageContext.getMessage()).hasFault(Current.getCallContext());
            instance.invokeHandlers(handlersID, soapMessageContext, fault ? 12 : 1, fromPosition, -1);
        }
        catch (SOAPException e) {
            log.error("Can't parse message", e);
        }
        if (soapMessageContext.getProperty("SOAPMessage.empty") != null) {
            return null;
        }
        return soapMessageContext;
    }

    public static SOAPMessageContext sendRequest(SOAPMessageContext soapMessageContext, ServiceClient serviceClient, HandlerRepository.DirectionPositionEntry position) throws RemoteException {
        boolean sendMessage = true;
        XMLInvocationHelperImpl instance = XMLInvocationHelperImpl.getInstance();
        try {
            instance.processMessage(serviceClient, soapMessageContext, position.getOutChainPosition() + 1);
        }
        catch (StopProcessingException e) {
            sendMessage = false;
        }
        if (soapMessageContext.getProperty("SOAPMessage.empty") != null) {
            return null;
        }
        ServiceClientImpl.CurrentSaver saver = new ServiceClientImpl.CurrentSaver(Current.getCallContext(), Current.getServiceClientContext(), Current.getProcessingType());
        try {
            SOAPMessage response = null;
            if (sendMessage) {
                response = XMLInvocationHelperImpl.sendReceiveMsg(new MessageQueue.MessageHolder(soapMessageContext, serviceClient, saver), position.getInChainPosition() + 1);
            }
            if (soapMessageContext.getProperty("SOAPMessage.empty") != null || response == null) {
                return null;
            }
            return soapMessageContext;
        }
        catch (LookupException e) {
            log.error("Can't lookup service", e);
            return null;
        }
    }

    public static AsyncConversation beginCall(SOAPMessage message, ServiceClient serviceClient, boolean setupContexts) throws XMLInvocationException, RemoteException {
        ServiceClientImpl.CurrentSaver oldCurrent = null;
        if (setupContexts) {
            oldCurrent = ((ServiceClientImpl)serviceClient).startProcessing();
        }
        try {
            AsyncConversationImpl async = new AsyncConversationImpl(serviceClient);
            async.invocationStarted();
            try {
                AsyncRuntimeManager.setup(async);
            }
            catch (LookupException e) {
                throw new XMLInvocationException("Lookup exception while creating connection", e);
            }
            XMLInvocationHelperImpl instance = XMLInvocationHelperImpl.getInstance();
            SOAPMessageContext soapMessageContext = instance.createAndSetupMessageContext(message);
            async.setSoapMessageContext(soapMessageContext);
            ServiceClientImpl.CurrentSaver saver = ((ServiceClientImpl)serviceClient).cloneCurrentSaver();
            async.setCallContext(saver.callContext);
            if (current == null) {
                current = (CurrentImpl)Context.getInstance("org.systinet.wasp.webservice.ICurrent");
            }
            current.setCallContext(saver.callContext);
            soapMessageContext.setProperty("runtime.invocation.async.asyncresult", async);
            try {
                instance.processMessage(serviceClient, soapMessageContext);
            }
            catch (StopProcessingException stop) {
                SOAPMessage msg = soapMessageContext.getMessage();
                if (msg != null) {
                    async.onMessage(msg);
                }
                AsyncRuntimeManager.incresseActiveJobs();
                AsyncConversationImpl asyncConversationImpl = async;
                Object var12_13 = null;
                if (setupContexts) {
                    ((ServiceClientImpl)serviceClient).endProcessing(oldCurrent);
                }
                return asyncConversationImpl;
            }
            AsyncRuntimeManager.submitMsg(new MessageQueue.MessageHolder(soapMessageContext, serviceClient, saver));
            AsyncConversationImpl asyncConversationImpl = async;
            Object var12_14 = null;
            if (setupContexts) {
                ((ServiceClientImpl)serviceClient).endProcessing(oldCurrent);
            }
            return asyncConversationImpl;
        }
        catch (Throwable throwable) {
            block11: {
                Object var12_15 = null;
                if (!setupContexts) break block11;
                ((ServiceClientImpl)serviceClient).endProcessing(oldCurrent);
            }
            throw throwable;
        }
    }

    private SOAPMessageContext createAndSetupMessageContext(SOAPMessage message) {
        SOAPMessageContext soapMessageContext = SOAPMessageContextFactory.newInstance();
        soapMessageContext.setMessage(message);
        this.setupMessageContext(soapMessageContext, this.getCurrent().getThreadLocals());
        return soapMessageContext;
    }

    private void setupMessageContext(SOAPMessageContext context, CurrentImpl.ThreadLocals contexts) {
        context.setProperty("core.current.threadlocals", contexts);
    }

    public static SOAPMessage endCall(AsyncConversation asyncResult, ServiceClient serviceClient, boolean setupContexts) throws XMLInvocationException, RemoteException {
        ((AsyncConversationImpl)asyncResult).setServiceClient(serviceClient);
        return XMLInvocationHelperImpl.endCall(asyncResult, setupContexts);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SOAPMessage endCall(AsyncConversation asyncResult, boolean setupContexts) throws RemoteException {
        SOAPMessage sOAPMessage;
        ServiceClientImpl.CurrentSaver oldCurrent = null;
        ServiceClient serviceClient = null;
        try {
            Long messageNumber;
            boolean isFault;
            if (setupContexts) {
                if (current == null) {
                    current = (CurrentImpl)Context.getInstance("org.systinet.wasp.webservice.ICurrent");
                }
                CurrentImpl.ThreadLocals threadLocals = current.getThreadLocals();
                oldCurrent = new ServiceClientImpl.CurrentSaver(threadLocals.callContext, threadLocals.serviceClientContext, threadLocals.processingType);
                threadLocals.callContext = ((AsyncConversationImpl)asyncResult).getCallContext();
                threadLocals.serviceClientContext = ((AsyncConversationImpl)asyncResult).getServiceClient().getContext();
                threadLocals.processingType = 1;
            }
            serviceClient = ((AsyncConversationImpl)asyncResult).getServiceClient();
            XMLInvocationHelperImpl instance = XMLInvocationHelperImpl.getInstance();
            SOAPMessage message = instance.waitForMessage(asyncResult);
            if (message == null) {
                if (((AsyncConversationImpl)asyncResult).isTimeouted(System.currentTimeMillis())) {
                    throw new TimeoutException();
                }
                SOAPMessage sOAPMessage2 = null;
                Object var15_8 = null;
                if (!setupContexts) return sOAPMessage2;
                ((ServiceClientImpl)serviceClient).getCallContext().getContextData().putAll(Current.getCallContext().getContextData());
                ((ServiceClientImpl)serviceClient).endProcessing(oldCurrent);
                return sOAPMessage2;
            }
            String processingID = (String)serviceClient.getContext().getContextData().get("core.handler.processing.id");
            String protocol = ((WaspSOAPMessage)message).getXMLProtocol();
            instance.saveProtocol2CallContext(serviceClient.getCallContext(), protocol);
            SOAPMessageContext soapMessageContext = ((AsyncConversationImpl)asyncResult).getSoapMessageContext();
            if (soapMessageContext == null) {
                soapMessageContext = instance.createAndSetupMessageContext(message);
                ((AsyncConversationImpl)asyncResult).setSoapMessageContext(soapMessageContext);
            } else {
                soapMessageContext.setMessage(message);
            }
            try {
                CurrentImpl.ThreadLocals threadLocals = (CurrentImpl.ThreadLocals)soapMessageContext.getProperty("core.current.threadlocals");
                isFault = ((WaspInternalSOAPMessage)message).hasFault(threadLocals.callContext);
            }
            catch (SOAPException e) {
                throw new XMLInvocationException("Exception while processing incoming message", e);
            }
            int direction = isFault ? 12 : 1;
            ISequence sequence = (ISequence)Sequence.getActiveInputSequence();
            if (sequence != null && (messageNumber = (Long)((AsyncConversationImpl)asyncResult).getCallContext().getContextData().get("serverbookmark.message.number")) != null) {
                try {
                    sequence.setCurrentMessageNumber(messageNumber);
                }
                catch (SequenceException e) {
                    log.error("Cannot set current message number", e);
                    throw new RemoteException(e.getMessage());
                }
            }
            instance.invokeHandlers(processingID, soapMessageContext, direction);
            SOAPMessage response = soapMessageContext.getMessage();
            if (response != null) {
                XMLInvocationHelperImpl._confirmCurrentInputMessage();
            }
            sOAPMessage = response;
        }
        catch (Throwable throwable) {
            Object var15_10 = null;
            if (!setupContexts) throw throwable;
            ((ServiceClientImpl)serviceClient).getCallContext().getContextData().putAll(Current.getCallContext().getContextData());
            ((ServiceClientImpl)serviceClient).endProcessing(oldCurrent);
            throw throwable;
        }
        Object var15_9 = null;
        if (!setupContexts) return sOAPMessage;
        ((ServiceClientImpl)serviceClient).getCallContext().getContextData().putAll(Current.getCallContext().getContextData());
        ((ServiceClientImpl)serviceClient).endProcessing(oldCurrent);
        return sOAPMessage;
    }

    private static Connection _connect(ServiceClient serviceClient) throws XMLInvocationException {
        Connection con;
        try {
            con = RAWInvocationHelper.createConnection(serviceClient, serviceClient.getServiceURL(), TransportMethod.POST);
        }
        catch (LookupException e) {
            throw new XMLInvocationException("Lookup exception while creating connection", e);
        }
        catch (StopProcessingException e) {
            throw new XMLInvocationException("Stop processing exception while creating connection", e);
        }
        catch (IOException e) {
            throw new XMLInvocationException("Exception while creating connection", e);
        }
        return con;
    }

    private static Connection _connect(ServiceClient serviceClient, String uri) throws XMLInvocationException {
        Connection con;
        try {
            con = RAWInvocationHelper.createConnection(serviceClient, uri, TransportMethod.GET);
        }
        catch (LookupException e) {
            throw new XMLInvocationException("Lookup exception while creating connection", e);
        }
        catch (StopProcessingException e) {
            throw new XMLInvocationException("Stop processing exception while creating connection", e);
        }
        catch (IOException e) {
            throw new XMLInvocationException("Exception while creating connection", e);
        }
        return con;
    }

    private void sendMessage(SOAPMessage message, Connection con) throws XMLInvocationException {
        try {
            message.writeTo(con.getOutputMessage());
        }
        catch (SOAPException e) {
            throw new XMLInvocationException("Exception while writing soap message to output stream", e);
        }
        catch (IOException e) {
            InputMessage inputMessage = con.getInputMessage();
            if (inputMessage != null) {
                try {
                    inputMessage.close();
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
            throw new XMLInvocationException("Exception while writing message to output stream", e);
        }
    }

    private void processMessage(ServiceClient serviceClient, SOAPMessageContext soapMessageContext) throws RemoteException, StopProcessingException {
        try {
            serviceClient.getServiceURL();
        }
        catch (LookupException e) {
            throw new XMLInvocationException("Lookup exception while creating connection", e);
        }
        this.processHandlers(serviceClient, soapMessageContext);
    }

    private void processMessage(ServiceClient serviceClient, SOAPMessageContext soapMessageContext, int position) throws RemoteException, StopProcessingException {
        try {
            serviceClient.getServiceURL();
        }
        catch (LookupException e) {
            throw new XMLInvocationException("Lookup exception while creating connection", e);
        }
        this.processHandlers(serviceClient, soapMessageContext, position);
    }

    private static String createGetUri(ServiceClient serviceClient, SOAPMessageContext soapMessageContext) throws RemoteException {
        WaspInternalSOAPMessage message = (WaspInternalSOAPMessage)soapMessageContext.getMessage();
        try {
            StringBuffer uri = new StringBuffer();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            message.writeTo(out);
            String uriLast = out.toString();
            String portLocation = null;
            try {
                portLocation = serviceClient.getServiceURL();
            }
            catch (LookupException e) {
                throw new RemoteException("Can't get port location", e);
            }
            uri.append(portLocation);
            if (uriLast == null) {
                uriLast = "";
            }
            if (portLocation == null) {
                portLocation = "";
            }
            if (portLocation.length() != 0 && portLocation.charAt(portLocation.length() - 1) != '/' && uriLast.length() != 0 && uriLast.charAt(0) != '/') {
                uri.append('/');
            }
            if (uriLast.charAt(0) == '/') {
                uri.append(uriLast.substring(1));
            } else {
                uri.append(uriLast);
            }
            return uri.toString();
        }
        catch (SOAPException e) {
            throw new RemoteException("Can't serialize message.", e);
        }
        catch (IOException e) {
            throw new RemoteException("Can't serialize message.", e);
        }
    }

    private void processHandlers(ServiceClient serviceClient, SOAPMessageContext soapMessageContext) throws RemoteException, StopProcessingException {
        SOAPMessage message = soapMessageContext.getMessage();
        String protocol = ((WaspSOAPMessage)message).getXMLProtocol();
        this.saveProtocol2CallContext(serviceClient.getCallContext(), protocol);
        String processingID = (String)serviceClient.getContext().getContextData().get("core.handler.processing.id");
        try {
            HandlerChainInvoker.State state = this.invokeHandlers(processingID, soapMessageContext, 2);
            if (state.statusCode == 2) {
                throw new StopProcessingException();
            }
        }
        catch (StopProcessingException e) {
            if (soapMessageContext.getProperty("SOAPMessage.empty") == null) {
                this.invokeHandlers(processingID, soapMessageContext, 1);
            }
            throw e;
        }
    }

    private void processHandlers(ServiceClient serviceClient, SOAPMessageContext soapMessageContext, int fromPosition) throws RemoteException, StopProcessingException {
        SOAPMessage message = soapMessageContext.getMessage();
        String protocol = ((WaspSOAPMessage)message).getXMLProtocol();
        this.saveProtocol2CallContext(serviceClient.getCallContext(), protocol);
        String processingID = (String)serviceClient.getContext().getContextData().get("core.handler.processing.id");
        try {
            HandlerChainInvoker.State state = this.invokeHandlers(processingID, soapMessageContext, 2, fromPosition, -1);
            if (state.statusCode == 2) {
                throw new StopProcessingException();
            }
        }
        catch (StopProcessingException e) {
            if (soapMessageContext.getProperty("SOAPMessage.empty") == null) {
                this.invokeHandlers(processingID, soapMessageContext, 1);
            }
            throw e;
        }
    }

    private SOAPMessage _receive(Connection con, ServiceClient serviceClient, SOAPMessageContext soapMessageContext) throws XMLInvocationException, RemoteException {
        return this._receive(con, serviceClient, soapMessageContext, -1);
    }

    private SOAPMessage _receive(Connection con, ServiceClient serviceClient, SOAPMessageContext soapMessageContext, int toPosition) throws XMLInvocationException, RemoteException {
        WaspSOAPMessage wmessage = (WaspSOAPMessage)soapMessageContext.getMessage();
        WaspMessageFactory factory = (WaspMessageFactory)wmessage.getMessageFactory();
        try {
            boolean fault;
            WaspSOAPMessage response;
            if (con.getInputMessage() == null) {
                AsyncConversationImpl async = (AsyncConversationImpl)soapMessageContext.getProperty("runtime.invocation.async.asyncresult");
                if (async == null) {
                    throw new RemoteException("You are performing blocking request-response call on one-way transport");
                }
                async.onMessage(new AsyncCallbackService.OneWayResponseMessage(async.getCorrelationID()));
                return null;
            }
            int sc = con.getInputMessage().getStatusCode();
            if (sc == 204 || sc == 202) {
                AsyncConversationImpl async = (AsyncConversationImpl)soapMessageContext.getProperty("runtime.invocation.async.asyncresult");
                if (async != null) {
                    async.onMessage(con.getInputMessage());
                } else {
                    con.getInputMessage().close();
                }
                return null;
            }
            try {
                InputMessage inputMessage = con.getInputMessage();
                if (factory.getTransportMethod().equals("get")) {
                    inputMessage = new GETInputMessageWrapper(inputMessage);
                }
                MessageSource source = messageSourceFactory.getMessageSource(inputMessage, soapMessageContext);
                response = factory.createMessage(source);
                CurrentImpl.ThreadLocals threadLocals = (CurrentImpl.ThreadLocals)soapMessageContext.getProperty("core.current.threadlocals");
                fault = ((WaspInternalSOAPMessage)response).hasFault(threadLocals.callContext);
            }
            catch (SOAPException e) {
                throw new XMLInvocationException("Exception while processing incoming message. Server returned error code: " + sc, e);
            }
            catch (TokenizerException e) {
                throw new XMLInvocationException("Exception while processing incoming message. Server returned error code: " + sc, e);
            }
            catch (UnsupportedMessageTypeException e) {
                throw new XMLInvocationException("Exception while processing incoming message. Server returned error code: " + sc, e);
            }
            soapMessageContext.setMessage(response);
            String handlersID = ((ServiceClientImpl)serviceClient).getHandlersID();
            this.invokeHandlers(handlersID, soapMessageContext, fault ? 12 : 1, -1, toPosition);
            return soapMessageContext.getMessage();
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (IOException e) {
            try {
                InputMessage inputMessage = con.getInputMessage();
                if (inputMessage != null) {
                    inputMessage.close();
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw new XMLInvocationException("Exception while processing incoming message message. " + e.getMessage(), e);
        }
    }

    private SOAPMessage waitForMessage(AsyncConversation asyncResult) throws RemoteException {
        return ((AsyncConversationImpl)asyncResult).endInvoke();
    }

    private HandlerChainInvoker.State invokeHandlers(String processingID, SOAPMessageContext soapMessageContext, int direction) throws RemoteException {
        return this.invokeHandlers(processingID, soapMessageContext, direction, -1, -1);
    }

    private HandlerChainInvoker.State invokeHandlers(String processingID, SOAPMessageContext soapMessageContext, int direction, int fromPostion, int toPosition) throws RemoteException {
        HandlerChainInvoker.State state;
        HandlerChainInvoker invoker = HandlerChainInvoker.getClientChainInvoker();
        switch (direction) {
            case 1: {
                state = invoker.processInput(soapMessageContext, processingID, fromPostion, toPosition);
                break;
            }
            case 2: {
                state = invoker.processOutput(soapMessageContext, processingID, fromPostion, toPosition);
                break;
            }
            case 12: {
                state = invoker.processFault(soapMessageContext, processingID, fromPostion, toPosition);
                break;
            }
            default: {
                throw new RuntimeException("Wrong direction: " + direction);
            }
        }
        if (state.statusCode == 3) {
            this.throwHandlerException(state.thrownException);
        }
        return state;
    }

    private void throwHandlerException(Exception e) throws RemoteException {
        if (e instanceof MustUnderstandException) {
            QName[] cause = ((MustUnderstandException)e).getCauseHeaders();
            StringBuffer causeHeaders = new StringBuffer();
            int i = 0;
            while (i < cause.length) {
                causeHeaders.append(cause[i].toString());
                if (i < cause.length - 1) {
                    causeHeaders.append(",");
                }
                ++i;
            }
            throw new RemoteException("Runtime exception occured during processing of handlers.No handler found for must understand header:" + causeHeaders);
        }
        throw new RemoteException("Runtime exception occured during processing of handlers", e);
    }

    private CurrentImpl getCurrent() {
        return (CurrentImpl)Context.getInstance(class$org$systinet$wasp$webservice$ICurrent == null ? (class$org$systinet$wasp$webservice$ICurrent = XMLInvocationHelperImpl.class$("org.systinet.wasp.webservice.ICurrent")) : class$org$systinet$wasp$webservice$ICurrent);
    }

    private boolean saveProtocol2CallContext(CallContext ctx, String protocol) {
        Map data = ctx.getContextData();
        if (!data.containsKey("wasp.xml.protocol")) {
            data.put("wasp.xml.protocol", protocol);
            return true;
        }
        return false;
    }

    public static void destroy() {
        AsyncRuntimeManager.destroy();
    }

    public static SOAPMessage sendReceiveMsg(MessageQueue.MessageHolder message, int toPosition) throws LookupException, RemoteException {
        Connection con;
        XMLInvocationHelperImpl instance = XMLInvocationHelperImpl.getInstance();
        CurrentImpl.ThreadLocals threadLocals = XMLInvocationHelperImpl.getInstance().getCurrent().getThreadLocals();
        threadLocals.callContext = message.currentSaver.callContext;
        threadLocals.serviceClientContext = message.currentSaver.scContext;
        threadLocals.processingType = 1;
        instance.setupMessageContext(message.msg, threadLocals);
        ServiceClient serviceClient = message.currentSaver.scContext.getServiceClient();
        if (((WaspMessageFactory)((WaspInternalSOAPMessage)message.msg.getMessage()).getMessageFactory()).getTransportMethod().equals("get")) {
            con = XMLInvocationHelperImpl._connect(serviceClient, XMLInvocationHelperImpl.createGetUri(serviceClient, message.msg));
        } else {
            con = XMLInvocationHelperImpl._connect(serviceClient);
            instance.sendMessage(message.msg.getMessage(), con);
        }
        return instance.receiveMessage(message, con, toPosition);
    }

    public static SOAPMessage sendReceiveMsg(MessageQueue.MessageHolder message) throws LookupException, RemoteException {
        return XMLInvocationHelperImpl.sendReceiveMsg(message, -1);
    }

    private SOAPMessage receiveMessage(MessageQueue.MessageHolder currentMsg, Connection con, int toPosition) throws XMLInvocationException, LookupException, RemoteException {
        String serviceURL = currentMsg.client.getServiceURL();
        return (WaspSOAPMessage)this._receive(con, currentMsg.client, currentMsg.msg, toPosition);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class InvocatoinHelperCallbackListener
    implements AsyncCallback {
        private SOAPMessage response;
        private boolean responseReady;

        private InvocatoinHelperCallbackListener() {
        }

        public SOAPMessage getResponse(AsyncConversation asyncConversation) throws RemoteException {
            try {
                InvocatoinHelperCallbackListener invocatoinHelperCallbackListener = this;
                synchronized (invocatoinHelperCallbackListener) {
                    if (!asyncConversation.isResponseReady()) {
                        while (!this.responseReady) {
                            this.wait();
                        }
                    }
                    this.responseReady = true;
                }
                this.response = XMLInvocationHelperImpl.endCall(asyncConversation, true);
            }
            catch (InterruptedException e) {
                throw new RuntimeWrappedException(e);
            }
            return this.response;
        }

        public void onResponse(AsyncConversation asyncConversation) {
            InvocatoinHelperCallbackListener invocatoinHelperCallbackListener = this;
            synchronized (invocatoinHelperCallbackListener) {
                if (this.responseReady) {
                    return;
                }
                this.responseReady = true;
                this.notify();
            }
        }

        public void onTimeout(AsyncConversation asyncConversation) {
        }
    }
}

