/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.async;

import com.idoox.debug.Category;
import com.idoox.util.ThreadPool;
import com.idoox.util.UUIDgen;
import com.systinet.wasp.async.AsyncCallbackService;
import com.systinet.wasp.async.AsyncConversationImpl;
import com.systinet.wasp.async.ConversationState;
import com.systinet.wasp.async.MessageQueue;
import com.systinet.wasp.async.config.AsyncConfigHelper;
import com.systinet.wasp.client.XMLInvocationHelperImpl;
import com.systinet.wasp.webservice.ServiceClientImpl;
import com.systinet.wasp.webservice.ServiceEndpointImpl;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.soap.SOAPMessage;
import org.idoox.transport.InputMessage;
import org.idoox.transport.Transport;
import org.idoox.transport.TransportStartException;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.Context;
import org.idoox.wasp.WaspInternalException;
import org.systinet.wasp.Wasp;
import org.systinet.wasp.addressing.AddressingHeaders;
import org.systinet.wasp.addressing.AddressingHeadersHelper;
import org.systinet.wasp.addressing.EndpointReference;
import org.systinet.wasp.async.AsyncConversation;
import org.systinet.wasp.client.XMLInvocationException;
import org.systinet.wasp.policy.IPolicyManager;
import org.systinet.wasp.soap.WaspSOAPMessage;
import org.systinet.wasp.webservice.LookupException;
import org.systinet.wasp.webservice.PublishException;
import org.systinet.wasp.webservice.Registry;
import org.systinet.wasp.webservice.ServiceClient;
import org.systinet.wasp.webservice.ServiceEndpoint;

public class AsyncRuntimeManager {
    private static final Category log = Category.getCategory("com.systinet.wasp.async.AsyncRuntimeManager");
    private static UUIDgen uuidGen = new UUIDgen();
    public static final String ASYNC_PREFIX = "/AsyncCallback_";
    private static AsyncRuntimeManager instance;
    private Map transportToServiceCount = new HashMap(5, 0.75f);
    private Map schemeToTransport = new HashMap(3, 0.75f);
    private Map reversePathToAsyncEndpoint = new HashMap(5, 0.75f);
    private Map asyncServiceToAsyncEndpoint = new HashMap(5, 0.75f);
    private static AsyncConversationRegistry asyncRegistry;
    private static int activeJobs;
    private static MessageQManager messageQmgr;
    private static AsyncConversationListener asyncListener;
    private static boolean closing;
    private static CleaningThread cleaningThread;
    private static TimeoutingThread timeoutingThread;
    private IPolicyManager policyManager = (IPolicyManager)Context.getInstance("org.systinet.wasp.policy.PolicyManager");
    static /* synthetic */ Class class$org$idoox$wasp$Context;

    private AsyncRuntimeManager() {
    }

    private void init() {
        asyncRegistry = new AsyncConversationRegistry();
        asyncRegistry.load();
    }

    public static synchronized AsyncRuntimeManager getInstance() {
        if (instance == null) {
            instance = new AsyncRuntimeManager();
            instance.init();
        }
        return instance;
    }

    private ServiceEndpoint createAsyncEndpoint(String asyncPath, AsyncCallbackService asyncService) {
        ServiceEndpoint asyncEndpoint;
        String path = asyncPath == null ? this.generateUniquePath() : asyncPath;
        Map map = this.reversePathToAsyncEndpoint;
        synchronized (map) {
            asyncEndpoint = (ServiceEndpoint)this.reversePathToAsyncEndpoint.get(path);
        }
        if (asyncEndpoint == null) {
            asyncEndpoint = ServiceEndpoint.create(path, asyncService);
            ((ServiceEndpointImpl)asyncEndpoint).setType(1);
        }
        return asyncEndpoint;
    }

    public ServiceEndpoint publishAsyncService(AsyncCallbackService asyncService, ServiceClient serviceClient, String path, boolean registerTransport) throws PublishException, LookupException, TransportStartException, MalformedURLException, WaspInternalException {
        ServiceEndpoint asyncEndpoint = this.createAsyncEndpoint(path, asyncService);
        Map contextData = asyncEndpoint.getContext().getContextData();
        contextData.put("serverbookmark.async.callback.service", Boolean.TRUE);
        contextData.put("async.client", serviceClient);
        contextData.putAll(serviceClient.getContext().getContextData());
        Registry.publish(asyncEndpoint);
        this.postPublish(asyncEndpoint, asyncService);
        if (registerTransport) {
            AsyncRuntimeManager asyncRuntimeManager = this;
            synchronized (asyncRuntimeManager) {
                String schema = this.getAsyncTransport(serviceClient);
                Transport transport = this.getTransportForScheme(schema);
                if (transport == null) {
                    this.startTransport(schema);
                } else {
                    this.increaseTransportCounter(transport);
                }
                if (cleaningThread == null) {
                    cleaningThread = new CleaningThread();
                    cleaningThread.setName("CleaningThread");
                    cleaningThread.setDaemon(true);
                    cleaningThread.start();
                }
            }
        }
        if (timeoutingThread == null) {
            timeoutingThread = new TimeoutingThread();
            timeoutingThread.setName("TimeoutingThread");
            timeoutingThread.setDaemon(true);
            timeoutingThread.start();
        }
        return asyncEndpoint;
    }

    public static void destroy() {
        if (instance == null) {
            return;
        }
        AsyncRuntimeManager asyncRuntimeManager = instance;
        synchronized (asyncRuntimeManager) {
            closing = true;
            if (messageQmgr != null) {
                messageQmgr.close();
            }
            if (cleaningThread != null) {
                cleaningThread.close();
            }
            if (timeoutingThread != null) {
                timeoutingThread.close();
            }
            Class clazz = class$org$idoox$wasp$Context == null ? (class$org$idoox$wasp$Context = AsyncRuntimeManager.class$("org.idoox.wasp.Context")) : class$org$idoox$wasp$Context;
            synchronized (clazz) {
                try {
                    long startTime = System.currentTimeMillis();
                    int i = 1;
                    while (activeJobs > 0 && i < 2) {
                        long currentTime = System.currentTimeMillis();
                        (class$org$idoox$wasp$Context == null ? AsyncRuntimeManager.class$("org.idoox.wasp.Context") : class$org$idoox$wasp$Context).wait(50L);
                        instance.wait(50L);
                        if (currentTime - startTime < (long)(i * 20000)) continue;
                        ++i;
                    }
                    if (activeJobs > 0) {
                        log.warn("Not all async conversations were finished.");
                    }
                }
                catch (InterruptedException e) {
                    log.warn("Destroy has been interrupted", e);
                }
            }
            try {
                instance.unpublishAllServices();
            }
            catch (PublishException e) {
                e.printStackTrace();
            }
        }
        asyncRegistry.store();
    }

    public static void setup(AsyncConversationImpl async) throws LookupException {
        async.addPropertyChangeListener(asyncListener);
        ServiceClientImpl serviceClient = (ServiceClientImpl)async.getServiceClient();
        AsyncRuntimeManager instance = AsyncRuntimeManager.getInstance();
        boolean shouldStart = instance.shouldPublishAsyncEndpoint(serviceClient);
        if (shouldStart) {
            String conversationID = instance.getSettedCorrId(serviceClient);
            conversationID = instance.startAsyncConversation(async, true, conversationID);
            instance.createAddressingHeaders(conversationID, serviceClient);
            instance.setupPolicy(serviceClient);
            instance.setConnectionTimeout(serviceClient, 0L);
        } else {
            instance.setConnectionTimeout(serviceClient, async.getTimeout());
        }
    }

    public static void incresseActiveJobs() {
        if (!closing) {
            AsyncRuntimeManager instance;
            AsyncRuntimeManager asyncRuntimeManager = instance = AsyncRuntimeManager.getInstance();
            synchronized (asyncRuntimeManager) {
                ++activeJobs;
            }
        }
    }

    public static void submitMsg(MessageQueue.MessageHolder holder) {
        if (!closing) {
            AsyncRuntimeManager instance;
            AsyncRuntimeManager asyncRuntimeManager = instance = AsyncRuntimeManager.getInstance();
            synchronized (asyncRuntimeManager) {
                ++activeJobs;
            }
            MessageQManager waiter = instance.initCheckingAndCleaningThread();
            waiter.addMessage(holder);
        }
    }

    public static void putResponseToQueue(String relatesTo, ServiceEndpoint se, InputMessage is) {
        AsyncRuntimeManager instance = AsyncRuntimeManager.getInstance();
        AsyncCallbackService service = instance.getAsyncCallbackService(se.getPath());
        service.onMessage(relatesTo, is);
    }

    private static void decreaseAsyncWaiters() {
        AsyncRuntimeManager instance;
        AsyncRuntimeManager asyncRuntimeManager = instance = AsyncRuntimeManager.getInstance();
        synchronized (asyncRuntimeManager) {
            --activeJobs;
            if (messageQmgr != null) {
                MessageQManager messageQManager = messageQmgr;
                synchronized (messageQManager) {
                    messageQmgr.notify();
                }
            }
        }
    }

    private void setConnectionTimeout(ServiceClient serviceClient, long timeout) {
        Map callCtxData = serviceClient.getCallContext().getContextData();
        Integer settimeout = (Integer)callCtxData.get("wasp.transport.connection.timeout");
        if (settimeout == null) {
            callCtxData.put("wasp.transport.connection.timeout", new Integer((int)timeout));
        }
    }

    private boolean shouldPublishAsyncEndpoint(ServiceClient sc) {
        return sc.getAsyncTransport() != null;
    }

    private void createAddressingHeaders(String convID, ServiceClient serviceClient) throws LookupException {
        EndpointReference to = new EndpointReference(serviceClient.getServiceURL());
        String serviceURL = ((ServiceClientImpl)serviceClient).getAsyncService().getAsyncServiceURL();
        EndpointReference from = new EndpointReference(serviceURL);
        AddressingHeadersHelper.createAndSetupOMIH(to, from, convID, serviceClient.getCallContext().getContextData());
    }

    private final String getSettedCorrId(ServiceClient serviceClient) {
        AddressingHeaders outHeaders = (AddressingHeaders)serviceClient.getCallContext().getContextData().get("addressing.output");
        if (outHeaders != null) {
            return outHeaders.messageID;
        }
        return null;
    }

    private void setupPolicy(ServiceClient serviceClient) {
        String serviceURL = ((ServiceClientImpl)serviceClient).getAsyncService().getAsyncServiceURL();
        serviceClient.getCallContext().getContextData().put("policy.input", this.policyManager.getEffectivePolicy(new EndpointReference(serviceURL)));
    }

    private String startAsyncConversation(AsyncConversationImpl async, boolean startTransport, String corrid) throws XMLInvocationException {
        try {
            ServiceClientImpl sc = (ServiceClientImpl)async.getServiceClient();
            AsyncCallbackService.Frontend asyncConfig = sc.getAsyncService();
            corrid = asyncConfig.addReceiver(async, corrid);
            if (startTransport) {
                String reversePath = async.getReversePath();
                String serviceURL = this.getServiceURL(sc, reversePath);
                AsyncCallbackService asyncService = this.getAsyncCallbackService(reversePath);
                asyncService.setCleaningThread(cleaningThread);
                asyncService.setServiceURL(serviceURL);
                String scheme = AsyncRuntimeManager.getSchemeFromURL(serviceURL);
                async.setAsyncTransport(scheme);
            }
            return corrid;
        }
        catch (Exception e) {
            throw new RuntimeWrappedException("Unable to start async conversation.", e);
        }
    }

    private MessageQManager initCheckingAndCleaningThread() {
        AsyncRuntimeManager asyncRuntimeManager = this;
        synchronized (asyncRuntimeManager) {
            if (messageQmgr == null) {
                messageQmgr = new MessageQManager();
                messageQmgr.setName("MessageQManager");
                messageQmgr.start();
            }
            MessageQManager messageQManager = messageQmgr;
            return messageQManager;
        }
    }

    private void postPublish(ServiceEndpoint asyncEndpoint, AsyncCallbackService asyncService) {
        Map map = this.reversePathToAsyncEndpoint;
        synchronized (map) {
            this.reversePathToAsyncEndpoint.put(asyncEndpoint.getPath(), asyncEndpoint);
        }
        Map map2 = this.asyncServiceToAsyncEndpoint;
        synchronized (map2) {
            this.asyncServiceToAsyncEndpoint.put(asyncService, asyncEndpoint);
        }
    }

    private void resumeAsyncConversation(AsyncConversationImpl async) {
        this.startAsyncConversation(async, true, null);
    }

    public void unpublishService(AsyncCallbackService service, ServiceClient serviceClient) throws PublishException {
        ServiceEndpoint asyncEndpoint;
        Map map = this.asyncServiceToAsyncEndpoint;
        synchronized (map) {
            asyncEndpoint = (ServiceEndpoint)this.asyncServiceToAsyncEndpoint.remove(service);
        }
        Registry.unpublish(asyncEndpoint);
        Map map2 = this.reversePathToAsyncEndpoint;
        synchronized (map2) {
            this.reversePathToAsyncEndpoint.remove(asyncEndpoint.getPath());
        }
        AsyncRuntimeManager asyncRuntimeManager = this;
        synchronized (asyncRuntimeManager) {
            Integer counter;
            String serviceURL = service.getServiceURL();
            if (serviceURL == null) {
                return;
            }
            String scheme = AsyncRuntimeManager.getSchemeFromURL(serviceURL);
            Transport transport = this.getTransportForScheme(scheme);
            if (transport != null && (counter = (Integer)this.transportToServiceCount.get(transport)) != null) {
                int newValue = counter - 1;
                if (newValue > 0) {
                    this.transportToServiceCount.put(transport, new Integer(newValue));
                } else {
                    this.unregisterTransport(scheme, transport);
                }
            }
        }
    }

    public void unpublishAllServices() throws PublishException {
        Map map = this.asyncServiceToAsyncEndpoint;
        synchronized (map) {
            AsyncCallbackService[] services = this.asyncServiceToAsyncEndpoint.keySet().toArray(new AsyncCallbackService[0]);
            int i = 0;
            while (i < services.length) {
                services[i].getFrontend().unpublishAsyncService();
                ++i;
            }
        }
    }

    private void increaseTransportCounter(Transport transport) {
        Integer counter = (Integer)this.transportToServiceCount.get(transport);
        int newValue = 1;
        if (counter != null) {
            this.transportToServiceCount.put(transport, new Integer(newValue += counter.intValue()));
        }
    }

    private void unregisterTransport(String scheme, Transport transport) {
        AsyncRuntimeManager asyncRuntimeManager = this;
        synchronized (asyncRuntimeManager) {
            transport.stop();
            this.transportToServiceCount.remove(transport);
            this.schemeToTransport.remove(scheme);
        }
    }

    private void registerTransport(String scheme, Transport transport) {
        AsyncRuntimeManager asyncRuntimeManager = this;
        synchronized (asyncRuntimeManager) {
            this.schemeToTransport.put(scheme, transport);
            this.registerTransportCounter(transport);
        }
    }

    private void registerTransportCounter(Transport transport) {
        this.transportToServiceCount.put(transport, new Integer(0));
    }

    private String getAsyncTransport(ServiceClient serviceClient) throws LookupException {
        String transportScheme = serviceClient.getAsyncTransport();
        if (transportScheme == null) {
            transportScheme = AsyncRuntimeManager.getSchemeFromURL(serviceClient.getServiceURL());
        }
        return transportScheme;
    }

    public void startTransport(String transportScheme) throws TransportStartException, MalformedURLException, WaspInternalException {
        AsyncRuntimeManager asyncRuntimeManager = this;
        synchronized (asyncRuntimeManager) {
            Transport transport;
            String serviceURL = Wasp.getAbsolutePath(transportScheme, "/");
            if (serviceURL == null) {
                transport = Wasp.startServer(transportScheme);
                this.registerTransport(transportScheme, transport);
            } else {
                transport = Wasp.startServer(transportScheme);
            }
            this.increaseTransportCounter(transport);
        }
    }

    private String getServiceURL(ServiceClient serviceClient, String servicePath) throws LookupException, MalformedURLException {
        String transportScheme = serviceClient.getAsyncTransport();
        if (transportScheme == null) {
            transportScheme = AsyncRuntimeManager.getSchemeFromURL(serviceClient.getServiceURL());
        }
        return Wasp.getAbsolutePath(transportScheme, servicePath);
    }

    private Transport getTransportForScheme(String scheme) {
        AsyncRuntimeManager asyncRuntimeManager = this;
        synchronized (asyncRuntimeManager) {
            Transport transport = (Transport)this.schemeToTransport.get(scheme);
            return transport;
        }
    }

    public static String getSchemeFromURL(String url) {
        return url.substring(0, url.indexOf(":"));
    }

    private String generateUniquePath() {
        String path = null;
        Map map = this.reversePathToAsyncEndpoint;
        synchronized (map) {
            while (path == null || this.reversePathToAsyncEndpoint.containsKey(path)) {
                path = ASYNC_PREFIX + uuidGen.uuidgen();
            }
        }
        return path;
    }

    public AsyncConversation[] load(String id, ServiceClient sc) {
        AsyncConversation[] conversations = asyncRegistry.getAsyncConversations(id);
        ServiceClient newServiceClient = ServiceClient.create(sc);
        newServiceClient.setWSDLLocation(sc.getWSDLLocation());
        int i = 0;
        while (i < conversations.length) {
            AsyncConversationImpl tempAsync = (AsyncConversationImpl)conversations[i];
            tempAsync.setServiceClient(newServiceClient);
            tempAsync.setCallContext(newServiceClient.getCallContext());
            tempAsync.addPropertyChangeListener(asyncListener);
            newServiceClient.setAsyncTransport(tempAsync.getAsyncTransport());
            this.startAsyncConversation(tempAsync, false, null);
            ++i;
        }
        return conversations;
    }

    public void registerAsyncConversation(AsyncConversationImpl async) {
        asyncRegistry.addAsyncConversation(async);
    }

    public AsyncCallbackService getAsyncCallbackService(String reversePath) {
        AsyncCallbackService ret = null;
        ServiceEndpoint asyncEndpoint = this.getAsyncServiceEndpoint(reversePath);
        if (asyncEndpoint != null) {
            try {
                ret = (AsyncCallbackService)asyncEndpoint.getServiceInstance().getImplementationObject();
            }
            catch (Exception ignore) {
                throw new RuntimeWrappedException("Exception while retrieving instance of an async endpoint", ignore);
            }
        }
        return ret;
    }

    public ServiceEndpoint getAsyncServiceEndpoint(String reversePath) {
        Map map = this.reversePathToAsyncEndpoint;
        synchronized (map) {
            ServiceEndpoint serviceEndpoint = (ServiceEndpoint)this.reversePathToAsyncEndpoint.get(reversePath);
            return serviceEndpoint;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        activeJobs = 0;
        asyncListener = new AsyncConversationListener();
    }

    class TimeoutingThread
    extends Thread {
        int WAITTIME = 500;
        private boolean stopping = false;
        Object mutex = new Object();

        TimeoutingThread() {
        }

        public void close() {
            TimeoutingThread timeoutingThread = this;
            synchronized (timeoutingThread) {
                this.stopping = true;
            }
        }

        public void run() {
            while (true) {
                TimeoutingThread timeoutingThread = this;
                synchronized (timeoutingThread) {
                    if (this.stopping) {
                        break;
                    }
                }
                ArrayList sevices = null;
                Map map = AsyncRuntimeManager.this.asyncServiceToAsyncEndpoint;
                synchronized (map) {
                    sevices = new ArrayList(AsyncRuntimeManager.this.asyncServiceToAsyncEndpoint.keySet());
                }
                if (sevices != null) {
                    Iterator iterator = ((AbstractList)sevices).iterator();
                    while (iterator.hasNext()) {
                        AsyncCallbackService callbackService = (AsyncCallbackService)iterator.next();
                        callbackService.manageTimeoutedAsyncConverstaions();
                    }
                }
                Object object = this.mutex;
                synchronized (object) {
                    try {
                        this.mutex.wait(this.WAITTIME);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    class CleaningThread
    extends Thread {
        int WAITTIME = 5000;
        boolean stopping = false;
        Object mutex = new Object();
        boolean received = true;

        CleaningThread() {
        }

        public void close() {
            CleaningThread cleaningThread = this;
            synchronized (cleaningThread) {
                this.stopping = true;
            }
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            block11: while (true) {
                var1_1 = this;
                synchronized (var1_1) {
                    if (this.stopping) {
                        break;
                    }
                }
                try {
                    var2_2 = this.mutex;
                    synchronized (var2_2) {
                        while (this.received) {
                            this.received = false;
                            this.mutex.wait(this.WAITTIME);
                        }
                        this.received = true;
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                sevices = null;
                var3_5 = AsyncRuntimeManager.access$600(AsyncRuntimeManager.this);
                synchronized (var3_5) {
                    sevices = new ArrayList<K>(AsyncRuntimeManager.access$600(AsyncRuntimeManager.this).keySet());
                }
                if (sevices == null) continue;
                iterator = sevices.iterator();
                while (true) {
                    if (iterator.hasNext()) ** break;
                    continue block11;
                    callbackService = (AsyncCallbackService)iterator.next();
                    callbackService.unpublishAsyncService();
                }
                break;
            }
        }

        public synchronized void refresh() {
            Object object = this.mutex;
            synchronized (object) {
                this.received = true;
                this.mutex.notifyAll();
            }
        }
    }

    private class AsyncConversationRegistry
    implements PropertyChangeListener {
        private Map asyncIDToAsyncConversations = new HashMap(5, 0.75f);

        private AsyncConversationRegistry() {
        }

        public void store() {
            AsyncConfigHelper.serialize(this.asyncIDToAsyncConversations);
        }

        public void load() {
            this.asyncIDToAsyncConversations = AsyncConfigHelper.deserialize();
        }

        public AsyncConversation[] getAsyncConversations(String id) {
            Map map = this.asyncIDToAsyncConversations;
            synchronized (map) {
                if (this.asyncIDToAsyncConversations.containsKey(id)) {
                    AsyncConversation[] asyncConversationArray = ((Set)this.asyncIDToAsyncConversations.get(id)).toArray(new AsyncConversation[0]);
                    return asyncConversationArray;
                }
                AsyncConversation[] asyncConversationArray = new AsyncConversation[]{};
                return asyncConversationArray;
            }
        }

        public void addAsyncConversation(AsyncConversationImpl async) {
            Map map = this.asyncIDToAsyncConversations;
            synchronized (map) {
                HashSet<AsyncConversationImpl> asyncs = (HashSet<AsyncConversationImpl>)this.asyncIDToAsyncConversations.get(async.getID());
                if (asyncs == null) {
                    asyncs = new HashSet<AsyncConversationImpl>();
                    this.asyncIDToAsyncConversations.put(async.getID(), asyncs);
                }
                asyncs.add(async);
            }
            async.addPropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("asyncconversation.state.prop".equals(evt.getPropertyName()) && evt.getNewValue().equals(ConversationState.FINISHED)) {
                this.store();
            }
        }
    }

    private static class AsyncConversationListener
    implements PropertyChangeListener {
        private AsyncConversationListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("asyncconversation.state.prop".equals(evt.getPropertyName())) {
                Object newState = evt.getNewValue();
                if (newState != ConversationState.ACTIVE) {
                    AsyncRuntimeManager.decreaseAsyncWaiters();
                } else {
                    AsyncRuntimeManager.getInstance().resumeAsyncConversation((AsyncConversationImpl)evt.getSource());
                }
            }
        }
    }

    class MsgSenders
    extends ThreadPool {
        public MsgSenders() {
            super("MsgSenders", 0, 10, false);
        }

        protected void handle(Object messageHolder) {
            SOAPMessage response;
            AsyncConversationImpl async;
            block12: {
                MessageQueue.MessageHolder message = (MessageQueue.MessageHolder)messageHolder;
                async = (AsyncConversationImpl)message.msg.getProperty("runtime.invocation.async.asyncresult");
                if (async != null) {
                    async.setCallContext(message.currentSaver.callContext);
                }
                response = null;
                try {
                    response = XMLInvocationHelperImpl.sendReceiveMsg(message);
                }
                catch (XMLInvocationException e) {
                    if (e.getException() instanceof InterruptedIOException) {
                        if (async != null) {
                            async.onTimeout();
                        }
                    } else if (async != null) {
                        async.onException(e);
                    }
                }
                catch (Throwable ex) {
                    if (async == null) break block12;
                    async.onException(ex);
                }
            }
            if (response != null) {
                if (async != null) {
                    async.onMessage(response);
                } else {
                    ((WaspSOAPMessage)response).release();
                }
            }
            if (async == null) {
                AsyncRuntimeManager.decreaseAsyncWaiters();
            }
        }
    }

    class MessageQManager
    extends Thread {
        private MsgSenders messageSenders;
        private MessageQueue messageQueue = new MessageQueue();
        private boolean stopping;

        public MessageQManager() {
            this.messageSenders = new MsgSenders();
        }

        public void close() {
            MessageQManager messageQManager = this;
            synchronized (messageQManager) {
                this.stopping = true;
                this.notifyAll();
            }
        }

        public void addMessage(MessageQueue.MessageHolder message) {
            MessageQManager messageQManager = this;
            synchronized (messageQManager) {
                this.messageQueue.push(message);
                this.notifyAll();
            }
        }

        public void run() {
            while (true) {
                MessageQManager messageQManager = this;
                synchronized (messageQManager) {
                    if (this.messageQueue.isEmpty() && activeJobs > 0 && !this.stopping) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                    }
                }
                if (!this.messageQueue.isEmpty()) {
                    MessageQueue.MessageHolder holder = this.messageQueue.pop();
                    this.messageSenders.job(holder);
                    continue;
                }
                AsyncRuntimeManager asyncRuntimeManager = AsyncRuntimeManager.this;
                synchronized (asyncRuntimeManager) {
                    if (activeJobs == 0 || this.stopping) {
                        while (this.stopping && activeJobs > 0) {
                            try {
                                AsyncRuntimeManager.this.wait(50L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        this.messageSenders.destroy();
                        messageQmgr = null;
                        break;
                    }
                }
            }
        }
    }
}

