/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.async;

import com.idoox.debug.Category;
import com.systinet.wasp.async.AsyncCallbackService;
import com.systinet.wasp.async.AsyncRuntimeManager;
import com.systinet.wasp.async.ConversationState;
import com.systinet.wasp.webservice.CurrentImpl;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPMessage;
import org.idoox.transport.Connection;
import org.idoox.transport.InputMessage;
import org.idoox.transport.client.ClientConnection;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.Context;
import org.systinet.wasp.async.AsyncCallback;
import org.systinet.wasp.async.AsyncConversation;
import org.systinet.wasp.async.TimeoutException;
import org.systinet.wasp.sequence.Sequence;
import org.systinet.wasp.soap.MessageSourceFactory;
import org.systinet.wasp.soap.WaspSOAPMessage;
import org.systinet.wasp.webservice.CallContext;
import org.systinet.wasp.webservice.ServiceClient;
import org.systinet.wasp.webservice.ServiceClientContext;

public class AsyncConversationImpl
extends AsyncConversation {
    public static final String SOAPMSG_CTX_KEY = "runtime.invocation.async.asyncresult";
    private static final String COFIRMATION_TEST_KEY = "runtime.invocation.async.confirmationtest";
    public static final String PROPERTY_STATE = "asyncconversation.state.prop";
    public static final String ONEWAY_METHOD_KEY = "oneway.method";
    private static Category log = Category.getCategory("com.systinet.wasp.async.AsyncConversationImpl");
    private static final int DEFAULT_TIMEOUT = 600000;
    private static final int NO_TIMEOUT = 0;
    private boolean responseReady;
    private AsyncCallback callback;
    private CallContext callCtx;
    private ServiceClient client;
    private Map invocProperties = Collections.synchronizedMap(new HashMap());
    private List messagePool = new LinkedList();
    private SOAPMessageContext soapMessageContext;
    private long timeout = 600000L;
    private long invocationStartTime = -1L;
    private boolean persistent = false;
    private String correlationID;
    private String reversePath;
    private String asyncID;
    private String asyncTransport;
    private ConversationState state = ConversationState.UNSPECIFIED;
    private PropertyChangeSupport listeners;
    private static MessageSourceFactory messageSourceFactory = MessageSourceFactory.newInstance();

    public AsyncConversationImpl() {
        this(null);
    }

    public AsyncConversationImpl(ServiceClient client) {
        this.client = client;
        this.listeners = new PropertyChangeSupport(this);
    }

    public ServiceClient getServiceClient() {
        return this.client;
    }

    public void setServiceClient(ServiceClient client) {
        this.client = client;
    }

    public void setTimeout(long milis) {
        this.timeout = milis;
        if (this.getCallContext() != null) {
            Connection conn = (Connection)this.getCallContext().getContextData().get("wasp.transport.connection");
            try {
                if (conn != null) {
                    ((ClientConnection)conn).setTimeout((int)milis);
                }
            }
            catch (IOException ignore) {
                log.warn("Unable to set connection timeout", ignore);
            }
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setCallback(AsyncCallback callback) {
        this.callback = callback;
        if (this.responseReady && this.callback != null) {
            this.notifyCallback(false);
        }
    }

    public boolean isResponseReady() {
        if (this.isTimeouted(System.currentTimeMillis())) {
            throw new TimeoutException();
        }
        return this.responseReady;
    }

    private synchronized void setResponseReady(boolean responseReady) {
        this.responseReady = responseReady;
    }

    private synchronized void notifyCallback(boolean timeout) {
        if (this.callback != null) {
            CurrentImpl current = (CurrentImpl)Context.getInstance("org.systinet.wasp.webservice.ICurrent");
            CurrentImpl.ThreadLocals threadLocals = current.getThreadLocals();
            CallContext oldCallContext = threadLocals.callContext;
            ServiceClientContext oldScContex = threadLocals.serviceClientContext;
            int oldProcessingType = threadLocals.processingType;
            try {
                threadLocals.callContext = this.callCtx;
                threadLocals.serviceClientContext = this.client.getContext();
                threadLocals.processingType = 1;
                if (oldCallContext != null && Sequence.getActiveInputSequence() == null) {
                    threadLocals.callContext.getContextData().put("sequence.input", oldCallContext.getContextData().get("sequence.input"));
                }
                if (!timeout) {
                    this.callback.onResponse(this);
                } else {
                    this.callback.onTimeout(this);
                }
                Object var8_7 = null;
                threadLocals.callContext = oldCallContext;
                threadLocals.serviceClientContext = oldScContex;
                threadLocals.processingType = oldProcessingType;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                threadLocals.callContext = oldCallContext;
                threadLocals.serviceClientContext = oldScContex;
                threadLocals.processingType = oldProcessingType;
                throw throwable;
            }
        }
    }

    public CallContext getCallContext() {
        return this.callCtx;
    }

    public synchronized void setCallContext(CallContext callCtx) {
        this.callCtx = callCtx;
    }

    public Map getInvocationProperties() {
        return this.invocProperties;
    }

    public void onMessage(SOAPMessage message) {
        if (!this.isActive()) {
            ((WaspSOAPMessage)message).release();
            return;
        }
        List list = this.messagePool;
        synchronized (list) {
            this.messagePool.add(message);
            this.setResponseReady(true);
            this.messagePool.notifyAll();
            this.notifyCallback(false);
        }
    }

    public void onMessage(AsyncCallbackService.OneWayResponseMessage message) {
        if (!this.isActive()) {
            return;
        }
        if (this.isOneWay()) {
            List list = this.messagePool;
            synchronized (list) {
                this.messagePool.add(message);
                this.setResponseReady(true);
                this.messagePool.notifyAll();
                this.notifyCallback(false);
            }
        }
    }

    public void onMessage(InputMessage message) {
        if (!this.isActive()) {
            try {
                message.close();
            }
            catch (IOException e) {
                log.error(e);
            }
            return;
        }
        if (!this.isAckMessage(message)) {
            List e = this.messagePool;
            synchronized (e) {
                this.messagePool.add(message);
                this.setResponseReady(true);
                this.messagePool.notifyAll();
                this.notifyCallback(false);
            }
        }
        try {
            message.close();
        }
        catch (IOException e) {
            log.error(e);
        }
    }

    public void onException(Throwable th) {
        if (!this.isActive()) {
            return;
        }
        List list = this.messagePool;
        synchronized (list) {
            this.messagePool.add(th);
            this.setResponseReady(true);
            this.messagePool.notifyAll();
            this.notifyCallback(false);
        }
    }

    public SOAPMessage endInvoke() throws RemoteException {
        SOAPMessage resMessage = null;
        List list = this.messagePool;
        synchronized (list) {
            if (this.isActive()) {
                if (this.messagePool.size() == 0) {
                    try {
                        this.messagePool.wait();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeWrappedException(e);
                    }
                }
                if (this.messagePool.size() > 0) {
                    Object message = this.messagePool.remove(0);
                    if (message instanceof SOAPMessage) {
                        resMessage = (SOAPMessage)message;
                    } else {
                        if (message instanceof InputMessage) {
                            this.handleRawMessage((InputMessage)message);
                            SOAPMessage sOAPMessage = null;
                            return sOAPMessage;
                        }
                        if (message instanceof Throwable) {
                            throw new RemoteException("Error when sending message", (Throwable)message);
                        }
                        SOAPMessage sOAPMessage = null;
                        return sOAPMessage;
                    }
                }
            }
            this.setResponseReady(false);
        }
        return resMessage;
    }

    public SOAPMessageContext getSoapMessageContext() {
        return this.soapMessageContext;
    }

    public void setSoapMessageContext(SOAPMessageContext soapMessageContext) {
        this.soapMessageContext = soapMessageContext;
    }

    public void invocationStarted() {
        this.setInvocationStartTime(System.currentTimeMillis());
        this.setState(ConversationState.ACTIVE);
    }

    public boolean isTimeouted(long currentTime) {
        if (this.timeout == 0L) {
            return false;
        }
        if (this.getState() == ConversationState.TIMEOUTED) {
            return true;
        }
        long remainingTime = this.getTimeToTimeout(currentTime);
        return remainingTime <= 0L;
    }

    public void setInvocationStartTime(long startTime) {
        this.invocationStartTime = startTime;
    }

    public long getInvocationStartTime() {
        return this.invocationStartTime;
    }

    private long getTimeToTimeout(long currentTime) {
        return this.invocationStartTime + this.timeout - currentTime;
    }

    public void onTimeout() {
        AsyncConversationImpl asyncConversationImpl = this;
        synchronized (asyncConversationImpl) {
            ConversationState state = this.getState();
            if (state == ConversationState.TIMEOUTED || state == ConversationState.FINISHED) {
                return;
            }
        }
        this.clearPool();
        this.setState(ConversationState.TIMEOUTED);
        List list = this.messagePool;
        synchronized (list) {
            this.messagePool.notifyAll();
        }
        this.notifyCallback(true);
    }

    public void finish() {
        AsyncConversationImpl asyncConversationImpl = this;
        synchronized (asyncConversationImpl) {
            ConversationState state = this.getState();
            if (state == ConversationState.TIMEOUTED || state == ConversationState.FINISHED) {
                return;
            }
        }
        this.clearPool();
        this.setState(ConversationState.FINISHED);
        List list = this.messagePool;
        synchronized (list) {
            this.messagePool.notifyAll();
        }
    }

    public synchronized boolean isFinished() {
        return this.getState() == ConversationState.FINISHED;
    }

    public void setID(String ID) {
        this.asyncID = ID;
        AsyncRuntimeManager.getInstance().registerAsyncConversation(this);
    }

    public String getID() {
        if (this.asyncID == null) {
            return this.correlationID;
        }
        return this.asyncID;
    }

    public void setPersistent() {
        if (this.correlationID == null) {
            throw new RuntimeWrappedException("Unable to persist such kind of asynchronous conversation.Coupled transport(e.g. WS-Routing) not used");
        }
        this.persistent = true;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public static AsyncConversation[] loadConversations(String id, ServiceClient sc) {
        return AsyncRuntimeManager.getInstance().load(id, sc);
    }

    public void interrupt() {
        this.clearPool();
        this.setState(ConversationState.INTERRUPTED);
        List list = this.messagePool;
        synchronized (list) {
            this.messagePool.notifyAll();
        }
    }

    public String getCorrelationID() {
        return this.correlationID;
    }

    public void setCorrelationID(String correlationID) {
        this.correlationID = correlationID;
    }

    public String getReversePath() {
        return this.reversePath;
    }

    public void setReversePath(String reversePath) {
        this.reversePath = reversePath;
    }

    public String getAsyncTransport() {
        return this.asyncTransport;
    }

    public void setAsyncTransport(String asyncProtocol) {
        this.asyncTransport = asyncProtocol;
    }

    public boolean isInterrupted() {
        AsyncConversationImpl asyncConversationImpl = this;
        synchronized (asyncConversationImpl) {
            boolean bl = this.getState() == ConversationState.INTERRUPTED;
            return bl;
        }
    }

    public void resume() {
        this.setState(ConversationState.ACTIVE);
    }

    public boolean isActive() {
        AsyncConversationImpl asyncConversationImpl = this;
        synchronized (asyncConversationImpl) {
            boolean bl = this.getState() == ConversationState.ACTIVE;
            return bl;
        }
    }

    private void clearPool() {
        List list = this.messagePool;
        synchronized (list) {
            Iterator it = this.messagePool.iterator();
            while (it.hasNext()) {
                Object message = it.next();
                if (message instanceof SOAPMessage) {
                    ((WaspSOAPMessage)message).release();
                    continue;
                }
                if (!(message instanceof InputMessage)) continue;
                try {
                    ((InputMessage)message).close();
                }
                catch (IOException e) {
                    log.error(e);
                }
            }
        }
    }

    private synchronized void setState(ConversationState state) {
        ConversationState oldState = this.state;
        this.state = state;
        this.listeners.firePropertyChange(PROPERTY_STATE, oldState, state);
    }

    private ConversationState getState() {
        return this.state;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    private void handleRawMessage(InputMessage im) {
        int statusCode = 0;
        try {
            try {
                statusCode = im.getStatusCode();
            }
            catch (IOException e) {
                throw new RuntimeWrappedException("Exception while processing incoming message. ", e);
            }
            if (statusCode >= 400) {
                try {
                    messageSourceFactory.getMessageSource(im, this.soapMessageContext);
                }
                catch (Exception e) {
                    throw new RuntimeWrappedException("Exception while processing incoming message. Server returned error code: " + statusCode, e);
                }
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                im.close();
            }
            catch (IOException e) {
                throw new RuntimeWrappedException("Exception while processing incoming message. ", e);
            }
            throw throwable;
        }
        try {
            im.close();
        }
        catch (IOException e) {
            throw new RuntimeWrappedException("Exception while processing incoming message. ", e);
        }
    }

    private boolean isAckMessage(InputMessage im) {
        int statusCode = 0;
        try {
            statusCode = im.getStatusCode();
        }
        catch (IOException e) {
            throw new RuntimeWrappedException("Exception while processing incoming message. ", e);
        }
        return !this.isOneWay() && statusCode == 202;
    }

    private boolean isOneWay() {
        return this.callCtx.getContextData().get(ONEWAY_METHOD_KEY) != null;
    }
}

