/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.async;

import com.idoox.debug.Category;
import com.idoox.util.UUID;
import com.systinet.wasp.async.AsyncConversationImpl;
import com.systinet.wasp.async.AsyncRuntimeManager;
import com.systinet.wasp.async.ConversationState;
import com.systinet.wasp.webservice.ServiceClientImpl;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.messaging.OnewayListener;
import javax.xml.soap.SOAPMessage;
import org.idoox.transport.InputMessage;
import org.idoox.transport.TransportStartException;
import org.idoox.wasp.WaspInternalException;
import org.systinet.wasp.addressing.AddressingHeaders;
import org.systinet.wasp.async.AsyncConversation;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.Initializable;
import org.systinet.wasp.webservice.LookupException;
import org.systinet.wasp.webservice.PublishException;
import org.systinet.wasp.webservice.ServiceClient;
import org.systinet.wasp.webservice.ServiceInstance;

public class AsyncCallbackService
implements OnewayListener,
Initializable {
    private static final Category cat = Category.getCategory("com.systinet.wasp.async.AsyncCallbackService");
    private Map corridToAsyncConversation = new HashMap(11, 0.75f);
    private Frontend frontend;
    private String serviceURL;
    private AsyncConversationListener asyncListener = new AsyncConversationListener();
    private AsyncRuntimeManager.CleaningThread cleaningThread = null;

    public void onMessage(String corrid, InputMessage message) {
        if (this.cleaningThread != null) {
            this.cleaningThread.refresh();
        }
        AsyncConversationImpl asyncConversation = null;
        Map map = this.corridToAsyncConversation;
        synchronized (map) {
            asyncConversation = (AsyncConversationImpl)this.corridToAsyncConversation.get(corrid);
        }
        if (asyncConversation != null && asyncConversation.isActive()) {
            Map callContextData = Current.getCallContext().getContextData();
            callContextData.put("lazy.input.processing", Boolean.TRUE);
            this.checkAndManageMessagePool(new TransportMessageReceipt(asyncConversation, message), callContextData);
        } else {
            try {
                message.close();
            }
            catch (IOException e) {
                cat.error(e);
            }
        }
    }

    public void onMessage(SOAPMessage message) {
        if (this.cleaningThread != null) {
            this.cleaningThread.refresh();
        }
        String corrid = this.getReceivedCorrid();
        AsyncConversationImpl asyncConversation = null;
        Map map = this.corridToAsyncConversation;
        synchronized (map) {
            asyncConversation = (AsyncConversationImpl)this.corridToAsyncConversation.get(corrid);
        }
        if (asyncConversation != null && asyncConversation.isActive()) {
            Map callContextData = Current.getCallContext().getContextData();
            callContextData.put("lazy.input.processing", Boolean.TRUE);
            this.checkAndManageMessagePool(new SaajMessageReceipt(asyncConversation, message), callContextData);
        }
    }

    public void onMessage(OneWayResponseMessage message) {
        if (this.cleaningThread != null) {
            this.cleaningThread.refresh();
        }
        String correlationId = message.getCorrelationId();
        AsyncConversationImpl asyncConversation = null;
        Map map = this.corridToAsyncConversation;
        synchronized (map) {
            asyncConversation = (AsyncConversationImpl)this.corridToAsyncConversation.get(correlationId);
        }
        if (asyncConversation != null && asyncConversation.isActive()) {
            Map callContextData = Current.getCallContext().getContextData();
            this.checkAndManageMessagePool(new OneWayResponseMessageReceipt(message, asyncConversation), callContextData);
        }
    }

    public AsyncCallbackService(Frontend frontend) {
        this.frontend = frontend;
    }

    private String registerAsyncConversation(AsyncConversationImpl asyncConversation, String corrID) {
        if (corrID == null && (corrID = asyncConversation.getCorrelationID()) == null) {
            corrID = this.generateCorrelationID();
            asyncConversation.setCorrelationID(corrID);
        }
        Map map = this.corridToAsyncConversation;
        synchronized (map) {
            this.corridToAsyncConversation.put(corrID, asyncConversation);
        }
        asyncConversation.addPropertyChangeListener(this.asyncListener);
        return corrID;
    }

    private String generateCorrelationID() {
        return "uuid:" + UUID.uuidgen();
    }

    private String getReceivedCorrid() {
        AddressingHeaders addr = (AddressingHeaders)Current.getCallContext().getContextData().get("addressing.input");
        return addr != null ? addr.getRelatedMessageID(AddressingHeaders.Relationship.RESPONSE) : null;
    }

    public Frontend getFrontend() {
        return this.frontend;
    }

    public void init(ServiceInstance serviceInstance) {
    }

    public String getServiceURL() {
        return this.serviceURL;
    }

    public void setServiceURL(String serviceURL) {
        this.serviceURL = serviceURL;
    }

    public void setCleaningThread(AsyncRuntimeManager.CleaningThread cleaningThread) {
        this.cleaningThread = cleaningThread;
    }

    public void destroy() {
    }

    public void unpublishAsyncService() {
        Frontend frontend = this.frontend;
        synchronized (frontend) {
            Map map = this.corridToAsyncConversation;
            synchronized (map) {
                if (this.corridToAsyncConversation.size() == 0) {
                    this.frontend.unpublishAsyncService();
                }
            }
        }
    }

    private void checkAndManageMessagePool(Receipt rcpt, Map callContextData) {
        Receipt receipt;
        Map src = (Map)callContextData.get("async.callcontext.propagate.to.client");
        if (src != null) {
            Map clientCallContextData = ((AsyncConversationImpl)rcpt.asyncConversation).getCallContext().getContextData();
            clientCallContextData.putAll(src);
        }
        if (rcpt instanceof SaajMessageReceipt) {
            receipt = (SaajMessageReceipt)rcpt;
            ((AsyncConversationImpl)receipt.asyncConversation).onMessage(receipt.message);
        } else if (rcpt instanceof TransportMessageReceipt) {
            receipt = (TransportMessageReceipt)rcpt;
            ((AsyncConversationImpl)receipt.asyncConversation).onMessage(((TransportMessageReceipt)receipt).message);
        } else {
            receipt = (OneWayResponseMessageReceipt)rcpt;
            ((AsyncConversationImpl)receipt.asyncConversation).onMessage(((OneWayResponseMessageReceipt)receipt).message);
        }
        this.manageTimeoutedAsyncConverstaions();
    }

    public void manageTimeoutedAsyncConverstaions() {
        Map map = this.corridToAsyncConversation;
        synchronized (map) {
            Iterator it = this.corridToAsyncConversation.keySet().iterator();
            while (it.hasNext()) {
                String corrid = (String)it.next();
                AsyncConversationImpl asyncConversation = (AsyncConversationImpl)this.corridToAsyncConversation.get(corrid);
                if (!asyncConversation.isTimeouted(System.currentTimeMillis())) continue;
                it.remove();
                asyncConversation.onTimeout();
            }
        }
    }

    public static class OneWayResponseMessage {
        private String correlationId;

        public OneWayResponseMessage(String correlationId) {
            this.correlationId = correlationId;
        }

        public String getCorrelationId() {
            return this.correlationId;
        }
    }

    private class OneWayResponseMessageReceipt
    extends Receipt {
        OneWayResponseMessage message;

        public OneWayResponseMessageReceipt(OneWayResponseMessage message, AsyncConversation asyncConversation) {
            this.message = message;
            this.asyncConversation = asyncConversation;
        }
    }

    private class TransportMessageReceipt
    extends Receipt {
        InputMessage message;

        public TransportMessageReceipt(AsyncConversation asyncConversation, InputMessage message) {
            this.asyncConversation = asyncConversation;
            this.message = message;
        }
    }

    private class SaajMessageReceipt
    extends Receipt {
        SOAPMessage message;

        public SaajMessageReceipt(AsyncConversation asyncConversation, SOAPMessage message) {
            this.asyncConversation = asyncConversation;
            this.message = message;
        }
    }

    private abstract class Receipt {
        AsyncConversation asyncConversation;

        private Receipt() {
        }
    }

    private class AsyncConversationListener
    implements PropertyChangeListener {
        private AsyncConversationListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("asyncconversation.state.prop".equals(evt.getPropertyName()) && (evt.getNewValue() == ConversationState.FINISHED || evt.getNewValue() == ConversationState.INTERRUPTED)) {
                Map map = AsyncCallbackService.this.corridToAsyncConversation;
                synchronized (map) {
                    AsyncConversationImpl async = (AsyncConversationImpl)evt.getSource();
                    AsyncCallbackService.this.corridToAsyncConversation.remove(async.getCorrelationID());
                }
            }
        }
    }

    public static class Frontend {
        private ServiceClient serviceClient;
        private AsyncCallbackService asyncService;

        public Frontend(ServiceClient client) {
            this.serviceClient = client;
        }

        public void oneWayAck(String correlationId) {
            this.asyncService.onMessage(new OneWayResponseMessage(correlationId));
        }

        public String addReceiver(AsyncConversationImpl asyncConversation, String corrid) throws LookupException, PublishException, TransportStartException, MalformedURLException, WaspInternalException {
            Frontend frontend = this;
            synchronized (frontend) {
                this.asyncService = ((ServiceClientImpl)this.serviceClient).publishAsyncEndpoint(true);
                corrid = this.asyncService.registerAsyncConversation(asyncConversation, corrid);
                asyncConversation.setReversePath(((ServiceClientImpl)this.serviceClient).getAsyncEndpointPath());
            }
            return corrid;
        }

        public void setAsyncService(AsyncCallbackService callbackService) {
            this.asyncService = callbackService;
        }

        public String getAsyncServiceURL() {
            Frontend frontend = this;
            synchronized (frontend) {
                String string = this.asyncService.getServiceURL();
                return string;
            }
        }

        public void unpublishAsyncService() {
            Frontend frontend = this;
            synchronized (frontend) {
                try {
                    if (this.asyncService != null && this.serviceClient != null && ((ServiceClientImpl)this.serviceClient).unpublishAsyncEndpointDefaultPath()) {
                        this.asyncService = null;
                    }
                }
                catch (PublishException e) {
                    cat.warn(e);
                }
            }
        }
    }
}

