/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.admin.utils;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class WsdlHelper {
    private static final int FETCH_WSDL_WSDLAPI = 0;
    private static final int FETCH_WSDL_DOM = 1;

    public static QName[] getWsdlOperations(String serviceAddress, String wsdlUrl) {
        try {
            Definition definition = WsdlHelper.fetchWsdl(1, wsdlUrl);
            return WsdlHelper.extractWsdlOperationsQNames(definition, serviceAddress);
        }
        catch (Exception e) {
            return new QName[0];
        }
    }

    public static QName[] extractWsdlOperationsQNames(Definition definition, String serviceAddress) {
        if (definition == null) {
            return null;
        }
        ArrayList<QName> result = new ArrayList<QName>();
        try {
            Binding[] bindings = definition.getBindings().values().toArray(new Binding[0]);
            if (bindings != null) {
                int i = 0;
                while (i < bindings.length) {
                    BindingOperation[] bindingOperations = bindings[i].getBindingOperations().toArray(new BindingOperation[0]);
                    int j = 0;
                    while (j < bindingOperations.length) {
                        List extensibilityElementsList;
                        String operationName = bindingOperations[j].getName();
                        BindingInput bindingInput = bindingOperations[j].getBindingInput();
                        if (bindingInput != null && (extensibilityElementsList = bindingInput.getExtensibilityElements()) != null && !extensibilityElementsList.isEmpty()) {
                            Iterator extensibilityElements = extensibilityElementsList.iterator();
                            while (extensibilityElements.hasNext()) {
                                QName operationQName;
                                ExtensibilityElement extensibilityElement = (ExtensibilityElement)extensibilityElements.next();
                                if (extensibilityElement instanceof SOAPBody) {
                                    operationQName = new QName(((SOAPBody)extensibilityElement).getNamespaceURI(), bindingOperations[j].getName());
                                    result.add(operationQName);
                                }
                                if (!(extensibilityElement instanceof MIMEMultipartRelated)) continue;
                                MIMEPart[] mimeParts = ((MIMEMultipartRelated)extensibilityElement).getMIMEParts().toArray(new MIMEPart[0]);
                                int k = 0;
                                while (k < mimeParts.length) {
                                    List extElementsList = mimeParts[k].getExtensibilityElements();
                                    if (extElementsList != null && !extElementsList.isEmpty()) {
                                        Iterator extElements = extElementsList.iterator();
                                        while (extElements.hasNext()) {
                                            ExtensibilityElement extElement = (ExtensibilityElement)extElements.next();
                                            if (!(extElement instanceof SOAPBody)) continue;
                                            operationQName = new QName(((SOAPBody)extElement).getNamespaceURI(), bindingOperations[j].getName());
                                            result.add(operationQName);
                                        }
                                    }
                                    ++k;
                                }
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        return result.toArray(new QName[0]);
    }

    private WsdlHelper() {
    }

    private static Definition fetchWsdl(int method, String wsdlUrl) throws WSDLException, ParserConfigurationException, SAXException, IOException, FileNotFoundException {
        Definition definition = null;
        if (wsdlUrl != null) {
            WSDLFactory wsdlFactory = WSDLFactory.newInstance("com.idoox.wsdl.factory.WSDLFactoryImpl");
            WSDLReader wsdlReader = wsdlFactory.newWSDLReader();
            wsdlReader.setFeature("javax.wsdl.verbose", false);
            switch (method) {
                case 0: {
                    definition = wsdlReader.readWSDL(null, wsdlUrl);
                    break;
                }
                case 1: {
                    DocumentBuilderFactory docBuildFact = DocumentBuilderFactory.newInstance();
                    docBuildFact.setNamespaceAware(true);
                    docBuildFact.setValidating(false);
                    DocumentBuilder docBuild = docBuildFact.newDocumentBuilder();
                    Document doc1 = docBuild.parse(wsdlUrl);
                    definition = wsdlReader.readWSDL(wsdlUrl, doc1);
                    break;
                }
                default: {
                    return null;
                }
            }
        } else {
            throw new FileNotFoundException("WSDL file " + wsdlUrl + " not found.");
        }
        return definition;
    }
}

